/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Import;
import org.w3c.dom.Document;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.test.util.TestUtils;
import org.wsi.util.Utils;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2101
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    boolean importFound = false;

    public BP2101(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(Import import_, Object object, WSDLTraversalContext wSDLTraversalContext) {
        this.importFound = true;
        if (import_.getDefinition() == null) {
            this.errors.add(import_.getNamespaceURI() + ":" + import_.getLocationURI() + "\nImport element does not reference a WSDL definition.");
        } else {
            try {
                Document document = this.validator.parseXMLDocumentURL(import_.getLocationURI(), ((Definition)object).getDocumentBaseURI(), TestUtils.getWSDLSchemaLocation());
            }
            catch (Throwable throwable) {
                this.errors.add(import_.getNamespaceURI() + ":" + import_.getLocationURI() + "\n" + Utils.getExceptionDetails(throwable));
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitImport(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.importFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

