/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Operation;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2119
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean docLiteralFound = false;
    private ErrorList errors = new ErrorList();

    public BP2119(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(SOAPBinding sOAPBinding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPBinding.getStyle() == null ? "document" : sOAPBinding.getStyle();
        wSDLTraversalContext.addParameter("style", string);
    }

    public void visit(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPOperation.getStyle();
        if (string == null) {
            string = (String)wSDLTraversalContext.getParameter("style");
        }
        if (!"document".equals(string)) {
            wSDLTraversalContext.cancelBindingOperationProcessing();
        }
    }

    public void visit(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string;
        String string2 = string = sOAPBody.getUse() == null ? "literal" : sOAPBody.getUse();
        if ("literal".equals(string)) {
            this.docLiteralFound = true;
            if (sOAPBody.getParts() == null) {
                Operation operation = wSDLTraversalContext.getBindingOperation().getOperation();
                if (operation == null) {
                    return;
                }
                Map map = null;
                if (object instanceof BindingInput) {
                    if (operation.getInput() == null || operation.getInput().getMessage() == null) {
                        return;
                    }
                    map = operation.getInput().getMessage().getParts();
                } else if (object instanceof BindingOutput) {
                    if (operation.getOutput() == null || operation.getOutput().getMessage() == null) {
                        return;
                    }
                    map = operation.getOutput().getMessage().getParts();
                }
                if (map != null && map.size() > 1) {
                    this.errors.add(wSDLTraversalContext.getBinding().getQName());
                    wSDLTraversalContext.cancelBindingProcessing();
                    wSDLTraversalContext.cancelBindingOperationProcessing();
                    wSDLTraversalContext.cancelBindingInputProcessing();
                    wSDLTraversalContext.cancelBindingOutputProcessing();
                }
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitSOAPBinding(true);
        wSDLTraversal.visitSOAPBody(true);
        wSDLTraversal.visitSOAPOperation(true);
        wSDLTraversal.ignoreImport();
        wSDLTraversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.docLiteralFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

