/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.test.util.WSDLUtil;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2120
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private Set wares = new HashSet();

    public BP2120(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(SOAPBinding sOAPBinding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPBinding.getStyle() == null ? "document" : sOAPBinding.getStyle();
        wSDLTraversalContext.addParameter("style", string);
    }

    public void visit(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPOperation.getStyle();
        if (string != null) {
            wSDLTraversalContext.addParameter("style", string);
        }
    }

    public void visit(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = (String)wSDLTraversalContext.getParameter("style");
        Operation operation = wSDLTraversalContext.getBindingOperation().getOperation();
        if (operation == null || operation.getInput() == null || operation.getInput().getMessage() == null) {
            return;
        }
        Message message = operation.getInput().getMessage();
        List list = WSDLUtil.getParts(operation, message, sOAPBody, string);
        if (list == null) {
            return;
        }
        linkedList.addAll(list);
        if ("rpc".equals(string)) {
            linkedList.add(0, operation.getName());
        }
        if (this.sameSignature(this.wares, linkedList)) {
            this.errors.add(operation.getName());
        } else {
            this.wares.add(linkedList);
        }
    }

    private boolean sameSignature(Set set, List list) {
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            List list2 = (List)iterator.next();
            if (list2.size() != list.size()) continue;
            Iterator iterator2 = list2.iterator();
            Iterator iterator3 = list.iterator();
            bl = true;
            while (iterator2.hasNext() && iterator3.hasNext() && bl) {
                Object e = iterator2.next();
                Object e2 = iterator3.next();
                if (e instanceof String && e2 instanceof String && ((String)e).equals((String)e2)) {
                    bl = true;
                    continue;
                }
                if (e instanceof Part && e2 instanceof Part) {
                    bl = this.sameParts((Part)e, (Part)e2);
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    private boolean sameParts(Part part, Part part2) {
        boolean bl = false;
        bl = part.getElementName() != null && part2.getElementName() != null && part.getElementName().equals(part2.getElementName()) ? true : part.getTypeName() != null && part2.getTypeName() != null && part.getTypeName().equals(part2.getTypeName());
        return bl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitSOAPBinding(true);
        wSDLTraversal.visitSOAPBody(true);
        wSDLTraversal.visitSOAPOperation(true);
        wSDLTraversal.ignoreBindingOutput();
        wSDLTraversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

