/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLUtils;

public class BP2123
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean claimFound = false;
    private static final String PORT_KEY = "port";
    private static final String BINDING_KEY = "binding";
    private static final String PORT_TYPE_KEY = "port type";
    private static final String OPERATION_KEY = "operation";
    private static final String MESSAGE_KEY = "message";

    public BP2123(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(Port port, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (port != null) {
            if (this.containsLegalClaim(port.getDocumentationElement())) {
                this.claimFound = true;
                wSDLTraversalContext.addParameter(PORT_KEY, Boolean.TRUE);
            } else {
                wSDLTraversalContext.addParameter(PORT_KEY, Boolean.FALSE);
            }
        }
    }

    public void visit(Binding binding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (binding != null) {
            Boolean bl = (Boolean)wSDLTraversalContext.getParameter(PORT_KEY);
            if (bl.booleanValue()) {
                wSDLTraversalContext.addParameter(BINDING_KEY, Boolean.TRUE);
            } else {
                this.claimFound = this.containsClaim(binding.getDocumentationElement());
                wSDLTraversalContext.addParameter(BINDING_KEY, new Boolean(this.containsLegalClaim(binding.getDocumentationElement())));
            }
        }
    }

    public void visit(PortType portType, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (portType != null) {
            Boolean bl = (Boolean)wSDLTraversalContext.getParameter(BINDING_KEY);
            if (bl.booleanValue()) {
                wSDLTraversalContext.addParameter(PORT_TYPE_KEY, Boolean.TRUE);
            } else {
                this.claimFound = this.containsClaim(portType.getDocumentationElement());
                wSDLTraversalContext.addParameter(PORT_TYPE_KEY, new Boolean(this.containsLegalClaim(portType.getDocumentationElement())));
            }
        }
    }

    public void visit(Operation operation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (operation != null) {
            Boolean bl = (Boolean)wSDLTraversalContext.getParameter(PORT_TYPE_KEY);
            if (bl.booleanValue()) {
                wSDLTraversalContext.addParameter(OPERATION_KEY, Boolean.TRUE);
            } else {
                this.claimFound = this.containsClaim(operation.getDocumentationElement());
                wSDLTraversalContext.addParameter(OPERATION_KEY, new Boolean(this.containsLegalClaim(operation.getDocumentationElement())));
            }
        }
    }

    public void visit(Message message, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (message != null) {
            Boolean bl = (Boolean)wSDLTraversalContext.getParameter(OPERATION_KEY);
            if (bl.booleanValue()) {
                wSDLTraversalContext.addParameter(MESSAGE_KEY, Boolean.TRUE);
            } else {
                this.claimFound = this.containsClaim(message.getDocumentationElement());
                wSDLTraversalContext.addParameter(MESSAGE_KEY, new Boolean(this.containsLegalClaim(message.getDocumentationElement())));
            }
        }
    }

    public void visit(ExtensibilityElement extensibilityElement, Object object, WSDLTraversalContext wSDLTraversalContext) {
        boolean bl;
        boolean bl2 = bl = extensibilityElement != null && extensibilityElement.getRequired() != null && extensibilityElement.getRequired() != false;
        if (this.isParentConforms(object, wSDLTraversalContext) && bl) {
            this.result = "warning";
            this.failureDetailMessage = extensibilityElement.toString();
        }
    }

    private boolean isParentConforms(Object object, WSDLTraversalContext wSDLTraversalContext) {
        boolean bl = false;
        if (object instanceof Port) {
            bl = (Boolean)wSDLTraversalContext.getParameter(PORT_KEY);
        } else if (object instanceof Binding || object instanceof BindingOperation || object instanceof BindingInput || object instanceof BindingOutput || object instanceof BindingFault) {
            bl = (Boolean)wSDLTraversalContext.getParameter(BINDING_KEY);
        } else if (object instanceof PortType) {
            bl = (Boolean)wSDLTraversalContext.getParameter(PORT_TYPE_KEY);
        } else if (object instanceof Operation || object instanceof Input || object instanceof Output || object instanceof Fault) {
            bl = (Boolean)wSDLTraversalContext.getParameter(OPERATION_KEY);
        } else if (object instanceof Message || object instanceof Part) {
            bl = (Boolean)wSDLTraversalContext.getParameter(MESSAGE_KEY);
        }
        return bl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitOperation(true);
        wSDLTraversal.visitBinding(true);
        wSDLTraversal.visitMessage(true);
        wSDLTraversal.visitPort(true);
        wSDLTraversal.visitPortType(true);
        wSDLTraversal.visitExtensibilityElement(true);
        wSDLTraversal.ignoreImport();
        wSDLTraversal.ignoreDefinition2Binding();
        wSDLTraversal.ignoreDefinition2Element();
        wSDLTraversal.ignoreDefinition2ExtensibilityElement();
        wSDLTraversal.ignoreDefinition2Message();
        wSDLTraversal.ignoreDefinition2PortType();
        wSDLTraversal.ignoreDefinition2Types();
        wSDLTraversal.traverse(definition);
        if (!this.claimFound) {
            this.result = "notApplicable";
        } else if (this.result.equals("warning")) {
            this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsClaim(Element element) {
        if (element == null) {
            return false;
        }
        return (element = XMLUtils.findChildElement(element, WSITag.WSI_CLAIM)) != null;
    }

    private boolean containsLegalClaim(Element element) {
        if (element == null) {
            return false;
        }
        element = XMLUtils.findChildElement(element, WSITag.WSI_CLAIM);
        while (element != null) {
            String string = element.getAttribute(WSITag.ATTR_CLAIM_CONFORMSTO.getLocalPart());
            if (string != null && string.equalsIgnoreCase("http://ws-i.org/profiles/basic/1.0")) {
                return true;
            }
            element = XMLUtils.findElement(element, WSITag.WSI_CLAIM);
        }
        return false;
    }
}

