/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP4201
extends AssertionProcessVisitor {
    private final WSDLValidatorImpl validator;
    private ErrorList errorList = new ErrorList();

    public BP4201(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(Import import_, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (import_ != null && (this.isRelativeURI(import_.getNamespaceURI()) || this.isRelativeURI(import_.getLocationURI()))) {
            this.errorList.add(import_.getNamespaceURI(), import_.getLocationURI());
        }
    }

    public void visit(Port port, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (port != null) {
            Iterator iterator = port.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SOAPAddress) || !this.isRelativeURI(((SOAPAddress)e).getLocationURI())) continue;
                this.errorList.add(((SOAPAddress)e).getElementType() + ":" + ((SOAPAddress)e).getLocationURI());
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitImport(true);
        wSDLTraversal.visitPort(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.traverse(definition);
        if (this.errorList.isEmpty()) {
            return this.validator.createAssertionResult(testAssertion, "notApplicable", (String)null);
        }
        this.failureDetail = this.validator.createFailureDetail(testAssertion.getFailureMessage() + "\n\n" + this.errorList.toString(), entryContext);
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean isRelativeURI(String string) {
        if (string == null) {
            return false;
        }
        try {
            if (new URI(string).isAbsolute()) {
                return false;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return true;
    }
}

