/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.report.impl;

import java.io.StringReader;
import org.wsi.WSIException;
import org.wsi.test.analyzer.config.AnalyzerConfig;
import org.wsi.test.analyzer.config.AssertionResultType;
import org.wsi.test.report.ArtifactReference;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.report.Entry;
import org.wsi.test.report.EntryContainer;
import org.wsi.test.report.FailureDetail;
import org.wsi.test.report.Report;
import org.wsi.test.report.ReportArtifact;
import org.wsi.test.report.ReportWriter;
import org.wsi.test.report.Reporter;

public class DefaultReporter
implements Reporter {
    protected Report report;
    protected ReportWriter reportWriter;
    protected AnalyzerConfig analyzerConfig;
    protected AssertionResultType assertionResultType;

    private DefaultReporter() {
    }

    public DefaultReporter(Report report, ReportWriter reportWriter) {
        this.report = report;
        this.reportWriter = reportWriter;
        this.analyzerConfig = report.getReportContext().getAnalyzer().getAnalyzerConfig();
        this.assertionResultType = this.analyzerConfig.getAssertionResultsOption().getAssertionResultType();
    }

    public void setCurrentArtifact(ReportArtifact reportArtifact) throws WSIException {
        this.report.setCurrentArtifact(reportArtifact);
        this.reportWriter.write(new StringReader(reportArtifact.getStartXMLString("")));
    }

    public void endCurrentArtifact() throws WSIException {
        this.reportWriter.write(new StringReader(this.report.getCurrentArtifact().getEndXMLString("")));
        this.report.endCurrentArtifact();
    }

    public void addArtifactReference(ArtifactReference artifactReference) throws WSIException {
        this.reportWriter.write(new StringReader(artifactReference.toXMLString("")));
        this.report.addArtifactReference(artifactReference);
    }

    public void setCurrentEntry(Entry entry) throws WSIException {
        this.report.setCurrentEntry(entry);
        this.reportWriter.write(new StringReader(entry.getStartXMLString("", this.report.getReportContext().getAnalyzer().getAnalyzerConfig().getAssertionResultsOption().getShowMessageEntry())));
    }

    public void setCurrentEnvelopeEntry(Entry entry) throws WSIException {
        this.report.setCurrentEntry(entry);
        this.reportWriter.write(new StringReader(entry.getStartXMLString("", this.report.getReportContext().getAnalyzer().getAnalyzerConfig().getAssertionResultsOption().getShowMessageEntry(), true)));
    }

    public void endCurrentEntry() throws WSIException {
        this.reportWriter.write(new StringReader(this.report.getCurrentEntry().getEndXMLString("")));
        this.report.endCurrentEntry();
    }

    public void addAssertionResult(AssertionResult assertionResult) throws WSIException {
        if (this.assertionResultType.isAll() || this.assertionResultType.isFailedOnly() && assertionResult.getResult().equals("failed") || this.assertionResultType.isNotPassed() && !assertionResult.getResult().equals("passed") || this.assertionResultType.isNotInfo() && !assertionResult.getAssertion().getType().equals("informational")) {
            this.reportWriter.write(new StringReader(assertionResult.toXMLString("")));
        }
        this.report.addAssertionResult(assertionResult);
    }

    public AssertionResult getAssertionResult(String string) {
        return this.report.getAssertionResult(string);
    }

    public void startReport() throws WSIException {
        this.reportWriter.write(new StringReader(this.report.getStartXMLString("")));
    }

    public void finishReport() throws WSIException {
        this.reportWriter.write(new StringReader(this.report.getEndXMLString("")));
    }

    public void finishReportWithError(String string) throws WSIException {
        if (this.report.getCurrentEntry() != null) {
            this.endCurrentEntry();
        }
        if (this.report.getCurrentArtifact() != null) {
            this.endCurrentArtifact();
        }
        this.reportWriter.write(new StringReader(this.report.getErrorXMLString("", string)));
    }

    public AssertionResult createAssertionResult() {
        return this.report.createAssertionResult();
    }

    public ReportArtifact createArtifact() {
        return this.report.createArtifact();
    }

    public Entry createEntry() {
        return this.report.createEntry();
    }

    public EntryContainer createEntryContainer() {
        return this.report.createEntryContainer();
    }

    public FailureDetail createFailureDetail() {
        return this.report.createFailureDetail();
    }

    public Report getReport() {
        return this.report;
    }

    public void setPrereqType(String string) {
        this.report.setPrereqType(string);
    }
}

