/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.report.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import org.wsi.WSIException;
import org.wsi.test.log.Log;
import org.wsi.test.report.ArtifactReference;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.report.Entry;
import org.wsi.test.report.EntryContainer;
import org.wsi.test.report.FailureDetail;
import org.wsi.test.report.Report;
import org.wsi.test.report.ReportArtifact;
import org.wsi.test.report.ReportContext;
import org.wsi.test.report.impl.AssertionResultImpl;
import org.wsi.test.report.impl.EntryContainerImpl;
import org.wsi.test.report.impl.EntryImpl;
import org.wsi.test.report.impl.FailureDetailImpl;
import org.wsi.test.report.impl.ReportArtifactImpl;
import org.wsi.test.util.TestUtils;
import org.wsi.util.Utils;
import org.wsi.xml.XMLUtils;

public class ReportImpl
implements Report {
    protected String filename = null;
    protected ReportContext reportContext = null;
    protected Log log = null;
    protected boolean allPassed = true;
    protected Vector artifactList = new Vector();
    protected Vector entryList = new Vector();
    protected ReportArtifact currentArtifact = null;
    protected Entry currentEntry = null;
    protected String prereqType;

    public String getLocation() {
        return this.filename;
    }

    public void setLocation(String string) {
        this.filename = string;
    }

    public ReportContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(ReportContext reportContext) {
        this.reportContext = reportContext;
    }

    public ReportArtifact getCurrentArtifact() {
        return this.currentArtifact;
    }

    public void setCurrentArtifact(ReportArtifact reportArtifact) throws WSIException {
        this.artifactList.add(reportArtifact);
        this.currentArtifact = reportArtifact;
        this.prereqType = "entry";
    }

    public void endCurrentArtifact() throws WSIException {
        this.currentArtifact = null;
    }

    public void addArtifactReference(ArtifactReference artifactReference) throws WSIException {
    }

    public Entry getCurrentEntry() {
        return this.currentEntry;
    }

    public void setCurrentEnvelopeEntry(Entry entry) throws WSIException {
    }

    public void setCurrentEntry(Entry entry) throws WSIException {
        this.entryList.add(entry);
        this.currentEntry = entry;
    }

    public void endCurrentEntry() throws WSIException {
        this.currentEntry = null;
    }

    public void addAssertionResult(AssertionResult assertionResult) {
        if (this.currentEntry != null) {
            this.currentEntry.addAssertionResult(assertionResult);
        }
        if (assertionResult.getResult().equals("failed")) {
            this.allPassed = false;
        }
    }

    public AssertionResult getAssertionResult(String string) {
        AssertionResult assertionResult = null;
        assertionResult = this.prereqType.equals("entry") ? this.currentEntry.getAssertionResult(string) : this.currentEntry.getEntryContainer().getAssertionResult(string);
        if (assertionResult == null) {
            Entry entry;
            for (int i = 0; i < this.entryList.size() && (assertionResult = (entry = (Entry)this.entryList.get(i)).getAssertionResult(string)) == null; ++i) {
            }
        }
        return assertionResult;
    }

    public AssertionResult createAssertionResult() {
        AssertionResultImpl assertionResultImpl = new AssertionResultImpl();
        assertionResultImpl.setAssertionResultsOption(this.reportContext.getAnalyzer().getAnalyzerConfig().getAssertionResultsOption());
        return assertionResultImpl;
    }

    public Entry createEntry() {
        EntryImpl entryImpl = new EntryImpl();
        return entryImpl;
    }

    public EntryContainer createEntryContainer() {
        EntryContainerImpl entryContainerImpl = new EntryContainerImpl();
        return entryContainerImpl;
    }

    public ReportArtifact createArtifact() {
        ReportArtifactImpl reportArtifactImpl = new ReportArtifactImpl();
        return reportArtifactImpl;
    }

    public FailureDetail createFailureDetail() {
        FailureDetailImpl failureDetailImpl = new FailureDetailImpl();
        return failureDetailImpl;
    }

    public String getSummaryResult() {
        return this.allPassed ? "passed" : "failed";
    }

    public void setPrereqType(String string) {
        this.prereqType = string;
    }

    public String toString() {
        return "Report:  ";
    }

    public String getStartXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("") && !string2.endsWith(":")) {
            string2 = string2 + ":";
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println(this.reportContext.getAnalyzer().getAnalyzerConfig().getAddStyleSheet().getStyleSheetString());
        String string3 = TestUtils.getXMLComment();
        if (string3 != null) {
            printWriter.print(string3);
        }
        printWriter.print("<" + string2 + "report" + " " + "name" + "=\"" + this.reportContext.getReportTitle() + "\"");
        printWriter.println("    timestamp=\"" + Utils.getTimestamp() + "\"");
        printWriter.println("    xmlns=\"http://www.ws-i.org/testing/2004/07/report/\"");
        printWriter.println("    xmlns:wsi-report=\"http://www.ws-i.org/testing/2004/07/report/\"");
        printWriter.println("    xmlns:wsi-log=\"http://www.ws-i.org/testing/2003/03/log/\"");
        printWriter.println("    xmlns:wsi-analyzerConfig=\"http://www.ws-i.org/testing/2004/07/analyzerConfig/\"");
        printWriter.println("    xmlns:wsi-monConfig=\"http://www.ws-i.org/testing/2003/03/monitorConfig/\"");
        printWriter.println("    xmlns:wsi-assertions=\"http://www.ws-i.org/testing/2004/07/assertions/\"");
        printWriter.println("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        printWriter.print(this.reportContext.getAnalyzer().toXMLString(string2));
        return stringWriter.toString();
    }

    public String getEndXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("") && !string2.endsWith(":")) {
            string2 = string2 + ":";
        }
        printWriter.print("  <" + string2 + "summary" + " ");
        printWriter.println("result=\"" + this.getSummaryResult() + "\">");
        printWriter.println("  </" + string2 + "summary" + ">");
        printWriter.println("</" + string2 + "report" + ">");
        return stringWriter.toString();
    }

    public String getErrorXMLString(String string, String string2) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string3 = string;
        if (!string3.equals("") && !string3.endsWith(":")) {
            string3 = string3 + ":";
        }
        printWriter.println("  <" + string3 + "analyzerFailure" + ">");
        printWriter.print("    <" + string3 + "failureDetail" + ">");
        printWriter.print(XMLUtils.xmlEscapedString(string2));
        printWriter.println("    </" + string3 + "failureDetail" + ">");
        printWriter.println("</" + string3 + "analyzerFailure" + ">");
        printWriter.println("</" + string3 + "report" + ">");
        return stringWriter.toString();
    }

    public String toXMLString(String string) {
        return this.getStartXMLString(string) + this.getEndXMLString(string);
    }
}

