/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.wsi.WSIException;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.log.impl.MimePartImpl;
import org.wsi.test.log.impl.MimePartsImpl;
import org.wsi.test.profile.ProfileAssertions;
import org.wsi.util.HTTPUtils;
import org.wsi.util.MIMEUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class Utils {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static ResourceBundle javaEncodingResource = null;
    private static final String JAVA_ENCODING_RESOURCE = "org.wsi.test.util.JavaEncoding";
    private static final String JAVA_ENCODING_DEFAULT = "UTF-8";

    public static final void logError(String string) {
        System.err.println("Error: " + string);
    }

    public static final String getExceptionDetails(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Exception: ");
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static String getTimestamp() {
        timestampFormat.setTimeZone(TimeZone.getDefault());
        return timestampFormat.format(new Date());
    }

    public static String getDate() {
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(new Date());
    }

    public static String getHTTPStatusCode(String string) throws WSIException {
        int n;
        int n2;
        String string2 = null;
        if (string.startsWith("HTTP")) {
            n2 = string.indexOf(" ");
            n = string.indexOf(" ", n2 + 1);
            if (n2 == -1 || n == -1) {
                throw new WSIException("Could not find status code in http headers: [" + string + "].");
            }
        } else {
            throw new WSIException("Could not find status code in http headers: [" + string + "].");
        }
        string2 = string.substring(n2 + 1, n);
        return string2;
    }

    public static String getHTTPHeaders(String string) {
        int n = string.indexOf("\r\n\r\n");
        if (n != -1) {
            n += 4;
        } else {
            n = Utils.getFirstCRLFCRLF(string);
            if (n == -1) {
                Utils.logError("Unable to parse HTTP message to find headers.  Full message: " + string);
                return "x-WSI-Test-Tool-Error: Couldn't find headers.  Full message: [" + string + "].";
            }
        }
        return string.substring(0, n);
    }

    public static String getContent(String string) {
        String string2 = "";
        int n = string.indexOf("\r\n\r\n");
        n = n != -1 ? (n += 4) : Utils.getFirstCRLFCRLF(string);
        if (n < 0) {
            Utils.logError("Unable to parse message to get content.  Full message: " + string);
            string2 = "x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + string + "].";
        } else {
            string2 = n >= string.length() ? "" : string.substring(n);
        }
        return string2;
    }

    public static byte[] getHTTPHeaders(byte[] byArray) {
        int n = Utils.getFirstCRLFCRLF(byArray, 0);
        if (n == -1) {
            Utils.logError("Unable to parse HTTP message to find headers.  Full message: " + byArray);
            return ("x-WSI-Test-Tool-Error: Couldn't find headers.  Full message: [" + byArray + "].").getBytes();
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static String getHTTPHeadersAsString(byte[] byArray, String string) {
        int n = Utils.getFirstCRLFCRLF(byArray, 0);
        if (n == -1) {
            Utils.logError("Unable to parse HTTP message to find headers.  Full message: " + byArray);
            return "x-WSI-Test-Tool-Error: Couldn't find headers.  Full message: [" + byArray + "].";
        }
        try {
            return new String(byArray, 0, n, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Utils.logError("Unsupported Encoding: " + string + ".  Full message: " + byArray);
            return "x-WSI-Test-Tool-Error: Unsupported Encoding \"" + string + "\".  Full message: [" + byArray + "].";
        }
    }

    public static String getContentAsString(byte[] byArray) {
        String string = "";
        int n = Utils.getFirstCRLFCRLF(byArray, 0);
        if (n < 0) {
            Utils.logError("Unable to parse message to get content.  Full message: " + byArray);
            string = "x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + byArray.toString() + "].";
        } else if (n < byArray.length) {
            try {
                string = new String(byArray, n, byArray.length - n);
            }
            catch (Exception exception) {
                Utils.logError("Unable to parse message to get content.  Full message: " + byArray);
                string = "x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + byArray.toString() + "].";
            }
        }
        return string;
    }

    public static byte[] getContent(byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        int n = Utils.getFirstCRLFCRLF(byArray, 0);
        if (n < 0) {
            Utils.logError("Unable to parse message to get content.  Full message: " + byArray);
            byArray = ("x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + byArray.toString() + "].").getBytes();
        } else if (n < byArray.length) {
            byte[] byArray3 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray3, 0, byArray.length - n);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public static int getFirstCRLF(byte[] byArray, int n) {
        int n2 = byArray.length;
        for (int i = n; i < n2 - 1; ++i) {
            if (byArray[i] != 13 || byArray[i + 1] != 10) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstCRLFCRLF(byte[] byArray, int n) {
        int n2 = byArray.length;
        for (int i = n; i < n2 - 3; ++i) {
            int n3;
            if (byArray[i] != 13 || byArray[i + 1] != 10 || byArray[i + 2] != 13) continue;
            if (byArray[i + 3] == 10) {
                return i + 4;
            }
            for (n3 = i + 3; n3 < byArray.length && byArray[n3] == 13; ++n3) {
            }
            if (n3 >= byArray.length || byArray[n3] != 10) continue;
            return n3 + 1;
        }
        return -1;
    }

    public static int getFirstCRLFCRLF(String string) {
        int n = string.indexOf("\r\n\r");
        if (n != -1) {
            int n2;
            for (n2 = n + 3; n2 < string.length() && string.startsWith("\r", n2); ++n2) {
            }
            if (n2 < string.length() && string.startsWith("\n", n2)) {
                return n2 + 1;
            }
            return Utils.getFirstCRLFCRLF(string.substring(n + 3));
        }
        return -1;
    }

    public static int[] getBoundaryIndices(byte[] byArray, String string) {
        int[] nArray = new int[256];
        int n = 0;
        try {
            byte[] byArray2 = ("\r\n--" + string).getBytes("US-ASCII");
            int n2 = 0;
            int n3 = 0;
            int n4 = byArray.length;
            while (n2 != -1) {
                n2 = Utils.indexOf(byArray, byArray2, n3);
                if (n2 == -1) continue;
                n3 = n2 + byArray2.length;
                nArray[n] = n2;
                ++n;
            }
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        int n4 = 0;
        if (n3 > n2 - n) {
            return -1;
        }
        for (n4 = n + n3 - 1; n4 < n2; ++n4) {
            int n5;
            int n6 = n4;
            for (n5 = n3 - 1; n5 >= 0 && byArray[n6] == byArray2[n5]; --n5) {
                --n6;
            }
            if (n5 != -1) continue;
            return n6 + 1;
        }
        return -1;
    }

    public static InputStream getInputStream(String string) throws IOException {
        URL uRL;
        InputStream inputStream;
        block10: {
            inputStream = null;
            try {
                uRL = new URL(string);
                inputStream = Utils.getInputStream(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                boolean bl = false;
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    bl = true;
                }
                catch (SecurityException securityException) {
                    bl = true;
                }
                catch (Exception exception) {
                    System.out.println("Exception in getInputStream :" + exception.toString());
                }
                if (!bl) break block10;
                inputStream = ClassLoader.getSystemResourceAsStream(string);
            }
        }
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null && (uRL = Thread.currentThread().getContextClassLoader().getResource(string)) != null) {
            inputStream = Utils.getInputStream(uRL);
        }
        if (inputStream == null) {
            throw new FileNotFoundException("Could not locate resource file: " + string);
        }
        return inputStream;
    }

    public static InputStream getInputStream(URL uRL) throws IOException, ConnectException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
        }
        catch (ConnectException connectException) {
            throw new ConnectException("Could not connect to URL: " + uRL.toExternalForm() + ".");
        }
        return bufferedInputStream;
    }

    public static boolean fileExists(String string) {
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                File file = new File(string);
                bl = file.exists();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static String getLocalHostName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = "127.0.0.1";
        }
        return string;
    }

    public static String formatURL(String string, String string2, String string3) {
        String string4 = string3;
        if (!string4.startsWith("/")) {
            string4 = "/" + string3;
        }
        return "http://" + string + ":" + string2 + string4;
    }

    public static String replaceString(String string, String string2, String string3) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string3.length();
        String string4 = string;
        int n4 = string4.indexOf(string2);
        while (n4 < string4.length() - 1 && n4 != -1) {
            string4 = string4.substring(0, n4) + string3 + string4.substring(n4 + n2);
            n = n4;
            n4 = string4.indexOf(string2, n + n3);
        }
        return string4;
    }

    public static String toHexString(String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        char[] cArray2 = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray2[n3++] = cArray[by >>> 4 & 0xF];
            cArray2[n3++] = cArray[by & 0xF];
        }
        return new String(cArray2);
    }

    public static String toHexString(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = byArray.length;
        char[] cArray2 = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray2[n3++] = cArray[by >>> 4 & 0xF];
            cArray2[n3++] = cArray[by & 0xF];
        }
        return new String(cArray2);
    }

    public static String getHTTPCharset(String string) {
        String string2 = null;
        string2 = string.toUpperCase();
        int[] nArray = new int[]{-1, -1, -1};
        int n = string2.indexOf("CHARSET");
        int n2 = Integer.MAX_VALUE;
        if (n < 17) {
            return "";
        }
        if ((n = string2.indexOf("=", n + 7)) == -1) {
            return "";
        }
        nArray[0] = string2.indexOf("'", ++n);
        nArray[1] = string2.indexOf("\r\n", n);
        nArray[2] = string2.indexOf("\"", n);
        for (int i = 0; i < 3; ++i) {
            if (!(nArray[i] != -1 & n2 > nArray[i])) continue;
            n2 = nArray[i];
        }
        if (n2 != Integer.MAX_VALUE) {
            string2 = string.substring(n, n2);
            string2.trim();
        } else {
            string2 = "";
        }
        return string2;
    }

    public static boolean isMultipartRelatedMessage(String string) {
        boolean bl = false;
        try {
            String string2 = HTTPUtils.getHttpHeaderAttribute(string, "Content-Type");
            if (string2 == null) {
                String string3 = Utils.getHttpHeaderSubAttribute(string, "Content-Type", "boundary");
                if (string3 != null && !string3.equals("")) {
                    bl = true;
                }
            } else {
                bl = string2.equalsIgnoreCase("multipart/related");
            }
        }
        catch (WSIException wSIException) {
            bl = false;
        }
        return bl;
    }

    public static String getHttpHeaderAttribute(String string, String string2) {
        String string3 = null;
        try {
            string3 = HTTPUtils.getHttpHeaderAttribute(string, string2);
        }
        catch (WSIException wSIException) {
            string3 = null;
        }
        return string3;
    }

    public static String getHttpHeaderSubAttribute(String string, String string2, String string3) {
        String string4 = null;
        try {
            string4 = HTTPUtils.getHttpHeaderSubAttribute(string, string2, string3);
        }
        catch (WSIException wSIException) {
            string4 = null;
        }
        return string4;
    }

    public static String getMimeHeaderAttribute(String string, String string2) {
        String string3 = null;
        try {
            string3 = MIMEUtils.getMimeHeaderAttribute(string, string2);
        }
        catch (WSIException wSIException) {
            string3 = null;
        }
        return string3;
    }

    public static String getMimeHeaderSubAttribute(String string, String string2, String string3) {
        String string4 = null;
        try {
            string4 = MIMEUtils.getMimeHeaderSubAttribute(string, string2, string3);
        }
        catch (WSIException wSIException) {
            string4 = null;
        }
        return string4;
    }

    public static String getXMLEncoding(String string) {
        String string2 = null;
        int n = string.indexOf("<?xml");
        int n2 = -1;
        if (n != -1 && (n2 = string.indexOf("?>", n)) > n) {
            string2 = string.substring(n, n2);
        }
        if (string2 != null) {
            n = string2.indexOf("encoding");
            if (n == -1) {
                string2 = "";
            } else {
                string2 = string2.substring(n + 8);
                string2 = string2.trim();
            }
        } else {
            return "";
        }
        if (string2.length() > 3) {
            n = string2.indexOf("=");
            if (n == 0) {
                string2 = string2.substring(1);
            } else {
                return "";
            }
        }
        if (string2.length() > 3) {
            String string3 = "\"";
            n = string2.indexOf(string3);
            if (n != 0) {
                string3 = "'";
                n = string2.indexOf("'");
            }
            string2 = n == 0 ? ((n2 = string2.indexOf(string3, 3)) != -1 ? string2.substring(1, n2) : "") : "";
        }
        return string2;
    }

    public static String getJavaEncoding(String string) {
        if (string == null || string.length() == 0) {
            return JAVA_ENCODING_DEFAULT;
        }
        try {
            if (javaEncodingResource == null) {
                javaEncodingResource = ResourceBundle.getBundle(JAVA_ENCODING_RESOURCE);
            }
            return javaEncodingResource.getString(string);
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static Vector arrayToVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(objectArray[i]);
        }
        return vector;
    }

    public static boolean isValidProfileTADVersion(ProfileAssertions profileAssertions) {
        boolean bl = false;
        String string = profileAssertions.getTADName();
        String string2 = profileAssertions.getTADVersion();
        if ("Basic Profile Test Assertions".equals(string)) {
            bl = Utils.checkVersionNumber("1.1.0", string2);
        } else if ("Basic Profile 1.1 Test Assertions".equals(string)) {
            bl = Utils.checkVersionNumber("1.1.0", string2);
        } else if ("Simple Soap Binding Profile [1.0] (with Basic Profile [1.1]) Test Assertions".equals(string)) {
            bl = Utils.checkVersionNumber("1.0.0", string2);
        } else if ("Attachments Profile [1.0] (with Basic Profile [1.1] and Simple Soap Binding Profile [1.0]) Test Assertions".equals(string)) {
            bl = Utils.checkVersionNumber("1.0.0", string2);
        }
        return bl;
    }

    private static boolean checkVersionNumber(String string, String string2) {
        boolean bl = true;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
            while (stringTokenizer.hasMoreTokens() && bl) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer2.hasMoreTokens()) continue;
                int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                if (n <= n2) {
                    bl = n >= n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static MimePart findRootPart(String string, Collection collection) {
        MimePart mimePart = null;
        String string2 = Utils.getHttpHeaderSubAttribute(string, "Content-Type", "start");
        if (!collection.isEmpty()) {
            mimePart = (MimePart)collection.iterator().next();
            if (string2 != null && !string2.equals("")) {
                Iterator iterator = collection.iterator();
                boolean bl = true;
                while (iterator.hasNext() && bl) {
                    String string3;
                    MimePart mimePart2 = (MimePart)iterator.next();
                    String string4 = mimePart2.getHeaders();
                    if (string4 == null || !string2.equals(string3 = Utils.getMimeHeaderAttribute(string4, "Content-ID"))) continue;
                    mimePart = mimePart2;
                    bl = false;
                }
            }
        }
        return mimePart;
    }

    public static byte[] decodeBase64(String string) {
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            return bASE64Decoder.decodeBuffer(string);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public static String encodeBase64(byte[] byArray) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encodeBuffer(byArray);
    }

    public static MimeParts parseMultipartRelatedMessage(String string, String string2, String string3) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(string3);
        }
        catch (Exception exception) {
            return null;
        }
        return Utils.parseMultipartRelatedMessage(byArray, string2, string3);
    }

    public static MimeParts parseMultipartRelatedMessage(byte[] byArray, String string, String string2) {
        int n;
        MimePartsImpl mimePartsImpl = new MimePartsImpl();
        String string3 = Utils.getHttpHeaderSubAttribute(string, "Content-Type", "boundary");
        ArrayList<MimePartImpl> arrayList = new ArrayList<MimePartImpl>();
        if (string3 == null) {
            return null;
        }
        String string4 = Utils.getHttpHeaderSubAttribute(string, "Content-Type", "start");
        int[] nArray = Utils.getBoundaryIndices(byArray, string3);
        boolean bl = true;
        for (n = nArray.length - 2; n >= 0; --n) {
            try {
                String string5;
                MimePartImpl mimePartImpl = new MimePartImpl();
                int n2 = Utils.getFirstCRLFCRLF(byArray, nArray[n]);
                if (n2 <= nArray[n] || n2 >= nArray[n + 1]) continue;
                String string6 = new String(byArray, nArray[n], n2 - nArray[n], "US-ASCII");
                String string7 = string6.substring(0, string6.indexOf("\r\n", 2) + 2);
                if (n == nArray.length - 2) {
                    string5 = new String(byArray, nArray[n + 1], byArray.length - nArray[n + 1], "US-ASCII");
                    int n3 = string6.indexOf("\r\n", 2);
                    if (n3 != -1) {
                        string5 = string6.substring(0, string6.indexOf("\r\n", 2) + 2);
                    }
                    mimePartImpl.setBoundaryStrings(new String[]{string7, string5});
                } else {
                    mimePartImpl.setBoundaryStrings(new String[]{string7});
                }
                string5 = string6.substring(string7.length());
                if (string5.startsWith("\r\n")) {
                    mimePartImpl.setHeaders("");
                } else {
                    mimePartImpl.setHeaders(string5);
                }
                String string8 = Utils.getMimeHeaderAttribute(string5, "Content-ID");
                int n4 = nArray[n + 1] - n2;
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, n2, byArray2, 0, n4);
                if (bl && n == 0 || string4 != null && !string4.equals("") && string4.equals(string8)) {
                    mimePartImpl.setContent(new String(byArray2, string2));
                    mimePartsImpl.setRootPart(mimePartImpl);
                } else {
                    String string9 = Utils.getMimeHeaderAttribute(string5, "Content-Transfer-Encoding");
                    if (string9 != null && string9.equalsIgnoreCase("base64")) {
                        mimePartImpl.setContent(new String(byArray2, string2));
                    } else {
                        mimePartImpl.setContent(Utils.encodeBase64(byArray2));
                    }
                }
                arrayList.add(mimePartImpl);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        n = arrayList.size();
        for (int i = n - 1; i >= 0; --i) {
            mimePartsImpl.addPart((MimePart)arrayList.get(i));
        }
        return mimePartsImpl;
    }
}

