/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.xml.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.wsi.xml.dom.DOMParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder {
    protected DOMParser domParser = null;
    protected EntityResolver entityResolver = null;
    protected ErrorHandler errorHandler = new DefaultHandler();
    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    static /* synthetic */ Class class$org$wsi$xml$XMLUtils;

    public DocumentBuilderImpl(DocumentBuilderFactory documentBuilderFactory, Hashtable hashtable) throws SAXException {
        this.domParser = new DOMParser();
        this.domParser.setFeature(NAMESPACES_FEATURE, documentBuilderFactory.isNamespaceAware());
        this.domParser.setFeature(VALIDATION_FEATURE, documentBuilderFactory.isValidating());
        if (documentBuilderFactory.isValidating()) {
            this.domParser.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        this.domParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", !documentBuilderFactory.isIgnoringElementContentWhitespace());
        this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", !documentBuilderFactory.isExpandEntityReferences());
        this.domParser.setFeature("http://apache.org/xml/features/include-comments", !documentBuilderFactory.isIgnoringComments());
        this.domParser.setFeature("http://apache.org/xml/features/create-cdata-nodes", !documentBuilderFactory.isCoalescing());
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
                    if (hashtable.get(string) instanceof InputSource[]) {
                        this.domParser.setProperty(string, (InputSource[])hashtable.get(string));
                        continue;
                    }
                    this.domParser.setProperty(string, (InputSource)hashtable.get(string));
                    continue;
                }
                this.domParser.setProperty(string, hashtable.get(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((class$org$wsi$xml$XMLUtils == null ? (class$org$wsi$xml$XMLUtils = DocumentBuilderImpl.class$("org.wsi.xml.XMLUtils")) : class$org$wsi$xml$XMLUtils).getClassLoader());
            if (this.entityResolver != null) {
                this.domParser.setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                this.domParser.setErrorHandler(this.errorHandler);
            }
            this.domParser.parse(inputSource);
            Document document = this.domParser.getDocument();
            return document;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public boolean isNamespaceAware() {
        boolean bl = false;
        try {
            bl = this.domParser.getFeature(NAMESPACES_FEATURE);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
        return bl;
    }

    public boolean isValidating() {
        boolean bl = false;
        try {
            bl = this.domParser.getFeature(VALIDATION_FEATURE);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
        return bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return new DOMImplementationImpl();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

