/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.Part;
import org.apache.axis.SOAPPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class Message
extends SOAPMessage
implements Serializable {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$Message == null ? (class$org$apache$axis$Message = Message.class$("org.apache.axis.Message")) : class$org$apache$axis$Message).getName());
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    public static final String MIME_APPLICATION_DIME = "application/dime";
    public static final String DEFAULT_ATTACHMNET_IMPL = "org.apache.axis.attachments.AttachmentsImpl";
    private static String mAttachmentsImplClassName = "org.apache.axis.attachments.AttachmentsImpl";
    public static final String MIME_UNKNOWN = "  ";
    private String messageType;
    private SOAPPart mSOAPPart;
    private Attachments mAttachments = null;
    private MimeHeaders headers;
    private boolean saveRequired = true;
    private MessageContext msgContext;
    private static Class attachImpl = null;
    private static boolean checkForAttchmentSupport = true;
    private static boolean attachmentSupportEnabled = false;
    static /* synthetic */ Class class$org$apache$axis$Message;

    public static String getAttachmentImplClassName() {
        return mAttachmentsImplClassName;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public Message(Object initialContents, boolean bodyInStream) {
        this.setup(initialContents, bodyInStream, null, null, null);
    }

    public Message(Object initialContents, boolean bodyInStream, MimeHeaders headers) {
        this.setup(initialContents, bodyInStream, null, null, headers);
    }

    public Message(Object initialContents, MimeHeaders headers) {
        this.setup(initialContents, true, null, null, headers);
    }

    public Message(Object initialContents, boolean bodyInStream, String contentType, String contentLocation) {
        this.setup(initialContents, bodyInStream, contentType, contentLocation, null);
    }

    public Message(Object initialContents) {
        this.setup(initialContents, false, null, null, null);
    }

    private static synchronized boolean isAttachmentSupportEnabled(MessageContext mc) {
        if (checkForAttchmentSupport) {
            checkForAttchmentSupport = false;
            try {
                AxisEngine ae;
                String attachImpName = DEFAULT_ATTACHMNET_IMPL;
                if (null != mc && null != (ae = mc.getAxisEngine())) {
                    attachImpName = (String)ae.getOption("attachments.implementation");
                }
                if (null == attachImpName) {
                    attachImpName = DEFAULT_ATTACHMNET_IMPL;
                }
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachImpl = ClassUtils.forName(attachImpName);
                attachmentSupportEnabled = true;
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoClassDefFoundError ex) {
                // empty catch block
            }
            log.debug((Object)(Messages.getMessage("attachEnabled") + MIME_UNKNOWN + attachmentSupportEnabled));
        }
        return attachmentSupportEnabled;
    }

    private void setup(Object initialContents, boolean bodyInStream, String contentType, String contentLocation, MimeHeaders mimeHeaders) {
        if (contentType == null && mimeHeaders != null) {
            String[] contentTypes = mimeHeaders.getHeader("Content-Type");
            String string = contentType = contentTypes != null ? contentTypes[0] : null;
        }
        if (contentLocation == null && mimeHeaders != null) {
            String[] contentLocations = mimeHeaders.getHeader("Content-Location");
            String string = contentLocation = contentLocations != null ? contentLocations[0] : null;
        }
        if (Message.isAttachmentSupportEnabled(this.getMessageContext())) {
            Constructor<?> attachImplConstr = attachImpl.getConstructors()[0];
            try {
                this.mAttachments = (Attachments)attachImplConstr.newInstance(initialContents, contentType, contentLocation);
                this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
            }
            catch (InvocationTargetException ex) {
                log.fatal((Object)Messages.getMessage("invocationTargetException00"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
            catch (InstantiationException ex) {
                log.fatal((Object)Messages.getMessage("instantiationException00"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                log.fatal((Object)Messages.getMessage("illegalAccessException00"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        } else if (contentType != null && contentType.startsWith("multipart")) {
            throw new RuntimeException(Messages.getMessage("noAttachments"));
        }
        if (null == this.mSOAPPart) {
            this.mSOAPPart = new SOAPPart(this, initialContents, bodyInStream);
        } else {
            this.mSOAPPart.setMessage(this);
        }
        if (this.mAttachments != null) {
            this.mAttachments.setRootPart(this.mSOAPPart);
        }
        this.headers = mimeHeaders == null ? new MimeHeaders() : mimeHeaders;
    }

    public javax.xml.soap.SOAPPart getSOAPPart() {
        return this.mSOAPPart;
    }

    public String getSOAPPartAsString() throws AxisFault {
        return this.mSOAPPart.getAsString();
    }

    public byte[] getSOAPPartAsBytes() throws AxisFault {
        return this.mSOAPPart.getAsBytes();
    }

    public SOAPEnvelope getSOAPEnvelope() throws AxisFault {
        return this.mSOAPPart.getAsSOAPEnvelope();
    }

    public Attachments getAttachmentsImpl() {
        return this.mAttachments;
    }

    public String getContentType(SOAPConstants sc) throws AxisFault {
        int sendType = 1;
        if (this.msgContext != null && this.msgContext.getService() != null) {
            sendType = this.msgContext.getService().getSendType();
        }
        if (sendType != 4) {
            this.mSOAPPart.getAsBytes();
        }
        String ret = sc.getContentType();
        if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            ret = this.mAttachments.getContentType();
        }
        return ret;
    }

    public long getContentLength() throws AxisFault {
        long ret = this.mSOAPPart.getAsBytes().length;
        if (this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount()) {
            ret = this.mAttachments.getContentLength();
        }
        return ret;
    }

    public void writeTo(OutputStream os) throws SOAPException, IOException {
        if (this.mAttachments == null || 0 == this.mAttachments.getAttachmentCount()) {
            try {
                Writer writer = new OutputStreamWriter(os, "UTF-8");
                writer = new BufferedWriter(writer);
                this.mSOAPPart.writeTo(writer);
                writer.flush();
            }
            catch (IOException e) {
                log.error((Object)Messages.getMessage("javaIOException00"), (Throwable)e);
            }
        } else {
            try {
                this.mAttachments.writeContentToStream(os);
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            }
        }
    }

    public String getContentDescription() {
        String[] values = this.headers.getHeader("Content-Description");
        if (values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setContentDescription(String description) {
        this.headers.setHeader("Content-Description", description);
    }

    public void saveChanges() throws SOAPException {
        this.saveRequired = false;
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public void removeAllAttachments() {
        this.mAttachments.removeAllAttachments();
    }

    public int countAttachments() {
        return this.mAttachments == null ? 0 : this.mAttachments.getAttachmentCount();
    }

    public Iterator getAttachments() {
        try {
            return this.mAttachments.getAttachments().iterator();
        }
        catch (AxisFault af) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)af);
            return null;
        }
    }

    public Iterator getAttachments(MimeHeaders headers) {
        return this.mAttachments.getAttachments(headers);
    }

    public void addAttachmentPart(AttachmentPart attachmentpart) {
        try {
            this.mAttachments.addAttachmentPart((Part)attachmentpart);
        }
        catch (AxisFault af) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)af);
        }
    }

    public AttachmentPart createAttachmentPart() {
        try {
            return (AttachmentPart)this.mAttachments.createAttachmentPart();
        }
        catch (AxisFault af) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)af);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

