<?xml version="1.0" encoding="UTF-8"?>

<!--
 Formatting for WS-I Log File generated by the Monitor tool.
 
	Copyright (c) 2002-2004 by The Web Services-Interoperability Organization (WS-I) and 
	Certain of its Members. All Rights Reserved.
	
	Notice
	The material contained herein is not a license, either expressly or impliedly, to any 
	intellectual property owned or controlled by any of the authors or developers of this 
	material or WS-I. The material contained herein is provided on an "AS IS" basis and to 
	the maximum extent permitted by applicable law, this material is provided AS IS AND WITH 
	ALL FAULTS, and the authors and developers of this material and WS-I hereby disclaim all 
	other warranties and conditions, either express, implied or statutory, including, but not 
	limited to, any (if any) implied warranties, duties or conditions of  merchantability, 
	of fitness for a particular purpose, of accuracy or completeness of responses, of results, 
	of workmanlike effort, of lack of viruses, and of lack of negligence. ALSO, THERE IS NO 
	WARRANTY OR CONDITION OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, CORRESPONDENCE TO 
	DESCRIPTION OR NON-INFRINGEMENT WITH REGARD TO THIS MATERIAL.
	
	IN NO EVENT WILL ANY AUTHOR OR DEVELOPER OF THIS MATERIAL OR WS-I BE LIABLE TO ANY OTHER 
	PARTY FOR THE COST OF PROCURING SUBSTITUTE GOODS OR SERVICES, LOST PROFITS, LOSS OF USE, 
	LOSS OF DATA, OR ANY INCIDENTAL, CONSEQUENTIAL, DIRECT, INDIRECT, OR SPECIAL DAMAGES 
	WHETHER UNDER CONTRACT, TORT, WARRANTY, OR OTHERWISE, ARISING IN ANY WAY OUT OF THIS OR 
	ANY OTHER AGREEMENT RELATING TO THIS MATERIAL, WHETHER OR NOT SUCH PARTY HAD ADVANCE 
	NOTICE OF THE POSSIBILITY OF SUCH DAMAGES.
	
	WS-I License Information
	Use of this WS-I Material is governed by the WS-I Test License and other licenses.  Information on these 
	licenses are contained in the README.txt and ReleaseNotes.txt files.  By downloading this file, you agree 
	to the terms of these licenses.
	
	How To Provide Feedback
	The Web Services-Interoperability Organization (WS-I) would like to receive input, 
	suggestions and other feedback ("Feedback") on this work from a wide variety of 
	industry participants to improve its quality over time. 
	
	By sending email, or otherwise communicating with WS-I, you (on behalf of yourself if 
	you are an individual, and your company if you are providing Feedback on behalf of the 
	company) will be deemed to have granted to WS-I, the members of WS-I, and other parties 
	that have access to your Feedback, a non-exclusive, non-transferable, worldwide, perpetual, 
	irrevocable, royalty-free license to use, disclose, copy, license, modify, sublicense or 
	otherwise distribute and exploit in any manner whatsoever the Feedback you provide regarding 
	the work. You acknowledge that you have no expectation of confidentiality with respect to 
	any Feedback you provide. You represent and warrant that you have rights to provide this 
	Feedback, and if you are providing Feedback on behalf of a company, you represent and warrant 
	that you have the rights to provide Feedback on behalf of your company. You also acknowledge 
	that WS-I is not required to review, discuss, use, consider or in any way incorporate your 
	Feedback into future versions of its work. If WS-I does incorporate some or all of your 
	Feedback in a future version of the work, it may, but is not obligated to include your name 
	(or, if you are identified as acting on behalf of your company, the name of your company) on 
	a list of contributors to the work. If the foregoing is not acceptable to you and any company 
	on whose behalf you are acting, please do not provide any Feedback.
	
	WS-I members should direct feedback on this document to wsi_testing@lists.ws-i.org; 
    non-members should direct feedback to wsi-tools@ws-i.org. 
	

  Copyright (c) 2002-2004 IBM Corporation.  All rights reserved.

  @author Peter Brittenham, peterbr@us.ibm.com
  @version 0.91
-->

<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:wsi-common="http://www.ws-i.org/testing/2003/03/common/"
	xmlns:wsi-monConfig="http://www.ws-i.org/testing/2003/03/monitorConfig/"
	xmlns:wsi-log="http://www.ws-i.org/testing/2003/03/log/">
<xsl:import href="common.xsl"/>

<xsl:output method="html" indent="yes"/>

<!--<xsl:variable name="titleRowColor" select="'#e1e1e1'"/>-->

<xsl:template match="/">
<html>
	<!-- <link type="text/css" rel="stylesheet" href="http://www.ws-i.org/styles.css" /> -->
	<head>
    <title>WS-I Log File Generated by WS-I Testing Tools</title>
    <!-- Need to put the following in a common CSS file -->
    <style type="text/css">
       BODY {
        border-top-style : none;
        border-left-style : none;
        border-right-style : none;
        border-bottom-style : none;
        font-family : Arial,sans-serif;
  	  font-size : 22px;
      }
      H1 {
        color : #336699;
  	  font-size : 26px;
      }
      H2 {
        background-color : #336699;
        PADDING-BOTTOM: 1px;
        PADDING-LEFT: 4px;
        PADDING-RIGHT: 4px;
        PADDING-TOP: 1px;
        color : white;
	  font-size : 24px;
      }
      H3 {
        background-color : #7ca8da;
        padding-left : 6px;
        padding-right : 6px;
        padding-top : 2px;
        padding-bottom : 2px;
   	  font-size : 22px;
      }
      TABLE {
        margin-left : 1em;
        margin-right : 1em;
        font-size : 20px;
      }    
      .contents1 {
        margin-left : 2em;
      }
      .contents2 {
        margin-left : 2.2em;
      }
      .data-type {
        margin-left : 1em;
        margin-right : 1em;
      }    
      .data-content {
        margin-left : 1em;
        margin-right : 1em;
      }    
    </style>
	</head>

	<body>
    <img align="right" src="http://www.ws-i.org/images/WS-I-logo.gif"/>
    <h1>WS-I Testing Tools Log File</h1>
    <xsl:apply-templates />
	</body>
</html>
</xsl:template>

<xsl:template match="wsi-log:log" >
  <table>
  <!-- REMOVED: name attribute no longer supported in monitor spec
  <tr><td>
  <b>Log:</b>
  </td><td>
  <xsl:value-of select="@name" />
  </td></tr>
  -->
  <tr><td>
  <b>Timestamp:</b>
	</td><td>
  <xsl:value-of select="@timestamp" />
	</td></tr>
  </table>
  <br/>
  
  <xsl:call-template name="copyright"/>
  
  <hr style="color : black;"/>
  <xsl:apply-templates select="wsi-log:monitor"/>
  <h2><a name="LogEntries">Log Entries</a></h2>
  <xsl:choose>
  <xsl:when test="wsi-log:messageEntry">
  <table cellpadding="4" bgcolor="#000000" cellspacing="1" valign="top">
  <tr bgcolor="{$titleRowColor}"><td>
  <b>ID</b>
  </td><td>
  <b>Conversation ID</b>
  </td><td>
  <b>Type</b>
	</td></tr>
  <xsl:for-each select="wsi-log:messageEntry">
  <!--<xsl:sort select="@ID" data-type="number"/>-->
   <tr bgcolor="#ffffff"><td>
    <xsl:variable name="linkName" select="@ID"/>
	  <a href="#{$linkName}"><xsl:value-of select="$linkName"/></a>
 </td><td>
  <xsl:value-of select="@conversationID" /> 
 </td><td>
  <xsl:value-of select="@type" /> 
 </td></tr>
  </xsl:for-each>
  </table>
  <xsl:apply-templates select="wsi-log:messageEntry">
    <!--<xsl:sort select="@ID"/>-->
  </xsl:apply-templates>
  </xsl:when>
  <xsl:otherwise>
  <b>This log file does not contain any message entries.</b>
  </xsl:otherwise>
  </xsl:choose>

	<xsl:call-template name="notice"/>
</xsl:template>
  
<xsl:template match="wsi-log:monitor" >
  <h2>Monitor Tool Information</h2>
  <table cellpadding="4" bgcolor="#000000" cellspacing="1" valign="top">
  <tr bgcolor="#ffffff"><td>
  <b>Version</b>
	</td><td>
  <xsl:value-of select="@version" />
	</td></tr>
  <tr bgcolor="#ffffff"><td>
  <b>Release Date</b>
	</td><td>
  <xsl:value-of select="@releaseDate" />
	</td></tr>
  <tr bgcolor="#ffffff"><td>
  <b>Implementer Name</b>
	</td><td>
  <xsl:value-of select="wsi-log:implementer/@name" />
	</td></tr>
  <tr bgcolor="#ffffff"><td>
  <b>Location</b>
	</td><td>
  <xsl:value-of select="wsi-log:implementer/@location" />
	</td></tr>
  </table>
  <xsl:apply-templates />
  <hr style="color : black;"/>
</xsl:template>
  
<xsl:template match="wsi-log:environment" >
  <h3>Monitor Runtime Environment Information</h3>
  <table cellpadding="4" bgcolor="#000000" cellspacing="1" valign="top">
  <tr bgcolor="#ffffff"><td>
  <b>Runtime Name</b>
	</td><td>
  <xsl:value-of select="wsi-log:runtime/@name" />
	</td></tr>
  <tr bgcolor="#ffffff"><td>
  <b>Runtime Version</b>
	</td><td>
  <xsl:value-of select="wsi-log:runtime/@version" />
	</td></tr>
  <tr bgcolor="#ffffff"><td>
  <b>Operating System Name</b>
	</td><td>
  <xsl:value-of select="wsi-log:operatingSystem/@name" />
	</td></tr>
  <tr bgcolor="#ffffff"><td>
  <b>Operating System Version</b>
	</td><td>
  <xsl:value-of select="wsi-log:operatingSystem/@version" />
	</td></tr>
  <tr bgcolor="#ffffff"><td>
  <b>XML Parser Name</b>
	</td><td>
  <xsl:value-of select="wsi-log:xmlParser/@name" />
	</td></tr>
  <tr bgcolor="#ffffff"><td>
  <b>XML Parser Version</b>
	</td><td>
  <xsl:value-of select="wsi-log:xmlParser/@version" />
	</td></tr>
  </table>
</xsl:template>
  
<xsl:template match="wsi-monConfig:configuration" >
  <h3>Monitor Configuration Information</h3>
  <xsl:if test="wsi-monConfig:comment">
    <p><xsl:value-of select="wsi-monConfig:comment" /></p>
  </xsl:if>
  <table cellpadding="4" bgcolor="#000000" cellspacing="1" valign="top">
  <tr  bgcolor="{$titleRowColor}"><td>
  <b>Log File</b>
  </td><td>
  <b>Replace Log</b>
  </td><td>
  <b>Log Duration</b>
  </td><td>
  <b>Cleanup Timeout</b>
  </td></tr>
  <tr bgcolor="#ffffff"><td>
  <xsl:value-of select="wsi-monConfig:logFile/@location" />
  </td><td>
  <xsl:value-of select="wsi-monConfig:logFile/@replace" />
  </td><td>
  <xsl:value-of select="wsi-monConfig:logDuration" />
  </td><td>
  <xsl:value-of select="wsi-monConfig:cleanupTimeoutSeconds" />
  </td></tr>
  </table>
  <p><b>Man-in-the-Middle Monitor:</b></p>
  <table cellpadding="4" bgcolor="#000000" cellspacing="1" valign="top">
    <tr  bgcolor="{$titleRowColor}"><td>
    <b>Listen Port</b>
    </td><td>
    <b>Scheme And Host/Port</b>
    </td><td>
    <b>Maximum Connections</b>
    </td><td>
    <b>Read Timeout Seconds</b>
    </td></tr>
    <xsl:for-each select="wsi-monConfig:manInTheMiddle/wsi-monConfig:redirect">
      <tr bgcolor="#ffffff"><td>
      <xsl:value-of select="wsi-monConfig:listenPort" />
      </td><td>
      <xsl:value-of select="wsi-monConfig:schemeAndHostPort" />
      </td><td>
      <xsl:value-of select="wsi-monConfig:maxConnections" />
      </td><td>
      <xsl:value-of select="wsi-monConfig:readTimeoutSeconds" />
      </td></tr>
  	</xsl:for-each>
  </table>
  <br/>
</xsl:template>

<xsl:template match="wsi-log:messageEntry" >
  <xsl:variable name="linkName" select="@ID"/>
	<a name="#{$linkName}"><h3>Message Entry: <xsl:value-of select="$linkName"/></h3></a>
  <table cellpadding="4" bgcolor="#000000" cellspacing="1" valign="top">
  <tr  bgcolor="{$titleRowColor}"><td>
  <b>Conversation ID</b>
  </td><td>
  <b>Message Type</b>
  </td><td>
  <b>Timestamp</b>
  </td><td>
  <b>Sender Host and Port</b>
  </td><td>
  <b>Receiver Host and Port</b>
  </td></tr>
  <tr bgcolor="#ffffff"><td>
  <xsl:value-of select="@conversationID" />
  </td><td>
  <xsl:value-of select="@type" />
  </td><td>
  <xsl:value-of select="@timestamp" />
  </td><td>
  <xsl:value-of select="wsi-log:senderHostAndPort" />
  </td><td>
  <xsl:value-of select="wsi-log:receiverHostAndPort" />
  </td></tr>
  </table>
  <br/>
  <!-- <p><a href="#LogEntries">Return to start of log entries.</a></p> -->
  <hr style="color : black;"/>
  <p><b>HTTP Headers:</b></p>
  <pre><xsl:value-of select="wsi-log:httpHeaders" /></pre>
  <hr style="color : black;"/>
  <p><b>Message Content:</b></p>
  <xsl:choose>
  <xsl:when test="wsi-log:messageContent=''">
    <b>[There is no message content.]</b>
  </xsl:when>
  <xsl:otherwise>
    <xsl:variable name="messageContent" select="wsi-log:messageContent"/>
    <xsl:choose>
    <xsl:when test="contains($messageContent, '&#xD;')">
    <pre><xsl:value-of select="wsi-log:messageContent" /></pre>
    </xsl:when>
    <xsl:when test="contains($messageContent, '&#xA;')">
    <pre><xsl:value-of select="wsi-log:messageContent" /></pre>
    </xsl:when>
    <xsl:otherwise>
    <text><xsl:value-of select="wsi-log:messageContent" /></text>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:otherwise>
  </xsl:choose>
  <hr style="color : black;"/>
  <p><a href="#LogEntries">Return to start of log entries.</a></p>
</xsl:template>
</xsl:stylesheet>
