// Copyright (c) 2011 RealSolid. Please read license.txt for applicable licensing.

#include "uibase.h"
#include "headers.h"



#include "../share/xpm/addressbook16.xpm"
#include "../share/xpm/addressbook20.xpm"
#include "../share/xpm/solidcoin16.xpm"
#include "../share/xpm/solidcoin20.xpm"
#include "../share/xpm/solidcoin32.xpm"
#include "../share/xpm/solidcoin48.xpm"
#include "../share/xpm/solidcoin80.xpm"
#include "../share/xpm/check.xpm"
#include "../share/xpm/send16.xpm"
#include "../share/xpm/send16noshadow.xpm"
#include "../share/xpm/send20.xpm"
#include "../share/xpm/trade20.xpm"
#include "../share/xpm/scmining.xpm"
#include "../share/xpm/white.xpm"
#include "../share/xpm/about.xpm"
#include "../share/sclogo.h"

#include "../share/xpm/tick.xpm"
#include "../share/xpm/question.xpm"


///////////////////////////////////////////////////////////////////////////

CMainFrameBase::CMainFrameBase( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxFrame( parent, id, title, pos, size, style )
{
    m_nMaxTX=(int)Setting_GetINT64("gui_showtx");

	this->SetSizeHints( wxDefaultSize, wxDefaultSize );
	this->SetBackgroundColour( wxSystemSettings::GetColour( wxSYS_COLOUR_BTNFACE ) );

	m_menubar = new wxMenuBar( 0 );
	m_menuFile = new wxMenu();
	wxMenuItem* menuFileExit,*menuFileNewWallet,*menuFileRenameWallet,*menuOpenDataDir;

    menuOpenDataDir =new wxMenuItem( m_menuFile, wxID_ANY, wxString( _("&Go to Wallet Directory") ) , wxString(_("Shows the data directory and files in it")), wxITEM_NORMAL );
	menuFileNewWallet = new wxMenuItem( m_menuFile, wxID_ANY, wxString( _("&New Wallet...") ) , wxString(_("Create a new wallet")), wxITEM_NORMAL );
	menuFileRenameWallet = new wxMenuItem( m_menuFile, wxID_ANY, wxString( _("&Rename Wallet...") ) , wxString(_("Rename selected wallet")), wxITEM_NORMAL );
	menuFileExit = new wxMenuItem( m_menuFile, wxID_EXIT, wxString( _("E&xit") ) , wxEmptyString, wxITEM_NORMAL );

    m_menuFile->Append( menuOpenDataDir );
    m_menuFile->AppendSeparator();
    m_menuFile->Append( menuFileNewWallet );
    m_menuFile->Append( menuFileRenameWallet );
    m_menuFile->AppendSeparator();
	m_menuFile->Append( menuFileExit );

	m_menubar->Append( m_menuFile, _("&File") );

	m_menuOptions = new wxMenu();
	wxMenuItem* m_menuOptionsChangeYourAddress,*menuSetDefaultWallet;
	m_menuOptionsChangeYourAddress = new wxMenuItem( m_menuOptions, wxID_ANY, wxString( _("&Address Book...") ) , wxEmptyString, wxITEM_NORMAL );
	m_menuOptions->Append( m_menuOptionsChangeYourAddress );
	m_menuOptions->AppendSeparator();

	m_menuOptionsEncryptWallet = new wxMenuItem( m_menuOptions, wxID_ANY, wxString( _("&Encrypt Wallet...") ) , wxEmptyString, wxITEM_NORMAL );
	m_menuOptions->Append( m_menuOptionsEncryptWallet );

	menuSetDefaultWallet = new wxMenuItem( m_menuOptions, wxID_ANY, wxString( _("&Set Current Wallet To Default") ) , wxEmptyString, wxITEM_NORMAL );
	m_menuOptions->Append( menuSetDefaultWallet );

	//m_menuOptionsChangeWalletPassphrase = new wxMenuItem( m_menuOptions, wxID_ANY, wxString( _("&Change Wallet Encryption Passphrase...") ) , wxEmptyString, wxITEM_NORMAL );
	//m_menuOptions->Append( m_menuOptionsChangeWalletPassphrase );

	m_menuOptions->AppendSeparator();

    m_menuShowMiningPanel = new wxMenuItem( m_menuOptions, wxID_ANY, wxString( _("Show &Mining Panel") ) , wxEmptyString, wxITEM_NORMAL );
    m_menuShowMiningPanel->SetCheckable(true);
    m_menuOptions->Append( m_menuShowMiningPanel );





    m_menuOptions->AppendSeparator();


	wxMenuItem* m_menuOptionsOptions;
	m_menuOptionsOptions = new wxMenuItem( m_menuOptions, wxID_PREFERENCES, wxString( _("&Options...") ) , wxEmptyString, wxITEM_NORMAL );
	m_menuOptions->Append( m_menuOptionsOptions );

	m_menubar->Append( m_menuOptions, _("&Settings") );

	m_menuHelp = new wxMenu();
	wxMenuItem* m_menuHelpAbout;
	m_menuHelpAbout = new wxMenuItem( m_menuHelp, wxID_ABOUT, wxString( _("&About...") ) , wxEmptyString, wxITEM_NORMAL );
	m_menuHelpHomePage= new wxMenuItem( m_menuHelp, wxID_ANY, wxString( _("&SolidCoin HomePage") ) , wxEmptyString, wxITEM_NORMAL );
	m_menuHelp->Append( m_menuHelpHomePage );
	m_menuHelp->Append( m_menuHelpAbout );

	m_menubar->Append( m_menuHelp, _("&Help") );

	this->SetMenuBar( m_menubar );

	m_statusBar = this->CreateStatusBar( 1, wxST_SIZEGRIP, wxID_ANY );

	m_MainSizer= new wxBoxSizer( wxVERTICAL );


	wxFlexGridSizer *pGrid=new wxFlexGridSizer(2,5,5);
	pGrid->AddGrowableCol(1);

    wxBoxSizer* pLeftArea;
    pLeftArea = new wxBoxSizer( wxVERTICAL );
	pLeftArea->Add( 0, 2, 0, wxEXPAND, 5 );

    wxMemoryInputStream is(g_sclogo, sizeof g_sclogo);
    wxBitmap mybitmap(wxImage(is, wxBITMAP_TYPE_ANY, -1), -1);
    wxBitmapButton *m_buttonLogo= new wxBitmapButton( this, wxID_ANY, mybitmap);
    m_buttonLogo->SetToolTip(wxT("Go to SolidCoin Home Page"));

    pLeftArea->Add( m_buttonLogo, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT, 5 );

    pGrid->Add( pLeftArea, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT, 5 );

    wxBoxSizer* pVertAddress;
	pVertAddress = new wxBoxSizer( wxVERTICAL );
	pVertAddress->Add( 0, 2, 0, wxEXPAND, 5 );

    //do wallet



	//do address and balance areas


	wxBoxSizer* boxSizerWallet;
	boxSizerWallet = new wxBoxSizer( wxHORIZONTAL );
	m_WalletText = new wxStaticText( this, wxID_ANY, _("Wallet:"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	m_WalletText->Wrap( -1 );
	boxSizerWallet->Add( m_WalletText, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxLEFT, 5 );

    m_WalletSelect = new wxComboBox(this, wxID_ANY, wxEmptyString,wxDefaultPosition,wxDefaultSize,0,0,wxCB_READONLY);
    m_WalletSelect->SetToolTip(wxT("Change your wallet to view other transactions and address books"));
    wxFont font2(15, wxFONTFAMILY_TELETYPE, wxNORMAL, wxBOLD);
    m_WalletSelect->SetFont(font2);


	boxSizerWallet->Add( m_WalletSelect, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

	m_staticTextBalance = new wxStaticText( this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( -1,-1 ), wxALIGN_LEFT);
	m_staticTextBalance->SetToolTip(wxT("The total amount of SolidCoins this wallet contains"));
	m_staticTextBalance->Wrap( -1 );
	//m_staticTextBalance->SetFont( wxFont( 8, 70, 90, 90, false, wxEmptyString ) );
	m_staticTextBalance->SetFont(font2);
	//m_staticTextBalance->SetBackgroundColour( wxColour( 255, 255, 255 ) );

	boxSizerWallet->Add( m_staticTextBalance, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    pVertAddress->Add(boxSizerWallet,0,wxEXPAND,5);

    wxBoxSizer* bSizer3;
	bSizer3 = new wxBoxSizer( wxHORIZONTAL );

	wxBoxSizer* bSizer66;
	bSizer66 = new wxBoxSizer( wxHORIZONTAL );

    wxFont font3(12, wxFONTFAMILY_DEFAULT, wxNORMAL, wxNORMAL);
    m_toolBar = new wxToolBar(this, wxID_ANY ,wxDefaultPosition,wxDefaultSize,wxTB_TEXT|wxTB_HORZ_LAYOUT |wxTB_FLAT );

	m_toolBar->SetToolBitmapSize( wxSize( 20,20 ) );
	m_toolBar->SetToolSeparation( 10 );
	//m_toolBar->SetFont( wxFont( wxNORMAL_FONT->GetPointSize(), 70, 90, 90, false, wxEmptyString ) );
	m_toolBar->SetFont(font3);

	m_toolBar->AddTool( wxID_BUTTONSEND, _("Send SolidCoins "), wxBitmap( send20_xpm ), wxNullBitmap, wxITEM_NORMAL, wxT("Click here to send SolidCoins"), wxEmptyString );
	m_toolBar->AddTool( wxID_BUTTONRECEIVE, _("Address Book"), wxBitmap( addressbook20_xpm ), wxNullBitmap, wxITEM_NORMAL, wxT("Open your SolidCoin Address Book to view your sent and received addresses"), wxEmptyString );
	m_toolBar->AddTool( wxID_BUTTONTRADE, _("Trade SolidCoins"), wxBitmap( trade20_xpm ), wxNullBitmap, wxITEM_NORMAL, wxT("Buy or sell SolidCoin into a variety of currencies, quickly and easily."), wxEmptyString );

	m_toolBar->Realize();
	bSizer66->Add( m_toolBar, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

	bSizer3->Add( bSizer66, 1, wxEXPAND|wxALL, 5 );


	bSizer3->Add( 0, 0, 0, wxEXPAND, 5 );

	wxString m_choiceFilterChoices[] = { _(" All"), _(" Sent"), _(" Received"), _(" In Progress") };
	int m_choiceFilterNChoices = sizeof( m_choiceFilterChoices ) / sizeof( wxString );
	m_choiceFilter = new wxChoice( this, wxID_ANY, wxDefaultPosition, wxSize( 110,-1 ), m_choiceFilterNChoices, m_choiceFilterChoices, 0 );
	m_choiceFilter->SetSelection( 0 );
	m_choiceFilter->Hide();

	bSizer3->Add( m_choiceFilter, 0, wxALIGN_BOTTOM|wxTOP|wxRIGHT|wxLEFT, 5 );
	pVertAddress->Add(bSizer3,0,wxEXPAND,5);

    /*
	wxBoxSizer* bSizer85;
	bSizer85 = new wxBoxSizer( wxHORIZONTAL );

	m_staticText32 = new wxStaticText( this, wxID_ANY, _("Your Address:"), wxDefaultPosition, wxDefaultSize, 0 );
	m_staticText32->Wrap( -1 );
	bSizer85->Add( m_staticText32, 0, wxALIGN_CENTER_VERTICAL|wxLEFT, 5 );

	m_textCtrlAddress = new wxTextCtrl( this, wxID_TEXTCTRLADDRESS, wxEmptyString, wxDefaultPosition, wxSize( 340,-1 ), wxTE_READONLY );
	bSizer85->Add( m_textCtrlAddress, 0, wxALIGN_CENTER_VERTICAL|wxRIGHT|wxLEFT, 5 );

	bSizer85->Add( 0, 0, 0, wxEXPAND, 5 );

	pVertAddress->Add( bSizer85, 0, wxEXPAND|wxRIGHT|wxLEFT, 5 );
	*/



	pGrid->Add(pVertAddress,0,wxEXPAND,5);

    m_MainSizer->Add(pGrid,0,wxEXPAND,5);
	//bSizer2->Add( bSizer3, 0, wxEXPAND, 5 );

	m_notebook = new wxNotebook( this, wxID_ANY, wxDefaultPosition, wxDefaultSize, 0 );
	m_panel9 = new wxPanel( m_notebook, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	wxBoxSizer* bSizer11;
	bSizer11 = new wxBoxSizer( wxVERTICAL );

	wxImageList *pImageList = new wxImageList(16,16);
    pImageList->Add(wxIcon(question16_xpm));
    pImageList->Add(wxIcon(tick16_xpm));

	m_listCtrlAll = new wxListCtrl( m_panel9, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLC_NO_SORT_HEADER|wxLC_REPORT|wxLC_SORT_DESCENDING|wxLC_HRULES|wxLC_VRULES );
	bSizer11->Add( m_listCtrlAll, 1, wxEXPAND, 5 );
	//m_listCtrlAll->SetBackgroundColour(wxColour(230,230,230));
	//m_listCtrlAll->SetForegroundColour(wxColour(255,255,255));







	m_panel9->SetSizer( bSizer11 );
	m_panel9->Layout();
	bSizer11->Fit( m_panel9 );
	m_notebook->AddPage( m_panel9, _("All Transactions"), true );
	//m_panel91 = new wxPanel( m_notebook, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	//wxBoxSizer* bSizer111;
	//bSizer111 = new wxBoxSizer( wxVERTICAL );
	//m_listCtrlSentReceived = new wxListCtrl( m_panel91, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLC_NO_SORT_HEADER|wxLC_REPORT|wxLC_SORT_DESCENDING );
	//bSizer111->Add( m_listCtrlSentReceived, 1, wxEXPAND, 5 );
	//m_listCtrlSentReceived->SetBackgroundColour(wxColour(64,64,64));
	//m_listCtrlSentReceived->SetForegroundColour(wxColour(255,255,255));

	//m_panel91->SetSizer( bSizer111 );
	//m_panel91->Layout();
	//bSizer111->Fit( m_panel91 );
	//m_notebook->AddPage( m_panel91, _("Sent/Received"), false );
	m_panel92 = new wxPanel( m_notebook, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );

	wxBoxSizer* bSizer112;
	bSizer112 = new wxBoxSizer( wxVERTICAL );

	m_listCtrlSent = new wxListCtrl( m_panel92, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLC_NO_SORT_HEADER|wxLC_REPORT|wxLC_SORT_DESCENDING );
	bSizer112->Add( m_listCtrlSent, 1, wxEXPAND, 5 );
	//m_listCtrlSent->SetBackgroundColour(wxColour(230,230,255));

	m_panel92->SetSizer( bSizer112 );
	m_panel92->Layout();
	bSizer112->Fit( m_panel92 );
	m_notebook->AddPage( m_panel92, _("Sent"), false );
	m_panel93 = new wxPanel( m_notebook, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	wxBoxSizer* bSizer113;
	bSizer113 = new wxBoxSizer( wxVERTICAL );

	m_listCtrlReceived = new wxListCtrl( m_panel93, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLC_NO_SORT_HEADER|wxLC_REPORT|wxLC_SORT_DESCENDING );
	bSizer113->Add( m_listCtrlReceived, 1, wxEXPAND, 5 );
	//m_listCtrlReceived->SetBackgroundColour(wxColour(230,255,230));

    m_listCtrlAll->SetImageList(pImageList, wxIMAGE_LIST_SMALL);
    m_listCtrlSent->SetImageList(pImageList, wxIMAGE_LIST_SMALL);
    m_listCtrlReceived->SetImageList(pImageList, wxIMAGE_LIST_SMALL);

	m_panel93->SetSizer( bSizer113 );
	m_panel93->Layout();
	bSizer113->Fit( m_panel93 );
	m_notebook->AddPage( m_panel93, _("Received"), false );




	m_MainSizer->Add( m_notebook, 1, wxEXPAND, 5 );
	//bSizer112->Add( m_listCtrlSent, 1, wxEXPAND, 5 );


	//bSizer2->Add( m_TxLimitText, 1, wxEXPAND, 5 );
	//boxSizerWallet->Add( m_TxLimitText, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxLEFT, 5 );
    m_TxLimitSelect = new wxComboBox(m_notebook, wxID_ANY, wxEmptyString,wxPoint(-1,-1),wxDefaultSize,0,0,wxCB_READONLY);
    m_TxLimitSelect->SetToolTip(wxT("Select how many transactions you want to show at a time"));
    m_TxLimitSelect->Append("Show last 50");
    m_TxLimitSelect->Append("Show last 250");
    m_TxLimitSelect->Append("Show last 500");
    m_TxLimitSelect->Append("Show All");
    switch(m_nMaxTX)
    {
        case 50:    m_TxLimitSelect->SetSelection(0);break;
        case 250:   m_TxLimitSelect->SetSelection(1);break;
        case 500:   m_TxLimitSelect->SetSelection(2);break;
        case 0:     m_TxLimitSelect->SetSelection(3);break;
    }


    wxFlexGridSizer *pGrid2=new wxFlexGridSizer(2,5,5);
	pGrid2->AddGrowableCol(1);

    pLeftArea = new wxBoxSizer( wxVERTICAL );
	pLeftArea->Add( 0, 2, 0, wxEXPAND, 5 );


    m_MiningPanel = new wxPanel( this, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
    //m_MiningPanel->SetBackgroundColour(wxColor(64,64,80));


    if(Setting_GetBOOL("gui_showminingpanel"))
    {
        m_MiningPanel->Show();
        m_menuShowMiningPanel->Check();
    }
    else
    {
        m_MiningPanel->Hide();
    }




	m_MiningStatus = new wxListCtrl( m_MiningPanel, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLC_NO_HEADER|wxLC_SINGLE_SEL|wxLC_REPORT );
	//m_MiningStatus->SetBackgroundColour(wxColor(64,64,80));
	//m_MiningStatus->SetForegroundColour(wxColor(255,255,255));
	m_MiningStatus->InsertColumn(0, "",wxLIST_FORMAT_LEFT, 500);
	//int n = m_MiningStatus->GetWindowStyleFlag();
	//m_MiningStatus->SetWindowStyleFlag(wxBORDER_NONE|wxCLIP_CHILDREN);
	m_MiningStatus->Refresh();


	pImageList = new wxImageList(16,16);
	wxBitmap bmp(16,16);
	pImageList->Add(wxIcon(blankwhite16_xpm));
    pImageList->Add(wxIcon(scmining16_xpm));

    m_MiningPoolSelect = new wxListCtrl( m_MiningPanel, wxID_ANY, wxDefaultPosition, wxSize(420,150), wxLC_NO_SORT_HEADER|wxLC_SINGLE_SEL|wxLC_REPORT );
    m_MiningPoolSelect->AssignImageList(pImageList, wxIMAGE_LIST_SMALL);
    m_MiningPoolSelect->InsertColumn(0, "Name",wxLIST_FORMAT_LEFT,  150);
    m_MiningPoolSelect->InsertColumn(1, "Hash Rate",wxLIST_FORMAT_LEFT,  110);
    m_MiningPoolSelect->InsertColumn(2, "Shares",wxLIST_FORMAT_LEFT,  60);
    m_MiningPoolSelect->InsertColumn(3, "Threads",wxLIST_FORMAT_LEFT,  80);
    m_MiningPoolSelect->SetToolTip(wxT("Mining by your self (SOLO) means you take all the\nrewards, but it can often take many hours/days to mine\na block like this.\n\nAlternatively mining with a pool means you work with\nothers to mine blocks and hence will get more regular\npayments at the cost of some fees."));

    BOOST_FOREACH(MINING_POOL pool, g_MiningPoolList)
    {
        int nIndex = m_MiningPoolSelect->InsertItem(m_MiningPoolSelect->GetItemCount(), "");
        m_MiningPoolSelect->SetItem(nIndex,0,pool.name);
        m_MiningPoolSelect->SetItem(nIndex,1,"0 KH/s");
        m_MiningPoolSelect->SetItem(nIndex,2,"0");
        m_MiningPoolSelect->SetItem(nIndex,3,"0");
    }


    pLeftArea->Add(m_MiningPoolSelect);


    wxBoxSizer* miningPanelSizer1,*miningPanelSizerUser,*miningPanelSizerPass,*miningPanelSizerAddress,*miningPanelSizerThreads;
    wxBoxSizer* miningButtonSizer,*miningstatussizer;
    wxStaticText *mining_label[5];
	miningPanelSizer1 = new wxBoxSizer( wxVERTICAL );
	miningstatussizer = new wxBoxSizer( wxVERTICAL );
	miningPanelSizerUser = new wxBoxSizer( wxHORIZONTAL);
	miningPanelSizerPass= new wxBoxSizer( wxHORIZONTAL);
	miningPanelSizerAddress = new wxBoxSizer( wxHORIZONTAL);
	miningPanelSizerThreads= new wxBoxSizer( wxHORIZONTAL);
	miningButtonSizer= new wxBoxSizer( wxHORIZONTAL);

    m_MiningName=new wxTextCtrl( m_MiningPanel, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );

    mining_label[0] = new wxStaticText( m_MiningPanel, wxID_ANY, "Host: ", wxDefaultPosition, wxSize( 70,-1 ), wxALIGN_RIGHT);
	mining_label[0]->SetToolTip(wxT("The username you need to log into the pool or server client you want to connect to"));
	m_MiningAddress = new wxTextCtrl( m_MiningPanel, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( 350,-1 ), 0 );

    mining_label[1] = new wxStaticText( m_MiningPanel, wxID_ANY, "Username: ", wxDefaultPosition, wxSize( 70,-1 ), wxALIGN_RIGHT);
	mining_label[1]->SetToolTip(wxT("The username you need to log into the pool or server client you want to connect to"));
	m_MiningUserName = new wxTextCtrl( m_MiningPanel, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( 135,-1 ), 0 );

	mining_label[2] = new wxStaticText( m_MiningPanel, wxID_ANY, "Password: ", wxDefaultPosition, wxSize( 80,-1 ), wxALIGN_RIGHT);
	mining_label[2]->SetToolTip(wxT("The password you need to log into the pool or server client you want to connect to"));
    m_MiningUserPass = new wxTextCtrl( m_MiningPanel, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( 135,-1 ), 0 );

    m_MiningTestworkStats = new wxTextCtrl( m_MiningPanel, wxID_ANY, "Minipool Stats", wxDefaultPosition, wxSize( -1,25 ), wxTE_READONLY );

	mining_label[3] = new wxStaticText( m_MiningPanel, wxID_ANY, "Threads: ", wxDefaultPosition, wxSize( 70,-1 ), wxALIGN_RIGHT);
	mining_label[3]->SetToolTip(wxT("The password you need to log into the pool or server client you want to connect to"));
	m_MiningThreads = new wxComboBox(m_MiningPanel, wxID_ANY, wxEmptyString,wxPoint(100,-1),wxDefaultSize,0,0,wxCB_READONLY);
    m_MiningThreads->SetToolTip(wxT("Select how many transactions you want to show at a time"));
    for(int x=1;x<=boost::thread::hardware_concurrency();x++)   m_MiningThreads->Append(str(boost::format("%d") % x ) );

    m_MiningButtonStart = new wxButton( m_MiningPanel, wxID_ANY, _("Start"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
    m_MiningButtonWebsite = new wxButton( m_MiningPanel, wxID_ANY, _("Create Account"), wxDefaultPosition, wxSize( -1,-1 ), 0 );

	//pGrid2->Add( pLeftArea, 1, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 10 );


    miningPanelSizerAddress->Add( mining_label[0], 0, wxALIGN_CENTER_VERTICAL);
    miningPanelSizerAddress->Add( m_MiningAddress, 0, wxALIGN_CENTER_VERTICAL);

    miningPanelSizerUser->Add( mining_label[1], 0, wxALIGN_CENTER_VERTICAL);
    miningPanelSizerUser->Add( m_MiningUserName, 0, wxALIGN_CENTER_VERTICAL);
    miningPanelSizerUser->Add( mining_label[2], 0, wxALIGN_CENTER_VERTICAL);
    miningPanelSizerUser->Add( m_MiningUserPass, 0, wxALIGN_CENTER_VERTICAL);

    miningPanelSizerThreads->Add( mining_label[3], 0, wxALIGN_CENTER_VERTICAL);
    miningPanelSizerThreads->Add( m_MiningThreads, 0, wxALIGN_CENTER_VERTICAL);


    miningButtonSizer->Add(m_MiningName, 1, wxEXPAND);
    miningButtonSizer->Add(m_MiningButtonWebsite, 0, wxALIGN_CENTER_VERTICAL|wxLEFT,5);
    miningButtonSizer->Add(m_MiningButtonStart, 0, wxALIGN_CENTER_VERTICAL|wxLEFT,5);

    miningPanelSizer1->Add(pLeftArea,0,wxEXPAND|wxLEFT,0);
    miningPanelSizer1->Add(miningPanelSizerAddress,0,wxEXPAND);
	miningPanelSizer1->Add(miningPanelSizerUser,0,wxEXPAND);
	miningPanelSizer1->Add(miningPanelSizerPass,0,wxEXPAND);
	miningPanelSizer1->Add(miningPanelSizerThreads,0,wxEXPAND);


	miningstatussizer->Add(miningButtonSizer,0,wxEXPAND);
	miningstatussizer->Add(-1,5);
	miningstatussizer->Add(m_MiningStatus,1,wxEXPAND);
	miningstatussizer->Add(-1,5);
	miningstatussizer->Add(m_MiningTestworkStats,0,wxEXPAND);



	pGrid2->Add( miningPanelSizer1, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxLEFT|wxBOTTOM, 5 );
	pGrid2->Add( miningstatussizer, 1, wxEXPAND|wxTOP|wxRIGHT|wxBOTTOM, 5 );

    m_MiningPanel->SetSizer(pGrid2);

    m_MainSizer->Add( m_MiningPanel, 0, wxEXPAND,0);


	this->SetSizer( m_MainSizer );
	this->Layout();

	// Connect Events

	this->Connect( wxEVT_SIZE, wxSizeEventHandler( CMainFrameBase::OnSize) );
	this->Connect( wxEVT_CLOSE_WINDOW, wxCloseEventHandler( CMainFrameBase::OnClose ) );
	this->Connect( wxEVT_ICONIZE, wxIconizeEventHandler( CMainFrameBase::OnIconize ) );
	this->Connect( wxEVT_IDLE, wxIdleEventHandler( CMainFrameBase::OnIdle ) );
	this->Connect( wxEVT_LEFT_DOWN, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_LEFT_UP, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_MIDDLE_DOWN, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_MIDDLE_UP, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_RIGHT_DOWN, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_RIGHT_UP, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_MOTION, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_LEFT_DCLICK, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_MIDDLE_DCLICK, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_RIGHT_DCLICK, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_LEAVE_WINDOW, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_ENTER_WINDOW, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Connect( wxEVT_PAINT, wxPaintEventHandler( CMainFrameBase::OnPaint ) );

	this->Connect( menuFileNewWallet->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuFileNewWallet) );
	this->Connect( menuOpenDataDir->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuFileOpenDataDir) );
	this->Connect( menuFileExit->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuFileExit ) );
	this->Connect( menuFileRenameWallet->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuRenameWallet ) );
	this->Connect( menuSetDefaultWallet->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuSetDefaultWallet) );
	this->Connect( m_menuShowMiningPanel->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuShowMiningPanel) );

	this->Connect( m_menuOptionsChangeYourAddress->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuOptionsChangeYourAddress ) );
	this->Connect( m_menuOptionsEncryptWallet->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuOptionsEncryptWallet ) );
	//this->Connect( m_menuOptionsChangeWalletPassphrase->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuOptionsChangeWalletPassphrase ) );
	this->Connect( m_menuOptionsOptions->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuOptionsOptions ) );
	this->Connect( m_menuHelpAbout->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuHelpAbout ) );
	this->Connect( m_menuHelpHomePage->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuAboutHomePage ) );

    m_MiningName->Connect( wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler( CMainFrameBase::OnMiningTextUpdate ), NULL, this );
    m_MiningUserName->Connect( wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler( CMainFrameBase::OnMiningTextUpdate ), NULL, this );
    m_MiningUserPass->Connect( wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler( CMainFrameBase::OnMiningTextUpdate ), NULL, this );
    m_MiningAddress->Connect( wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler( CMainFrameBase::OnMiningTextUpdate ), NULL, this );
    m_MiningThreads->Connect(wxEVT_COMMAND_COMBOBOX_SELECTED,wxCommandEventHandler( CMainFrameBase::OnMiningThreadSelect), NULL, this );

    m_MiningPoolSelect->Connect(wxEVT_COMMAND_LIST_ITEM_SELECTED,wxListEventHandler(CMainFrameBase::OnMiningListItemSelected), NULL, this );
	m_MiningPoolSelect->Connect(wxEVT_COMMAND_LIST_ITEM_DESELECTED,wxListEventHandler(CMainFrameBase::OnMiningListItemDeSelected), NULL, this );
	m_MiningButtonStart->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CMainFrameBase::OnMiningButtonStart), NULL, this );
	m_MiningButtonWebsite->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CMainFrameBase::OnMiningButtonWebsite), NULL, this );

    m_TxLimitSelect->Connect(wxEVT_COMMAND_COMBOBOX_SELECTED,wxCommandEventHandler( CMainFrameBase::OnTXLimitSelect), NULL, this );
	m_WalletSelect->Connect(wxEVT_COMMAND_COMBOBOX_SELECTED,wxCommandEventHandler( CMainFrameBase::OnWalletSelect), NULL, this );
	m_toolBar->Connect( wxID_BUTTONSEND, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( CMainFrameBase::OnButtonSend), NULL, this );
	m_toolBar->Connect( wxID_BUTTONRECEIVE, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( CMainFrameBase::OnButtonAddressBook), NULL, this );
	m_toolBar->Connect( wxID_BUTTONTRADE, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( CMainFrameBase::OnButtonTrade), NULL, this );
	m_buttonLogo->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CMainFrameBase::OnButtonLogo), NULL, this );
	m_notebook->Connect( wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED, wxNotebookEventHandler( CMainFrameBase::OnNotebookPageChanged ), NULL, this );
	m_listCtrlAll->Connect( wxEVT_COMMAND_LIST_COL_BEGIN_DRAG, wxListEventHandler( CMainFrameBase::OnListColBeginDrag ), NULL, this );
	m_listCtrlAll->Connect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CMainFrameBase::OnListItemActivated ), NULL, this );
	m_listCtrlAll->Connect( wxEVT_PAINT, wxPaintEventHandler( CMainFrameBase::OnPaintListCtrl ), NULL, this );
	m_listCtrlSent->Connect( wxEVT_COMMAND_LIST_COL_BEGIN_DRAG, wxListEventHandler( CMainFrameBase::OnListColBeginDrag ), NULL, this );
	m_listCtrlSent->Connect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CMainFrameBase::OnListItemActivated ), NULL, this );
	m_listCtrlSent->Connect( wxEVT_PAINT, wxPaintEventHandler( CMainFrameBase::OnPaintListCtrl ), NULL, this );
	m_listCtrlReceived->Connect( wxEVT_COMMAND_LIST_COL_BEGIN_DRAG, wxListEventHandler( CMainFrameBase::OnListColBeginDrag ), NULL, this );
	m_listCtrlReceived->Connect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CMainFrameBase::OnListItemActivated ), NULL, this );
	m_listCtrlReceived->Connect( wxEVT_PAINT, wxPaintEventHandler( CMainFrameBase::OnPaintListCtrl ), NULL, this );
}

//#include <windows.h>
CMainFrameBase::~CMainFrameBase()
{
    return;
    //MessageBoxA(0,"h",0,0);

	// Disconnect Events
	/*


	this->Disconnect( wxEVT_CLOSE_WINDOW, wxCloseEventHandler( CMainFrameBase::OnClose ) );
	this->Disconnect( wxEVT_ICONIZE, wxIconizeEventHandler( CMainFrameBase::OnIconize ) );
	this->Disconnect( wxEVT_IDLE, wxIdleEventHandler( CMainFrameBase::OnIdle ) );
	this->Disconnect( wxEVT_LEFT_DOWN, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_LEFT_UP, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_MIDDLE_DOWN, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_MIDDLE_UP, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_RIGHT_DOWN, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_RIGHT_UP, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_MOTION, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_LEFT_DCLICK, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_MIDDLE_DCLICK, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_RIGHT_DCLICK, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_LEAVE_WINDOW, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_ENTER_WINDOW, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( CMainFrameBase::OnMouseEvents ) );
	this->Disconnect( wxEVT_PAINT, wxPaintEventHandler( CMainFrameBase::OnPaint ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuFileExit ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuOptionsChangeYourAddress ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuOptionsEncryptWallet ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuOptionsChangeWalletPassphrase ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuOptionsOptions ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( CMainFrameBase::OnMenuHelpAbout ) );
	m_toolBar->Disconnect( wxID_BUTTONSEND, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( CMainFrameBase::OnButtonSend), NULL, this);
	m_toolBar->Disconnect( wxID_BUTTONRECEIVE, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( CMainFrameBase::OnButtonAddressBook), NULL, this );

	m_buttonLogo->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CMainFrameBase::OnButtonLogo), NULL, this );
	m_notebook->Disconnect( wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED, wxNotebookEventHandler( CMainFrameBase::OnNotebookPageChanged ), NULL, this );
	m_listCtrlAll->Disconnect( wxEVT_COMMAND_LIST_COL_BEGIN_DRAG, wxListEventHandler( CMainFrameBase::OnListColBeginDrag ), NULL, this );
	m_listCtrlAll->Disconnect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CMainFrameBase::OnListItemActivated ), NULL, this );
	m_listCtrlAll->Disconnect( wxEVT_PAINT, wxPaintEventHandler( CMainFrameBase::OnPaintListCtrl ), NULL, this );
	m_listCtrlSent->Disconnect( wxEVT_COMMAND_LIST_COL_BEGIN_DRAG, wxListEventHandler( CMainFrameBase::OnListColBeginDrag ), NULL, this );
	m_listCtrlSent->Disconnect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CMainFrameBase::OnListItemActivated ), NULL, this );
	m_listCtrlSent->Disconnect( wxEVT_PAINT, wxPaintEventHandler( CMainFrameBase::OnPaintListCtrl ), NULL, this );
	m_listCtrlReceived->Disconnect( wxEVT_COMMAND_LIST_COL_BEGIN_DRAG, wxListEventHandler( CMainFrameBase::OnListColBeginDrag ), NULL, this );
	m_listCtrlReceived->Disconnect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CMainFrameBase::OnListItemActivated ), NULL, this );
	m_listCtrlReceived->Disconnect( wxEVT_PAINT, wxPaintEventHandler( CMainFrameBase::OnPaintListCtrl ), NULL, this );
	*/


}

CTxDetailsDialogBase::CTxDetailsDialogBase( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxDialog( parent, id, title, pos, size, style )
{
	this->SetSizeHints( wxDefaultSize, wxDefaultSize );

	wxBoxSizer* boxSizer = new wxBoxSizer( wxVERTICAL );

	wxBoxSizer* bSizer66;
	bSizer66 = new wxBoxSizer( wxVERTICAL );

	m_htmlWin = new wxHtmlWindow( this, wxID_ANY, wxDefaultPosition, wxSize(700,300), wxHW_SCROLLBAR_AUTO );
	bSizer66->Add( m_htmlWin, 1, wxALL|wxEXPAND, 5 );

	boxSizer->Add( bSizer66, 1, wxEXPAND, 5 );

	wxBoxSizer* bSizer65;
	bSizer65 = new wxBoxSizer( wxHORIZONTAL );

	m_buttonOK = new wxButton( this, wxID_OK, _("OK"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer65->Add( m_buttonOK, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	boxSizer->Add( bSizer65, 0, wxALIGN_RIGHT, 5 );

	this->SetSizerAndFit( boxSizer );
	this->Layout();

	// Connect Events
	m_buttonOK->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CTxDetailsDialogBase::OnButtonOK ), NULL, this );
}

CTxDetailsDialogBase::~CTxDetailsDialogBase()
{
	// Disconnect Events
	m_buttonOK->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CTxDetailsDialogBase::OnButtonOK ), NULL, this );
}

COptionsDialogBase::COptionsDialogBase( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxDialog( parent, id, title, pos, size, style )
{
	this->SetSizeHints( wxDefaultSize, wxDefaultSize );

	wxBoxSizer* bSizer55;
	bSizer55 = new wxBoxSizer( wxVERTICAL );

	wxBoxSizer* bSizer66;
	bSizer66 = new wxBoxSizer( wxHORIZONTAL );

	m_listBox = new wxListBox( this, wxID_ANY, wxDefaultPosition, wxSize( 110,-1 ), 0, NULL, wxLB_NEEDED_SB|wxLB_SINGLE );
	bSizer66->Add( m_listBox, 0, wxEXPAND|wxRIGHT, 5 );

	m_scrolledWindow = new wxScrolledWindow( this, wxID_ANY, wxDefaultPosition, wxDefaultSize, 0 );
	m_scrolledWindow->SetScrollRate( 5, 5 );
	wxBoxSizer* bSizer63;
	bSizer63 = new wxBoxSizer( wxVERTICAL );

	m_panelMain = new wxPanel( m_scrolledWindow, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	wxBoxSizer* bSizer69;
	bSizer69 = new wxBoxSizer( wxVERTICAL );


	bSizer69->Add( 0, 16, 0, wxEXPAND, 5 );

	m_checkBoxStartOnSystemStartup = new wxCheckBox( m_panelMain, wxID_ANY, _("&Start SolidCoin on system startup"), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer69->Add( m_checkBoxStartOnSystemStartup, 0, wxALL, 5 );

	m_checkBoxMinimizeToTray = new wxCheckBox( m_panelMain, wxID_ANY, _("&Minimize to the tray instead of the taskbar"), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer69->Add( m_checkBoxMinimizeToTray, 0, wxALL, 5 );

	m_checkBoxUseUPnP = new wxCheckBox( m_panelMain, wxID_ANY, _("Map port using &UPnP"), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer69->Add( m_checkBoxUseUPnP, 0, wxALL, 5 );

	m_checkBoxMinimizeOnClose = new wxCheckBox( m_panelMain, wxID_ANY, _("M&inimize to the tray on close"), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer69->Add( m_checkBoxMinimizeOnClose, 0, wxALL|wxALIGN_CENTER_VERTICAL, 5 );

	wxBoxSizer* bSizer102;
	bSizer102 = new wxBoxSizer( wxHORIZONTAL );

	m_checkBoxUseProxy = new wxCheckBox( m_panelMain, wxID_ANY, _("&Connect through socks4 proxy (requires restart to apply): "), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer102->Add( m_checkBoxUseProxy, 0, wxALL|wxALIGN_CENTER_VERTICAL, 5 );

	bSizer69->Add( bSizer102, 1, wxEXPAND, 5 );

	wxBoxSizer* bSizer103;
	bSizer103 = new wxBoxSizer( wxHORIZONTAL );


	bSizer103->Add( 18, 0, 0, 0, 5 );

	m_staticTextProxyIP = new wxStaticText( m_panelMain, wxID_ANY, _("Proxy &IP:"), wxDefaultPosition, wxDefaultSize, 0 );
	m_staticTextProxyIP->Wrap( -1 );
	bSizer103->Add( m_staticTextProxyIP, 0, wxALL|wxALIGN_CENTER_VERTICAL, 5 );

	m_textCtrlProxyIP = new wxTextCtrl( m_panelMain, wxID_PROXYIP, wxEmptyString, wxDefaultPosition, wxSize( 140,-1 ), 0 );
	m_textCtrlProxyIP->SetMaxLength( 15 );
	bSizer103->Add( m_textCtrlProxyIP, 0, wxALIGN_CENTER_VERTICAL, 5 );

	m_staticTextProxyPort = new wxStaticText( m_panelMain, wxID_ANY, _(" &Port:"), wxDefaultPosition, wxDefaultSize, 0 );
	m_staticTextProxyPort->Wrap( -1 );
	bSizer103->Add( m_staticTextProxyPort, 0, wxALL|wxALIGN_CENTER_VERTICAL, 5 );

	m_textCtrlProxyPort = new wxTextCtrl( m_panelMain, wxID_PROXYPORT, wxEmptyString, wxDefaultPosition, wxSize( 55,-1 ), 0 );
	m_textCtrlProxyPort->SetMaxLength( 5 );
	bSizer103->Add( m_textCtrlProxyPort, 0, wxALIGN_CENTER_VERTICAL, 5 );

	bSizer69->Add( bSizer103, 1, wxEXPAND, 5 );


	bSizer69->Add( 0, 1, 0, 0, 5 );

	//m_staticText32 = new wxStaticText( m_panelMain, wxID_ANY, _("Optional transaction fee per KB that helps make sure your transactions are processed quickly.  Most transactions are 1KB.  Fee 0.01 recommended."), wxDefaultPosition, wxDefaultSize, 0 );
	//m_staticText32->Wrap( 365 );
	//bSizer69->Add( m_staticText32, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxRIGHT|wxLEFT, 5 );

	//wxBoxSizer* bSizer56;
	//bSizer56 = new wxBoxSizer( wxHORIZONTAL );

	//m_staticText31 = new wxStaticText( m_panelMain, wxID_ANY, _("Pay transaction fee:"), wxDefaultPosition, wxDefaultSize, 0 );
	//m_staticText31->Wrap( -1 );
	//bSizer56->Add( m_staticText31, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxLEFT, 5 );

	//m_textCtrlTransactionFee = new wxTextCtrl( m_panelMain, wxID_TRANSACTIONFEE, wxEmptyString, wxDefaultPosition, wxSize( 70,-1 ), 0 );
	//bSizer56->Add( m_textCtrlTransactionFee, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

	//bSizer69->Add( bSizer56, 0, wxEXPAND, 5 );

	m_panelMain->SetSizer( bSizer69 );
	m_panelMain->Layout();
	bSizer69->Fit( m_panelMain );
	bSizer63->Add( m_panelMain, 0, wxEXPAND, 5 );

	m_panelMining = new wxPanel( m_scrolledWindow, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );

	wxFlexGridSizer *pGrid=new wxFlexGridSizer(2,5,5);
	pGrid->AddGrowableCol(1);

    wxStaticText *miningIDText = new wxStaticText( m_panelMining, wxID_ANY, _("Mining ID:"), wxDefaultPosition, wxDefaultSize, 0 );
	miningIDText->SetToolTip(wxT("When you are mining and find a block this text is written into it, to immortalize it forever! If you are a pool set it to your pool name so others know when you find blocks.\n\nRestart is needed for it to take effect."));

	m_MiningID = new wxTextCtrl( m_panelMining, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( 120,-1 ), 0 );
	m_MiningID->SetMaxLength( 12 );

	pGrid->Add( miningIDText, 0, wxALIGN_CENTER_VERTICAL|wxALIGN_RIGHT);
	pGrid->Add( m_MiningID, 1, wxALIGN_CENTER_VERTICAL);

	wxStaticText *miningTargetText = new wxStaticText( m_panelMining, wxID_ANY, _("Share Target:"), wxDefaultPosition, wxDefaultSize, 0 );
	miningTargetText->SetToolTip(wxT("Here you can determine what constitutes a mining share. Instead of letting your miners send shares when they find a real target (ie one share = found block) you can set a lower target that means they send back more solutions that have the potential to be valid blocks but may not necessarily be a valid solution.\n\nPools usually set a diff 1 share target so that miners request work often and they can pay them out in a fairer manner.\n\nA restart is needed before it takes effect."));

	m_MiningShareTarget = new wxComboBox(m_panelMining, wxID_ANY, wxEmptyString,wxPoint(-1,-1),wxDefaultSize,0,0,wxCB_READONLY);
    m_MiningShareTarget->Append("Real Target");
    for(int x=1;x<=32;x++)   m_MiningShareTarget->Append(str(boost::format("Difficulty %d Target") % x) );

	pGrid->Add( miningTargetText, 0, wxALIGN_CENTER_VERTICAL|wxALIGN_RIGHT);
	pGrid->Add( m_MiningShareTarget, 0, wxALIGN_CENTER_VERTICAL);


	m_panelMining->SetSizer( pGrid );
	m_panelMining->Layout();

	bSizer63->Add( m_panelMining, 0, wxEXPAND, 5 );

	pGrid=new wxFlexGridSizer(2,5,5);
	pGrid->AddGrowableCol(1);

	m_panelTiming = new wxPanel( m_scrolledWindow, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );

    wxStaticText *ntpDisableText= new wxStaticText( m_panelTiming, wxID_ANY, _("Network Time Protocol:"), wxDefaultPosition, wxDefaultSize, 0 );
	ntpDisableText->SetToolTip(wxT("NTP is used to warn you if your system clock is incorrect, which may stop you being able to mine or use the network efficiently. It is recommmend you leave this enabled!"));

	m_CBTime_NTP = new wxComboBox(m_panelTiming, wxID_ANY, wxEmptyString,wxPoint(-1,-1),wxDefaultSize,0,0,wxCB_READONLY);
    m_CBTime_NTP->Append("Disabled");
    m_CBTime_NTP->Append("Enabled");

    wxStaticText *ntpSCTimeText= new wxStaticText( m_panelTiming, wxID_ANY, _("SolidCoin Timing:"), wxDefaultPosition, wxDefaultSize, 0 );
	ntpSCTimeText->SetToolTip(wxT("SolidCoin Timing essentially doesn't rely on your system clock as the timer. Instead it uses NTP and its own internal timing system to rather accurately compute time. If your system clock is always correct you don't really need to enable this."));
    m_CBTime_SCTime = new wxComboBox(m_panelTiming, wxID_ANY, wxEmptyString,wxPoint(-1,-1),wxDefaultSize,0,0,wxCB_READONLY);
    m_CBTime_SCTime->Append("Disabled");
    m_CBTime_SCTime->Append("Enabled");


    wxStaticText *ntpServerText= new wxStaticText( m_panelTiming, wxID_ANY, _("NTP Server:"), wxDefaultPosition, wxDefaultSize, 0 );
	ntpServerText->SetToolTip(wxT("Set the NTP server you want to use here"));
    m_Time_NTPServer = new wxTextCtrl( m_panelTiming, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( 150,-1 ), 0 );




	pGrid->Add( ntpDisableText, 0, wxALIGN_CENTER_VERTICAL|wxALIGN_RIGHT);
	pGrid->Add( m_CBTime_NTP, 0, wxALIGN_CENTER_VERTICAL);
	pGrid->Add( ntpSCTimeText, 0, wxALIGN_CENTER_VERTICAL|wxALIGN_RIGHT);
	pGrid->Add( m_CBTime_SCTime, 0, wxALIGN_CENTER_VERTICAL);
	pGrid->Add( ntpServerText, 0, wxALIGN_CENTER_VERTICAL|wxALIGN_RIGHT);
	pGrid->Add( m_Time_NTPServer, 0, wxALIGN_CENTER_VERTICAL);



	m_panelTiming->SetSizer( pGrid );
	m_panelTiming->Layout();
	bSizer63->Add( m_panelTiming, 0, wxEXPAND, 5 );


    //wxCheckBox* m_CBTime_NTP;
    //wxCheckBox* m_CBTime_SCTime;


	m_scrolledWindow->SetSizer( bSizer63 );
	m_scrolledWindow->Layout();
	bSizer63->Fit( m_scrolledWindow );
	bSizer66->Add( m_scrolledWindow, 1, wxEXPAND|wxLEFT, 5 );

	bSizer55->Add( bSizer66, 1, wxEXPAND|wxALL, 9 );

	wxBoxSizer* bSizer58;
	bSizer58 = new wxBoxSizer( wxHORIZONTAL );

	m_buttonOK = new wxButton( this, wxID_OK, _("OK"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer58->Add( m_buttonOK, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonCancel = new wxButton( this, wxID_CANCEL, _("Cancel"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer58->Add( m_buttonCancel, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonApply = new wxButton( this, wxID_APPLY, _("&Apply"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer58->Add( m_buttonApply, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	bSizer55->Add( bSizer58, 0, wxALIGN_RIGHT, 5 );

	this->SetSizer( bSizer55 );
	this->Layout();

	// Connect Events
	m_listBox->Connect( wxEVT_COMMAND_LISTBOX_SELECTED, wxCommandEventHandler( COptionsDialogBase::OnListBox ), NULL, this );
	m_checkBoxMinimizeToTray->Connect( wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnCheckBoxMinimizeToTray ), NULL, this );
	m_checkBoxUseProxy->Connect( wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnCheckBoxUseProxy ), NULL, this );
	m_textCtrlProxyIP->Connect( wxEVT_KILL_FOCUS, wxFocusEventHandler( COptionsDialogBase::OnKillFocusProxy ), NULL, this );
	m_textCtrlProxyPort->Connect( wxEVT_KILL_FOCUS, wxFocusEventHandler( COptionsDialogBase::OnKillFocusProxy ), NULL, this );
	m_buttonOK->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnButtonOK ), NULL, this );
	m_buttonCancel->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnButtonCancel ), NULL, this );
	m_buttonApply->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnButtonApply ), NULL, this );
}

COptionsDialogBase::~COptionsDialogBase()
{
	// Disconnect Events
    m_listBox->Disconnect( wxEVT_COMMAND_LISTBOX_SELECTED, wxCommandEventHandler( COptionsDialogBase::OnListBox ), NULL, this );
	m_checkBoxMinimizeToTray->Disconnect( wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnCheckBoxMinimizeToTray ), NULL, this );
	m_checkBoxUseProxy->Disconnect( wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnCheckBoxUseProxy ), NULL, this );
	m_textCtrlProxyIP->Disconnect( wxEVT_KILL_FOCUS, wxFocusEventHandler( COptionsDialogBase::OnKillFocusProxy ), NULL, this );
	m_textCtrlProxyPort->Disconnect( wxEVT_KILL_FOCUS, wxFocusEventHandler( COptionsDialogBase::OnKillFocusProxy ), NULL, this );
	m_buttonOK->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnButtonOK ), NULL, this );
	m_buttonCancel->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnButtonCancel ), NULL, this );
	m_buttonApply->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( COptionsDialogBase::OnButtonApply ), NULL, this );
}

CAboutDialogBase::CAboutDialogBase( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxDialog( parent, id, title, pos, size, style )
{
	this->SetSizeHints( wxDefaultSize, wxDefaultSize );


	bSizer63 = new wxBoxSizer( wxHORIZONTAL );

	m_bitmap = new wxStaticBitmap( this, wxID_ANY, wxBitmap( about_xpm ), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer63->Add( m_bitmap, 0, 0, 5 );

	wxBoxSizer* bSizer60;
	bSizer60 = new wxBoxSizer( wxVERTICAL );

	wxBoxSizer* bSizer62;
	bSizer62 = new wxBoxSizer( wxHORIZONTAL );

	wxBoxSizer* bSizer631;
	bSizer631 = new wxBoxSizer( wxVERTICAL );


	bSizer631->Add( 0, 65, 0, wxEXPAND, 5 );

	wxBoxSizer* bSizer64;
	bSizer64 = new wxBoxSizer( wxHORIZONTAL );

	m_staticText40 = new wxStaticText( this, wxID_ANY, _("SolidCoin "), wxDefaultPosition, wxDefaultSize, 0 );
	m_staticText40->Wrap( -1 );
	m_staticText40->SetFont( wxFont( 10, 74, 90, 92, false, wxT("Tahoma") ) );

	bSizer64->Add( m_staticText40, 0, wxALIGN_BOTTOM|wxTOP|wxBOTTOM|wxLEFT, 5 );

	m_staticTextVersion = new wxStaticText( this, wxID_ANY, _("version"), wxDefaultPosition, wxDefaultSize, 0 );
	m_staticTextVersion->Wrap( -1 );
	m_staticTextVersion->SetFont( wxFont( 10, 74, 90, 90, false, wxT("Tahoma") ) );

	bSizer64->Add( m_staticTextVersion, 0, wxALIGN_BOTTOM|wxTOP|wxBOTTOM|wxRIGHT, 5 );

	bSizer631->Add( bSizer64, 0, wxEXPAND, 5 );


	bSizer631->Add( 0, 4, 0, wxEXPAND, 5 );

	m_staticTextMain = new wxStaticText( this, wxID_ANY,
        _(  "Copyright (c) 2011 SolidCoin Developers\n\n"
            "SolidCoin is the most reliable and secure crypto-currency in existence. With SolidCoin\n"
            "businesses and users can finally be safe knowing their coins will still be there tomorrow!\n"
            "SolidCoin is making it easy for everyone around the world to jump into one of the fastest\n"
            "ways to pay others for their goods and services.\n\n"
            "Thanks to: Karmaon, noagendamarket, RylandAlmanza, Solid_Ohforf, twobits, caish5, ahimoth,\n"
            "viperjbm, brightsky, mush, TimothyA, NeonLicht, flippro, Lorna Morgan, thracky, pho|, moonboon\n"
            "Cokein, Joulesbeef, Heisenb3rg, Ten98, Shawn Powers, Coinotron, Blobber, Skewb\n"
            "..and to all SolidCoin BETA testers and supporters!\n\n"
            "This product includes software developed by the OpenSSL Project for use in the \n"
            "OpenSSL Toolkit (http://www.openssl.org/) and cryptographic software written by \n"
            "Eric Young (eay@cryptsoft.com) and UPnP software written by Thomas Bernard."
        ), wxDefaultPosition, wxDefaultSize, 0 );
	m_staticTextMain->Wrap( -1 );
	bSizer631->Add( m_staticTextMain, 0, wxALL, 5 );


	bSizer631->Add( 0, 0, 0, wxEXPAND, 5 );

	bSizer62->Add( bSizer631, 1, wxEXPAND, 5 );

	bSizer60->Add( bSizer62, 1, wxEXPAND, 5 );

	wxBoxSizer* bSizer61;
	bSizer61 = new wxBoxSizer( wxHORIZONTAL );


	bSizer61->Add( 0, 0, 1, wxEXPAND, 5 );

	m_buttonOK = new wxButton( this, wxID_OK, _("OK"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer61->Add( m_buttonOK, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 6 );

	bSizer60->Add( bSizer61, 0, wxALIGN_RIGHT|wxEXPAND|wxRIGHT, 2 );

	bSizer63->Add( bSizer60, 1, wxEXPAND|wxLEFT, 5 );

	this->SetSizerAndFit( bSizer63 );
	this->Layout();

	// Connect Events
	m_buttonOK->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAboutDialogBase::OnButtonOK ), NULL, this );
}

CAboutDialogBase::~CAboutDialogBase()
{
	// Disconnect Events
	m_buttonOK->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAboutDialogBase::OnButtonOK ), NULL, this );
}

CSendDialogBase::CSendDialogBase( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxDialog( parent, id, title, pos, size, style )
{
	this->SetSizeHints( wxDefaultSize, wxDefaultSize );

	wxBoxSizer* bSizer21;
	bSizer21 = new wxBoxSizer( wxVERTICAL );


	bSizer21->Add( 0, 5, 0, wxEXPAND, 5 );

	wxBoxSizer* fgSizer1;
	fgSizer1 = new wxBoxSizer( wxVERTICAL);

	m_staticTextInstructions = new wxStaticText( this, wxID_ANY, _("Enter a SolidCoin address to send to (e.g. sNS17iag9jJgTHD1VXjvLCEnZuQ3rJDE9L)  "), wxDefaultPosition, wxDefaultSize, 0 );

	fgSizer1->Add( 0, 0, 0, wxEXPAND|wxALL, 5 );
	fgSizer1->Add( m_staticTextInstructions, 0, wxLEFT|wxRIGHT, 30);
	fgSizer1->Add( 0, 0, 0, wxEXPAND|wxALL, 5 );

	wxBoxSizer* bSizer47;
	bSizer47 = new wxBoxSizer( wxHORIZONTAL );

	//bSizer47->SetMinSize( wxSize( 70,-1 ) );

	//bSizer47->Add( 0, 0, 1, wxEXPAND, 5 );
	//m_bitmapCheckMark = new wxStaticBitmap( this, wxID_ANY, wxBitmap( check_xpm ), wxDefaultPosition, wxSize( 16,16 ), 0 );
	//bSizer47->Add( m_bitmapCheckMark, 0, wxALL|wxALIGN_CENTER_VERTICAL, 5 );

	m_staticText36 = new wxStaticText( this, wxID_ANY, _("Pay &To:"), wxDefaultPosition, wxSize( 90,-1 ), wxALIGN_RIGHT );
	m_textCtrlAddress = new wxTextCtrl( this, wxID_TEXTCTRLPAYTO, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_buttonPaste = new wxButton( this, wxID_BUTTONPASTE, _("&Paste"), wxDefaultPosition, wxSize( -1,-1 ), wxBU_EXACTFIT );
	m_buttonAddress = new wxButton( this, wxID_BUTTONADDRESSBOOK, _(" Address &Book..."), wxDefaultPosition, wxDefaultSize, 0 );


    bSizer47->Add( m_staticText36, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 5 );
	bSizer47->Add( m_textCtrlAddress, 1, wxALIGN_CENTER_VERTICAL|wxALL, 5 );
	bSizer47->Add( m_buttonPaste, 0, wxALIGN_CENTER_VERTICAL|wxRIGHT, 5 );
	bSizer47->Add( m_buttonAddress, 0, wxALIGN_CENTER_VERTICAL|wxRIGHT, 5 );

    fgSizer1->Add( bSizer47, 0, wxEXPAND, 5 );

	wxBoxSizer* bSizer20;
	bSizer20 = new wxBoxSizer( wxHORIZONTAL );

	m_staticText19 = new wxStaticText( this, wxID_ANY, _("&Amount:"), wxDefaultPosition, wxSize( 90,-1 ), wxALIGN_RIGHT );

	m_textCtrlAmount = new wxTextCtrl( this, wxID_TEXTCTRLAMOUNT, wxEmptyString, wxDefaultPosition, wxSize( 145,-1 ), 0 );
	m_textCtrlAmount->SetMaxLength( 20 );
	m_textCtrlAmount->SetFont( wxFont( wxNORMAL_FONT->GetPointSize(), 70, 90, 90, false, wxEmptyString ) );

	m_staticTextFee = new wxStaticText( this, wxID_ANY, _("Fee:"), wxDefaultPosition, wxSize( -1,-1 ), wxALIGN_RIGHT );

	m_textCtrlFee = new wxTextCtrl( this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( 100,-1 ), wxTE_READONLY );
	m_textCtrlFee->SetFont( wxFont( wxNORMAL_FONT->GetPointSize(), 70, 90, 90, false, wxEmptyString ) );

    m_staticTextTotal= new wxStaticText( this, wxID_ANY, _("Total:"), wxDefaultPosition, wxSize( -1,-1 ), wxALIGN_RIGHT );
    m_textCtrlTotal = new wxTextCtrl( this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( 100,-1 ), wxTE_READONLY );

    bSizer20->Add( m_staticText19, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 5 );
	bSizer20->Add( m_textCtrlAmount, 1, wxALIGN_CENTER_VERTICAL|wxALL, 5 );
	bSizer20->Add( m_staticTextFee, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxLEFT|wxALIGN_RIGHT, 5 );
	bSizer20->Add( m_textCtrlFee, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );
	bSizer20->Add( m_staticTextTotal, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM|wxLEFT|wxALIGN_RIGHT, 5 );
	bSizer20->Add( m_textCtrlTotal, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );
	fgSizer1->Add( bSizer20, 1, wxEXPAND);

    wxBoxSizer* bSizerFinalBalance;
	bSizerFinalBalance = new wxBoxSizer( wxHORIZONTAL );

	m_staticTextBalance = new wxStaticText( this, wxID_ANY, _("Final Balance:"), wxDefaultPosition, wxSize( 90,-1 ), wxALIGN_RIGHT );
	m_textCtrlBalance = new wxTextCtrl( this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( 100,-1 ), wxTE_READONLY );

    m_buttonSend = new wxButton( this, wxID_BUTTONSEND, _("&Send"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	m_buttonCancel = new wxButton( this, wxID_CANCEL, _("Cancel"), wxDefaultPosition, wxSize( -1,-1 ), 0 );

    bSizerFinalBalance->Add( m_staticTextBalance, 0, wxALIGN_CENTER_VERTICAL|wxTOP|wxBOTTOM, 5 );
	bSizerFinalBalance->Add( m_textCtrlBalance, 1, wxALIGN_CENTER_VERTICAL|wxALL, 5 );
	bSizerFinalBalance->Add( m_buttonSend, 0, wxALL|wxALIGN_CENTER_VERTICAL, 5 );
	bSizerFinalBalance->Add( m_buttonCancel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 5 );
	fgSizer1->Add( bSizerFinalBalance, 1, wxEXPAND);

	this->SetSizerAndFit( fgSizer1 );
	this->Layout();

	// Connect Events
	m_textCtrlAddress->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler( CSendDialogBase::OnKeyDown ), NULL, this );
	m_textCtrlAddress->Connect( wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler( CSendDialogBase::OnAmountTextUpdate ), NULL, this );
	m_buttonPaste->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendDialogBase::OnButtonPaste ), NULL, this );
	m_buttonAddress->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendDialogBase::OnButtonAddressBook ), NULL, this );
	m_textCtrlAmount->Connect( wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler( CSendDialogBase::OnAmountTextUpdate ), NULL, this );
	//m_textCtrlAmount->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler( CSendDialogBase::OnKeyDown ), NULL, this );
	m_textCtrlAmount->Connect( wxEVT_KILL_FOCUS, wxFocusEventHandler( CSendDialogBase::OnKillFocusAmount ), NULL, this );
	m_buttonSend->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendDialogBase::OnButtonSend ), NULL, this );
	m_buttonCancel->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendDialogBase::OnButtonCancel ), NULL, this );
}

CSendDialogBase::~CSendDialogBase()
{
	// Disconnect Events
	m_textCtrlAddress->Disconnect( wxEVT_KEY_DOWN, wxKeyEventHandler( CSendDialogBase::OnKeyDown ), NULL, this );
	m_textCtrlAddress->Disconnect( wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler( CSendDialogBase::OnTextAddress ), NULL, this );
	m_buttonPaste->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendDialogBase::OnButtonPaste ), NULL, this );
	m_buttonAddress->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendDialogBase::OnButtonAddressBook ), NULL, this );
	m_textCtrlAmount->Disconnect( wxEVT_KEY_DOWN, wxKeyEventHandler( CSendDialogBase::OnKeyDown ), NULL, this );
	m_textCtrlAmount->Disconnect( wxEVT_KILL_FOCUS, wxFocusEventHandler( CSendDialogBase::OnKillFocusAmount ), NULL, this );
	m_buttonSend->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendDialogBase::OnButtonSend ), NULL, this );
	m_buttonCancel->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendDialogBase::OnButtonCancel ), NULL, this );
}

CSendingDialogBase::CSendingDialogBase( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxDialog( parent, id, title, pos, size, style )
{
	this->SetSizeHints( wxDefaultSize, wxDefaultSize );

	wxBoxSizer* bSizer68;
	bSizer68 = new wxBoxSizer( wxVERTICAL );

	m_staticTextSending = new wxStaticText( this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxSize( -1,14 ), 0 );
	m_staticTextSending->Wrap( -1 );
	bSizer68->Add( m_staticTextSending, 0, wxALIGN_CENTER_VERTICAL|wxEXPAND|wxTOP|wxRIGHT|wxLEFT, 8 );

	m_textCtrlStatus = new wxTextCtrl( this, wxID_ANY, _("\n\nConnecting..."), wxDefaultPosition, wxDefaultSize, wxTE_CENTRE|wxTE_MULTILINE|wxTE_NO_VSCROLL|wxTE_READONLY|wxNO_BORDER );
	m_textCtrlStatus->SetBackgroundColour( wxSystemSettings::GetColour( wxSYS_COLOUR_BTNFACE ) );

	bSizer68->Add( m_textCtrlStatus, 1, wxEXPAND|wxRIGHT|wxLEFT, 10 );

	wxBoxSizer* bSizer69;
	bSizer69 = new wxBoxSizer( wxHORIZONTAL );


	bSizer69->Add( 0, 0, 1, wxEXPAND, 5 );

	m_buttonOK = new wxButton( this, wxID_ANY, _("OK"), wxDefaultPosition, wxDefaultSize, 0 );
	m_buttonOK->Enable( false );

	bSizer69->Add( m_buttonOK, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonCancel = new wxButton( this, wxID_CANCEL, _("Cancel"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer69->Add( m_buttonCancel, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	bSizer68->Add( bSizer69, 0, wxEXPAND, 5 );

	this->SetSizerAndFit( bSizer68 );
	this->Layout();

	// Connect Events
	this->Connect( wxEVT_CLOSE_WINDOW, wxCloseEventHandler( CSendingDialogBase::OnClose ) );
	this->Connect( wxEVT_PAINT, wxPaintEventHandler( CSendingDialogBase::OnPaint ) );
	m_buttonOK->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendingDialogBase::OnButtonOK ), NULL, this );
	m_buttonCancel->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendingDialogBase::OnButtonCancel ), NULL, this );
}

CSendingDialogBase::~CSendingDialogBase()
{
	// Disconnect Events
	this->Disconnect( wxEVT_CLOSE_WINDOW, wxCloseEventHandler( CSendingDialogBase::OnClose ) );
	this->Disconnect( wxEVT_PAINT, wxPaintEventHandler( CSendingDialogBase::OnPaint ) );
	m_buttonOK->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendingDialogBase::OnButtonOK ), NULL, this );
	m_buttonCancel->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CSendingDialogBase::OnButtonCancel ), NULL, this );
}


CAddressBookDialogBase::CAddressBookDialogBase( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxDialog( parent, id, title, pos, size, style )
{
	this->SetSizeHints( wxDefaultSize, wxDefaultSize );

	wxBoxSizer* bSizer58;
	bSizer58 = new wxBoxSizer( wxVERTICAL );

	m_notebook = new wxNotebook( this, wxID_ANY, wxDefaultPosition, wxDefaultSize, 0 );
	m_panelSending = new wxPanel( m_notebook, wxID_PANELSENDING, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	wxBoxSizer* bSizer68;
	bSizer68 = new wxBoxSizer( wxVERTICAL );


	bSizer68->Add( 0, 0, 0, wxEXPAND, 5 );

	m_staticText55 = new wxStaticText( m_panelSending, wxID_ANY, _("SolidCoin Address"), wxDefaultPosition, wxDefaultSize, 0 );
	m_staticText55->Wrap( -1 );
	m_staticText55->Hide();

	bSizer68->Add( m_staticText55, 0, wxTOP|wxRIGHT|wxLEFT, 5 );

	m_listCtrlSending = new wxListCtrl( m_panelSending, wxID_LISTCTRLSENDING, wxDefaultPosition, wxSize(-1,250), wxLC_NO_SORT_HEADER|wxLC_REPORT|wxLC_SORT_ASCENDING );
	bSizer68->Add( m_listCtrlSending, 1, wxALL|wxEXPAND, 5 );

	m_panelSending->SetSizer( bSizer68 );
	m_panelSending->Layout();
	bSizer68->Fit( m_panelSending );
	m_notebook->AddPage( m_panelSending, _("Sending"), false );
	m_panelReceiving = new wxPanel( m_notebook, wxID_PANELRECEIVING, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	wxBoxSizer* bSizer681;
	bSizer681 = new wxBoxSizer( wxVERTICAL );


	bSizer681->Add( 0, 0, 0, wxEXPAND, 5 );

	m_staticText45 = new wxStaticText( m_panelReceiving, wxID_ANY, _("These are your SolidCoin addresses for receiving payments.  You can give a different one to each sender to keep track of who is paying you.  The highlighted address will be displayed in the main window."), wxDefaultPosition, wxDefaultSize, 0 );
	m_staticText45->Wrap( 570 );
	bSizer681->Add( m_staticText45, 0, wxTOP|wxRIGHT|wxLEFT, 6 );


	bSizer681->Add( 0, 2, 0, wxEXPAND, 5 );

	m_listCtrlReceiving = new wxListCtrl( m_panelReceiving, wxID_LISTCTRLRECEIVING, wxDefaultPosition, wxSize(-1,250), wxLC_NO_SORT_HEADER|wxLC_REPORT|wxLC_SORT_ASCENDING );
	bSizer681->Add( m_listCtrlReceiving, 1, wxALL|wxEXPAND, 5 );

	m_panelReceiving->SetSizer( bSizer681 );
	m_panelReceiving->Layout();
	bSizer681->Fit( m_panelReceiving );
	m_notebook->AddPage( m_panelReceiving, _("Receiving"), true );

	bSizer58->Add( m_notebook, 1, wxEXPAND|wxTOP|wxRIGHT|wxLEFT, 5 );

	wxBoxSizer* bSizer69;
	bSizer69 = new wxBoxSizer( wxHORIZONTAL );


	bSizer69->Add( 0, 0, 1, wxEXPAND, 5 );

	m_buttonDelete = new wxButton( this, wxID_BUTTONDELETE, _("&Delete"), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer69->Add( m_buttonDelete, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonCopy = new wxButton( this, wxID_BUTTONCOPY, _(" &Copy to Clipboard "), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer69->Add( m_buttonCopy, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonEdit = new wxButton( this, wxID_BUTTONEDIT, _("&Edit..."), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer69->Add( m_buttonEdit, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonNew = new wxButton( this, wxID_ANY, _(" &New Address... "), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer69->Add( m_buttonNew, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonOK = new wxButton( this, wxID_OK, _("OK"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer69->Add( m_buttonOK, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonCancel = new wxButton( this, wxID_CANCEL, _("Cancel"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer69->Add( m_buttonCancel, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	bSizer58->Add( bSizer69, 0, wxEXPAND, 5 );

	this->SetSizerAndFit( bSizer58 );
	this->Layout();

	// Connect Events
	this->Connect( wxEVT_CLOSE_WINDOW, wxCloseEventHandler( CAddressBookDialogBase::OnClose ) );
	m_notebook->Connect( wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED, wxNotebookEventHandler( CAddressBookDialogBase::OnNotebookPageChanged ), NULL, this );
	m_listCtrlSending->Connect( wxEVT_COMMAND_LIST_END_LABEL_EDIT, wxListEventHandler( CAddressBookDialogBase::OnListEndLabelEdit ), NULL, this );
	m_listCtrlSending->Connect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CAddressBookDialogBase::OnListItemActivated ), NULL, this );
	m_listCtrlSending->Connect( wxEVT_COMMAND_LIST_ITEM_SELECTED, wxListEventHandler( CAddressBookDialogBase::OnListItemSelected ), NULL, this );
	m_listCtrlReceiving->Connect( wxEVT_COMMAND_LIST_END_LABEL_EDIT, wxListEventHandler( CAddressBookDialogBase::OnListEndLabelEdit ), NULL, this );
	m_listCtrlReceiving->Connect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CAddressBookDialogBase::OnListItemActivated ), NULL, this );
	m_listCtrlReceiving->Connect( wxEVT_COMMAND_LIST_ITEM_SELECTED, wxListEventHandler( CAddressBookDialogBase::OnListItemSelected ), NULL, this );
	m_buttonDelete->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonDelete ), NULL, this );
	m_buttonCopy->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonCopy ), NULL, this );
	m_buttonEdit->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonEdit ), NULL, this );
	m_buttonNew->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonNew ), NULL, this );
	m_buttonOK->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonOK ), NULL, this );
	m_buttonCancel->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonCancel ), NULL, this );
}

CAddressBookDialogBase::~CAddressBookDialogBase()
{
	// Disconnect Events
    this->Disconnect( wxEVT_CLOSE_WINDOW, wxCloseEventHandler( CAddressBookDialogBase::OnClose ) );
    m_notebook->Disconnect( wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED, wxNotebookEventHandler( CAddressBookDialogBase::OnNotebookPageChanged ), NULL, this );

	m_listCtrlSending->Disconnect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CAddressBookDialogBase::OnListItemActivated ), NULL, this );
	m_listCtrlSending->Disconnect( wxEVT_COMMAND_LIST_ITEM_SELECTED, wxListEventHandler( CAddressBookDialogBase::OnListItemSelected ), NULL, this );
	m_listCtrlReceiving->Disconnect( wxEVT_COMMAND_LIST_ITEM_ACTIVATED, wxListEventHandler( CAddressBookDialogBase::OnListItemActivated ), NULL, this );
	m_listCtrlReceiving->Disconnect( wxEVT_COMMAND_LIST_ITEM_SELECTED, wxListEventHandler( CAddressBookDialogBase::OnListItemSelected ), NULL, this );
	m_listCtrlSending->Disconnect( wxEVT_COMMAND_LIST_END_LABEL_EDIT, wxListEventHandler( CAddressBookDialogBase::OnListEndLabelEdit ), NULL, this );
	m_listCtrlReceiving->Disconnect( wxEVT_COMMAND_LIST_END_LABEL_EDIT, wxListEventHandler( CAddressBookDialogBase::OnListEndLabelEdit ), NULL, this );


	m_buttonDelete->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonDelete ), NULL, this );
	m_buttonCopy->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonCopy ), NULL, this );
	m_buttonEdit->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonEdit ), NULL, this );
	m_buttonNew->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonNew ), NULL, this );
	m_buttonOK->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonOK ), NULL, this );
	m_buttonCancel->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CAddressBookDialogBase::OnButtonCancel ), NULL, this );

}

CGetTextFromUserDialogBase::CGetTextFromUserDialogBase( wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style ) : wxDialog( parent, id, title, pos, size, style )
{
	this->SetSizeHints( wxDefaultSize, wxDefaultSize );


	bSizer79 = new wxBoxSizer( wxVERTICAL );

	wxBoxSizer* bSizer81;
	bSizer81 = new wxBoxSizer( wxVERTICAL );


	bSizer81->Add( 0, 0, 1, wxEXPAND, 5 );

	m_staticTextMessage1 = new wxStaticText( this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_staticTextMessage1->Wrap( -1 );
	bSizer81->Add( m_staticTextMessage1, 0, wxTOP|wxRIGHT|wxLEFT, 5 );

	m_textCtrl1 = new wxTextCtrl( this, wxID_TEXTCTRL, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER );
	bSizer81->Add( m_textCtrl1, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL, 5 );

	m_staticTextMessage2 = new wxStaticText( this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_staticTextMessage2->Wrap( -1 );
	m_staticTextMessage2->Hide();

	bSizer81->Add( m_staticTextMessage2, 0, wxTOP|wxRIGHT|wxLEFT, 5 );

	m_textCtrl2 = new wxTextCtrl( this, wxID_TEXTCTRL, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER );
	m_textCtrl2->Hide();

	bSizer81->Add( m_textCtrl2, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL, 5 );


	bSizer81->Add( 0, 0, 1, wxEXPAND, 5 );

	bSizer79->Add( bSizer81, 1, wxEXPAND|wxALL, 10 );

	wxBoxSizer* bSizer80;
	bSizer80 = new wxBoxSizer( wxHORIZONTAL );


	bSizer80->Add( 0, 0, 1, wxEXPAND, 5 );

	m_buttonOK = new wxButton( this, wxID_OK, _("OK"), wxDefaultPosition, wxSize( -1,-1 ), 0 );
	bSizer80->Add( m_buttonOK, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	m_buttonCancel = new wxButton( this, wxID_CANCEL, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
	bSizer80->Add( m_buttonCancel, 0, wxALL|wxALIGN_CENTER_VERTICAL|wxEXPAND, 5 );

	bSizer79->Add( bSizer80, 0, wxEXPAND, 5 );

	this->SetSizerAndFit( bSizer79 );

	this->Layout();

	// Connect Events
	this->Connect( wxEVT_CLOSE_WINDOW, wxCloseEventHandler( CGetTextFromUserDialogBase::OnClose ) );
	m_textCtrl1->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler( CGetTextFromUserDialogBase::OnKeyDown ), NULL, this );
	m_textCtrl2->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler( CGetTextFromUserDialogBase::OnKeyDown ), NULL, this );
	m_buttonOK->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CGetTextFromUserDialogBase::OnButtonOK ), NULL, this );
	m_buttonCancel->Connect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CGetTextFromUserDialogBase::OnButtonCancel ), NULL, this );
}

CGetTextFromUserDialogBase::~CGetTextFromUserDialogBase()
{
	// Disconnect Events
	this->Disconnect( wxEVT_CLOSE_WINDOW, wxCloseEventHandler( CGetTextFromUserDialogBase::OnClose ) );
	m_textCtrl1->Disconnect( wxEVT_KEY_DOWN, wxKeyEventHandler( CGetTextFromUserDialogBase::OnKeyDown ), NULL, this );
	m_textCtrl2->Disconnect( wxEVT_KEY_DOWN, wxKeyEventHandler( CGetTextFromUserDialogBase::OnKeyDown ), NULL, this );
	m_buttonOK->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CGetTextFromUserDialogBase::OnButtonOK ), NULL, this );
	m_buttonCancel->Disconnect( wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler( CGetTextFromUserDialogBase::OnButtonCancel ), NULL, this );

}
