// Copyright (c) 2011 RealSolid. Please read license.txt for applicable licensing.

#include "headers.h"




CCriticalSection g_WalletLock;
std::vector<CWallet*> g_WalletList;
CWallet *g_pSelectedWallet=0;
CWallet *g_pDefaultWallet=0;



//////////////////////////////////////////////////////////////////////////////
//
// dispatching functions
//

void RegisterWallet(CWallet* pwalletIn)
{
    g_WalletList.push_back(pwalletIn);
}

void UnregisterWallet(CWallet* pwalletIn)
{

}

bool Wallet_IsFromMe(CTransaction& tx)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        if (pwallet->IsFromMe(tx))  return true;
    }
    return false;
}

CWallet* Wallet_IsMine(const CTxOut& txout)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        if (pwallet->IsMine(txout))  return pwallet;
    }
    return 0;
}

bool Wallet_GetTransaction(const uint256& hashTx, CWalletTx& wtx)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        if (pwallet->GetTransaction(hashTx,wtx))    return true;
    }
    return false;
}

void Wallet_Erase(uint256 hash)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        pwallet->EraseFromWallet(hash);
    }
}

void Wallet_ReacceptWalletTransactions(void)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        pwallet->ReacceptWalletTransactions();
    }
}

void Wallet_Sync(const CTransaction& tx, const CBlock* pblock, bool fUpdate)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        pwallet->AddToWalletIfInvolvingMe(tx, pblock, fUpdate);
    }
}

void Wallet_SetBestChain(const CBlockLocator& loc)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        pwallet->SetBestChain(loc);
    }
}

void Wallet_UpdatedTransaction(const uint256& hashTx)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        pwallet->UpdatedTransaction(hashTx);
    }
}

void Wallet_PrintWallets(const CBlock& block)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        pwallet->PrintWallet(block);
    }
}

void Wallet_Inventory(const uint256& hash)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        pwallet->Inventory(hash);
    }
}

void Wallet_ResendWalletTransactions()
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)
    {
        pwallet->ResendWalletTransactions();
    }
}

CWallet* Wallet_GetDefault()
{
    return g_pDefaultWallet;
}

void Wallet_Cleanup(void)
{

}

CWallet* Wallet_Get(int nNum)
{
    if(nNum>=g_WalletList.size()) return 0;
    return g_WalletList[nNum];
}
CWallet* Wallet_Get(const std::string &name)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)       //ensure its in our list
    {
        if(pwallet->GetWalletName()==name)
        {
            return pwallet;
        }
    }
    return 0;
}

void Wallet_SetDefault(CWallet *pDefaultWallet)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)       //ensure its in our list
    {
        if(pwallet==pDefaultWallet)
        {
            g_pDefaultWallet=pwallet;
            Setting_Set("wallet_default",pwallet->GetWalletName());
            return;
        }
    }
}

void Wallet_SetSelected(CWallet *pSelectedWallet)
{
    BOOST_FOREACH(CWallet* pwallet, g_WalletList)       //ensure its in our list
    {
        if(pwallet==pSelectedWallet)
        {
            g_pSelectedWallet=pwallet;
            return;
        }
    }
}

CWallet* Wallet_GetSelected()
{
    return g_pSelectedWallet;
}
