//Please read license.txt for licensing and copyright information

#ifdef GUI
#include "headers.h"
#include "db.h"
#include "init.h"
#include "wallet_func.h"
#include "strlcpy.h"
#include <boost/filesystem/fstream.hpp>
#include <boost/format.hpp>
#include <boost/filesystem/convenience.hpp>
#ifdef _MSC_VER
#include <crtdbg.h>
#endif



using namespace std;
using namespace boost;
extern const char * send16noshadow_xpm[];
extern const char* addressbook16_xpm[];
extern CCriticalSection cs_main;
extern const char *solidcoin80_xpm[];

DEFINE_EVENT_TYPE(wxEVT_UITHREADCALL)

CMainFrame* pframeMain = NULL;
CMyTaskBarIcon* ptaskbaricon = NULL;
bool fClosedToTray = false;
wxLocale g_locale;

#ifdef __WXMSW__
double nScaleX = 1.0;
double nScaleY = 1.0;
#else
static const double nScaleX = 1.0;
static const double nScaleY = 1.0;
#endif


void HandleCtrlA(wxKeyEvent& event)
{
    // Ctrl-a select all
    event.Skip();
    wxTextCtrl* textCtrl = (wxTextCtrl*)event.GetEventObject();
    if (event.GetModifiers() == wxMOD_CONTROL && event.GetKeyCode() == 'A')
        textCtrl->SetSelection(-1, -1);
}

bool Is24HourTime()
{
    //char pszHourFormat[256];
    //pszHourFormat[0] = '\0';
    //GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_ITIME, pszHourFormat, 256);
    //return (pszHourFormat[0] != '0');
    return true;
}

string DateStr(int64 nTime)
{
    // Can only be used safely here in the UI
    return (string)wxDateTime((time_t)nTime).FormatDate();
}

string TimeStr(int64 nTime)
{
    // Can only be used safely here in the UI
    wxDateTime datetime((time_t)nTime);
    return (string)datetime.Format("%H:%M");
}

string DateTimeStr(int64 nTime)
{
    // Can only be used safely here in the UI
    wxDateTime datetime((time_t)nTime);
    if (Is24HourTime())
        return (string)datetime.Format("%x %H:%M");
    else
        return (string)datetime.Format("%x ") + itostr((datetime.GetHour() + 11) % 12 + 1) + (string)datetime.Format(":%M %p");
}

wxString GetItemText(wxListCtrl* listCtrl, int nIndex, int nColumn)
{
    // Helper to simplify access to listctrl
    wxListItem item;
    item.m_itemId = nIndex;
    item.m_col = nColumn;
    item.m_mask = wxLIST_MASK_TEXT;
    if (!listCtrl->GetItem(item))
        return "";
    return item.GetText();
}

int InsertLine(wxListCtrl* listCtrl, const wxString& str0, const wxString& str1)
{
    int nIndex = listCtrl->InsertItem(listCtrl->GetItemCount(), str0);
    listCtrl->SetItem(nIndex, 1, str1);
    return nIndex;
}


void SetItemTextColour(wxListCtrl* listCtrl, int nIndex, const wxColour& colour)
{
    // Repaint on Windows is more flickery if the colour has ever been set,
    // so don't want to set it unless it's different.  Default colour has
    // alpha 0 transparent, so our colours don't match using operator==.
    //wxColour c1 = listCtrl->GetItemTextColour(nIndex);
    //if (!c1.IsOk())
        //c1 = wxColour(0,0,0);
    //if (colour.Red() != c1.Red() || colour.Green() != c1.Green() || colour.Blue() != c1.Blue())
        listCtrl->SetItemTextColour(nIndex, colour);
}

void SetSelection(wxListCtrl* listCtrl, int nIndex)
{
    int nSize = listCtrl->GetItemCount();
    long nState = (wxLIST_STATE_SELECTED|wxLIST_STATE_FOCUSED);
    for (int i = 0; i < nSize; i++)
        listCtrl->SetItemState(i, (i == nIndex ? nState : 0), nState);
}

int GetSelection(wxListCtrl* listCtrl)
{
    int nSize = listCtrl->GetItemCount();
    for (int i = 0; i < nSize; i++)
        if (listCtrl->GetItemState(i, wxLIST_STATE_SELECTED))
            return i;
    return -1;
}

string HtmlEscape(const char* psz, bool fMultiLine=false)
{
    int len = 0;
    for (const char* p = psz; *p; p++)
    {
             if (*p == '<') len += 4;
        else if (*p == '>') len += 4;
        else if (*p == '&') len += 5;
        else if (*p == '"') len += 6;
        else if (*p == ' ' && p > psz && p[-1] == ' ' && p[1] == ' ') len += 6;
        else if (*p == '\n' && fMultiLine) len += 5;
        else
            len++;
    }
    string str;
    str.reserve(len);
    for (const char* p = psz; *p; p++)
    {
             if (*p == '<') str += "&lt;";
        else if (*p == '>') str += "&gt;";
        else if (*p == '&') str += "&amp;";
        else if (*p == '"') str += "&quot;";
        else if (*p == ' ' && p > psz && p[-1] == ' ' && p[1] == ' ') str += "&nbsp;";
        else if (*p == '\n' && fMultiLine) str += "<br>\n";
        else
            str += *p;
    }
    return str;
}

string HtmlEscape(const string& str, bool fMultiLine=false)
{
    return HtmlEscape(str.c_str(), fMultiLine);
}

void CalledMessageBox(const string& message, const string& caption, int style, wxWindow* parent, int x, int y, int* pnRet, bool* pfDone)
{
    *pnRet = wxMessageBox(message, caption, style, parent, x, y);
    *pfDone = true;
}

int ThreadSafeMessageBox(const string& message, const string& caption, int style, wxWindow* parent, int x, int y)
{
#ifdef __WXMSW__
    return wxMessageBox(message, caption, style, parent, x, y);
#else
    if (wxThread::IsMain() || fDaemon)
    {
        return wxMessageBox(message, caption, style, parent, x, y);
    }
    else
    {
        int nRet = 0;
        bool fDone = false;
        UIThreadCall(bind(CalledMessageBox, message, caption, style, parent, x, y, &nRet, &fDone));
        while (!fDone)
            Sleep(100);
        return nRet;
    }
#endif
}

bool ThreadSafeAskFee(int64 nFeeRequired, const string& strCaption, wxWindow* parent)
{
    return true;
    if (nFeeRequired < MIN_TX_FEE || fDaemon)
        return true;
    string strMessage = strprintf(
        _("This transaction is over the size limit.  You can still send it for a fee of %s, "
          "which goes to the nodes that process your transaction and helps to support the network.  "
          "Do you want to pay the fee?"),
        FormatMoney(nFeeRequired).c_str());
    return (ThreadSafeMessageBox(strMessage, strCaption, wxYES_NO, parent) == wxYES);
}

void CalledSetStatusBar(const string& strText, int nField)
{
    if (nField == 0 && GetWarnings("statusbar") != "")
        return;
    if (pframeMain && pframeMain->m_statusBar)
        pframeMain->m_statusBar->SetStatusText(strText, nField);
}

//assumed locked before entering
bool GetWalletPassphrase()
{
    if (Wallet_GetSelected()->IsLocked())
    {
        string strWalletPass;
        strWalletPass.reserve(100);
        mlock(&strWalletPass[0], strWalletPass.capacity());

        // obtain current wallet encrypt/decrypt key, from passphrase
        // Note that the passphrase is not mlock()d during this entry and could potentially
        // be obtained from disk long after solidcoin has run.
        strWalletPass = wxGetPasswordFromUser(_("Enter the current passphrase to the wallet."),
                                              _("Passphrase")).ToStdString();

        if (!strWalletPass.size())
        {
            fill(strWalletPass.begin(), strWalletPass.end(), '\0');
            munlock(&strWalletPass[0], strWalletPass.capacity());
            wxMessageBox(_("Please supply the current wallet decryption passphrase."), "SolidCoin");
            return false;
        }

        if (!Wallet_GetSelected()->Unlock(strWalletPass))
        {
            fill(strWalletPass.begin(), strWalletPass.end(), '\0');
            munlock(&strWalletPass[0], strWalletPass.capacity());
            wxMessageBox(_("The passphrase entered for the wallet decryption was incorrect."), "SolidCoin");
            return false;
        }
        fill(strWalletPass.begin(), strWalletPass.end(), '\0');
        munlock(&strWalletPass[0], strWalletPass.capacity());
    }
    return true;
}








//////////////////////////////////////////////////////////////////////////////
//
// CMainFrame
//

CMainFrame::CMainFrame(wxWindow* parent) : CMainFrameBase(parent)
{
    Connect(wxEVT_UITHREADCALL, wxCommandEventHandler(CMainFrame::OnUIThreadCall), NULL, this);

    SetSelection(m_MiningPoolSelect,0);
    // Set initially selected page
    wxNotebookEvent event;
    event.SetSelection(0);
    OnNotebookPageChanged(event);
    m_notebook->ChangeSelection(0);

    // Init
    fRefreshListCtrl = false;
    fRefreshListCtrlRunning = false;
    fOnSetFocusAddress = false;
    fRefresh = false;
    m_choiceFilter->SetSelection(0);
    double dResize = nScaleX;
#ifdef __WXMSW__
    SetIcon(wxICON(solidcoin));
    SetSize(dResize * GetSize().GetWidth(), nScaleY * GetSize().GetHeight());
#else
    wxIcon mainicon;
    mainicon.CopyFromBitmap(wxBitmap(solidcoin80_xpm));
    SetIcon(mainicon);
    SetBackgroundColour(m_toolBar->GetBackgroundColour());
    //wxFont fontTmp = m_staticText41->GetFont();
    //m_staticTextBalance->SetFont(fontTmp);
    //m_staticTextBalance->SetSize(140, 17);
    // resize to fit ubuntu's huge default font
    dResize = 1.22;
    SetSize(dResize * GetSize().GetWidth(), 1.15 * GetSize().GetHeight());
#endif
    //m_staticTextBalance->SetLabel("  "+FormatMoney(Wallet_GetSelected()->GetBalance()) + "  ");
    //m_staticTextBalance->SetLabel(" "+FormatMoney(0) + "  ");
    m_listCtrl->SetFocus();
    ptaskbaricon = new CMyTaskBarIcon();
#ifdef __WXMAC_OSX__
    // Mac automatically moves wxID_EXIT, wxID_PREFERENCES and wxID_ABOUT
    // to their standard places, leaving these menus empty.
    GetMenuBar()->Remove(2); // remove Help menu
    GetMenuBar()->Remove(0); // remove File menu
#endif

    // Init column headers
    int nDateWidth = DateTimeStr(1229413914).size() * 6 + 8;
    if (!strstr(DateTimeStr(1229413914).c_str(), "2008"))
        nDateWidth += 12;
#ifdef __WXMAC_OSX__
    nDateWidth += 5;
    dResize -= 0.01;
#endif
    wxListCtrl* pplistCtrl[] = {m_listCtrlAll, m_listCtrlSent, m_listCtrlReceived};
    BOOST_FOREACH(wxListCtrl* p, pplistCtrl)
    {
        p->InsertColumn(0, "",               wxLIST_FORMAT_LEFT,  dResize * 20);
        p->InsertColumn(1, _("Status"),      wxLIST_FORMAT_LEFT,  dResize * 112);
        p->InsertColumn(2, _("Date"),        wxLIST_FORMAT_LEFT,  dResize * nDateWidth);
        p->InsertColumn(3, _("Description"), wxLIST_FORMAT_LEFT,  dResize * 409 - nDateWidth);
        p->InsertColumn(4, _("Debit"),       wxLIST_FORMAT_RIGHT, dResize * 79);
        p->InsertColumn(5, _("Credit"),      wxLIST_FORMAT_RIGHT, dResize * 79);
        p->InsertColumn(6, "",               wxLIST_FORMAT_LEFT,  dResize * 0);
    }

    // Init status bar
    int pnWidths[3] = { -100, 88, 370 };
#ifndef __WXMSW__
    pnWidths[1] = pnWidths[1] * 1.1 * dResize;
    pnWidths[2] = pnWidths[2] * 1.1 * dResize;
#endif
    m_statusBar->SetFieldsCount(3, pnWidths);

    // Fill your address text box
    vector<unsigned char> vchPubKey;
    //if (CWalletDB(Wallet_GetSelected()->strWalletFile,"r").ReadDefaultKey(vchPubKey))
      //  m_textCtrlAddress->SetValue(CSolidCoinAddress(vchPubKey).ToString());

    {
        LOCK_WALLET_ACCESS();
        UpdateWalletSelect(Wallet_GetSelected());   //default wallet is selected at init
    }

    // Fill listctrl with wallet transactions
    RefreshListCtrl();
}

CMainFrame::~CMainFrame()
{
    pframeMain = NULL;
    delete ptaskbaricon;
    ptaskbaricon = NULL;
}

void CMainFrame::OnNotebookPageChanged(wxNotebookEvent& event)
{
    event.Skip();
    nPage = event.GetSelection();
    if (nPage == ALL)
    {
        m_listCtrl = m_listCtrlAll;
        fShowGenerated = true;
        fShowSent = true;
        fShowReceived = true;
    }
    else if (nPage == SENT)
    {
        m_listCtrl = m_listCtrlSent;
        fShowGenerated = false;
        fShowSent = true;
        fShowReceived = false;
    }
    else if (nPage == RECEIVED)
    {
        m_listCtrl = m_listCtrlReceived;
        fShowGenerated = false;
        fShowSent = false;
        fShowReceived = true;
    }
    RefreshListCtrl();
    m_listCtrl->SetFocus();
}
void CMainFrame::OnSize(wxSizeEvent& event)
{
    event.Skip();
    wxSize size=GetClientSize();;
    wxSize size2=m_TxLimitSelect->GetSize();

    m_TxLimitSelect->Move(wxPoint(size.x-size2.x,0));

}
void CMainFrame::OnClose(wxCloseEvent& event)
{
    if (Setting_GetBOOL("gui_minonclose") && event.CanVeto() && !IsIconized())
    {
        event.Veto();   // Divert close to minimize
        fClosedToTray = true;
        Iconize(true);
    }
    else
    {
        Destroy();
        CreateThread(Shutdown, NULL);
    }
}

void CMainFrame::OnIconize(wxIconizeEvent& event)
{
    event.Skip();
    // Hide the task bar button when minimized.  Event is sent when the frame is minimized or restored. wxWidgets 2.8.9 doesn't have IsIconized() so there's no way    // to get rid of the deprecated warning.  Just ignore it.
    // What the fuck sort of comment is this one above? IsIconized is used all over the source code already
    if (!event.IsIconized())
        fClosedToTray = false;
#if defined(__WXGTK__) || defined(__WXMAC_OSX__)
    if (Setting_GetBOOL("gui_mintotray")) {
#endif
    // The tray icon sometimes disappears on ubuntu karmic
    // Hiding the taskbar button doesn't work cleanly on ubuntu lucid
    // Reports of CPU peg on 64-bit linux
    if (Setting_GetBOOL("gui_mintotray") && event.IsIconized())    fClosedToTray = true;
    Show(!fClosedToTray);
    //ptaskbaricon->Show(Setting_GetBOOL("gui_mintotray") || fClosedToTray);
#if defined(__WXGTK__) || defined(__WXMAC_OSX__)
    }
#endif
}

void CMainFrame::OnMouseEvents(wxMouseEvent& event)
{
    event.Skip();
    RandAddSeed();
    RAND_add(&event.m_x, sizeof(event.m_x), 0.25);
    RAND_add(&event.m_y, sizeof(event.m_y), 0.25);
}

void CMainFrame::OnListColBeginDrag(wxListEvent& event)
{
    // Hidden columns not resizeable
    if ( (event.GetColumn() == 0 ||  event.GetColumn() == 6)&& !fDebug)     event.Veto();
    else                                                                    event.Skip();
}

int CMainFrame::GetSortIndex(const string& strSort)
{
#ifdef __WXMSW__
    return 0;
#else
    // The wx generic listctrl implementation used on GTK doesn't sort,
    // so we have to do it ourselves.  Remember, we sort in reverse order.
    // In the wx generic implementation, they store the list of items
    // in a vector, so indexed lookups are fast, but inserts are slower
    // the closer they are to the top.
    int low = 0;
    int high = m_listCtrl->GetItemCount();
    while (low < high)
    {
        int mid = low + ((high - low) / 2);
        if (strSort.compare(m_listCtrl->GetItemText(mid,0).c_str()) >= 0)
            high = mid;
        else
            low = mid + 1;
    }
    return low;
#endif
}

void CMainFrame::InsertLine(bool fNew, int nIndex, uint256 hashKey, string strSort, const wxColour& colour, const wxString& str2, const wxString& str3, const wxString& str4, const wxString& str5, const wxString& str6, bool bConfirmed)
{
    strSort = " " + strSort;       // leading space to workaround wx2.9.0 ubuntu 9.10 bug
    long nData = *(long*)&hashKey; //  where first char of hidden column is displayed

    // Find item
    if (!fNew && nIndex == -1)
    {
        string strHash = " " + hashKey.ToString();
        while ((nIndex = m_listCtrl->FindItem(nIndex, nData)) != -1)
            if (GetItemText(m_listCtrl, nIndex, 6) == strHash)
                break;
    }

    // fNew is for blind insert, only use if you're sure it's new
    if (fNew || nIndex == -1)
    {
        nIndex = m_listCtrl->InsertItem(GetSortIndex(strSort), strSort);
    }
    else
    {
        // If sort key changed, must delete and reinsert to make it relocate
        if (GetItemText(m_listCtrl, nIndex, 0) != strSort)
        {
            m_listCtrl->DeleteItem(nIndex);
            nIndex = m_listCtrl->InsertItem(nIndex, strSort);
        }
    }
    m_listCtrl->SetItem(nIndex, 1, str2);
    m_listCtrl->SetItem(nIndex, 2, str3);
    m_listCtrl->SetItem(nIndex, 3, str4);
    m_listCtrl->SetItem(nIndex, 4, str5);
    m_listCtrl->SetItem(nIndex, 5, str6);
    m_listCtrl->SetItem(nIndex, 6, " " + hashKey.ToString());
    m_listCtrl->SetItemData(nIndex, nData);
    SetItemTextColour(m_listCtrl, nIndex, colour);
    if(bConfirmed)  m_listCtrl->SetItemImage(nIndex, 1);
    else            m_listCtrl->SetItemImage(nIndex, 0);
    //SetItemTextColour(m_listCtrl, nIndex, wxColor(255,255,255));
}

bool CMainFrame::DeleteLine(uint256 hashKey)
{
    long nData = *(long*)&hashKey;

    // Find item
    int nIndex = -1;
    string strHash = " " + hashKey.ToString();
    while ((nIndex = m_listCtrl->FindItem(nIndex, nData)) != -1)
        if (GetItemText(m_listCtrl, nIndex, 6) == strHash)
            break;

    if (nIndex != -1)
        m_listCtrl->DeleteItem(nIndex);

    return nIndex != -1;
}

string FormatTxStatus(const CWalletTx& wtx)
{
    // Status
    if (!wtx.IsFinal())
    {
        if (wtx.nLockTime < LOCKTIME_THRESHOLD)
            return strprintf(_("Open for %"PRI64d" blocks"), g_qBlockBestHeight - wtx.nLockTime);
        else
            return strprintf(_("Open until %s"), DateTimeStr(wtx.nLockTime).c_str());
    }
    else
    {
        int64 nDepth = wtx.GetDepthInMainChain();
        if (SolidTime_Get() - wtx.nTimeReceived > 2 * 60 && wtx.GetRequestCount() == 0)
            return strprintf(_("%"PRI64d"/offline?"), nDepth);
        else if(wtx.IsCoinBase())
        {
            if (nDepth < COINBASE_MATURITY) return strprintf(_("Confirming (%d%%)"), (int)(nDepth*(100.0/COINBASE_MATURITY)) );
            else                            return strprintf(_("Confirmed"));
        }
        else
        {
            if (nDepth < 6) return strprintf(_("Confirming (%d%%)"), (int)(nDepth*17) );
            else            return strprintf(_("Confirmed"));
        }
    }
}

string SingleLine(const string& strIn)
{
    string strOut;
    bool fOneSpace = false;
    BOOST_FOREACH(unsigned char c, strIn)
    {
        if (isspace(c))
        {
            fOneSpace = true;
        }
        else if (c > ' ')
        {
            if (fOneSpace && !strOut.empty())
                strOut += ' ';
            strOut += c;
            fOneSpace = false;
        }
    }
    return strOut;
}

//assumed wallet locked prior
bool CMainFrame::InsertTransaction(const CWalletTx& wtx, bool fNew, int nIndex)
{
    int64 nTime = wtx.nTimeDisplayed = wtx.GetTxTime();
    int64 nCredit = wtx.GetCredit(true);
    int64 nDebit = wtx.GetDebit();
    int64 nNet = nCredit - nDebit;
    uint256 hash = wtx.GetHash();
    string strStatus = FormatTxStatus(wtx);
    bool fConfirmed = wtx.fConfirmedDisplayed = wtx.IsConfirmed();
    wxColour colour = (fConfirmed ? wxColour(0,0,0) : wxColour(128,128,128));
    map<string, string> mapValue = wtx.mapValue;
    wtx.nLinesDisplayed = 1;
    nListViewUpdated++;
    bool bFullConfirm = false;


    if(wtx.IsCoinBase())
    {
        if(wtx.GetConfirmed() >= COINBASE_MATURITY) bFullConfirm=true;
    }
    else if(wtx.GetConfirmed() >= 6) bFullConfirm=true;


    wtx.bConfirmedDisplayed=bFullConfirm;

    // Filter

    if (wtx.IsCoinBase())
    {
        // Don't show generated coin until confirmed by at least one block after it
        // so we don't get the user's hopes up until it looks like it's probably accepted.
        //
        // It is not an error when generated blocks are not accepted.  By design,
        // some percentage of blocks, like 10% or more, will end up not accepted.
        // This is the normal mechanism by which the network copes with latency.
        //
        // We display regular transactions right away before any confirmation
        // because they can always get into some block eventually.  Generated coins
        // are special because if their block is not accepted, they are not valid.
        //
        if (wtx.GetDepthInMainChain() < 2)
        {
            wtx.nLinesDisplayed = 0;
            return false;
        }

        if (!fShowGenerated)
            return false;


    }

    // Find the block the tx is in
    CBlockIndex* pindex = NULL;
    map<uint256, CBlockIndex*>::iterator mi = g_BlockIndexMap.find(wtx.hashBlock);
    if (mi != g_BlockIndexMap.end())
        pindex = (*mi).second;

    // Sort order, unrecorded transactions sort to the top
    string strSort = strprintf("%010"PRI64d"-%01d-%010u",(pindex ? pindex->blk.nBlockNum : INT64_MAX),(wtx.IsCoinBase() ? 1 : 0),wtx.nTimeReceived);

    // Insert line
    if (nNet > 0 || wtx.IsCoinBase())
    {
        //
        // Credit
        //
        string strDescription;
        if (wtx.IsCoinBase())
        {
            // Generated
            strDescription = _("Generated");
            if (nCredit == 0)
            {
                int64 nUnmatured = 0;
                BOOST_FOREACH(const CTxOut& txout, wtx.vout)
                    nUnmatured += Wallet_GetSelected()->GetCredit(txout);
                if (wtx.IsInMainChain())
                {
                    strDescription = strprintf(_("Generated (%s matures in %d more blocks)"), FormatMoney(nUnmatured).c_str(), wtx.GetBlocksToMaturity());

                    // Check if the block was requested by anyone
                    if (SolidTime_Get() - wtx.nTimeReceived > 2 * 60 && wtx.GetRequestCount() == 0)
                        strDescription = _("Generated - Warning: This block was not received by any other nodes and will probably not be accepted!");
                }
                else
                {
                    strDescription = _("Generated (not accepted)");
                }
            }
        }
        else if (!mapValue["from"].empty() || !mapValue["message"].empty())
        {
            // Received by IP connection
            if (!fShowReceived)
                return false;
            if (!mapValue["from"].empty())  strDescription += _("From: ") + mapValue["from"];
            if (!mapValue["message"].empty())
            {
                if (!strDescription.empty())    strDescription += " - ";
                strDescription += mapValue["message"];
            }
        }
        else
        {
            // Received by SolidCoin Address
            if (!fShowReceived) return false;
            BOOST_FOREACH(const CTxOut& txout, wtx.vout)
            {
                //CWallet *pWallet=Wallet_IsMine(txout);
                //if (pWallet)
                if(Wallet_GetSelected()->IsMine(txout))
                {
                    CSolidCoinAddress address;
                    if (ExtractAddress(txout.scriptPubKey, Wallet_GetSelected(), address))
                    {
                        //strDescription += _("Received payment to ");
                        //strDescription += _("Received with address ");
                        strDescription += _("Received with: ");
                        map<CSolidCoinAddress, string>::iterator mi = Wallet_GetSelected()->mapAddressBook.find(address);
                        if (mi != Wallet_GetSelected()->mapAddressBook.end() && !(*mi).second.empty())
                        {
                            string strLabel = (*mi).second;
                            strDescription += address.ToString().substr(0,12) + "... ";
                            strDescription += "(" + strLabel + ")";
                        }
                        else
                            strDescription += address.ToString();
                    }
                    break;
                }
            }
        }

        string strCredit = FormatMoney(nNet, true);
        if (!fConfirmed)
            strCredit = "[" + strCredit + "]";

        InsertLine(fNew, nIndex, hash, strSort, colour,
                   strStatus,
                   nTime ? DateTimeStr(nTime) : "",
                   SingleLine(strDescription),
                   "",
                   strCredit,bFullConfirm);
    }
    else
    {
        bool fAllFromMe = true;
        BOOST_FOREACH(const CTxIn& txin, wtx.vin)
            fAllFromMe = fAllFromMe && Wallet_GetSelected()->IsMine(txin);

        bool fAllToMe = true;
        BOOST_FOREACH(const CTxOut& txout, wtx.vout)
            fAllToMe = fAllToMe && Wallet_GetSelected()->IsMine(txout);

        if (fAllFromMe && fAllToMe)
        {
            // Payment to self
            int64 nChange = wtx.GetChange();
            InsertLine(fNew, nIndex, hash, strSort, colour,
                       strStatus,
                       nTime ? DateTimeStr(nTime) : "",
                       _("Payment to yourself"),
                       FormatMoney(-(nDebit - nChange), true),
                       FormatMoney(nCredit - nChange, true),bFullConfirm);
        }
        else if (fAllFromMe)
        {
            //
            // Debit
            //
            if (!fShowSent)
                return false;

            int64 nTxFee = nDebit - wtx.GetValueOut();
            wtx.nLinesDisplayed = 0;
            for (int nOut = 0; nOut < wtx.vout.size(); nOut++)
            {
                const CTxOut& txout = wtx.vout[nOut];
                //CWallet *pWallet = Wallet_IsMine(txout);
                //if (pWallet)    continue;
                if(Wallet_GetSelected()->IsMine(txout)) continue;

                CSolidCoinAddress address;
                string strAddress;
                if (!mapValue["to"].empty())
                {
                    // Sent to IP
                    strAddress = mapValue["to"];
                }
                else
                {
                    // Sent to SolidCoin Address
                    if (ExtractAddress(txout.scriptPubKey, NULL, address))
                        strAddress = address.ToString();
                }

                string strDescription = _("To: ");
                    if (Wallet_GetSelected()->mapAddressBook.count(address) && !Wallet_GetSelected()->mapAddressBook[address].empty())
                        strDescription += Wallet_GetSelected()->mapAddressBook[address] + " ";
                strDescription += strAddress;
                if (!mapValue["message"].empty())
                {
                    if (!strDescription.empty())
                        strDescription += " - ";
                    strDescription += mapValue["message"];
                }
                else if (!mapValue["comment"].empty())
                {
                    if (!strDescription.empty())
                        strDescription += " - ";
                    strDescription += mapValue["comment"];
                }

                int64 nValue = txout.nValue;
                if (nTxFee > 0)
                {
                    nValue += nTxFee;
                    nTxFee = 0;
                }

                InsertLine(fNew, nIndex, hash, strprintf("%s-%d", strSort.c_str(), nOut), colour,
                           strStatus,
                           nTime ? DateTimeStr(nTime) : "",
                           SingleLine(strDescription),
                           FormatMoney(-nValue, true),
                           "",bFullConfirm);
                nIndex = -1;
                wtx.nLinesDisplayed++;
                break;
            }
        }
        else
        {
            //
            // Mixed debit transaction, can't break down payees
            //
            bool fAllMine = true;
            BOOST_FOREACH(const CTxOut& txout, wtx.vout)
                fAllMine = fAllMine && Wallet_GetSelected()->IsMine(txout);
            BOOST_FOREACH(const CTxIn& txin, wtx.vin)
                fAllMine = fAllMine && Wallet_GetSelected()->IsMine(txin);

            InsertLine(fNew, nIndex, hash, strSort, colour,
                       strStatus,
                       nTime ? DateTimeStr(nTime) : "",
                       "",
                       FormatMoney(nNet, true),
                       "",bFullConfirm);
        }
    }

    return true;
}

void CMainFrame::RefreshListCtrl()
{
    fRefreshListCtrl = true;
    ::wxWakeUpIdle();
}

void CMainFrame::OnIdle(wxIdleEvent& event)
{
    CWallet *pWallet;
    if (fRefreshListCtrl)
    {
        fRefreshListCtrl = false;
        m_listCtrl->DeleteAllItems();


        vector<pair<unsigned int, uint256> > vSorted;   // Collect list of wallet transactions and sort newest first

        LOCK_WALLET_ACCESS();

        pWallet = Wallet_GetSelected();
        pWallet->vWalletUpdated.clear();


        vSorted.reserve(pWallet->mapWallet.size());
        for (map<uint256, CWalletTx>::iterator it = pWallet->mapWallet.begin(); it != pWallet->mapWallet.end(); ++it)
        {
            const CWalletTx& wtx = (*it).second;
            unsigned int nTime = UINT_MAX - wtx.GetTxTime();
            vSorted.push_back(make_pair(nTime, (*it).first));
        }
        sort(vSorted.begin(), vSorted.end());   // Sort so the newest transactions are first

        // Fill list control
        int numTX=0;
        for (int i = 0; i < vSorted.size();)
        {
            if (fShutdown)  return;
            {
                uint256& hash = vSorted[i++].second;
                map<uint256, CWalletTx>::iterator mi = pWallet->mapWallet.find(hash);
                if (mi != pWallet->mapWallet.end())
                {
                    if(InsertTransaction((*mi).second, true))
                    {
                        numTX++;
                        if(m_nMaxTX && numTX>=m_nMaxTX) break;
                    }
                }
            }
            if (i == 100 || i % 500 == 0)                wxYield();     //lets the UI update? kinda hacky
        }
        // Update transaction total display
        MainFrameRepaint();
    }
}

void CMainFrame::RefreshStatusColumn()
{
    static CBlockIndex* pindexLastBest;
    if (pindexLastBest == g_pBlockBestIndex)   return;
    pindexLastBest = g_pBlockBestIndex;


    int nStart = 0;
    int nEnd = m_listCtrl->GetItemCount();

    for (int nIndex = nStart; nIndex < nEnd ; nIndex++)
    {
        uint256 hash((string)GetItemText(m_listCtrl, nIndex, 6));
        map<uint256, CWalletTx>::iterator mi = Wallet_GetSelected()->mapWallet.find(hash);
        if (mi == Wallet_GetSelected()->mapWallet.end())    continue;
        CWalletTx& wtx = (*mi).second;
        if (wtx.IsCoinBase() || wtx.GetTxTime() != wtx.nTimeDisplayed || wtx.bConfirmedDisplayed==false)
        {
            if (!InsertTransaction(wtx, false, nIndex))
            {
                //m_listCtrl->DeleteItem(nIndex--);
            }
        }
        else
        {
            InsertTransaction(wtx, false, nIndex);
            //m_listCtrl->SetItem(nIndex, 1, FormatTxStatus(wtx));
        }
    }
}

void CMainFrame::OnPaint(wxPaintEvent& event)
{
    event.Skip();
    if (fRefresh)
    {
        fRefresh = false;
        Refresh();
    }
}


unsigned int nNeedRepaint = 0;
unsigned int nLastRepaint = 0;
int64 nLastRepaintTime = 0;
int64 nRepaintInterval = 250;

void ThreadDelayedRepaint(void* parg)
{
    while (!fShutdown)
    {
        if (nLastRepaint != nNeedRepaint && GetTimeMillis() - nLastRepaintTime >= nRepaintInterval)
        {
            nLastRepaint = nNeedRepaint;
            if (pframeMain)
            {
                //printf("DelayedRepaint\n");
                wxPaintEvent event;
                pframeMain->fRefresh = true;
                pframeMain->GetEventHandler()->AddPendingEvent(event);
            }
        }
        Sleep(nRepaintInterval);
    }
}

void MainFrameRepaint()
{
    // This is called by network code that shouldn't access pframeMain
    // directly because it could still be running after the UI is closed.
    if (pframeMain)
    {
        // Don't repaint too often
        static int64 nLastRepaintRequest;
        if (GetTimeMillis() - nLastRepaintRequest < 100)
        {
            nNeedRepaint++;
            return;
        }
        nLastRepaintRequest = GetTimeMillis();
        //printf("MainFrameRepaint\n");
        wxPaintEvent event;
        pframeMain->fRefresh = true;
        pframeMain->GetEventHandler()->AddPendingEvent(event);
    }
}

void CMainFrame::OnPaintListCtrl(wxPaintEvent& event)
{
    // Skip lets the listctrl do the paint, we're just hooking the message
    event.Skip();

    if (ptaskbaricon)   ptaskbaricon->UpdateTooltip();

    // Slower stuff
    static int nTransactionCount;
    bool fPaintedBalance = false;
    if (GetTimeMillis() - nLastRepaintTime >= nRepaintInterval)
    {
        LOCK_WALLET_ACCESS();
        nLastRepaint = nNeedRepaint;
        nLastRepaintTime = GetTimeMillis();

        CWallet* pWallet=Wallet_GetSelected();
        // Update listctrl contents
        if (!pWallet->vWalletUpdated.empty())
        {
            string strTop;
            if (m_listCtrl->GetItemCount()) strTop = (string)m_listCtrl->GetItemText(0);
            BOOST_FOREACH(uint256 hash, pWallet->vWalletUpdated)
            {
                map<uint256, CWalletTx>::iterator mi = pWallet->mapWallet.find(hash);
                if (mi != pWallet->mapWallet.end())
                {
                    InsertTransaction((*mi).second, false);
                    if(m_nMaxTX && m_listCtrl->GetItemCount()>m_nMaxTX)
                    {
                        m_listCtrl->DeleteItem(m_listCtrl->GetItemCount()-1);
                    }
                }
            }
            pWallet->vWalletUpdated.clear();
            if (m_listCtrl->GetItemCount() && strTop != (string)m_listCtrl->GetItemText(0)) m_listCtrl->ScrollList(0, INT_MIN/2);
        }

        // Balance total
        {
            //balancew will only update once new blocks arive
            m_staticTextBalance->SetLabel(" Balance: " + FormatMoney(pWallet->GetBalance()) + " SC");

        }
        RefreshStatusColumn();  //update status column
    }
    //if (!Wallet_GetSelected()->vWalletUpdated.empty() || !fPaintedBalance)
    // Update status bar
    static string strPrevWarning;
    string strWarning = GetWarnings("statusbar");
    if (strWarning != "")
        m_statusBar->SetStatusText(string("    ") + _(strWarning), 0);
    else if (strPrevWarning != "")
        m_statusBar->SetStatusText("", 0);
    strPrevWarning = strWarning;

    int nDiff=(int)GetDifficulty(0);

    extern int64 g_nBestBlockCountExternal;
    string ExternalBlockCount;
    if(g_nBestBlockCountExternal==0)                ExternalBlockCount = "(???)";
    else if(g_qBlockBestHeight<g_nBestBlockCountExternal)  ExternalBlockCount = str(boost::format("(%d%%)") % (int)((g_qBlockBestHeight/(float)g_nBestBlockCountExternal)*100) );
    else                                            ExternalBlockCount = "(100%)";

    string strStatus = strprintf(_(" Connections: %d    Blocks: %"PRI64d" %s    Diff: %d"), vNodes.size(), g_qBlockBestHeight,ExternalBlockCount.c_str(), nDiff);
    m_statusBar->SetStatusText(strStatus, 2);
}


void UIThreadCall(boost::function0<void> fn)
{
    // Call this with a function object created with bind.
    // bind needs all parameters to match the function's expected types
    // and all default parameters specified.  Some examples:
    //  UIThreadCall(bind(wxBell));
    //  UIThreadCall(bind(wxMessageBox, wxT("Message"), wxT("Title"), wxOK, (wxWindow*)NULL, -1, -1));
    //  UIThreadCall(bind(&CMainFrame::OnMenuHelpAbout, pframeMain, event));
    if (pframeMain)
    {
        wxCommandEvent event(wxEVT_UITHREADCALL);
        event.SetClientData((void*)new boost::function0<void>(fn));
        pframeMain->GetEventHandler()->AddPendingEvent(event);
    }
}

void CMainFrame::OnUIThreadCall(wxCommandEvent& event)
{
    boost::function0<void>* pfn = (boost::function0<void>*)event.GetClientData();
    (*pfn)();
    delete pfn;
}

void CMainFrame::OnMenuFileExit(wxCommandEvent& event)
{
    // File->Exit
    Close(true);
}

void CMainFrame::OnMenuFileOpenDataDir(wxCommandEvent& event)
{
    #ifdef __WXMSW__
    wxExecute("explorer "+GetDataDir(),wxEXEC_ASYNC,NULL);
    #elif __WXOSX__
    wxExecute("open "+GetDataDir(),wxEXEC_ASYNC,NULL);
    #else
    wxExecute("konqueror "+GetDataDir(),wxEXEC_ASYNC,NULL);
    #endif
}


void CMainFrame::OnMenuSetDefaultWallet(wxCommandEvent& event)
{
    LOCK_WALLET_ACCESS();
    Wallet_SetDefault(Wallet_GetSelected());
    UpdateWalletSelect(Wallet_GetSelected());
}

void CMainFrame::OnMenuFileNewWallet(wxCommandEvent& event)
{
    string walletNameNew="name";
    CGetTextFromUserDialog dialog(this, _("New Wallet"), _("Wallet Name"), walletNameNew);
    if (!dialog.ShowModal())    return;
    walletNameNew=dialog.GetValue();

    try
    {
        boost::filesystem::path walletFileName= GetDataDir() + "/wallet_" + walletNameNew+".dat";
        string walletFileNameSimple="wallet_" + walletNameNew+".dat";
        if(boost::filesystem::exists(walletFileName))
        {
            wxMessageBox("That wallet name is already in use, please select another","Error: Already exists");
            return;
        }
        if(boost::filesystem::portable_name(walletFileNameSimple)==false)
        {
            wxMessageBox("That wallet name is invalid, use standard characters (A->Z, 0->9, etc)","Error: Invalid Name");
            return;
        }

        CWallet *pwallet = new CWallet(walletNameNew);
        int nLoadWalletRet = pwallet->LoadWallet(false);
        if (nLoadWalletRet != DB_LOAD_OK)
        {
            wxMessageBox("Could not create: "+walletFileNameSimple+"\nError Code:"+boost::str(boost::format("%d")%nLoadWalletRet),"Error: Create Wallet");
            return;
        }
        {
            LOCK_WALLET_ACCESS();
            RegisterWallet(pwallet);
            UpdateWalletSelect(Wallet_GetSelected());
        }

    }
    catch (std::exception& e)
    {
        wxMessageBox(e.what(),"New Wallet Error");
        return;
    }
}

void CMainFrame::OnMenuRenameWallet(wxCommandEvent& event)
{
    string walletNameNew,walletNameOld;
    string oldFileName;
    {
        LOCK_WALLET_ACCESS();
        walletNameOld=walletNameNew=Wallet_GetSelected()->GetWalletName();

        oldFileName=Wallet_GetSelected()->GetWalletFileName();
    }
    CGetTextFromUserDialog dialog(this, _("Rename Wallet"), _("Wallet Name"), walletNameOld);
    if (!dialog.ShowModal())    return;
    walletNameNew = dialog.GetValue();
    if(walletNameNew==walletNameOld)    return; //same name do nothing

    try
    {
        boost::filesystem::path newWallet= GetDataDir() + "/wallet_" + walletNameNew+".dat";
        boost::filesystem::path oldWallet= GetDataDir() + "/wallet_" + walletNameOld+".dat";
        if(boost::filesystem::exists(newWallet))
        {
            wxMessageBox("That wallet name is already in use, please select another","Error: Already exists");
            return;
        }
        if(boost::filesystem::exists(oldWallet)==false)
        {
            wxMessageBox("Could not find old wallet:\n"+oldWallet.string(),"Error: Unable to find original wallet");
            return;
        }

        {
            LOCK_WALLET_ACCESS();
            boost::filesystem::rename(oldWallet,newWallet);
            Wallet_GetSelected()->setWalletName(walletNameNew); //also updates filename
            UpdateWalletSelect(Wallet_GetSelected());
        }
        wxMessageBox("Renamed wallet from "+walletNameOld+" to "+walletNameNew);
    }
    catch (std::exception& e)
    {
        wxMessageBox(e.what(),"Rename Wallet Error");
        return;
    }
}

void CMainFrame::UpdateWalletSelect(CWallet *pWalletSelect)
{
    int nNum=0;
    CWallet *pWallet;
    m_WalletSelect->Clear();
    while( (pWallet=Wallet_Get(nNum++)) )
    {
        std::string name = pWallet->GetWalletName();
        if(Wallet_GetDefault()==pWallet) name+=" *";
        m_WalletSelect->Append(name);
        if(pWalletSelect==pWallet)    m_WalletSelect->SetSelection(nNum-1);
    }
}

void CMainFrame::OnMenuOptionsChangeYourAddress(wxCommandEvent& event)
{
    // Options->Your Receiving Addresses
    CAddressBookDialog dialog(this, "", CAddressBookDialog::RECEIVING, false);
    if (!dialog.ShowModal())
        return;
}

void CMainFrame::OnMenuOptionsEncryptWallet(wxCommandEvent& event)
{
    LOCK_WALLET_ACCESS();
    // Options->Encrypt Wallet
    if (Wallet_GetSelected()->IsCrypted())
    {
        wxMessageBox(_("Wallet already encrypted."), "SolidCoin", wxOK | wxICON_ERROR);
        return;
    }

    string strWalletPass;
    strWalletPass.reserve(100);
    mlock(&strWalletPass[0], strWalletPass.capacity());

    // obtain current wallet encrypt/decrypt key, from passphrase
    // Note that the passphrase is not mlock()d during this entry and could potentially
    // be obtained from disk long after solidcoin has run.
    strWalletPass = wxGetPasswordFromUser(_("Enter the new passphrase to the wallet.\nPlease use a passphrase of 10 or more random characters, or eight or more words."),
                                          _("Passphrase")).ToStdString();
    if (strWalletPass.size()<=0) return;        //when user cancels its blank
    if (strWalletPass.size()<10)
    {
        fill(strWalletPass.begin(), strWalletPass.end(), '\0');
        munlock(&strWalletPass[0], strWalletPass.capacity());
        wxMessageBox(_("Error: The supplied passphrase was too short."), "SolidCoin", wxOK | wxICON_ERROR);
        return;
    }

    if(wxMessageBox(_("WARNING: If you encrypt your wallet and lose your passphrase, you will LOSE ALL OF YOUR SOLIDCOINS!\nAre you sure you wish to encrypt your wallet?"), "SolidCoin", wxYES_NO) != wxYES)
        return;

    string strWalletPassTest;
    strWalletPassTest.reserve(100);
    mlock(&strWalletPassTest[0], strWalletPassTest.capacity());
    strWalletPassTest = wxGetPasswordFromUser(_("Please re-enter your new wallet passphrase."),
                                              _("Passphrase")).ToStdString();

    if (strWalletPassTest != strWalletPass)
    {
        fill(strWalletPass.begin(), strWalletPass.end(), '\0');
        fill(strWalletPassTest.begin(), strWalletPassTest.end(), '\0');
        munlock(&strWalletPass[0], strWalletPass.capacity());
        munlock(&strWalletPassTest[0], strWalletPassTest.capacity());
        wxMessageBox(_("Error: the supplied passphrases didn't match."), "SolidCoin", wxOK | wxICON_ERROR);
        return;
    }

    if (!Wallet_GetSelected()->EncryptWallet(strWalletPass))
    {
        fill(strWalletPass.begin(), strWalletPass.end(), '\0');
        fill(strWalletPassTest.begin(), strWalletPassTest.end(), '\0');
        munlock(&strWalletPass[0], strWalletPass.capacity());
        munlock(&strWalletPassTest[0], strWalletPassTest.capacity());
        wxMessageBox(_("Wallet encryption failed."), "SolidCoin", wxOK | wxICON_ERROR);
        return;
    }
    fill(strWalletPass.begin(), strWalletPass.end(), '\0');
    fill(strWalletPassTest.begin(), strWalletPassTest.end(), '\0');
    munlock(&strWalletPass[0], strWalletPass.capacity());
    munlock(&strWalletPassTest[0], strWalletPassTest.capacity());
    wxMessageBox(_("Wallet Encrypted.\nRemember that encrypting your wallet cannot fully protect your solidcoins from being stolen by malware infecting your computer."), "SolidCoin");

    //m_menuOptions->Remove(m_menuOptionsEncryptWallet);
    //m_menuOptions->Insert(m_menuOptions->GetMenuItemCount() - 1, m_menuOptionsChangeWalletPassphrase);
}

void CMainFrame::OnMenuOptionsChangeWalletPassphrase(wxCommandEvent& event)
{
    // Options->Change Wallet Encryption Passphrase
    LOCK_WALLET_ACCESS();
    if (!Wallet_GetSelected()->IsCrypted())
    {
        wxMessageBox(_("Wallet is unencrypted, please encrypt it first."), "SolidCoin", wxOK | wxICON_ERROR);
        return;
    }

    string strOldWalletPass;
    strOldWalletPass.reserve(100);
    mlock(&strOldWalletPass[0], strOldWalletPass.capacity());

    // obtain current wallet encrypt/decrypt key, from passphrase
    // Note that the passphrase is not mlock()d during this entry and could potentially
    // be obtained from disk long after solidcoin has run.
    strOldWalletPass = wxGetPasswordFromUser(_("Enter the current passphrase to the wallet."),
                                             _("Passphrase")).ToStdString();
    if(!strOldWalletPass.size()) return;

    {
        bool fWasLocked = Wallet_GetSelected()->IsLocked();
        Wallet_GetSelected()->Lock();

        if (!strOldWalletPass.size() || !Wallet_GetSelected()->Unlock(strOldWalletPass))
        {
            fill(strOldWalletPass.begin(), strOldWalletPass.end(), '\0');
            munlock(&strOldWalletPass[0], strOldWalletPass.capacity());
            wxMessageBox(_("The passphrase entered for the wallet decryption was incorrect."), "SolidCoin", wxOK | wxICON_ERROR);
            return;
        }

        if (fWasLocked)
            Wallet_GetSelected()->Lock();

        string strNewWalletPass;
        strNewWalletPass.reserve(100);
        mlock(&strNewWalletPass[0], strNewWalletPass.capacity());

        // obtain new wallet encrypt/decrypt key, from passphrase
        // Note that the passphrase is not mlock()d during this entry and could potentially
        // be obtained from disk long after solidcoin has run.
        strNewWalletPass = wxGetPasswordFromUser(_("Enter the new passphrase for the wallet."),
                                                 _("Passphrase")).ToStdString();

        if (!strNewWalletPass.size())
        {
            fill(strOldWalletPass.begin(), strOldWalletPass.end(), '\0');
            fill(strNewWalletPass.begin(), strNewWalletPass.end(), '\0');
            munlock(&strOldWalletPass[0], strOldWalletPass.capacity());
            munlock(&strNewWalletPass[0], strNewWalletPass.capacity());
            wxMessageBox(_("Error: The supplied passphrase was too short."), "SolidCoin", wxOK | wxICON_ERROR);
            return;
        }

        string strNewWalletPassTest;
        strNewWalletPassTest.reserve(100);
        mlock(&strNewWalletPassTest[0], strNewWalletPassTest.capacity());

        // obtain new wallet encrypt/decrypt key, from passphrase
        // Note that the passphrase is not mlock()d during this entry and could potentially
        // be obtained from disk long after solidcoin has run.
        strNewWalletPassTest = wxGetPasswordFromUser(_("Re-enter the new passphrase for the wallet."),
                                                     _("Passphrase")).ToStdString();

        if (strNewWalletPassTest != strNewWalletPass)
        {
            fill(strOldWalletPass.begin(), strOldWalletPass.end(), '\0');
            fill(strNewWalletPass.begin(), strNewWalletPass.end(), '\0');
            fill(strNewWalletPassTest.begin(), strNewWalletPassTest.end(), '\0');
            munlock(&strOldWalletPass[0], strOldWalletPass.capacity());
            munlock(&strNewWalletPass[0], strNewWalletPass.capacity());
            munlock(&strNewWalletPassTest[0], strNewWalletPassTest.capacity());
            wxMessageBox(_("Error: the supplied passphrases didn't match."), "SolidCoin", wxOK | wxICON_ERROR);
            return;
        }

        if (!Wallet_GetSelected()->ChangeWalletPassphrase(strOldWalletPass, strNewWalletPass))
        {
            fill(strOldWalletPass.begin(), strOldWalletPass.end(), '\0');
            fill(strNewWalletPass.begin(), strNewWalletPass.end(), '\0');
            fill(strNewWalletPassTest.begin(), strNewWalletPassTest.end(), '\0');
            munlock(&strOldWalletPass[0], strOldWalletPass.capacity());
            munlock(&strNewWalletPass[0], strNewWalletPass.capacity());
            munlock(&strNewWalletPassTest[0], strNewWalletPassTest.capacity());
            wxMessageBox(_("The passphrase entered for the wallet decryption was incorrect."), "SolidCoin", wxOK | wxICON_ERROR);
            return;
        }
        fill(strOldWalletPass.begin(), strOldWalletPass.end(), '\0');
        fill(strNewWalletPass.begin(), strNewWalletPass.end(), '\0');
        fill(strNewWalletPassTest.begin(), strNewWalletPassTest.end(), '\0');
        munlock(&strOldWalletPass[0], strOldWalletPass.capacity());
        munlock(&strNewWalletPass[0], strNewWalletPass.capacity());
        munlock(&strNewWalletPassTest[0], strNewWalletPassTest.capacity());
        wxMessageBox(_("Wallet Passphrase Changed."), "SolidCoin");
    }
}



void CMainFrame::OnMenuOptionsOptions(wxCommandEvent& event)
{
    COptionsDialog dialog(this);
    dialog.ShowModal();
}

void CalledUpdateMiningUI(void)
{
    pframeMain->UpdateMiningUI();
}

void CalledUpdateMiningStatus(const string& strText)
{
    if (!pframeMain || !pframeMain->m_MiningStatus) return;
    std::string output = TimeStr(SolidTime_Get()) + " : "+strText;
    pframeMain->m_MiningStatus->InsertItem(0,output);
}

void CalledUpdateMiningHash(int64 nMilli, std::vector<MINING_SPEEDS> *pSpeeds)
{
    if (!pframeMain || !pframeMain->m_MiningStatus) return;
    //std::string output = TimeStr(GetSolidTime()) + " : "+strText;
    //pframeMain->m_MiningStatus->InsertItem(0,output);
    double dSec = nMilli/1000.0;
    for(int x=0;x<pSpeeds->size();x++)
    {
        MINING_SPEEDS *pSpeed = &(*pSpeeds)[x];
        if(pSpeed->nID==-1)
        {
            pframeMain->m_MiningTestworkStats->SetValue( str(boost::format("MiniPool Stats - Speed: %.02f KH/s - Shares: %d (%d invalid)") % (pSpeed->qHash/1000.0) % pSpeed->qShares % pSpeed->qInvalid ) );

        }
        else
        {
            pframeMain->m_MiningPoolSelect->SetItem( pSpeed->nID,1,str(boost::format("%.02f KH/s") % ((pSpeed->qHash/1000.0)/dSec) ) );
            pframeMain->m_MiningPoolSelect->SetItem( pSpeed->nID,2,str(boost::format("%d") % pSpeed->qShares) );

            MINING_POOL *pPool= &g_MiningPoolList[pSpeed->nID];
            pPool->qLastHashPerSec=(int64)(pSpeed->qHash/dSec);
            pPool->qTotalHash+=pSpeed->qHash;
            pPool->qTotalShares=pSpeed->qShares;
        }
    }



    delete pSpeeds;
}


void CMainFrame::OnMiningTextUpdate( wxCommandEvent& event )
{
    event.Skip();
    UpdateMiningText();
}

void CMainFrame::UpdateMiningText(void)
{
    int nItem = GetSelection(m_MiningPoolSelect);
    if(nItem<0 || nItem>=g_MiningPoolList.size()) return;
    MINING_POOL *pPool= &g_MiningPoolList[nItem];

    pPool->name=m_MiningName->GetLineText(0).ToStdString();
    m_MiningPoolSelect->SetItem(nItem,0,pPool->name);
    pPool->user=m_MiningUserName->GetLineText(0).ToStdString();
    pPool->pass=m_MiningUserPass->GetLineText(0).ToStdString();

    std::string addr = m_MiningAddress->GetLineText(0).ToStdString();

    int npos=addr.find(":");
	if(npos!=std::string::npos)
    {
        pPool->nPort=atoi(addr.substr(npos+1,addr.length()));
        pPool->host=addr.substr(0,npos);
    }
    else
    {
        pPool->host=addr;
        pPool->nPort=0;
    }
    /*
	host=geturl.substr(7,geturl.length());
	npos=host.find("/");
	if(npos==(int)std::string::npos) return false;
	dir=host.substr(npos,host.length());
	host.erase(npos,host.length());
    std::
    */
}

void CMainFrame::UpdateMiningUI(void)
{
    MUTEX_LOCK(cs_main);

    MINING_POOL *pPool=0;
    int nItem = GetSelection(m_MiningPoolSelect);
    if(nItem>=0 && nItem<g_MiningPoolList.size())
    {
        pPool= &g_MiningPoolList[nItem];
    }

    if(!pPool || pPool->website.length()<=0)    m_MiningButtonWebsite->Enable(false);
    else                                        m_MiningButtonWebsite->Enable(true);

    if(pPool && pPool->nRunning)
    {
        m_MiningButtonStart->SetLabel("Stop");
        m_MiningPoolSelect->SetItem(nItem,0,pPool->name,1);
        m_MiningPoolSelect->SetItem(nItem,3,str(boost::format("%d")%pPool->nThreads ) );

    }
    else
    {
        m_MiningButtonStart->SetLabel("Start");
        if(pPool)
        {
            m_MiningPoolSelect->SetItem(nItem,0,pPool->name,0);
            m_MiningPoolSelect->SetItem(nItem,1,"0 KH/s");
            m_MiningPoolSelect->SetItem(nItem,3,"0");
        }
    }

    if(!pPool)  m_MiningButtonStart->Enable(false);
    else        m_MiningButtonStart->Enable(true);

    bool bEnable=true;
    if(!pPool || pPool->nRunning)  bEnable=false;

    m_MiningName->Enable(bEnable);
    m_MiningAddress->Enable(bEnable);
    m_MiningUserName->Enable(bEnable);
    m_MiningUserPass->Enable(bEnable);
    m_MiningThreads->Enable(bEnable);
}


void CMainFrame::OnMiningListItemSelected( wxListEvent& event )
{
    int nItem = GetSelection(m_MiningPoolSelect);
    if(nItem<0 || nItem>=g_MiningPoolList.size()) return;

    MINING_POOL *pPool=&g_MiningPoolList[nItem];

    m_MiningName->ChangeValue(pPool->name);
    m_MiningAddress->ChangeValue(pPool->host+":"+itostr(pPool->nPort));
    m_MiningUserName->ChangeValue(pPool->user);
    m_MiningUserPass->ChangeValue(pPool->pass);

    m_MiningThreads->SetSelection(pPool->nThreads-1);


    UpdateMiningUI();
}


void CMainFrame::OnMiningListItemDeSelected( wxListEvent& event )
{
    m_MiningName->Clear();
    m_MiningAddress->Clear();
    m_MiningUserName->Clear();
    m_MiningUserPass->Clear();

    UpdateMiningUI();
}
void Mining_AddPool(MINING_POOL *pPool);
void Mining_RemovePool(int id);

void CMainFrame::OnMiningButtonStart( wxCommandEvent& event )
{
    MUTEX_LOCK(cs_main);
    int nItem = GetSelection(m_MiningPoolSelect);
    int nThreads=m_MiningThreads->GetSelection()+1;
    if(nItem<0 || nItem>=g_MiningPoolList.size()) return;


    MINING_POOL *pPool=&g_MiningPoolList[nItem];

    if(g_MiningPoolList[nItem].nRunning)    //close her down
    {
        Mining_RemovePool(pPool->id);
        pPool->nRunning=0;
    }
    else                                    //start her up
    {
        pPool->qLastHashPerSec=0;
        pPool->qTotalHash=0;
        pPool->qTotalShares=0;
        pPool->id=nItem;
        Mining_AddPool(pPool);
        pPool->nRunning=1;
    }
    UpdateMiningUI();
}

void CMainFrame::OnMiningThreadSelect( wxCommandEvent& event )
{
    int nItem = GetSelection(m_MiningPoolSelect);
    if(nItem<0 || nItem>=g_MiningPoolList.size()) return;
    g_MiningPoolList[nItem].nThreads=m_MiningThreads->GetSelection()+1;
}

void CMainFrame::OnMiningButtonWebsite( wxCommandEvent& event )
{
    int nItem = GetSelection(m_MiningPoolSelect);
    if(nItem<0 || nItem>=g_MiningPoolList.size()) return;

    wxLaunchDefaultBrowser(g_MiningPoolList[nItem].website);

}

void CMainFrame::OnMenuShowMiningPanel(wxCommandEvent& event)
{
    bool bEnabled=!Setting_GetBOOL("gui_showminingpanel");
    Setting_SetBOOL("gui_showminingpanel",bEnabled);
    if(bEnabled)
    {
        m_MiningPanel->Show();
        m_menuShowMiningPanel->Check();
    }
    else
    {
        m_MiningPanel->Hide();
        m_menuShowMiningPanel->Check(false);
    }
    this->SetSizer( m_MainSizer );
	this->Layout();
    //m_MainSizer->Layout();
    //this->SetSizerAndLayout

}


void CMainFrame::OnMenuHelpAbout(wxCommandEvent& event)
{
    // Help->About
    CAboutDialog dialog(this);
    dialog.ShowModal();
}

void CMainFrame::OnButtonSend(wxCommandEvent& event)
{
    // Toolbar: Send
    CSendDialog dialog(this);
    dialog.ShowModal();
}

void CMainFrame::OnTXLimitSelect( wxCommandEvent& event )
{
    switch(event.GetSelection())
    {
        case 0: m_nMaxTX=50;break;
        case 1: m_nMaxTX=250;break;
        case 2: m_nMaxTX=500;break;
        case 3: m_nMaxTX=0;break;
    }
    Setting_SetINT64("gui_showtx",m_nMaxTX);

    m_WalletText->SetFocus();       //mouse scroll after selecting this combobox shouldnt go through the options
    RefreshListCtrl();
}

void CMainFrame::OnWalletSelect( wxCommandEvent& event )
{
    int nWallet=event.GetSelection();

    {
        LOCK_WALLET_ACCESS();
        CWallet *pWallet = Wallet_Get(nWallet);
        Wallet_SetSelected(pWallet);

        if (Wallet_GetSelected()->IsCrypted())
        {
            //m_menuOptions->Remove(m_menuOptionsEncryptWallet);
        }
        else
        {
            //m_menuOptions->Remove(m_menuOptionsChangeWalletPassphrase);
        }
    }
    m_WalletText->SetFocus();
    RefreshListCtrl();
    //MainFrameRepaint(); // Refresh UI
    //wxMessageBox(pWallet->GetWalletFileName());



}

void CMainFrame::OnButtonAddressBook(wxCommandEvent& event)
{
    // Toolbar: Address Book
    CAddressBookDialog dialogAddr(this, "", CAddressBookDialog::SENDING, false);
    if (dialogAddr.ShowModal() == 2)
    {
        // Send
        CSendDialog dialogSend(this, dialogAddr.GetSelectedAddress());
        dialogSend.ShowModal();
    }
}

void CMainFrame::OnButtonTrade(wxCommandEvent& event)
{
    wxLaunchDefaultBrowser("http://solidcoin.info/market.php");
}

void CMainFrame::OnMenuAboutHomePage(wxCommandEvent& event)
{
    wxLaunchDefaultBrowser("http://solidcoin.info");
}

void CMainFrame::OnButtonLogo(wxCommandEvent& event)
{
    wxLaunchDefaultBrowser("http://solidcoin.info");
}

void CMainFrame::OnListItemActivated(wxListEvent& event)
{
    uint256 hash((string)GetItemText(m_listCtrl, event.GetIndex(), 6));
    CWalletTx wtx;

    {
        LOCK_WALLET_ACCESS();
        map<uint256, CWalletTx>::iterator mi = Wallet_GetSelected()->mapWallet.find(hash);
        if (mi == Wallet_GetSelected()->mapWallet.end())
        {
            debugprintf(WARN, "CMainFrame::OnListItemActivated() : tx not found in mapWallet\n");
            return;
        }
        wtx = (*mi).second;
    }
    CTxDetailsDialog dialog(this, wtx);
    dialog.ShowModal();
    //CTxDetailsDialog* pdialog = new CTxDetailsDialog(this, wtx);
    //pdialog->Show();
}






//////////////////////////////////////////////////////////////////////////////
//
// CTxDetailsDialog
//

CTxDetailsDialog::CTxDetailsDialog(wxWindow* parent, CWalletTx wtx) : CTxDetailsDialogBase(parent)
{
#ifdef __WXMSW__
    SetSize(nScaleX * GetSize().GetWidth(), nScaleY * GetSize().GetHeight());
#endif
    LOCK_WALLET_ACCESS();
    {
        string strHTML;
        strHTML.reserve(4000);
        strHTML += "<html><font face='verdana, arial, helvetica, sans-serif'>";

        int64 nTime = wtx.GetTxTime();
        int64 nCredit = wtx.GetCredit();
        int64 nDebit = wtx.GetDebit();
        int64 nNet = nCredit - nDebit;

        strHTML += _("<b>Status:</b> ") + FormatTxStatus(wtx) + str(boost::format(" [%d]") % wtx.GetConfirmed()) ;
        int nRequests = wtx.GetRequestCount();
        if (nRequests != -1)
        {
            if (nRequests == 0)
                strHTML += _(", has not been successfully broadcast yet");
            else if (nRequests == 1)
                strHTML += strprintf(_(", broadcast through %d node"), nRequests);
            else
                strHTML += strprintf(_(", broadcast through %d nodes"), nRequests);
        }
        strHTML += "<br>";

        strHTML += _("<b>Date:</b> ") + (nTime ? DateTimeStr(nTime) : "") + "<br>";
        strHTML += _("<b>TX ID:</b> ") + wtx.GetHash().ToString() + "<br>";


        //
        // From
        //
        if (wtx.IsCoinBase())
        {
            strHTML += _("<b>Source:</b> Generated<br>");
        }
        else if (!wtx.mapValue["from"].empty())
        {
            // Online transaction
            if (!wtx.mapValue["from"].empty())
                strHTML += _("<b>From:</b> ") + HtmlEscape(wtx.mapValue["from"]) + "<br>";
        }
        else
        {
            // Offline transaction
            if (nNet > 0)
            {
                // Credit
                BOOST_FOREACH(const CTxOut& txout, wtx.vout)
                {
                    if (Wallet_GetSelected()->IsMine(txout))
                    {
                        CSolidCoinAddress address;
                        if (ExtractAddress(txout.scriptPubKey, Wallet_GetSelected(), address))
                        {
                            if (Wallet_GetSelected()->mapAddressBook.count(address))
                            {
                                strHTML += string() + _("<b>From:</b> ") + _("unknown") + "<br>";
                                strHTML += _("<b>To:</b> ");
                                strHTML += HtmlEscape(address.ToString());
                                if (!Wallet_GetSelected()->mapAddressBook[address].empty())
                                    strHTML += _(" (yours, label: ") + Wallet_GetSelected()->mapAddressBook[address] + ")";
                                else
                                    strHTML += _(" (yours)");
                                strHTML += "<br>";
                            }
                        }
                        break;
                    }
                }
            }
        }


        //
        // To
        //
        string strAddress;
        if (!wtx.mapValue["to"].empty())
        {
            // Online transaction
            strAddress = wtx.mapValue["to"];
            strHTML += _("<b>To:</b> ");
            if (Wallet_GetSelected()->mapAddressBook.count(strAddress) && !Wallet_GetSelected()->mapAddressBook[strAddress].empty())
                strHTML += Wallet_GetSelected()->mapAddressBook[strAddress] + " ";
            strHTML += HtmlEscape(strAddress) + "<br>";
        }


        //
        // Amount
        //
        if (wtx.IsCoinBase() && nCredit == 0)
        {
            //
            // Coinbase
            //
            int64 nUnmatured = 0;
            BOOST_FOREACH(const CTxOut& txout, wtx.vout)
                nUnmatured += Wallet_GetSelected()->GetCredit(txout);
            strHTML += _("<b>Credit:</b> ");
            if (wtx.IsInMainChain())
                strHTML += strprintf(_("(%s matures in %d more blocks)"), FormatMoney(nUnmatured).c_str(), wtx.GetBlocksToMaturity());
            else
                strHTML += _("(not accepted)");
            strHTML += "<br>";
        }
        else if (nNet > 0)
        {
            //
            // Credit
            //
            strHTML += _("<b>Credit:</b> ") + FormatMoney(nNet) + "<br>";
        }
        else
        {
            bool fAllFromMe = true;
            BOOST_FOREACH(const CTxIn& txin, wtx.vin)
                fAllFromMe = fAllFromMe && Wallet_GetSelected()->IsMine(txin);

            bool fAllToMe = true;
            BOOST_FOREACH(const CTxOut& txout, wtx.vout)
                fAllToMe = fAllToMe && Wallet_GetSelected()->IsMine(txout);

            if (fAllFromMe)
            {
                //
                // Debit
                //
                BOOST_FOREACH(const CTxOut& txout, wtx.vout)
                {
                    if (Wallet_GetSelected()->IsMine(txout))
                        continue;

                    if (wtx.mapValue["to"].empty())
                    {
                        // Offline transaction
                        CSolidCoinAddress address;
                        if (ExtractAddress(txout.scriptPubKey, Wallet_GetSelected(), address))
                        {
                            string strAddress = address.ToString();
                            strHTML += _("<b>To:</b> ");
                            if (Wallet_GetSelected()->mapAddressBook.count(address) && !Wallet_GetSelected()->mapAddressBook[address].empty())
                                strHTML += Wallet_GetSelected()->mapAddressBook[address] + " ";
                            strHTML += strAddress;
                            strHTML += "<br>";
                        }
                    }

                    strHTML += _("<b>Debit:</b> ") + FormatMoney(-txout.nValue) + "<br>";
                }

                if (fAllToMe)
                {
                    // Payment to self
                    int64 nChange = wtx.GetChange();
                    int64 nValue = nCredit - nChange;
                    strHTML += _("<b>Debit:</b> ") + FormatMoney(-nValue) + "<br>";
                    strHTML += _("<b>Credit:</b> ") + FormatMoney(nValue) + "<br>";
                }

                int64 nTxFee = nDebit - wtx.GetValueOut();
                if (nTxFee > 0)
                    strHTML += _("<b>Transaction fee:</b> ") + FormatMoney(-nTxFee) + "<br>";
            }
            else
            {
                //
                // Mixed debit transaction
                //
                BOOST_FOREACH(const CTxIn& txin, wtx.vin)
                    if (Wallet_GetSelected()->IsMine(txin))
                        strHTML += _("<b>Debit:</b> ") + FormatMoney(-Wallet_GetSelected()->GetDebit(txin)) + "<br>";
                BOOST_FOREACH(const CTxOut& txout, wtx.vout)
                    if (Wallet_GetSelected()->IsMine(txout))
                        strHTML += _("<b>Credit:</b> ") + FormatMoney(Wallet_GetSelected()->GetCredit(txout)) + "<br>";
            }
        }

        strHTML += _("<b>Net amount:</b> ") + FormatMoney(nNet, true) + "<br>";


        //
        // Message
        //
        if (!wtx.mapValue["message"].empty())
            strHTML += string() + "<br><b>" + _("Message:") + "</b><br>" + HtmlEscape(wtx.mapValue["message"], true) + "<br>";
        if (!wtx.mapValue["comment"].empty())
            strHTML += string() + "<br><b>" + _("Comment:") + "</b><br>" + HtmlEscape(wtx.mapValue["comment"], true) + "<br>";

        if (wtx.IsCoinBase())
            strHTML += string() + "<br>" + _("Generated coins must wait 120 blocks before they can be spent.  When you generated this block, it was broadcast to the network to be added to the block chain.  If it fails to get into the chain, it will change to \"not accepted\" and not be spendable.  This may occasionally happen if another node generates a block within a few seconds of yours.") + "<br>";


        //
        // Debug view
        //
        if (fDebug)
        {
            strHTML += "<hr><br>debug print<br><br>";
            BOOST_FOREACH(const CTxIn& txin, wtx.vin)
                if (Wallet_GetSelected()->IsMine(txin))
                    strHTML += "<b>Debit:</b> " + FormatMoney(-Wallet_GetSelected()->GetDebit(txin)) + "<br>";
            BOOST_FOREACH(const CTxOut& txout, wtx.vout)
                if (Wallet_GetSelected()->IsMine(txout))
                    strHTML += "<b>Credit:</b> " + FormatMoney(Wallet_GetSelected()->GetCredit(txout)) + "<br>";

            strHTML += "<br><b>Transaction:</b><br>";
            strHTML += HtmlEscape(wtx.ToString(), true);

            strHTML += "<br><b>Inputs:</b><br>";
            {
                BOOST_FOREACH(const CTxIn& txin, wtx.vin)
                {
                    COutPoint prevout = txin.prevout;
                    map<uint256, CWalletTx>::iterator mi = Wallet_GetSelected()->mapWallet.find(prevout.hash);
                    if (mi != Wallet_GetSelected()->mapWallet.end())
                    {
                        const CWalletTx& prev = (*mi).second;
                        if (prevout.n < prev.vout.size())
                        {
                            strHTML += HtmlEscape(prev.ToString(), true);
                            strHTML += " &nbsp;&nbsp; " + FormatTxStatus(prev) + ", ";
                            strHTML = strHTML + "IsMine=" + (Wallet_GetSelected()->IsMine(prev.vout[prevout.n]) ? "true" : "false") + "<br>";
                        }
                    }
                }
            }
        }



        strHTML += "</font></html>";
        string(strHTML.begin(), strHTML.end()).swap(strHTML);
        m_htmlWin->SetPage(strHTML);
        m_buttonOK->SetFocus();
    }
}

void CTxDetailsDialog::OnButtonOK(wxCommandEvent& event)
{
    EndModal(false);
}






//////////////////////////////////////////////////////////////////////////////
//
// Startup folder
//

#ifdef __WXMSW__
string StartupShortcutPath()
{
    return MyGetSpecialFolderPath(CSIDL_STARTUP, true) + "\\SolidCoin.lnk";
}

bool GetStartOnSystemStartup()
{
    return filesystem::exists(StartupShortcutPath().c_str());
}

void SetStartOnSystemStartup(bool fAutoStart)
{
    // If the shortcut exists already, remove it for updating
    remove(StartupShortcutPath().c_str());

    if (fAutoStart)
    {
        CoInitialize(NULL);

        // Get a pointer to the IShellLink interface.
        IShellLink* psl = NULL;
        HRESULT hres = CoCreateInstance(CLSID_ShellLink, NULL,
                                CLSCTX_INPROC_SERVER, IID_IShellLink,
                                reinterpret_cast<void**>(&psl));

        if (SUCCEEDED(hres))
        {
            // Get the current executable path
            TCHAR pszExePath[MAX_PATH];
            GetModuleFileName(NULL, pszExePath, sizeof(pszExePath));

            // Set the path to the shortcut target
            psl->SetPath(pszExePath);
            PathRemoveFileSpec(pszExePath);
            psl->SetWorkingDirectory(pszExePath);
            psl->SetShowCmd(SW_SHOWMINNOACTIVE);

            // Query IShellLink for the IPersistFile interface for
            // saving the shortcut in persistent storage.
            IPersistFile* ppf = NULL;
            hres = psl->QueryInterface(IID_IPersistFile,
                                       reinterpret_cast<void**>(&ppf));
            if (SUCCEEDED(hres))
            {
                WCHAR pwsz[MAX_PATH];
                // Ensure that the string is ANSI.
                MultiByteToWideChar(CP_ACP, 0, StartupShortcutPath().c_str(), -1, pwsz, MAX_PATH);
                // Save the link by calling IPersistFile::Save.
                hres = ppf->Save(pwsz, TRUE);
                ppf->Release();
            }
            psl->Release();
        }
        CoUninitialize();
    }
}

#elif defined(__WXGTK__)

// Follow the Desktop Application Autostart Spec:
//  http://standards.freedesktop.org/autostart-spec/autostart-spec-latest.html

boost::filesystem::path GetAutostartDir()
{
    namespace fs = boost::filesystem;

    char* pszConfigHome = getenv("XDG_CONFIG_HOME");
    if (pszConfigHome) return fs::path(pszConfigHome) / fs::path("autostart");
    char* pszHome = getenv("HOME");
    if (pszHome) return fs::path(pszHome) / fs::path(".config/autostart");
    return fs::path();
}

boost::filesystem::path GetAutostartFilePath()
{
    return GetAutostartDir() / boost::filesystem::path("solidcoin.desktop");
}

bool GetStartOnSystemStartup()
{
    boost::filesystem::ifstream optionFile(GetAutostartFilePath());
    if (!optionFile.good())
        return false;
    // Scan through file for "Hidden=true":
    string line;
    while (!optionFile.eof())
    {
        getline(optionFile, line);
        if (line.find("Hidden") != string::npos &&
            line.find("true") != string::npos)
            return false;
    }
    optionFile.close();

    return true;
}

void SetStartOnSystemStartup(bool fAutoStart)
{
    if (!fAutoStart)
    {
        unlink(GetAutostartFilePath().c_str());
    }
    else
    {
        char pszExePath[MAX_PATH+1];
        memset(pszExePath, 0, sizeof(pszExePath));
        if (readlink("/proc/self/exe", pszExePath, sizeof(pszExePath)-1) == -1)
            return;

        boost::filesystem::create_directories(GetAutostartDir());

        boost::filesystem::ofstream optionFile(GetAutostartFilePath(), ios_base::out|ios_base::trunc);
        if (!optionFile.good())
        {
            wxMessageBox(_("Cannot write autostart/solidcoin.desktop file"), "SolidCoin");
            return;
        }
        // Write a solidcoin.desktop file to the autostart directory:
        optionFile << "[Desktop Entry]\n";
        optionFile << "Type=Application\n";
        optionFile << "Name=SolidCoin\n";
        optionFile << "Exec=" << pszExePath << "\n";
        optionFile << "Terminal=false\n";
        optionFile << "Hidden=false\n";
        optionFile.close();
    }
}
#else

// TODO: OSX startup stuff; see:
// http://developer.apple.com/mac/library/documentation/MacOSX/Conceptual/BPSystemStartup/Articles/CustomLogin.html

bool GetStartOnSystemStartup() { return false; }
void SetStartOnSystemStartup(bool fAutoStart) { }

#endif






//////////////////////////////////////////////////////////////////////////////
//
// COptionsDialog
//

COptionsDialog::COptionsDialog(wxWindow* parent) : COptionsDialogBase(parent)
{
    // Set up list box of page choices
    m_listBox->Append(_("Main"));
    m_listBox->Append(_("Timing"));
    m_listBox->Append(_("Mining"));
    m_listBox->SetSelection(0);
    SelectPage(0);
#ifndef __WXMSW__
    SetSize(1.0 * GetSize().GetWidth(), 1.2 * GetSize().GetHeight());
#else
    SetSize(nScaleX * GetSize().GetWidth(), nScaleY * GetSize().GetHeight());
#endif
#if defined(__WXGTK__) || defined(__WXMAC_OSX__)
    m_checkBoxStartOnSystemStartup->SetLabel(_("&Start SolidCoin on window system startup"));
    if (!Setting_GetBOOL("gui_mintotray"))
    {
        // Minimize to tray is just too buggy on Linux
        m_checkBoxMinimizeToTray->SetValue(false);
        m_checkBoxMinimizeToTray->Enable(false);
        m_checkBoxMinimizeOnClose->SetLabel(_("&Minimize on close"));
    }
#endif
#ifdef __WXMAC_OSX__
    m_checkBoxStartOnSystemStartup->Enable(false); // not implemented yet
#endif

    // Init values
    m_checkBoxStartOnSystemStartup->SetValue(GetStartOnSystemStartup());
    //m_checkBoxMinimizeToTray->SetValue(Setting_GetBOOL("gui_mintotray"));
    m_checkBoxMinimizeToTray->SetValue(Setting_GetBOOL("gui_mintotray"));
    m_checkBoxMinimizeOnClose->SetValue(Setting_GetBOOL("gui_minonclose"));

    #ifdef USE_UPNP
    m_checkBoxUseUPnP->SetValue(Setting_GetBOOL("upnp"));
    #else
    m_checkBoxUseUPnP->Enable(false);
    #endif


    bool bUseProxy = Setting_GetBOOL("proxy_use");
    m_checkBoxUseProxy->SetValue(bUseProxy);
    m_textCtrlProxyIP->Enable(bUseProxy);
    m_textCtrlProxyPort->Enable(bUseProxy);
    m_staticTextProxyIP->Enable(bUseProxy);
    m_staticTextProxyPort->Enable(bUseProxy);
    m_textCtrlProxyIP->SetValue(Setting_Get("proxy_address"));
    m_textCtrlProxyPort->SetValue(Setting_Get("proxy_port"));

    m_MiningID->SetValue(Setting_Get("mining_id"));

    int nShareTarget=(int)Setting_GetINT64("mining_sharetarget");
    if(nShareTarget<=32)    m_MiningShareTarget->SetSelection(nShareTarget);
    else                    m_MiningShareTarget->SetSelection(-1);


    bool bDisableNTP=Setting_GetBOOL("time_disablentp");
    m_CBTime_NTP->SetSelection(!bDisableNTP);

    m_Time_NTPServer->SetValue(Setting_Get("time_ntpserver"));
    m_CBTime_SCTime->SetSelection(Setting_GetBOOL("time_solidcoin"));
    m_Time_NTPServer->Enable(!bDisableNTP);
    m_CBTime_SCTime->Enable(!bDisableNTP);


    m_buttonOK->SetFocus();
}

void COptionsDialog::SelectPage(int nPage)
{
    m_panelMain->Show(nPage == 0);
    m_panelTiming->Show(nPage == 1);
    m_panelMining->Show(nPage == 2);

    m_scrolledWindow->Layout();
    m_scrolledWindow->SetScrollbars(0, 0, 0, 0, 0, 0);
}

void COptionsDialog::OnListBox(wxCommandEvent& event)
{
    SelectPage(event.GetSelection());
}

void COptionsDialog::OnKillFocusTransactionFee(wxFocusEvent& event)
{
    event.Skip();
    //int64 nTmp = nTransactionFee;

}

void COptionsDialog::OnCheckBoxUseProxy(wxCommandEvent& event)
{
    m_textCtrlProxyIP->Enable(event.IsChecked());
    m_textCtrlProxyPort->Enable(event.IsChecked());
    m_staticTextProxyIP->Enable(event.IsChecked());
    m_staticTextProxyPort->Enable(event.IsChecked());
}

CAddress COptionsDialog::GetProxyAddr()
{
    // Be careful about byte order, addr.ip and addr.port are big endian
    CAddress addr(m_textCtrlProxyIP->GetValue() + ":" + m_textCtrlProxyPort->GetValue());
    if (addr.ip == INADDR_NONE)
        addr.ip = addrProxy.ip;
    int nPort = atoi(m_textCtrlProxyPort->GetValue());
    addr.port = htons(nPort);
    if (nPort <= 0 || nPort > USHRT_MAX)
        addr.port = addrProxy.port;
    return addr;
}

void COptionsDialog::OnKillFocusProxy(wxFocusEvent& event)
{
    event.Skip();
    m_textCtrlProxyIP->SetValue(GetProxyAddr().ToStringIP());
    m_textCtrlProxyPort->SetValue(GetProxyAddr().ToStringPort());
}


void COptionsDialog::OnButtonOK(wxCommandEvent& event)
{
    OnButtonApply(event);
    EndModal(false);
}

void COptionsDialog::OnButtonCancel(wxCommandEvent& event)
{
    EndModal(false);
}

void COptionsDialog::OnButtonApply(wxCommandEvent& event)
{


    Setting_Set("mining_id",m_MiningID->GetValue().ToStdString());

    int nShareTarget=m_MiningShareTarget->GetSelection();
    if(nShareTarget<=32) Setting_SetINT64("mining_sharetarget",nShareTarget);

    Setting_SetBOOL("gui_minonclose",m_checkBoxMinimizeOnClose->GetValue());
    Setting_SetBOOL("gui_mintotray",m_checkBoxMinimizeToTray->GetValue());
    //Setting_SetBOOL("gui_mintotray",m_checkBoxMinimizeToTray->GetValue());

    #ifdef USE_UPNP
    Setting_SetBOOL("upnp",m_checkBoxUseUPnP->GetValue());
    MapPort(m_checkBoxUseUPnP->GetValue());
    #endif

    SetStartOnSystemStartup(m_checkBoxStartOnSystemStartup->GetValue());


    g_bUseProxy = m_checkBoxUseProxy->GetValue();
    addrProxy = GetProxyAddr();

    Setting_SetBOOL("proxy_use",g_bUseProxy);
    Setting_Set("proxy_address",addrProxy.ToStringIP());
    Setting_Set("proxy_port",addrProxy.ToStringPort());


    extern CCriticalSection g_CS_Time;
    extern bool g_bTimeDisableNTP;
    extern bool g_bUseSolidCoinTime;
    extern std::string g_TimeNTPServer;
    {
        MUTEX_LOCK(g_CS_Time);
        g_bTimeDisableNTP=!((bool)m_CBTime_NTP->GetSelection());
        g_bUseSolidCoinTime=(bool)m_CBTime_SCTime->GetSelection();
        g_TimeNTPServer=m_Time_NTPServer->GetValue().ToStdString();
    }
    Setting_SetBOOL("time_disablentp",g_bTimeDisableNTP);
    Setting_SetBOOL("time_solidcoin",g_bUseSolidCoinTime);
    Setting_Set("time_ntpserver",g_TimeNTPServer);

    m_Time_NTPServer->Enable(!g_bTimeDisableNTP);
    m_CBTime_SCTime->Enable(!g_bTimeDisableNTP);


    {
        extern CCriticalSection cs_getwork;
        extern int64 g_MiningShareTargetInt;
        extern uint256 g_MiningShareTargetHash;
        extern string g_MiningIDString;
        MUTEX_LOCK(cs_getwork);
        g_MiningShareTargetInt = Setting_GetINT64("mining_sharetarget");
        g_MiningIDString = Setting_Get("mining_id");
        if(g_MiningShareTargetInt>0)
        {
            CBigNum bn=g_bnBlockProofOfWorkLimit;
            bn= bn/g_MiningShareTargetInt;
            g_MiningShareTargetHash = bn.getuint256();
        }
    }

    /*
    if (fHaveUPnP && fUseUPnP != m_checkBoxUseUPnP->GetValue())
    {
        fUseUPnP = m_checkBoxUseUPnP->GetValue();
        walletdb.WriteSetting("fUseUPnP", fUseUPnP);

    }

    fUseProxy = m_checkBoxUseProxy->GetValue();
    walletdb.WriteSetting("fUseProxy", fUseProxy);

    addrProxy = GetProxyAddr();
    walletdb.WriteSetting("addrProxy", addrProxy);
    */
}






//////////////////////////////////////////////////////////////////////////////
//
// CAboutDialog
//

CAboutDialog::CAboutDialog(wxWindow* parent) : CAboutDialogBase(parent)
{
    m_staticTextVersion->SetLabel(strprintf(_("version 2.03"), FormatFullVersion().c_str()));

    // Change (c) into UTF-8 or ANSI copyright symbol
    wxString str = m_staticTextMain->GetLabel();
#if wxUSE_UNICODE
    str.Replace("(c)", wxString::FromUTF8("\xC2\xA9"));
#else
    str.Replace("(c)", "\xA9");
#endif
    m_staticTextMain->SetLabel(str);
#ifndef __WXMSW__
    // Resize on Linux to make the window fit the text.
    // The text was wrapped manually rather than using the Wrap setting because
    // the wrap would be too small on Linux and it can't be changed at this point.
    wxFont fontTmp = m_staticTextMain->GetFont();
    if (fontTmp.GetPointSize() > 8);
        fontTmp.SetPointSize(8);
    m_staticTextMain->SetFont(fontTmp);
    //SetSize(GetSize().GetWidth() + 44, GetSize().GetHeight() + 10);
#else
    //SetSize(nScaleX * GetSize().GetWidth(), nScaleY * GetSize().GetHeight());
#endif
    this->SetSizerAndFit( bSizer63 );
}

void CAboutDialog::OnButtonOK(wxCommandEvent& event)
{
    EndModal(false);
}






//////////////////////////////////////////////////////////////////////////////
//
// CSendDialog
//

CSendDialog::CSendDialog(wxWindow* parent, const wxString& strAddress) : CSendDialogBase(parent)
{
    // Init
    m_textCtrlAddress->SetValue(strAddress);
    m_textCtrlAddress->SetFocus();

    //// todo: should add a display of your balance for convenience
#ifndef __WXMSW__
    //wxFont fontTmp = m_staticTextInstructions->GetFont();
    //if (fontTmp.GetPointSize() > 9) fontTmp.SetPointSize(9);
    //m_staticTextInstructions->SetFont(fontTmp);
    //SetSize(725, 180);
#else
    //SetSize(nScaleX * GetSize().GetWidth(), nScaleY * GetSize().GetHeight());
#endif

    // Set Icon
    if (nScaleX == 1.0 && nScaleY == 1.0) // We don't have icons of the proper size otherwise
    {
        wxIcon iconSend;
        iconSend.CopyFromBitmap(wxBitmap(send16noshadow_xpm));
        SetIcon(iconSend);
    }
#ifdef __WXMSW__
    else
        SetIcon(wxICON(solidcoin));
#endif

    {
        LOCK_WALLET_ACCESS();
        m_textCtrlBalance->SetValue(FormatMoney(Wallet_GetSelected()->GetBalance()));
        m_bWasLocked = Wallet_GetSelected()->IsLocked();
        if (!GetWalletPassphrase())
        {
            return;
        }
    }

    m_buttonSend->Enable(false);

    // Fixup the tab order
    m_buttonPaste->MoveAfterInTabOrder(m_buttonCancel);
    m_buttonAddress->MoveAfterInTabOrder(m_buttonPaste);
    this->Layout();
}

void CSendDialog::OnKillFocusAmount(wxFocusEvent& event)
{
    // Reformat the amount
    event.Skip();
    if (m_textCtrlAmount->GetValue().Trim().empty())
        return;
    int64 nTmp;
    if (ParseMoney(m_textCtrlAmount->GetValue(), nTmp))
        m_textCtrlAmount->SetValue(FormatMoney(nTmp));
}

void CSendDialog::OnButtonAddressBook(wxCommandEvent& event)
{
    // Open address book
    CAddressBookDialog dialog(this, m_textCtrlAddress->GetValue(), CAddressBookDialog::SENDING, true);
    if (dialog.ShowModal())
        m_textCtrlAddress->SetValue(dialog.GetSelectedAddress());
}

void CSendDialog::OnButtonPaste(wxCommandEvent& event)
{
    // Copy clipboard to address box
    if (wxTheClipboard->Open())
    {
        if (wxTheClipboard->IsSupported(wxDF_TEXT))
        {
            wxTextDataObject data;
            wxTheClipboard->GetData(data);
            m_textCtrlAddress->SetValue(data.GetText());
        }
        wxTheClipboard->Close();
    }
}

void CSendDialog::OnButtonSend(wxCommandEvent& event)
{

    MUTEX_LOCK(cs_main);
    LOCK_WALLET_ACCESS();

    CWalletTx wtx;
    string strAddress = (string)m_textCtrlAddress->GetValue();

    // Parse amount
    int64 nValue = 0;
    if (!ParseMoney(m_textCtrlAmount->GetValue(), nValue) || nValue <= 0)
    {
        wxMessageBox(_("Error in amount  "), _("Send Coins"));
        return;
    }
    if (nValue > Wallet_GetSelected()->GetBalance())
    {
        wxMessageBox(_("Amount exceeds your balance  "), _("Send Coins"));
        return;
    }
    if (nValue + MIN_TX_FEE > Wallet_GetSelected()->GetBalance())
    {
        wxMessageBox(string(_("Total exceeds your balance when the ")) + FormatMoney(MIN_TX_FEE) + _(" transaction fee is included  "), _("Send Coins"));
        return;
    }

    // Parse solidcoin address
    CSolidCoinAddress address(strAddress);

    // Send to solidcoin address
    CScript scriptPubKey;
    scriptPubKey.SetSolidCoinAddress(address);
    string strError = Wallet_GetSelected()->SendMoney(scriptPubKey, nValue, wtx, 0);
    if (strError == "") wxMessageBox(_("Payment sent  "), _("Sending..."));
    else if (strError == "ABORTED") return; // leave send dialog open
    else
    {
        wxMessageBox(strError + "  ", _("Sending..."));
        CloseSendDialog(0);
        return;
    }

    if (!Wallet_GetSelected()->mapAddressBook.count(address))    Wallet_GetSelected()->SetAddressBookName(strAddress, "");

    CloseSendDialog(1);
}

void CSendDialog::OnButtonCancel(wxCommandEvent& event)
{
     CloseSendDialog(0);
}

void CSendDialog::OnAmountTextUpdate( wxCommandEvent& event )
{
    int64 nFeeAmount=0;

    string strAddress = (string)m_textCtrlAddress->GetValue();
    CSolidCoinAddress address(strAddress);
    bool bSolidCoinAddress = address.IsValid();


    {
        MUTEX_LOCK(cs_main);
        LOCK_WALLET_ACCESS();

        // Parse amount
        int64 nValue = 0;
        if (!ParseMoney(m_textCtrlAmount->GetValue(), nValue) || nValue <= 0)   goto END;
        //if (nValue > Wallet_GetSelected()->GetBalance())    goto END;

        // Send to solidcoin address
        if(Wallet_GetSelected()->GetFees(nValue,nFeeAmount))
        {
            m_textCtrlFee->SetValue(FormatMoney(nFeeAmount));
            m_textCtrlTotal->SetValue(FormatMoney(nFeeAmount+nValue));
            m_textCtrlBalance->SetValue(FormatMoney(Wallet_GetSelected()->GetBalance()-(nFeeAmount+nValue) ));
            if(bSolidCoinAddress)   m_buttonSend->Enable(true);
            else                    m_buttonSend->Enable(false);

            return;
        }
    }
END:
    m_buttonSend->Enable(false);
    m_textCtrlFee->SetValue("Invalid Amount");
    m_textCtrlBalance->SetValue(FormatMoney(Wallet_GetSelected()->GetBalance()));
    m_textCtrlTotal->SetValue("");
    return;

}


void CSendDialog::CloseSendDialog(int nID)
{
    if(m_bWasLocked)    Wallet_GetSelected()->Lock();
    EndModal(nID);
}






//////////////////////////////////////////////////////////////////////////////
//
// CSendingDialog
//

CSendingDialog::CSendingDialog(wxWindow* parent, const CAddress& addrIn, int64 nPriceIn, const CWalletTx& wtxIn) : CSendingDialogBase(NULL) // we have to give null so parent can't destroy us
{
    addr = addrIn;
    nPrice = nPriceIn;
    wtx = wtxIn;
    start = wxDateTime::UNow();
    memset(pszStatus, 0, sizeof(pszStatus));
    fCanCancel = true;
    fAbort = false;
    fSuccess = false;
    fUIDone = false;
    fWorkDone = false;
#ifndef __WXMSW__
    SetSize(1.2 * GetSize().GetWidth(), 1.08 * GetSize().GetHeight());
#else
    SetSize(nScaleX * GetSize().GetWidth(), nScaleY * GetSize().GetHeight());
#endif

    SetTitle(strprintf(_("Sending %s to %s"), FormatMoney(nPrice).c_str(), wtx.mapValue["to"].c_str()));
    m_textCtrlStatus->SetValue("");

    CreateThread(SendingDialogStartTransfer, this);
}

CSendingDialog::~CSendingDialog()
{
    debugprintf(INFO, "~CSendingDialog()\n");
}

void CSendingDialog::Close()
{
    // Last one out turn out the lights.
    // fWorkDone signals that work side is done and UI thread should call destroy.
    // fUIDone signals that UI window has closed and work thread should call destroy.
    // This allows the window to disappear and end modality when cancelled
    // without making the user wait for ConnectNode to return.  The dialog object
    // hangs around in the background until the work thread exits.
    if (IsModal())
        EndModal(fSuccess);
    else
        Show(false);
    if (fWorkDone)
        Destroy();
    else
        fUIDone = true;
}



void CSendingDialog::OnClose(wxCloseEvent& event)
{
    if (!event.CanVeto() || fWorkDone || fAbort || !fCanCancel)
    {
        Close();
    }
    else
    {
        event.Veto();
        wxCommandEvent cmdevent;
        OnButtonCancel(cmdevent);
    }
}

void CSendingDialog::OnButtonOK(wxCommandEvent& event)
{
    if (fWorkDone)
        Close();
}

void CSendingDialog::OnButtonCancel(wxCommandEvent& event)
{
    if (fCanCancel)
        fAbort = true;
}

void CSendingDialog::OnPaint(wxPaintEvent& event)
{
    event.Skip();
    if (strlen(pszStatus) > 130)
        m_textCtrlStatus->SetValue(string("\n") + pszStatus);
    else
        m_textCtrlStatus->SetValue(string("\n\n") + pszStatus);
    m_staticTextSending->SetFocus();
    if (!fCanCancel)
        m_buttonCancel->Enable(false);
    if (fWorkDone)
    {
        m_buttonOK->Enable(true);
        m_buttonOK->SetFocus();
        m_buttonCancel->Enable(false);
    }
    if (fAbort && fCanCancel && IsShown())
    {
        strcpy(pszStatus, _("CANCELLED"));
        m_buttonOK->Enable(true);
        m_buttonOK->SetFocus();
        m_buttonCancel->Enable(false);
        m_buttonCancel->SetLabel(_("Cancelled"));
        Close();
        wxMessageBox(_("Transfer cancelled  "), _("Sending..."), wxOK, this);
    }
}


//
// Everything from here on is not in the UI thread and must only communicate
// with the rest of the dialog through variables and calling repaint.
//

void CSendingDialog::Repaint()
{
    Refresh();
    wxPaintEvent event;
    GetEventHandler()->AddPendingEvent(event);
}

bool CSendingDialog::Status()
{
    if (fUIDone)
    {
        Destroy();
        return false;
    }
    if (fAbort && fCanCancel)
    {
        memset(pszStatus, 0, 10);
        strcpy(pszStatus, _("CANCELLED"));
        Repaint();
        fWorkDone = true;
        return false;
    }
    return true;
}

bool CSendingDialog::Status(const string& str)
{
    if (!Status())
        return false;

    // This can be read by the UI thread at any time,
    // so copy in a way that can be read cleanly at all times.
    memset(pszStatus, 0, min(str.size()+1, sizeof(pszStatus)));
    strlcpy(pszStatus, str.c_str(), sizeof(pszStatus));

    Repaint();
    return true;
}

bool CSendingDialog::Error(const string& str)
{
    fCanCancel = false;
    fWorkDone = true;
    Status(string(_("Error: ")) + str);
    return false;
}

void SendingDialogStartTransfer(void* parg)
{
    ((CSendingDialog*)parg)->StartTransfer();
}

void CSendingDialog::StartTransfer()
{
    LOCK_WALLET_ACCESS();
    // Make sure we have enough money
    if (nPrice + MIN_TX_FEE > Wallet_GetSelected()->GetBalance())
    {
        Error(_("Insufficient funds"));
        return;
    }

    // We may have connected already for product details
    if (!Status(_("Connecting...")))
        return;
    CNode* pnode = ConnectNode(addr, 15 * 60);
    if (!pnode)
    {
        Error(_("Unable to connect"));
        return;
    }

    // Send order to seller, with response going to OnReply2 via event handler
    if (!Status(_("Requesting public key...")))
        return;
    pnode->PushRequest("checkorder", wtx, SendingDialogOnReply2, this);
}

void SendingDialogOnReply2(void* parg, CDataStream& vRecv)
{
    ((CSendingDialog*)parg)->OnReply2(vRecv);
}

void CSendingDialog::OnReply2(CDataStream& vRecv)
{
    if (!Status(_("Received public key...")))
        return;

    CScript scriptPubKey;
    int nRet;
    try
    {
        vRecv >> nRet;
        if (nRet > 0)
        {
            string strMessage;
            if (!vRecv.empty())
                vRecv >> strMessage;
            if (nRet == 2)
                Error(_("Recipient is not accepting transactions sent by IP address"));
            else
                Error(_("Transfer was not accepted"));
            //// todo: enlarge the window and enable a hidden white box to put seller's message
            return;
        }
        vRecv >> scriptPubKey;
    }
    catch (...)
    {
        //// what do we want to do about this?
        Error(_("Invalid response received"));
        return;
    }

    // Pause to give the user a chance to cancel
    while (wxDateTime::UNow() < start + wxTimeSpan(0, 0, 0, 2 * 1000))
    {
        Sleep(200);
        if (!Status())
            return;
    }


    {
        MUTEX_LOCK(cs_main);
        LOCK_WALLET_ACCESS();

        if (!Status(_("Creating transaction...")))
            return;
        if (nPrice + MIN_TX_FEE > Wallet_GetSelected()->GetBalance())
        {
            Error(_("Insufficient funds"));
            return;
        }

        CReserveKey reservekey;
        reservekey.SetWallet(Wallet_GetSelected());
        int64 nFeeRequired;
        {
            bool fWasLocked = Wallet_GetSelected()->IsLocked();
            if (!GetWalletPassphrase())
                return;

            if (!Wallet_GetSelected()->CreateTransaction(scriptPubKey, nPrice, wtx, reservekey, nFeeRequired))
            {
                if (nPrice + nFeeRequired > Wallet_GetSelected()->GetBalance())
                    Error(strprintf(_("This transaction requires a transaction fee of at least %s because of its amount, complexity, or use of recently received funds"), FormatMoney(nFeeRequired).c_str()));
                else
                    Error(_("Transaction creation failed"));
                return;
            }

            if (fWasLocked)
                Wallet_GetSelected()->Lock();
       }

        // Transaction fee
        if (!ThreadSafeAskFee(nFeeRequired, _("Sending..."), this))
        {
            Error(_("Transaction aborted"));
            return;
        }

        // Make sure we're still connected
        CNode* pnode = ConnectNode(addr, 2 * 60 * 60);
        if (!pnode)
        {
            Error(_("Lost connection, transaction cancelled"));
            return;
        }

        // Last chance to cancel
        Sleep(50);
        if (!Status())
            return;
        fCanCancel = false;
        if (fAbort)
        {
            fCanCancel = true;
            if (!Status())
                return;
            fCanCancel = false;
        }
        if (!Status(_("Sending payment...")))
            return;

        // Commit
        if (!Wallet_GetSelected()->CommitTransaction(wtx, reservekey))
        {
            Error(_("The transaction was rejected.  This might happen if some of the coins in your wallet were already spent, such as if you used a copy of wallet.dat and coins were spent in the copy but not marked as spent here."));
            return;
        }

        // Send payment tx to seller, with response going to OnReply3 via event handler
        CWalletTx wtxSend = wtx;
        wtxSend.fFromMe = false;
        pnode->PushRequest("submitorder", wtxSend, SendingDialogOnReply3, this);

        Status(_("Waiting for confirmation..."));
        MainFrameRepaint();
    }
}

void SendingDialogOnReply3(void* parg, CDataStream& vRecv)
{
    ((CSendingDialog*)parg)->OnReply3(vRecv);
}

void CSendingDialog::OnReply3(CDataStream& vRecv)
{
    int nRet;
    try
    {
        vRecv >> nRet;
        if (nRet > 0)
        {
            Error(_("The payment was sent, but the recipient was unable to verify it.\n"
                    "The transaction is recorded and will credit to the recipient,\n"
                    "but the comment information will be blank."));
            return;
        }
    }
    catch (...)
    {
        //// what do we want to do about this?
        Error(_("Payment was sent, but an invalid response was received"));
        return;
    }

    fSuccess = true;
    fWorkDone = true;
    Status(_("Payment completed"));
}






//////////////////////////////////////////////////////////////////////////////
//
// CAddressBookDialog
//

CAddressBookDialog::CAddressBookDialog(wxWindow* parent, const wxString& strInitSelected, int nPageIn, bool fDuringSendIn) : CAddressBookDialogBase(parent)
{
#ifdef __WXMSW__
    SetSize(nScaleX * GetSize().GetWidth(), (nScaleY * GetSize().GetHeight()) );
#endif

    // Set initially selected page
    wxNotebookEvent event;
    event.SetSelection(nPageIn);
    OnNotebookPageChanged(event);
    m_notebook->ChangeSelection(nPageIn);

    fDuringSend = fDuringSendIn;
    if (!fDuringSend)
        m_buttonCancel->Show(false);

    // Set Icon
    if (nScaleX == 1.0 && nScaleY == 1.0) // We don't have icons of the proper size otherwise
    {
        //wxIcon iconAddressBook;
        //iconAddressBook.CopyFromBitmap(wxBitmap(addressbook16_xpm));
        //SetIcon(wxIcon(addressbook16_xpm));
    }
#ifdef __WXMSW__
    else
        SetIcon(wxICON(solidcoin));
#endif

    // Init column headers
    m_listCtrlSending->InsertColumn(0, _("Name"), wxLIST_FORMAT_LEFT, 200);
    m_listCtrlSending->InsertColumn(1, _("Address"), wxLIST_FORMAT_LEFT, 350);
    m_listCtrlSending->SetFocus();
    m_listCtrlReceiving->InsertColumn(0, _("Label"), wxLIST_FORMAT_LEFT, 200);
    m_listCtrlReceiving->InsertColumn(1, _("SolidCoin Address"), wxLIST_FORMAT_LEFT, 350);
    m_listCtrlReceiving->SetFocus();

    // Fill listctrl with address book data
    LOCK_WALLET_ACCESS();

    SetTitle(Wallet_GetSelected()->GetWalletName()+" Address Book");
    {
        //string strDefaultReceiving = (string)pframeMain->m_textCtrlAddress->GetValue();
        BOOST_FOREACH(const PAIRTYPE(CSolidCoinAddress, string)& item, Wallet_GetSelected()->mapAddressBook)
        {
            const CSolidCoinAddress& address = item.first;
            string strName = item.second;
            bool fMine = Wallet_GetSelected()->HaveKey(address);
            wxListCtrl* plistCtrl = fMine ? m_listCtrlReceiving : m_listCtrlSending;
            int nIndex = InsertLine(plistCtrl, strName, address.ToString());
            //if (address.ToString() == (fMine ? strDefaultReceiving : string(strInitSelected)))
              //  plistCtrl->SetItemState(nIndex, wxLIST_STATE_SELECTED|wxLIST_STATE_FOCUSED, wxLIST_STATE_SELECTED|wxLIST_STATE_FOCUSED);
        }
    }
}

wxString CAddressBookDialog::GetSelectedAddress()
{
    int nIndex = GetSelection(m_listCtrl);
    if (nIndex == -1)
        return "";
    return GetItemText(m_listCtrl, nIndex, 1);
}

wxString CAddressBookDialog::GetSelectedSendingAddress()
{
    int nIndex = GetSelection(m_listCtrlSending);
    if (nIndex == -1)
        return "";
    return GetItemText(m_listCtrlSending, nIndex, 1);
}

wxString CAddressBookDialog::GetSelectedReceivingAddress()
{
    int nIndex = GetSelection(m_listCtrlReceiving);
    if (nIndex == -1)
        return "";
    return GetItemText(m_listCtrlReceiving, nIndex, 1);
}

void CAddressBookDialog::OnNotebookPageChanged(wxNotebookEvent& event)
{
    event.Skip();
    nPage = event.GetSelection();
    if (nPage == SENDING)
        m_listCtrl = m_listCtrlSending;
    else if (nPage == RECEIVING)
        m_listCtrl = m_listCtrlReceiving;
    m_buttonDelete->Show(nPage == SENDING);
    m_buttonCopy->Show(nPage == RECEIVING);
    this->Layout();
    m_listCtrl->SetFocus();
}

void CAddressBookDialog::OnListEndLabelEdit(wxListEvent& event)
{
    // Update address book with edited name
    event.Skip();
    if (event.IsEditCancelled())
        return;
    string strAddress = (string)GetItemText(m_listCtrl, event.GetIndex(), 1);

    LOCK_WALLET_ACCESS();
     Wallet_GetSelected()->SetAddressBookName(strAddress, string(event.GetText()));
    pframeMain->RefreshListCtrl();
}

void CAddressBookDialog::OnListItemSelected(wxListEvent& event)
{
    event.Skip();
    return;
}

void CAddressBookDialog::OnListItemActivated(wxListEvent& event)
{
    event.Skip();
    if (fDuringSend)
    {
        // Doubleclick returns selection
        EndModal(GetSelectedAddress() != "" ? 2 : 0);
        return;
    }

    // Doubleclick edits item
    wxCommandEvent event2;
    OnButtonEdit(event2);
}

void CAddressBookDialog::OnButtonDelete(wxCommandEvent& event)
{
    if (nPage != SENDING)
        return;
    for (int nIndex = m_listCtrl->GetItemCount()-1; nIndex >= 0; nIndex--)
    {
        if (m_listCtrl->GetItemState(nIndex, wxLIST_STATE_SELECTED))
        {
            string strAddress = (string)GetItemText(m_listCtrl, nIndex, 1);
            LOCK_WALLET_ACCESS();
            Wallet_GetSelected()->DelAddressBookName(strAddress);
            m_listCtrl->DeleteItem(nIndex);
        }
    }
    pframeMain->RefreshListCtrl();
}

void CAddressBookDialog::OnButtonCopy(wxCommandEvent& event)
{
    // Copy address box to clipboard
    if (wxTheClipboard->Open())
    {
        wxTheClipboard->SetData(new wxTextDataObject(GetSelectedAddress()));
        wxTheClipboard->Close();
    }
}

bool CAddressBookDialog::CheckIfMine(const string& strAddress, const string& strTitle)
{
    LOCK_WALLET_ACCESS();
    CSolidCoinAddress address(strAddress);
    bool fMine = address.IsValid() && Wallet_GetSelected()->HaveKey(address);
    if (fMine)
        wxMessageBox(_("This is one of your own addresses for receiving payments and cannot be entered in the address book.  "), strTitle);
    return fMine;
}

void CAddressBookDialog::OnButtonEdit(wxCommandEvent& event)
{
    int nIndex = GetSelection(m_listCtrl);
    if (nIndex == -1)
        return;
    string strName = (string)m_listCtrl->GetItemText(nIndex);
    string strAddress = (string)GetItemText(m_listCtrl, nIndex, 1);
    string strAddressOrg = strAddress;

    if (nPage == SENDING)
    {
        // Ask name and address
        do
        {
            CGetTextFromUserDialog dialog(this, _("Edit Address"), _("Name"), strName, _("Address"), strAddress);
            if (!dialog.ShowModal())
                return;
            strName = dialog.GetValue1();
            strAddress = dialog.GetValue2();
        }
        while (CheckIfMine(strAddress, _("Edit Address")));

    }
    else if (nPage == RECEIVING)
    {
        // Ask name
        CGetTextFromUserDialog dialog(this, _("Edit Address Label"), _("Label"), strName);
        if (!dialog.ShowModal())
            return;
        strName = dialog.GetValue();
    }

    // Write back
    LOCK_WALLET_ACCESS();
    {
        if (strAddress != strAddressOrg)
            Wallet_GetSelected()->DelAddressBookName(strAddressOrg);
        Wallet_GetSelected()->SetAddressBookName(strAddress, strName);
    }
    m_listCtrl->SetItem(nIndex, 1, strAddress);
    m_listCtrl->SetItemText(nIndex, strName);
    pframeMain->RefreshListCtrl();
}

void CAddressBookDialog::OnButtonNew(wxCommandEvent& event)
{
    string strName;
    string strAddress;

    LOCK_WALLET_ACCESS();

    if (nPage == SENDING)
    {
        // Ask name and address
        do
        {
            CGetTextFromUserDialog dialog(this, _("Add Address"), _("Name"), strName, _("Address"), strAddress);
            if (!dialog.ShowModal())
                return;
            strName = dialog.GetValue1();
            strAddress = dialog.GetValue2();
        }
        while (CheckIfMine(strAddress, _("Add Address")));
    }
    else if (nPage == RECEIVING)
    {
        // Ask name
        CGetTextFromUserDialog dialog(this,
            _("New Receiving Address"),
            _("You should use a new address for each payment you receive.\n\nLabel"),
            "");
        if (!dialog.ShowModal())
            return;
        strName = dialog.GetValue();


        {
            bool fWasLocked = Wallet_GetSelected()->IsLocked();
            if (!GetWalletPassphrase())
                return;

            // Generate new key
            _REGEN:
            strAddress = CSolidCoinAddress(Wallet_GetSelected()->GetOrReuseKeyFromPool()).ToString();
            if(!fTestNet && strAddress[0]!='s')  goto _REGEN;    //ensure we have an 's'

            if (fWasLocked)
                Wallet_GetSelected()->Lock();
        }
    }

    // Add to list and select it
    Wallet_GetSelected()->SetAddressBookName(strAddress, strName);
    int nIndex = InsertLine(m_listCtrl, strName, strAddress);
    SetSelection(m_listCtrl, nIndex);
    m_listCtrl->SetFocus();
    if (nPage == SENDING)
        pframeMain->RefreshListCtrl();
}

void CAddressBookDialog::OnButtonOK(wxCommandEvent& event)
{
    // OK
    EndModal(GetSelectedAddress() != "" ? 1 : 0);
}

void CAddressBookDialog::OnButtonCancel(wxCommandEvent& event)
{
    // Cancel
    EndModal(0);
}

void CAddressBookDialog::OnClose(wxCloseEvent& event)
{
    // Close
    EndModal(0);
}






//////////////////////////////////////////////////////////////////////////////
//
// CMyTaskBarIcon
//

enum
{
    ID_TASKBAR_RESTORE = 10001,
    ID_TASKBAR_SEND,
    ID_TASKBAR_OPTIONS,
    ID_TASKBAR_GENERATE,
    ID_TASKBAR_EXIT,
};

BEGIN_EVENT_TABLE(CMyTaskBarIcon, wxTaskBarIcon)
    EVT_TASKBAR_LEFT_DCLICK(CMyTaskBarIcon::OnLeftButtonDClick)
    EVT_MENU(ID_TASKBAR_RESTORE, CMyTaskBarIcon::OnMenuRestore)
    EVT_MENU(ID_TASKBAR_SEND, CMyTaskBarIcon::OnMenuSend)
    EVT_MENU(ID_TASKBAR_OPTIONS, CMyTaskBarIcon::OnMenuOptions)
    EVT_MENU(ID_TASKBAR_EXIT, CMyTaskBarIcon::OnMenuExit)
END_EVENT_TABLE()

void CMyTaskBarIcon::Show(bool fShow)
{
    static char pszPrevTip[200];
    if (fShow)
    {
        string strTooltip = _("SolidCoin v2.03\r\n");
        int nItem = 0;
        for(int nPool=0;nPool<g_MiningPoolList.size();nPool++)
        {
            MINING_POOL* pPool= &g_MiningPoolList[nPool];
            if(pPool->nRunning)
            {
                strTooltip += pPool->name + ": ";
                strTooltip += str(boost::format("%.02f KH/s") % (pPool->qLastHashPerSec/1000.0) );
                strTooltip += "\r\n";
            }
        }

        // Optimization, only update when changed, using char array to be reentrant
        if (strncmp(pszPrevTip, strTooltip.c_str(), sizeof(pszPrevTip)-1) != 0)
        {
            strlcpy(pszPrevTip, strTooltip.c_str(), sizeof(pszPrevTip));
#ifdef __WXMSW__
            // somehow it'll choose the wrong size and scale it down if
            // we use the main icon, so we hand it one with only 16x16
            SetIcon(wxICON(favicon), strTooltip);
#else
            wxIcon mainicon;
            mainicon.CopyFromBitmap(wxBitmap(solidcoin80_xpm));
            SetIcon(mainicon, strTooltip);
#endif
        }
    }
    else
    {
        strlcpy(pszPrevTip, "", sizeof(pszPrevTip));
        RemoveIcon();
    }
}

void CMyTaskBarIcon::Hide()
{
    Show(false);
}

void CMyTaskBarIcon::OnLeftButtonDClick(wxTaskBarIconEvent& event)
{
    Restore();
}

void CMyTaskBarIcon::OnMenuRestore(wxCommandEvent& event)
{
    Restore();
}

void CMyTaskBarIcon::OnMenuSend(wxCommandEvent& event)
{
    // Taskbar: Send
    CSendDialog dialog(pframeMain);
    dialog.ShowModal();
}

void CMyTaskBarIcon::OnMenuOptions(wxCommandEvent& event)
{
    // Since it's modal, get the main window to do it
    wxCommandEvent event2(wxEVT_COMMAND_MENU_SELECTED, wxID_PREFERENCES);
    pframeMain->GetEventHandler()->AddPendingEvent(event2);
}

void CMyTaskBarIcon::Restore()
{
    pframeMain->Show();
    wxIconizeEvent event(0, false);
    pframeMain->GetEventHandler()->AddPendingEvent(event);
    pframeMain->Iconize(false);
    pframeMain->Raise();
}


void CMyTaskBarIcon::OnMenuExit(wxCommandEvent& event)
{
    pframeMain->Close(true);
}

void CMyTaskBarIcon::UpdateTooltip()
{
    if (IsIconInstalled())
        Show(true);
}

wxMenu* CMyTaskBarIcon::CreatePopupMenu()
{
    wxMenu* pmenu = new wxMenu;
    pmenu->Append(ID_TASKBAR_RESTORE, _("&Open SolidCoin"));
    pmenu->Append(ID_TASKBAR_SEND, _("&Send SolidCoins"));
    pmenu->Append(ID_TASKBAR_OPTIONS, _("O&ptions..."));
#ifndef __WXMAC_OSX__ // Mac has built-in quit menu
    pmenu->AppendSeparator();
    pmenu->Append(ID_TASKBAR_EXIT, _("E&xit"));
#endif
    return pmenu;
}






//////////////////////////////////////////////////////////////////////////////
//
// CMyApp
//

void CreateMainWindow()
{
    pframeMain = new CMainFrame(NULL);
    if (Setting_GetBOOL("gui_startminimized"))
        pframeMain->Iconize(true);
#if defined(__WXGTK__) || defined(__WXMAC_OSX__)
    //if (!Setting_GetBOOL("gui_mintotray")) fMinimizeToTray = false;
#endif
    pframeMain->Show(true);  // have to show first to get taskbar button to hide
    if (Setting_GetBOOL("gui_mintotray") && pframeMain->IsIconized())    fClosedToTray = true;
    pframeMain->Show(!fClosedToTray);
    //ptaskbaricon->Show(Setting_GetBOOL("gui_mintotray") || fClosedToTray);
    ptaskbaricon->Show(true);
    //CreateThread(ThreadDelayedRepaint, NULL);
}


// Define a new application
class CMyApp : public wxApp
{
public:
    CMyApp(){};
    ~CMyApp(){};
    bool OnInit();
    bool OnInit2();
    int OnExit();

    // Hook Initialize so we can start without GUI
    virtual bool Initialize(int& argc, wxChar** argv);

    // 2nd-level exception handling: we get all the exceptions occurring in any
    // event handler here
    virtual bool OnExceptionInMainLoop();

    // 3rd, and final, level exception handling: whenever an unhandled
    // exception is caught, this function is called
    virtual void OnUnhandledException();

    // and now for something different: this function is called in case of a
    // crash (e.g. dereferencing null pointer, division by 0, ...)
    virtual void OnFatalException();
};

IMPLEMENT_APP(CMyApp)

bool CMyApp::Initialize(int& argc, wxChar** argv)
{
    for (int i = 1; i < argc; i++)
        if (!IsSwitchChar(argv[i][0]))
            fCommandLine = true;

    if (!fCommandLine)
    {
        // wxApp::Initialize will remove environment-specific parameters,
        // so it's too early to call ParseParameters yet
        for (int i = 1; i < argc; i++)
        {
            wxString str = argv[i];
            if (str == "-daemon")
                fDaemon = true;
        }
    }

#ifdef __WXGTK__
    if (fDaemon || fCommandLine)
    {
        // Call the original Initialize while suppressing error messages
        // and ignoring failure.  If unable to initialize GTK, it fails
        // near the end so hopefully the last few things don't matter.
        {
            wxLogNull logNo;
            wxApp::Initialize(argc, argv);
        }

        if (fDaemon)
        {
            // Daemonize
            pid_t pid = fork();
            if (pid < 0)
            {
                fprintf(stderr, "Error: fork() returned %d errno %d\n", pid, errno);
                return false;
            }
            if (pid > 0)
                pthread_exit((void*)0);

            pid_t sid = setsid();
            if (sid < 0)
                fprintf(stderr, "Error: setsid() returned %d errno %d\n", sid, errno);
        }

        return true;
    }
#endif

    return wxApp::Initialize(argc, argv);
}

bool CMyApp::OnInit()
{
    wxImage::AddHandler(new wxPNGHandler);
#if defined(__WXMSW__) && defined(__WXDEBUG__) && defined(GUI)
    // Disable malfunctioning wxWidgets debug assertion
    extern int g_isPainting;
    g_isPainting = 10000;
#endif
#if defined(__WXMSW__ ) || defined(__WXMAC_OSX__)
    SetAppName("SolidCoin");
#else
    SetAppName("solidcoin");
#endif
#ifdef __WXMSW__
#if wxUSE_UNICODE
    // Hack to set wxConvLibc codepage to UTF-8 on Windows,
    // may break if wxMBConv_win32 implementation in strconv.cpp changes.
    class wxMBConv_win32 : public wxMBConv
    {
    public:
        long m_CodePage;
        size_t m_minMBCharWidth;
    };
    if (((wxMBConv_win32*)&wxConvLibc)->m_CodePage == CP_ACP)
        ((wxMBConv_win32*)&wxConvLibc)->m_CodePage = CP_UTF8;
#endif
#endif

    // Load locale/<lang>/LC_MESSAGES/solidcoin.mo language file
    g_locale.Init(wxLANGUAGE_DEFAULT, 0);
    g_locale.AddCatalogLookupPathPrefix("locale");
#ifndef __WXMSW__
    g_locale.AddCatalogLookupPathPrefix("/usr/share/locale");
    g_locale.AddCatalogLookupPathPrefix("/usr/local/share/locale");
#endif
    g_locale.AddCatalog("wxstd"); // wxWidgets standard translations, if any
    g_locale.AddCatalog("solidcoin");

#ifdef __WXMSW__
    HDC hdc = GetDC(NULL);
    if (hdc)
    {
        nScaleX = GetDeviceCaps(hdc, LOGPIXELSX) / 96.0;
        nScaleY = GetDeviceCaps(hdc, LOGPIXELSY) / 96.0;
        ReleaseDC(NULL, hdc);
    }
#endif

    std::string *str=0;
    if(argc)
    {
        str = new std::string[argc];
        for(int i=0;i<argc;i++) str[i]=argv[i].ToStdString();
    }
    bool bRet=AppInit(argc, str);
    delete[] str;
    return bRet;
}

int CMyApp::OnExit()
{
    Shutdown(NULL);
    return wxApp::OnExit();
}

bool CMyApp::OnExceptionInMainLoop()
{
    try
    {
        throw;
    }
    catch (std::exception& e)
    {
        PrintException(&e, "CMyApp::OnExceptionInMainLoop()");
        wxLogWarning("Exception %s %s", typeid(e).name(), e.what());
        Sleep(1000);
        throw;
    }
    catch (...)
    {
        PrintException(NULL, "CMyApp::OnExceptionInMainLoop()");
        wxLogWarning("Unknown exception");
        Sleep(1000);
        throw;
    }
    return true;
}

void CMyApp::OnUnhandledException()
{
    // this shows how we may let some exception propagate uncaught
    try
    {
        throw;
    }
    catch (std::exception& e)
    {
        PrintException(&e, "CMyApp::OnUnhandledException()");
        wxLogWarning("Exception %s %s", typeid(e).name(), e.what());
        Sleep(1000);
        throw;
    }
    catch (...)
    {
        PrintException(NULL, "CMyApp::OnUnhandledException()");
        wxLogWarning("Unknown exception");
        Sleep(1000);
        throw;
    }
}

void CMyApp::OnFatalException()
{
    wxMessageBox(_("Program has crashed and will terminate.  "), "SolidCoin", wxOK | wxICON_ERROR);
}
#endif
