/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;

public class EllipseDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintEllipse ellipse = (JRPrintEllipse)element;
        if (ellipse.getMode() == 1) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX() + offsetX, ellipse.getY() + offsetY, ellipse.getWidth(), ellipse.getHeight());
        }
        grx.setColor(ellipse.getLinePen().getLineColor());
        Stroke stroke = EllipseDrawer.getStroke(ellipse.getLinePen(), 2);
        if (stroke != null) {
            grx.setStroke(stroke);
            if (ellipse.getLinePen().getLineStyle() == 3) {
                float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
                AffineTransform oldTx = grx.getTransform();
                grx.translate((float)(ellipse.getX() + offsetX) - lineWidth / 3.0f, (float)(ellipse.getY() + offsetY) - lineWidth / 3.0f);
                grx.scale(((float)element.getWidth() + 2.0f * lineWidth / 3.0f) / (float)element.getWidth(), ((float)element.getHeight() + 2.0f * lineWidth / 3.0f) / (float)element.getHeight());
                grx.drawOval(0, 0, ellipse.getWidth(), ellipse.getHeight());
                grx.setTransform(oldTx);
                grx.translate((float)(ellipse.getX() + offsetX) + lineWidth / 3.0f, (float)(ellipse.getY() + offsetY) + lineWidth / 3.0f);
                grx.scale(((float)element.getWidth() - 2.0f * lineWidth / 3.0f) / (float)element.getWidth(), ((float)element.getHeight() - 2.0f * lineWidth / 3.0f) / (float)element.getHeight());
                grx.drawOval(0, 0, ellipse.getWidth(), ellipse.getHeight());
                grx.setTransform(oldTx);
            } else {
                grx.drawOval(ellipse.getX() + offsetX, ellipse.getY() + offsetY, ellipse.getWidth(), ellipse.getHeight());
            }
        }
    }
}

