/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class SchemaGenerator {
    private static final Localizer _loc = Localizer.forPackage(SchemaGenerator.class);
    private final DataSource _ds;
    private final DBDictionary _dict;
    private final Log _log;
    private final Object[][] _allowed;
    private boolean _indexes = true;
    private boolean _fks = true;
    private boolean _pks = true;
    private boolean _seqs = true;
    private boolean _openjpaTables = true;
    private SchemaGroup _group = null;
    private List _listeners = null;
    private int _schemaObjects = 0;

    public SchemaGenerator(JDBCConfiguration conf) {
        this._ds = conf.getDataSource2(null);
        this._log = conf.getLog("openjpa.jdbc.Schema");
        this._dict = conf.getDBDictionaryInstance();
        this._allowed = SchemaGenerator.parseSchemasList(conf.getSchemasList());
    }

    private static Object[][] parseSchemasList(String[] args) {
        Collection<String> tables;
        if (args == null || args.length == 0) {
            return null;
        }
        HashMap<String, LinkedList<String>> schemas = new HashMap<String, LinkedList<String>>();
        for (int i = 0; i < args.length; ++i) {
            String table;
            String schema;
            int dotIdx = args[i].indexOf(46);
            if (dotIdx == -1) {
                schema = args[i];
                table = null;
            } else if (dotIdx == 0) {
                schema = null;
                table = args[i].substring(1);
            } else {
                schema = args[i].substring(0, dotIdx);
                table = args[i].substring(dotIdx + 1);
            }
            if (table == null && !schemas.containsKey(schema)) {
                schemas.put(schema, null);
                continue;
            }
            if (table == null) continue;
            tables = (Collection)schemas.get(schema);
            if (tables == null) {
                tables = new LinkedList<String>();
                schemas.put(schema, (LinkedList<String>)tables);
            }
            tables.add(table);
        }
        Object[][] parsed = new Object[schemas.size()][2];
        int idx = 0;
        Iterator itr = schemas.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            tables = (LinkedList<String>)entry.getValue();
            parsed[idx][0] = entry.getKey();
            if (tables != null) {
                parsed[idx][1] = tables.toArray(new String[tables.size()]);
            }
            ++idx;
        }
        return parsed;
    }

    public boolean getIndexes() {
        return this._indexes;
    }

    public void setIndexes(boolean indexes) {
        this._indexes = indexes;
    }

    public boolean getForeignKeys() {
        return this._fks;
    }

    public void setForeignKeys(boolean fks) {
        this._fks = fks;
    }

    public boolean getPrimaryKeys() {
        return this._pks;
    }

    public void setPrimaryKeys(boolean pks) {
        this._pks = pks;
    }

    public boolean getSequences() {
        return this._seqs;
    }

    public void setSequences(boolean seqs) {
        this._seqs = seqs;
    }

    public boolean getOpenJPATables() {
        return this._openjpaTables;
    }

    public void setOpenJPATables(boolean openjpaTables) {
        this._openjpaTables = openjpaTables;
    }

    public SchemaGroup getSchemaGroup() {
        if (this._group == null) {
            this._group = new SchemaGroup();
        }
        return this._group;
    }

    public void setSchemaGroup(SchemaGroup group) {
        this._group = group;
    }

    public void generateSchemas() throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-schemas"));
        this.generateSchemas(null);
    }

    public void generateSchemas(String[] schemasAndTables) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-schemas"));
        Object[][] schemaMap = schemasAndTables == null || schemasAndTables.length == 0 ? this._allowed : SchemaGenerator.parseSchemasList(schemasAndTables);
        if (schemaMap == null) {
            this.generateSchema(null, null);
            int numTables = this.getTables(null).size();
            this._schemaObjects += numTables + (this._pks ? numTables : 0) + (this._indexes ? numTables : 0) + (this._fks ? numTables : 0);
            if (this._pks) {
                this.generatePrimaryKeys(null, null);
            }
            if (this._indexes) {
                this.generateIndexes(null, null);
            }
            if (this._fks) {
                this.generateForeignKeys(null, null);
            }
            return;
        }
        for (int i = 0; i < schemaMap.length; ++i) {
            this.generateSchema((String)schemaMap[i][0], (String[])schemaMap[i][1]);
        }
        for (int i = 0; i < schemaMap.length; ++i) {
            String schemaName = (String)schemaMap[i][0];
            String[] tableNames = (String[])schemaMap[i][1];
            int numTables = tableNames != null ? tableNames.length : this.getTables(schemaName).size();
            this._schemaObjects += numTables + (this._pks ? numTables : 0) + (this._indexes ? numTables : 0) + (this._fks ? numTables : 0);
            if (this._pks) {
                this.generatePrimaryKeys(schemaName, tableNames);
            }
            if (this._indexes) {
                this.generateIndexes(schemaName, tableNames);
            }
            if (!this._fks) continue;
            this.generateForeignKeys(schemaName, tableNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSchema(String name, String[] tableNames) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-schema", name));
        Connection conn = this._ds.getConnection();
        DatabaseMetaData meta = conn.getMetaData();
        try {
            if (tableNames == null) {
                this.generateTables(name, null, conn, meta);
            } else {
                for (int i = 0; i < tableNames.length; ++i) {
                    this.generateTables(name, tableNames[i], conn, meta);
                }
            }
            if (this._seqs) {
                this.generateSequences(name, null, conn, meta);
            }
        }
        finally {
            try {
                conn.commit();
            }
            catch (SQLException se) {}
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePrimaryKeys(String schemaName, String[] tableNames) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-all-primaries", schemaName));
        Connection conn = this._ds.getConnection();
        DatabaseMetaData meta = conn.getMetaData();
        try {
            if (tableNames == null) {
                this.generatePrimaryKeys(schemaName, null, conn, meta);
            } else {
                for (int i = 0; i < tableNames.length; ++i) {
                    this.generatePrimaryKeys(schemaName, tableNames[i], conn, meta);
                }
            }
        }
        finally {
            try {
                conn.commit();
            }
            catch (SQLException se) {}
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateIndexes(String schemaName, String[] tableNames) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-all-indexes", schemaName));
        Connection conn = this._ds.getConnection();
        DatabaseMetaData meta = conn.getMetaData();
        try {
            if (tableNames == null) {
                this.generateIndexes(schemaName, null, conn, meta);
            } else {
                for (int i = 0; i < tableNames.length; ++i) {
                    this.generateIndexes(schemaName, tableNames[i], conn, meta);
                }
            }
        }
        finally {
            try {
                conn.commit();
            }
            catch (SQLException se) {}
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateForeignKeys(String schemaName, String[] tableNames) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-all-foreigns", schemaName));
        Connection conn = this._ds.getConnection();
        DatabaseMetaData meta = conn.getMetaData();
        try {
            if (tableNames == null) {
                this.generateForeignKeys(schemaName, null, conn, meta);
            } else {
                for (int i = 0; i < tableNames.length; ++i) {
                    this.generateForeignKeys(schemaName, tableNames[i], conn, meta);
                }
            }
        }
        finally {
            try {
                conn.commit();
            }
            catch (SQLException se) {}
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    public void generateTables(String schemaName, String tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-columns", schemaName, tableName));
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("gen-tables", schemaName, tableName));
        }
        Column[] cols = this._dict.getColumns(meta, conn.getCatalog(), schemaName, tableName, null, conn);
        HashSet<String> tableNames = null;
        if (tableName == null || "%".equals(tableName)) {
            Table[] tables = this._dict.getTables(meta, conn.getCatalog(), schemaName, tableName, conn);
            tableNames = new HashSet<String>();
            for (int i = 0; tables != null && i < tables.length; ++i) {
                if (cols == null) {
                    tableNames.add(tables[i].getName());
                    continue;
                }
                tableNames.add(tables[i].getName().toUpperCase());
            }
        }
        if (cols == null && tableName == null) {
            Iterator itr = tableNames.iterator();
            while (itr.hasNext()) {
                this.generateTables(schemaName, (String)itr.next(), conn, meta);
            }
            return;
        }
        SchemaGroup group = this.getSchemaGroup();
        for (int i = 0; cols != null && i < cols.length; ++i) {
            Table table;
            tableName = cols[i].getTableName();
            String tableSchema = StringUtils.trimToNull((String)cols[i].getSchemaName());
            if (!this._openjpaTables && (tableName.toUpperCase().startsWith("OPENJPA_") || tableName.toUpperCase().startsWith("JDO_")) || this._dict.isSystemTable(tableName, tableSchema, schemaName != null) || tableNames != null && !tableNames.contains(tableName.toUpperCase()) || !this.isAllowedTable(tableSchema, tableName)) continue;
            Schema schema = group.getSchema(tableSchema);
            if (schema == null) {
                schema = group.addSchema(tableSchema);
            }
            if ((table = schema.getTable(tableName)) == null) {
                table = schema.addTable(tableName);
                if (this._log.isTraceEnabled()) {
                    this._log.trace(_loc.get("col-table", table));
                }
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("gen-column", cols[i].getName(), table));
            }
            if (table.getColumn(cols[i].getName()) != null) continue;
            table.importColumn(cols[i]);
        }
    }

    private boolean isAllowedTable(String schema, String table) {
        int i;
        if (this._allowed == null) {
            return true;
        }
        String[] anySchemaTables = null;
        for (i = 0; i < this._allowed.length; ++i) {
            if (this._allowed[i][0] == null) {
                anySchemaTables = (String[])this._allowed[i][1];
                if (schema != null) continue;
                break;
            }
            if (!StringUtils.equalsIgnoreCase((String)schema, (String)((String)this._allowed[i][0]))) continue;
            if (table == null) {
                return true;
            }
            String[] tables = (String[])this._allowed[i][1];
            if (tables == null) {
                return true;
            }
            for (int j = 0; j < tables.length; ++j) {
                if (!StringUtils.equalsIgnoreCase((String)table, (String)tables[j])) continue;
                return true;
            }
        }
        if (anySchemaTables != null) {
            if (table == null) {
                return true;
            }
            for (i = 0; i < anySchemaTables.length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)table, (String)anySchemaTables[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void generatePrimaryKeys(String schemaName, String tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-primary", schemaName, tableName));
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("gen-pks", schemaName, tableName));
        }
        SchemaGroup group = this.getSchemaGroup();
        if (tableName != null && group.findTable(tableName) == null) {
            return;
        }
        PrimaryKey[] pks = this._dict.getPrimaryKeys(meta, conn.getCatalog(), schemaName, tableName, conn);
        if (pks == null && tableName == null) {
            Collection tables = this.getTables(schemaName);
            Iterator itr = tables.iterator();
            while (itr.hasNext()) {
                Table table = (Table)itr.next();
                this.generatePrimaryKeys(table.getSchemaName(), table.getName(), conn, meta);
            }
            return;
        }
        for (int i = 0; pks != null && i < pks.length; ++i) {
            PrimaryKey pk;
            Table table;
            schemaName = StringUtils.trimToNull((String)pks[i].getSchemaName());
            Schema schema = group.getSchema(schemaName);
            if (schema == null || (table = schema.getTable(pks[i].getTableName())) == null) continue;
            String colName = pks[i].getColumnName();
            String name = pks[i].getName();
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("gen-pk", name, table, colName));
            }
            if ((pk = table.getPrimaryKey()) == null) {
                pk = table.addPrimaryKey(name);
            }
            pk.addColumn(table.getColumn(colName));
        }
    }

    public void generateIndexes(String schemaName, String tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-indexes", schemaName, tableName));
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("gen-indexes", schemaName, tableName));
        }
        SchemaGroup group = this.getSchemaGroup();
        if (tableName != null && group.findTable(tableName) == null) {
            return;
        }
        Index[] idxs = this._dict.getIndexInfo(meta, conn.getCatalog(), schemaName, tableName, false, true, conn);
        if (idxs == null && tableName == null) {
            Collection tables = this.getTables(schemaName);
            Iterator itr = tables.iterator();
            while (itr.hasNext()) {
                Table table = (Table)itr.next();
                this.generateIndexes(table.getSchemaName(), table.getName(), conn, meta);
            }
            return;
        }
        for (int i = 0; idxs != null && i < idxs.length; ++i) {
            Index idx;
            String colName;
            Table table;
            schemaName = StringUtils.trimToNull((String)idxs[i].getSchemaName());
            Schema schema = group.getSchema(schemaName);
            if (schema == null || (table = schema.getTable(idxs[i].getTableName())) == null) continue;
            String pkName = table.getPrimaryKey() != null ? table.getPrimaryKey().getName() : null;
            String name = idxs[i].getName();
            if (StringUtils.isEmpty((String)name) || pkName != null && name.equalsIgnoreCase(pkName) || this._dict.isSystemIndex(name, table) || table.getColumn(colName = idxs[i].getColumnName()) == null) continue;
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("gen-index", name, table, colName));
            }
            if ((idx = table.getIndex(name)) == null) {
                idx = table.addIndex(name);
                idx.setUnique(idxs[i].isUnique());
            }
            idx.addColumn(table.getColumn(colName));
        }
    }

    public void generateForeignKeys(String schemaName, String tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        ForeignKey fk;
        this.fireGenerationEvent(_loc.get("generating-foreign", schemaName, tableName));
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("gen-fks", schemaName, tableName));
        }
        SchemaGroup group = this.getSchemaGroup();
        if (tableName != null && group.findTable(tableName) == null) {
            return;
        }
        ForeignKey[] fks = this._dict.getImportedKeys(meta, conn.getCatalog(), schemaName, tableName, conn);
        if (fks == null && tableName == null) {
            Collection tables = this.getTables(schemaName);
            Iterator itr = tables.iterator();
            while (itr.hasNext()) {
                Table table = (Table)itr.next();
                this.generateForeignKeys(table.getSchemaName(), table.getName(), conn, meta);
            }
            return;
        }
        boolean seqWas0 = false;
        HashSet<ForeignKey> invalids = null;
        for (int i = 0; fks != null && i < fks.length; ++i) {
            Table pkTable;
            Table table;
            schemaName = StringUtils.trimToNull((String)fks[i].getSchemaName());
            Schema schema = group.getSchema(schemaName);
            if (schema == null || (table = schema.getTable(fks[i].getTableName())) == null) continue;
            String name = fks[i].getName();
            String fkColName = fks[i].getColumnName();
            String pkColName = fks[i].getPrimaryKeyColumnName();
            int seq = fks[i].getKeySequence();
            if (seq == 0) {
                seqWas0 = true;
            }
            if (seqWas0) {
                ++seq;
            }
            String pkSchemaName = fks[i].getPrimaryKeySchemaName();
            String pkTableName = fks[i].getPrimaryKeyTableName();
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("gen-fk", new Object[]{name, table, fkColName, pkTableName, pkColName, seq + ""}));
            }
            if (!StringUtils.isEmpty((String)pkSchemaName)) {
                pkTableName = pkSchemaName + "." + pkTableName;
            }
            if ((pkTable = group.findTable(pkTableName)) == null) {
                throw new SQLException(_loc.get("gen-nofktable", table, pkTableName).getMessage());
            }
            fk = table.getForeignKey(name);
            if (seq == 1 || fk == null) {
                fk = table.addForeignKey(name);
                fk.setDeferred(fks[i].isDeferred());
                fk.setDeleteAction(fks[i].getDeleteAction());
            }
            if (invalids != null && invalids.contains(fk)) continue;
            try {
                fk.join(table.getColumn(fkColName), pkTable.getColumn(pkColName));
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn(_loc.get("bad-join", iae.toString()));
                }
                if (invalids == null) {
                    invalids = new HashSet<ForeignKey>();
                }
                invalids.add(fk);
            }
        }
        if (invalids != null) {
            Iterator itr = invalids.iterator();
            while (itr.hasNext()) {
                fk = (ForeignKey)itr.next();
                fk.getTable().removeForeignKey(fk);
            }
        }
    }

    public void generateSequences(String schemaName, String sequenceName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-sequences", schemaName));
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("gen-seqs", schemaName, sequenceName));
        }
        Sequence[] seqs = this._dict.getSequences(meta, conn.getCatalog(), null, sequenceName, conn);
        SchemaGroup group = this.getSchemaGroup();
        for (int i = 0; seqs != null && i < seqs.length; ++i) {
            sequenceName = seqs[i].getName();
            String sequenceSchema = StringUtils.trimToNull((String)seqs[i].getSchemaName());
            if (!this._openjpaTables && (sequenceName.toUpperCase().startsWith("OPENJPA_") || sequenceName.toUpperCase().startsWith("JDO_")) || this._dict.isSystemSequence(sequenceName, sequenceSchema, schemaName != null) || !this.isAllowedTable(sequenceSchema, null)) continue;
            Schema schema = group.getSchema(sequenceSchema);
            if (schema == null) {
                schema = group.addSchema(sequenceSchema);
            }
            if (schema.getSequence(sequenceName) != null) continue;
            schema.addSequence(sequenceName);
        }
    }

    private void fireGenerationEvent(Object schemaObject) throws SQLException {
        if (schemaObject == null) {
            return;
        }
        if (this._listeners == null || this._listeners.size() == 0) {
            return;
        }
        Event e = new Event(schemaObject, this._schemaObjects);
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            Listener l = (Listener)i.next();
            if (l.schemaObjectGenerated(e)) continue;
            throw new SQLException(_loc.get("refresh-cancelled").getMessage());
        }
    }

    public void addListener(Listener l) {
        if (this._listeners == null) {
            this._listeners = new LinkedList();
        }
        this._listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this._listeners != null && this._listeners.remove(l);
    }

    private Collection getTables(String schemaName) {
        SchemaGroup group = this.getSchemaGroup();
        if (schemaName != null) {
            Schema schema = group.getSchema(schemaName);
            if (schema == null) {
                return Collections.EMPTY_LIST;
            }
            return Arrays.asList(schema.getTables());
        }
        Schema[] schemas = group.getSchemas();
        LinkedList<Table> tables = new LinkedList<Table>();
        for (int i = 0; i < schemas.length; ++i) {
            tables.addAll(Arrays.asList(schemas[i].getTables()));
        }
        return tables;
    }

    public class Event
    extends EventObject {
        private final int _total;

        public Event(Object ob, int total) {
            super(ob);
            this._total = total;
        }

        public int getTotal() {
            return this._total;
        }
    }

    public static interface Listener {
        public boolean schemaObjectGenerated(Event var1);
    }
}

