/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.IdentityMap;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.AttachStrategy;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.DetachedStateAttachStrategy;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.VersionAttachStrategy;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.CallbackException;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;
import org.apache.openjpa.util.ProxyManager;
import org.apache.openjpa.util.UserException;

class AttachManager {
    private static final Localizer _loc = Localizer.forPackage(AttachManager.class);
    private final BrokerImpl _broker;
    private final ProxyManager _proxy;
    private final OpCallbacks _call;
    private final boolean _copyNew;
    private final boolean _failFast;
    private final IdentityMap _attached = new IdentityMap();
    private AttachStrategy _version = null;
    private AttachStrategy _detach = null;

    public AttachManager(BrokerImpl broker, boolean copyNew, OpCallbacks call) {
        this._broker = broker;
        this._proxy = broker.getConfiguration().getProxyManagerInstance();
        this._call = call;
        this._copyNew = copyNew;
        this._failFast = (broker.getConfiguration().getMetaDataRepositoryInstance().getMetaDataFactory().getDefaults().getCallbackMode() & 2) != 0;
    }

    public OpCallbacks getBehavior() {
        return this._call;
    }

    public boolean getCopyNew() {
        return this._copyNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attach(Object pc) {
        if (pc == null) {
            return null;
        }
        CallbackException excep = null;
        try {
            Object object = this.attach(pc, null, null, null, true);
            return object;
        }
        catch (CallbackException ce) {
            excep = ce;
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            List<CallbackException> exceps = null;
            exceps = excep == null || !this._failFast ? this.invokeAfterAttach(null) : Collections.singletonList(excep);
            this._attached.clear();
            this.throwExceptions(exceps, null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] attachAll(Collection instances) {
        Object[] attached = new Object[instances.size()];
        List exceps = null;
        List failed = null;
        boolean opt = true;
        boolean failFast = false;
        try {
            int i = 0;
            Iterator itr = instances.iterator();
            while (itr.hasNext()) {
                block10: {
                    try {
                        attached[i] = this.attach(itr.next(), null, null, null, true);
                    }
                    catch (OpenJPAException ke) {
                        if (opt && !(ke instanceof OptimisticException)) {
                            opt = false;
                        }
                        if (opt && ke.getFailedObject() != null) {
                            failed = this.add(failed, ke.getFailedObject());
                        }
                        exceps = this.add(exceps, ke);
                        if (!(ke instanceof CallbackException) || !this._failFast) break block10;
                        failFast = true;
                        break;
                    }
                    catch (RuntimeException re) {
                        exceps = this.add(exceps, re);
                    }
                }
                ++i;
            }
        }
        finally {
            if (!(failFast || exceps != null && exceps.size() >= instances.size())) {
                exceps = this.invokeAfterAttach(exceps);
            }
            this._attached.clear();
        }
        this.throwExceptions(exceps, failed, opt);
        return attached;
    }

    private List invokeAfterAttach(List exceps) {
        Set entries = this._attached.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Object attached = entry.getValue();
            StateManagerImpl sm = this._broker.getStateManagerImpl(attached, true);
            if (sm.isNew()) continue;
            try {
                this._broker.fireLifecycleEvent(attached, entry.getKey(), sm.getMetaData(), 16);
            }
            catch (RuntimeException re) {
                exceps = this.add(exceps, re);
                if (!this._failFast || !(re instanceof CallbackException)) continue;
                break;
            }
        }
        return exceps;
    }

    private List add(List list, Object obj) {
        if (list == null) {
            list = new LinkedList<Object>();
        }
        list.add(obj);
        return list;
    }

    private void throwExceptions(List exceps, List failed, boolean opt) {
        if (exceps == null) {
            return;
        }
        if (exceps.size() == 1) {
            throw (RuntimeException)exceps.get(0);
        }
        Throwable[] t = exceps.toArray(new Throwable[exceps.size()]);
        if (opt && failed != null) {
            throw new OptimisticException(failed, t);
        }
        if (opt) {
            throw new OptimisticException(t);
        }
        throw new UserException(_loc.get("nested-exceps")).setNestedThrowables(t);
    }

    Object attach(Object toAttach, PersistenceCapable into, OpenJPAStateManager owner, ValueMetaData ownerMeta, boolean explicit) {
        if (toAttach == null) {
            return null;
        }
        Object attached = this._attached.get(toAttach);
        if (attached != null) {
            return attached;
        }
        int action = this.processArgument(toAttach);
        if ((action & 4) == 0) {
            return toAttach;
        }
        ClassMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(ImplHelper.getManagedInstance(toAttach).getClass(), this._broker.getClassLoader(), true);
        return this.getStrategy(toAttach).attach(this, toAttach, meta, into, owner, ownerMeta, explicit);
    }

    private int processArgument(Object obj) {
        if (this._call == null) {
            return 4;
        }
        return this._call.processArgument(6, obj, this._broker.getStateManager(obj));
    }

    private AttachStrategy getStrategy(Object toAttach) {
        PersistenceCapable pc = ImplHelper.toPersistenceCapable(toAttach, this.getBroker().getConfiguration());
        if (pc.pcGetStateManager() instanceof AttachStrategy) {
            return (AttachStrategy)((Object)pc.pcGetStateManager());
        }
        Object obj = pc.pcGetDetachedState();
        if (obj instanceof AttachStrategy) {
            return (AttachStrategy)obj;
        }
        if (obj == null || obj == PersistenceCapable.DESERIALIZED) {
            if (this._version == null) {
                this._version = new VersionAttachStrategy();
            }
            return this._version;
        }
        if (this._detach == null) {
            this._detach = new DetachedStateAttachStrategy();
        }
        return this._detach;
    }

    BrokerImpl getBroker() {
        return this._broker;
    }

    ProxyManager getProxyManager() {
        return this._proxy;
    }

    PersistenceCapable getAttachedCopy(Object pc) {
        return ImplHelper.toPersistenceCapable(this._attached.get(pc), this.getBroker().getConfiguration());
    }

    void setAttachedCopy(Object from, PersistenceCapable into) {
        this._attached.put(from, (Object)into);
    }

    void fireBeforeAttach(Object pc, ClassMetaData meta) {
        this._broker.fireLifecycleEvent(pc, null, meta, 15);
    }

    Object getDetachedObjectId(Object pc) {
        if (pc == null) {
            return null;
        }
        return this.getStrategy(pc).getDetachedObjectId(this, pc);
    }

    StateManagerImpl assertManaged(Object obj) {
        StateManagerImpl sm = this._broker.getStateManagerImpl(obj, true);
        if (sm == null) {
            throw new UserException(_loc.get("not-managed", Exceptions.toString(obj))).setFailedObject(obj);
        }
        return sm;
    }
}

