/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataDefaults;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public abstract class AbstractMetaDataDefaults
implements MetaDataDefaults {
    private static final Localizer _loc = Localizer.forPackage(AbstractMetaDataDefaults.class);
    private int _access = 2;
    private int _identity = 0;
    private boolean _ignore = true;
    private boolean _interface = true;
    private boolean _pcRegistry = true;
    private int _callback = 16;
    private boolean _unwrapped = false;

    public boolean getUsePCRegistry() {
        return this._pcRegistry;
    }

    public void setUsePCRegistry(boolean pcRegistry) {
        this._pcRegistry = pcRegistry;
    }

    public int getDefaultAccessType() {
        return this._access;
    }

    public void setDefaultAccessType(int access) {
        this._access = access;
    }

    public int getDefaultIdentityType() {
        return this._identity;
    }

    public void setDefaultIdentityType(int identity) {
        this._identity = identity;
    }

    public int getCallbackMode() {
        return this._callback;
    }

    public void setCallbackMode(int mode) {
        this._callback = mode;
    }

    public void setCallbackMode(int mode, boolean on) {
        this._callback = on ? (this._callback |= mode) : (this._callback &= ~mode);
    }

    public boolean getCallbacksBeforeListeners(int type) {
        return false;
    }

    public boolean isDeclaredInterfacePersistent() {
        return this._interface;
    }

    public void setDeclaredInterfacePersistent(boolean pers) {
        this._interface = pers;
    }

    public boolean isDataStoreObjectIdFieldUnwrapped() {
        return this._unwrapped;
    }

    public void setDataStoreObjectIdFieldUnwrapped(boolean unwrapped) {
        this._unwrapped = unwrapped;
    }

    public boolean getIgnoreNonPersistent() {
        return this._ignore;
    }

    public void setIgnoreNonPersistent(boolean ignore) {
        this._ignore = ignore;
    }

    public void populate(ClassMetaData meta, int access) {
        if (meta.getDescribedType() == Object.class) {
            return;
        }
        if (access == 0 && ((access = this.getAccessType(meta)) & 2) != 0 && (access & 4) != 0) {
            throw new UserException(_loc.get("access-field-and-prop", meta.getDescribedType().getName()));
        }
        meta.setAccessType(access);
        Log log = meta.getRepository().getLog();
        if (log.isTraceEnabled()) {
            log.trace(_loc.get("gen-meta", meta));
        }
        if (!this._pcRegistry || !this.populateFromPCRegistry(meta)) {
            if (log.isTraceEnabled()) {
                log.trace(_loc.get("meta-reflect"));
            }
            this.populateFromReflection(meta);
        }
    }

    protected void populate(FieldMetaData fmd) {
    }

    private boolean populateFromPCRegistry(ClassMetaData meta) {
        Class cls = meta.getDescribedType();
        try {
            String[] fieldNames = PCRegistry.getFieldNames(cls);
            Class[] fieldTypes = PCRegistry.getFieldTypes(cls);
            for (int i = 0; i < fieldNames.length; ++i) {
                AccessibleObject member = meta.getAccessType() == 2 ? (Field)AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldAction(cls, fieldNames[i])) : Reflection.findGetter(meta.getDescribedType(), fieldNames[i], true);
                FieldMetaData fmd = meta.addDeclaredField(fieldNames[i], fieldTypes[i]);
                fmd.backingMember((Member)((Object)member));
                this.populate(fmd);
            }
            return true;
        }
        catch (IllegalStateException iae) {
            return false;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new UserException(e);
        }
    }

    private void populateFromReflection(ClassMetaData meta) {
        boolean iface = meta.getDescribedType().isInterface();
        AccessibleObject[] members = meta.getAccessType() == 2 && !iface ? (Field[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction(meta.getDescribedType())) : (Method[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction(meta.getDescribedType()));
        for (int i = 0; i < members.length; ++i) {
            boolean def;
            String name;
            int mods = members[i].getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || (name = this.getFieldName((Member)((Object)members[i]))) == null || this.isReservedFieldName(name) || !(def = this.isDefaultPersistent(meta, (Member)((Object)members[i]), name)) && this._ignore) continue;
            FieldMetaData fmd = meta.addDeclaredField(name, class$java$lang$Object == null ? AbstractMetaDataDefaults.class$("java.lang.Object") : class$java$lang$Object);
            fmd.backingMember((Member)((Object)members[i]));
            if (!def) {
                fmd.setExplicit(true);
                fmd.setManagement(0);
            }
            this.populate(fmd);
        }
    }

    protected int getAccessType(ClassMetaData meta) {
        return 2;
    }

    protected String getFieldName(Member member) {
        if (member instanceof Field) {
            return member.getName();
        }
        Method meth = (Method)member;
        if (meth.getReturnType() == Void.TYPE || meth.getParameterTypes().length != 0) {
            return null;
        }
        String name = meth.getName();
        if (name.startsWith("get") && name.length() > 3) {
            name = name.substring(3);
        } else if ((meth.getReturnType() == Boolean.TYPE || meth.getReturnType() == Boolean.class) && name.startsWith("is") && name.length() > 2) {
            name = name.substring(2);
        } else {
            return null;
        }
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    protected boolean isReservedFieldName(String name) {
        return name.startsWith("openjpa") || name.startsWith("jdo");
    }

    protected abstract boolean isDefaultPersistent(ClassMetaData var1, Member var2, String var3);

    public Member getBackingMember(FieldMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        try {
            if (fmd.getDefiningMetaData().getAccessType() == 2) {
                return (Field)AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldAction(fmd.getDeclaringType(), fmd.getName()));
            }
            return Reflection.findGetter(fmd.getDeclaringType(), fmd.getName(), true);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new InternalException(e);
        }
    }

    public Class getUnimplementedExceptionType() {
        return UnsupportedOperationException.class;
    }

    protected static boolean isUserDefined(Class cls) {
        return cls != null && !cls.getName().startsWith("java.") && !cls.getName().startsWith("javax.");
    }
}

