/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.CheckProfiles;
import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.generic.ProfileServerFactory;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.opt.security.AdminClient;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.HandshakeBeginMessage;
import javax.management.remote.message.HandshakeEndMessage;
import javax.management.remote.message.HandshakeErrorMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.VersionMessage;
import javax.security.auth.Subject;

public class AdminServer
implements ServerAdmin {
    private Map env = null;
    private Map subjectsTable = new WeakHashMap();
    private Map profilesTable = new WeakHashMap();
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "AdminServer");

    public AdminServer(Map map) {
        this.env = map != null ? map : Collections.EMPTY_MAP;
    }

    public MessageConnection connectionOpen(MessageConnection messageConnection) throws IOException {
        boolean bl = true;
        try {
            String string;
            Object object;
            Subject subject;
            block22: {
                Message message;
                subject = null;
                String string2 = (String)this.env.get("jmx.remote.profiles");
                String string3 = "1.0";
                if (logger.traceOn()) {
                    logger.trace("connectionOpen", ">>>>> Handshake Begin <<<<<");
                    logger.trace("connectionOpen", "Server Supported Profiles [ " + string2 + " ]");
                    logger.trace("connectionOpen", "Server JMXMP Version [ " + string3 + " ]");
                }
                HandshakeBeginMessage handshakeBeginMessage = new HandshakeBeginMessage(string2, string3);
                messageConnection.writeMessage(handshakeBeginMessage);
                while (true) {
                    Object object2;
                    Message message2;
                    if ((message = messageConnection.readMessage()) instanceof HandshakeErrorMessage) {
                        bl = false;
                        message2 = (HandshakeErrorMessage)message;
                        AdminClient.throwExceptionOnError((HandshakeErrorMessage)message2);
                        continue;
                    }
                    if (message instanceof HandshakeEndMessage) {
                        Object[] objectArray;
                        message2 = (HandshakeEndMessage)message;
                        object2 = ((HandshakeEndMessage)message2).getContext();
                        if (logger.traceOn()) {
                            logger.trace("connectionOpen", ">>>>> Handshake End <<<<<");
                            logger.trace("connectionOpen", "Client Context Object [ " + object2 + " ]");
                        }
                        object = this.env.get("jmx.remote.context");
                        if (messageConnection instanceof SocketConnectionIf) {
                            ((SocketConnectionIf)((Object)messageConnection)).setSubject(subject);
                        }
                        string = messageConnection.getConnectionId();
                        JMXAuthenticator jMXAuthenticator = (JMXAuthenticator)this.env.get("jmx.remote.authenticator");
                        if (jMXAuthenticator != null) {
                            objectArray = new Object[]{string, subject};
                            subject = jMXAuthenticator.authenticate(objectArray);
                            if (messageConnection instanceof SocketConnectionIf) {
                                ((SocketConnectionIf)((Object)messageConnection)).setSubject(subject);
                            }
                            string = messageConnection.getConnectionId();
                        }
                        if (logger.traceOn()) {
                            logger.trace("connectionOpen", "Server Context Object [ " + object + " ]");
                            logger.trace("connectionOpen", "Server Connection Id [ " + string + " ]");
                        }
                        objectArray = this.getProfilesByName(messageConnection);
                        CheckProfiles checkProfiles = (CheckProfiles)this.env.get("com.sun.jmx.remote.profile.checker");
                        if (checkProfiles != null) {
                            checkProfiles.checkProfiles(this.env, (List)objectArray, object2, string);
                        } else {
                            this.checkProfilesForEquality(string2, (List)objectArray);
                        }
                        break block22;
                    }
                    if (message instanceof VersionMessage) {
                        message2 = (VersionMessage)message;
                        object2 = ((VersionMessage)message2).getVersion();
                        if (((String)object2).equals(string3)) {
                            object = new VersionMessage(string3);
                            messageConnection.writeMessage((Message)object);
                            continue;
                        }
                        throw new IOException("Protocol version mismatch: Client [" + (String)object2 + "] vs. Server [" + string3 + "]");
                    }
                    if (!(message instanceof ProfileMessage)) break;
                    message2 = (ProfileMessage)message;
                    object2 = message2.getProfileName();
                    object = this.getProfile(messageConnection, (String)object2);
                    if (object == null) {
                        object = ProfileServerFactory.createProfile((String)object2, this.env);
                        if (logger.traceOn()) {
                            logger.trace("connectionOpen", ">>>>> Profile " + object.getClass().getName() + " <<<<<");
                        }
                        object.initialize(messageConnection, subject);
                        this.putProfile(messageConnection, (ProfileServer)object);
                    }
                    object.consumeMessage((ProfileMessage)message2);
                    message2 = object.produceMessage();
                    messageConnection.writeMessage(message2);
                    if (!object.isComplete()) continue;
                    subject = object.activate();
                }
                throw new IOException("Unexpected message: " + message.getClass().getName());
            }
            HandshakeEndMessage handshakeEndMessage = new HandshakeEndMessage(object, string);
            messageConnection.writeMessage(handshakeEndMessage);
            this.putSubject(messageConnection, subject);
        }
        catch (Exception exception) {
            block23: {
                if (bl) {
                    try {
                        messageConnection.writeMessage(new HandshakeErrorMessage(exception.toString()));
                    }
                    catch (Exception exception2) {
                        if (!logger.debugOn()) break block23;
                        logger.debug("connectionOpen", "Could not send HandshakeErrorMessage to the client", exception2);
                    }
                }
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
        return messageConnection;
    }

    public void connectionClosed(MessageConnection messageConnection) {
        this.removeSubject(messageConnection);
        this.removeProfiles(messageConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject getSubject(MessageConnection messageConnection) {
        Map map = this.subjectsTable;
        synchronized (map) {
            return (Subject)this.subjectsTable.get(messageConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putSubject(MessageConnection messageConnection, Subject subject) {
        Map map = this.subjectsTable;
        synchronized (map) {
            this.subjectsTable.put(messageConnection, subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubject(MessageConnection messageConnection) {
        Map map = this.subjectsTable;
        synchronized (map) {
            this.subjectsTable.remove(messageConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileServer getProfile(MessageConnection messageConnection, String string) {
        Map map = this.profilesTable;
        synchronized (map) {
            ArrayList arrayList = (ArrayList)this.profilesTable.get(messageConnection);
            if (arrayList == null) {
                return null;
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ProfileServer profileServer = (ProfileServer)iterator.next();
                if (!profileServer.getName().equals(string)) continue;
                return profileServer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void putProfile(MessageConnection messageConnection, ProfileServer profileServer) {
        Map map = this.profilesTable;
        synchronized (map) {
            ArrayList<ProfileServer> arrayList = (ArrayList<ProfileServer>)this.profilesTable.get(messageConnection);
            if (arrayList == null) {
                arrayList = new ArrayList<ProfileServer>();
                this.profilesTable.put(messageConnection, arrayList);
            }
            if (!arrayList.contains(profileServer)) {
                arrayList.add(profileServer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getProfiles(MessageConnection messageConnection) {
        Map map = this.profilesTable;
        synchronized (map) {
            return (ArrayList)this.profilesTable.get(messageConnection);
        }
    }

    private ArrayList getProfilesByName(MessageConnection messageConnection) {
        ArrayList arrayList = this.getProfiles(messageConnection);
        if (arrayList == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ProfileServer profileServer = (ProfileServer)iterator.next();
            arrayList2.add(profileServer.getName());
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeProfiles(MessageConnection messageConnection) {
        Map map = this.profilesTable;
        synchronized (map) {
            ArrayList arrayList = (ArrayList)this.profilesTable.get(messageConnection);
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ProfileServer profileServer = (ProfileServer)iterator.next();
                    try {
                        profileServer.terminate();
                    }
                    catch (Exception exception) {
                        if (!logger.debugOn()) continue;
                        logger.debug("removeProfiles", "Got an exception to terminate a ProfileServer: " + profileServer.getName(), exception);
                    }
                }
                arrayList.clear();
            }
            this.profilesTable.remove(messageConnection);
        }
    }

    private void checkProfilesForEquality(String string, List list) throws IOException {
        boolean bl;
        boolean bl2 = string == null || string.equals("");
        boolean bl3 = bl = list == null || list.isEmpty();
        if (bl2 && bl) {
            return;
        }
        if (bl2) {
            throw new IOException("The server does not support any profile but the client requires one");
        }
        if (bl) {
            throw new IOException("The client does not require any profile but the server mandates one");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        if (arrayList.size() != list.size()) {
            throw new IOException("The client negotiated profiles do not match the server required profiles.");
        }
        if (!list.containsAll(arrayList)) {
            throw new IOException("The client negotiated profiles " + list + " do not match " + "the server required profiles " + arrayList + ".");
        }
    }
}

