/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.extendable.UnmodifiableExtendableItem;

public class ModuleRevisionId
extends UnmodifiableExtendableItem {
    private static final String ENCODE_SEPARATOR = ":#@#:";
    private static final String ENCODE_PREFIX = "+";
    private static final String NULL_ENCODE = "@#:NULL:#@";
    static final String STRICT_CHARS_PATTERN = "[a-zA-Z0-9\\-/\\._+=]";
    private static final String REV_STRICT_CHARS_PATTERN = "[a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]";
    private static final Map CACHE = new WeakHashMap();
    public static final Pattern MRID_PATTERN = Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)(?:#([a-zA-Z0-9\\-/\\._+=]+))?;([a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    public static final Pattern NON_CAPTURING_PATTERN = Pattern.compile("(?:[a-zA-Z0-9\\-/\\._+=]*)#(?:[a-zA-Z0-9\\-/\\._+=]+)(?:#(?:[a-zA-Z0-9\\-/\\._+=]+))?;(?:[a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    private final ModuleId moduleId;
    private final String branch;
    private final String revision;
    private int hash;

    public static ModuleRevisionId parse(String mrid) {
        Matcher m = MRID_PATTERN.matcher(mrid.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("module revision text representation do not match expected pattern. given mrid='" + mrid + "' expected form=" + MRID_PATTERN.pattern());
        }
        return ModuleRevisionId.newInstance(m.group(1), m.group(2), m.group(3), m.group(4));
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String revision) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name), revision));
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String revision, Map extraAttributes) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name), revision, extraAttributes));
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String branch, String revision) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name), branch, revision));
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String branch, String revision, Map extraAttributes) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name), branch, revision, extraAttributes));
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String branch, String revision, Map extraAttributes, boolean replaceNullBranchWithDefault) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name), branch, revision, extraAttributes, replaceNullBranchWithDefault));
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId mrid, String rev) {
        return ModuleRevisionId.intern(new ModuleRevisionId(mrid.getModuleId(), mrid.getBranch(), rev, mrid.getQualifiedExtraAttributes()));
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId mrid, String branch, String rev) {
        return ModuleRevisionId.intern(new ModuleRevisionId(mrid.getModuleId(), branch, rev, mrid.getQualifiedExtraAttributes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleRevisionId intern(ModuleRevisionId moduleRevisionId) {
        ModuleRevisionId r = null;
        Map map = CACHE;
        synchronized (map) {
            WeakReference ref = (WeakReference)CACHE.get(moduleRevisionId);
            if (ref != null) {
                r = (ModuleRevisionId)ref.get();
            }
            if (r == null) {
                r = moduleRevisionId;
                CACHE.put(r, new WeakReference<ModuleRevisionId>(r));
            }
        }
        return r;
    }

    public ModuleRevisionId(ModuleId moduleId, String revision) {
        this(moduleId, null, revision, null);
    }

    public ModuleRevisionId(ModuleId moduleId, String branch, String revision) {
        this(moduleId, branch, revision, null);
    }

    private ModuleRevisionId(ModuleId moduleId, String revision, Map extraAttributes) {
        this(moduleId, null, revision, extraAttributes);
    }

    private ModuleRevisionId(ModuleId moduleId, String branch, String revision, Map extraAttributes) {
        this(moduleId, branch, revision, extraAttributes, true);
    }

    private ModuleRevisionId(ModuleId moduleId, String branch, String revision, Map extraAttributes, boolean replaceNullBranchWithDefault) {
        super(null, extraAttributes);
        this.moduleId = moduleId;
        IvyContext context = IvyContext.getContext();
        this.branch = replaceNullBranchWithDefault && branch == null ? (context.peekIvy() == null ? null : context.getSettings().getDefaultBranch(moduleId)) : branch;
        this.revision = revision == null ? Ivy.getWorkingRevision() : revision;
        this.setStandardAttribute("organisation", this.moduleId.getOrganisation());
        this.setStandardAttribute("module", this.moduleId.getName());
        this.setStandardAttribute("branch", this.branch);
        this.setStandardAttribute("revision", this.revision);
    }

    public ModuleId getModuleId() {
        return this.moduleId;
    }

    public String getName() {
        return this.getModuleId().getName();
    }

    public String getOrganisation() {
        return this.getModuleId().getOrganisation();
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleRevisionId)) {
            return false;
        }
        ModuleRevisionId other = (ModuleRevisionId)obj;
        if (!other.getRevision().equals(this.getRevision())) {
            return false;
        }
        if (other.getBranch() == null && this.getBranch() != null) {
            return false;
        }
        if (other.getBranch() != null && !other.getBranch().equals(this.getBranch())) {
            return false;
        }
        if (!other.getModuleId().equals(this.getModuleId())) {
            return false;
        }
        return ((Object)other.getQualifiedExtraAttributes()).equals(this.getQualifiedExtraAttributes());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.getBranch() == null ? 0 : this.getBranch().hashCode());
            this.hash = this.hash * 13 + this.getRevision().hashCode();
            this.hash = this.hash * 13 + this.getModuleId().hashCode();
            this.hash = this.hash * 13 + ((Object)this.getQualifiedExtraAttributes()).hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.moduleId + (this.branch == null || this.branch.length() == 0 ? "" : "#" + this.branch) + ";" + (this.revision == null ? "NONE" : this.revision);
    }

    public String encodeToString() {
        StringBuffer buf = new StringBuffer();
        Map attributes = this.getAttributes();
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String attName = (String)iter.next();
            String value = (String)attributes.get(attName);
            value = value == null ? NULL_ENCODE : value;
            buf.append(ENCODE_PREFIX).append(attName).append(ENCODE_SEPARATOR).append(ENCODE_PREFIX).append(value).append(ENCODE_SEPARATOR);
        }
        return buf.toString();
    }

    public static ModuleRevisionId decode(String encoded) {
        String[] parts = encoded.split(ENCODE_SEPARATOR);
        if (parts.length % 2 != 0) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "'");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < parts.length; i += 2) {
            String attName = parts[i];
            if (!attName.startsWith(ENCODE_PREFIX)) {
                throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': " + attName + " doesn't start with " + ENCODE_PREFIX);
            }
            attName = attName.substring(1);
            String attValue = parts[i + 1];
            if (!attValue.startsWith(ENCODE_PREFIX)) {
                throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': " + attValue + " doesn't start with " + ENCODE_PREFIX);
            }
            if (NULL_ENCODE.equals(attValue = attValue.substring(1))) {
                attValue = null;
            }
            attributes.put(attName, attValue);
        }
        String org = (String)attributes.remove("organisation");
        String mod = (String)attributes.remove("module");
        String rev = (String)attributes.remove("revision");
        String branch = (String)attributes.remove("branch");
        if (org == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no organisation");
        }
        if (mod == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no module name");
        }
        if (rev == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no revision");
        }
        return ModuleRevisionId.newInstance(org, mod, branch, rev, attributes);
    }

    public String getBranch() {
        return this.branch;
    }
}

