package Plugins::TransitionUpdater::Plugin;

# TransitionUpdater/Plugin.pm by James Sutula(jsutula@sutula.us) March 2008

# This code is derived from code with the following copyright message:
#
# SqueezeCenter Copyright 2001-2007 Logitech.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;
use Time::HiRes;

use base qw(Slim::Plugin::Base);

use Plugins::TransitionUpdater::Settings;

use Scalar::Util qw(blessed);

use Slim::Control::Request;
use Slim::Utils::Log;
use Slim::Utils::Prefs;
use Slim::Player::ReplayGain;


my $prefs = preferences('plugin.transitionupdater');

my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.transitionupdater',
	'defaultLevel' => 'ERROR',
	'description'  => getDisplayName(),
});


sub getDisplayName {
	return 'PLUGIN_TRANSITION_UPDATER';
}

sub initPlugin {
	my $class = shift;

	$class->SUPER::initPlugin();
	Slim::Control::Request::subscribe(\&commandCallback, 
                                    [['playlist'], ['newsong']]);

	Plugins::TransitionUpdater::Settings->new;

	if ((defined $prefs->get('random_transition_duration')) != 1) {
		$prefs->set('random_transition_duration', 10);
	}
	if ((defined $prefs->get('random_transition_type')) != 1) {
		$prefs->set('random_transition_type', 1);
	}
	if ((defined $prefs->get('album_transition_duration')) != 1) {
		$prefs->set('album_transition_duration', 0);
	}
	if ((defined $prefs->get('album_transition_type')) != 1) {
		$prefs->set('album_transition_type', 0);
	}
	
	
}

sub shutdownPlugin {
	Slim::Control::Request::unsubscribe(\&commandCallback);
}

sub commandCallback {

	my $request = shift;
	my $client = $request->client();

	#if next or previous song is album match, use playing album options
	if (Slim::Player::ReplayGain->trackAlbumMatch($client, -1) || Slim::Player::ReplayGain->trackAlbumMatch($client, 1))
	{
		preferences('server')->client($client)->set("transitionDuration",$prefs->get('album_transition_duration'));
		preferences('server')->client($client)->set("transitionType",$prefs->get('album_transition_type'));
		if ($log->is_debug)
		{
			$log->debug("TU: Using transition preferences for playing an album.\n");
		}
	}
	#else use playing random tracks option
	else
	{
		preferences('server')->client($client)->set("transitionDuration",$prefs->get('random_transition_duration'));
		preferences('server')->client($client)->set("transitionType",$prefs->get('random_transition_type'));
		if ($log->is_debug)
		{
			$log->debug("TU: Using transition preferences for random tracks.\n");
		}
	}	
}





1;
