/*
 * Decompiled with CFR 0.152.
 */
package ptolemy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import ptolemy.Plot;
import ptolemy.PlotBox;
import ptolemy.PlotPoint;
import starlogo.LineWidget;
import starlogo.StarLogo;

public class LineLive
extends Plot {
    int n;
    double val;
    LineWidget lw;
    public double time = 0.0;
    public Hashtable hashtable = new Hashtable();
    private double d1 = 0.0;
    private double d2 = 0.0;
    private double d3 = 0.0;
    private boolean _first = true;
    private double _count = 0.0;

    public LineLive(LineWidget lineWidget, int n) {
        this.lw = lineWidget;
        this.type = n;
        this.num = 1;
        this.initme();
    }

    public PlotBox copy(LineWidget lineWidget) {
        LineLive lineLive = new LineLive(lineWidget, this.type);
        super.copy(lineWidget, lineLive);
        lineLive.n = this.n;
        lineLive.val = this.val;
        lineLive.time = this.time;
        return lineLive;
    }

    public void allOff() {
        this.setGrid(false);
        this.setTitle("", this.lw.tbc.getPreTitle());
        this.setXLabel("");
        this.setYLabel("");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return "False";
        }
    }

    public void initme() {
        this.setupLineWidget(this.lw);
        if (StarLogo.DEBUG) {
            System.out.println("initialized lw");
        }
        this.setGrid(false);
        this.setBars(false);
        this.setConnected(true);
        this.setButtons(false);
        this.setPointsPersistence(0);
        this.setMarksStyle("none");
        if (this.type == 0) {
            this.setBars(true);
            this.setConnected(false);
        }
        if (this.type == 4 || this.type == 3) {
            this.setBars(false);
            this.setMarksStyle("points");
        }
        if (this.type == 3) {
            this.setConnected(false);
        }
    }

    public synchronized void addDataPoint(int n, double d) {
        if (this.type == 1) {
            this.addPoint(n, (int)this.time, d, true);
            this.time += 1.0 / (double)this.num;
        }
        if (this.type == 0) {
            this.addPoint(1, n, d, false);
        }
    }

    public synchronized void addPoints() {
        throw new RuntimeException("not implemented; use addDataPoint and addDataPointToVector instead");
    }

    public synchronized void addDataPoint(int n, double d, double d2) {
        if (StarLogo.DEBUG) {
            System.out.println("add data point: " + n + "," + d + "," + d2);
        }
        this.addPoint(n, d, d2, true);
    }

    public synchronized void addDataPointToHash(int n, int n2, double d, double d2) {
        this.addHashPoint(n, n2, d, d2);
        if (this.type == 0) {
            // empty if block
        }
    }

    public synchronized void addHashPoint(int n, int n2, double d, double d2) {
        Integer n3 = new Integer(n);
        PlotPoint plotPoint = new PlotPoint();
        plotPoint.x = d;
        plotPoint.y = d2;
        Hashtable hashtable = null;
        if (this.hashtable.get(n3) == null) {
            hashtable = new Hashtable();
            hashtable.put(new Integer(n2), plotPoint);
            this.hashtable.put(n3, hashtable);
        } else {
            Integer n4 = new Integer(n2);
            hashtable = (Hashtable)this.hashtable.get(n3);
            if (hashtable.get(n4) != null) {
                PlotPoint plotPoint2 = (PlotPoint)hashtable.get(n4);
                this.erasePoint(n, plotPoint2.x, plotPoint2.y);
            }
            hashtable.put(n4, plotPoint);
        }
        this.addPoint(n, d, d2, this.getConnected());
    }

    public synchronized void removeHashPoint(int n) {
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2;
            Hashtable hashtable;
            Integer n3 = (Integer)enumeration.nextElement();
            if (this.hashtable.get(n3) == null || (hashtable = (Hashtable)this.hashtable.get(n3)).get(n2 = new Integer(n)) == null) continue;
            PlotPoint plotPoint = (PlotPoint)hashtable.get(n2);
            this.erasePoint(n3, plotPoint.x, plotPoint.y);
            hashtable.remove(n2);
        }
    }

    public synchronized void erasePoint(int n, double d, double d2) {
        Vector vector;
        PlotPoint plotPoint = null;
        try {
            vector = (Vector)this._points.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            plotPoint = (PlotPoint)vector.elementAt(n2);
            if (plotPoint.x == d && plotPoint.y == d2) {
                vector.removeElementAt(n2);
                return;
            }
            ++n2;
        }
    }

    public synchronized void addDataPointToVector(int n, double d, double d2, int n2) {
        throw new RuntimeException("addDataPointToVector not implemented.  use addDataPointToHash() instead.");
    }

    public synchronized void ppreset(int n) {
        this.clear(n);
    }

    public void setNum(int n) {
        if (n > 0) {
            this.num = n;
        }
    }

    public int getNum() {
        return this.num;
    }

    public double ppxcor(int n) {
        double d = 0.0;
        try {
            Vector vector = (Vector)this._points.elementAt(n);
            if (vector.size() != 0) {
                d = ((PlotPoint)vector.elementAt((int)(vector.size() - 1))).x;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public double ppycor(int n) {
        double d = 0.0;
        try {
            Vector vector = (Vector)this._points.elementAt(n);
            if (vector.size() != 0) {
                d = ((PlotPoint)vector.elementAt((int)(vector.size() - 1))).y;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public void samplePlot() {
        Random random = new Random();
    }

    public String toString() {
        return LineWidget.getType(this.type) + this.lw.id + (this == this.lw.tbc.widgetPlot ? " widget" : " frame");
    }
}

