/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import starlogo.Colors;
import starlogo.Interface;
import starlogo.Patch;
import starlogo.PatchCanvas;
import starlogo.StarLogo;
import starlogo.Turtle;
import starlogo.TurtleShapes;

public class AltPatchCanvas
extends PatchCanvas
implements ImageProducer {
    ImageConsumer ic;
    int[] pixels;
    int rowbytes;
    int nextlineoffset;
    int nextpatchoffset;

    public void init(Interface interface_) {
        this.parent = interface_;
        this.image = interface_.createImage(this);
        this.xoffset = this.position.x;
        this.yoffset = this.position.y;
        this.rowbytes = this.position.width;
        this.pixels = new int[this.position.width * this.position.height];
        this.nextlineoffset = this.rowbytes * (this.sl.cellsize - 1);
        this.nextpatchoffset = -((this.rowbytes - 1) * this.sl.cellsize);
        this.updateImage();
    }

    public void updateImage() {
        if (this.sl.cellsize < 8) {
            this.updateImageNoShapes();
        } else {
            this.updateImageShapes();
        }
    }

    public void updateImageNoShapes() {
        int n = this.sl.widthp2 + 1;
        int n2 = 0;
        int n3 = this.sl.height;
        while (n3 != 0) {
            int n4 = this.sl.width;
            while (n4 != 0) {
                Patch patch = this.sl.patches[n];
                int n5 = 0;
                n5 = patch.topturtle != null && patch.topturtle.shownp ? Colors.colorarrayints[(int)(patch.topturtle.color * 32.0)] : Colors.colorarrayints[(int)(patch.pc * 32.0)];
                int n6 = this.sl.cellsize;
                while (n6 != 0) {
                    int n7 = this.sl.cellsize - 1;
                    while (n7 >= 0) {
                        this.pixels[n2 + n7] = n5;
                        --n7;
                    }
                    n2 += this.rowbytes;
                    --n6;
                }
                ++n;
                n2 += this.nextpatchoffset;
                --n4;
            }
            n2 += this.nextlineoffset;
            n += 2;
            --n3;
        }
        this.startProduction(this.ic);
        this.uptodate = true;
    }

    public void updateImageShapes() {
        int n = this.sl.widthp2 + 1;
        int n2 = 0;
        int n3 = this.sl.cellsize;
        int n4 = this.sl.height;
        while (n4 != 0) {
            int n5 = this.sl.width;
            while (n5 != 0) {
                int n6;
                int n7;
                Patch patch = this.sl.patches[n];
                if (patch.topturtle != null && patch.topturtle.shownp) {
                    n7 = Colors.colorarrayints[(int)(patch.topturtle.color * 32.0)];
                    n6 = Colors.colorarrayints[(int)(patch.pc * 32.0)];
                    TurtleShapes turtleShapes = TurtleShapes.getShape(patch.topturtle.shape);
                    int n8 = (int)((patch.topturtle.heading + 11.25) / 22.5) % 16;
                    double[] dArray = turtleShapes.getColorsForSize(n3)[n8];
                    int[] nArray = turtleShapes.getMasksForSize(n3)[n8];
                    int n9 = 0;
                    int n10 = 0;
                    while (n9 < n3) {
                        int n11 = 0;
                        while (n11 < n3) {
                            this.pixels[n2 + n11] = nArray[2 * n10] == -1 ? n7 : (nArray[2 * n10 + 1] == -1 ? n6 : Colors.colorarrayints[(int)(dArray[n10] * 32.0)]);
                            ++n10;
                            ++n11;
                        }
                        n2 += this.rowbytes;
                        ++n9;
                    }
                } else {
                    n7 = Colors.colorarrayints[(int)(patch.pc * 32.0)];
                    n6 = n3;
                    while (n6 != 0) {
                        int n12 = n3 - 1;
                        while (n12 >= 0) {
                            this.pixels[n2 + n12] = n7;
                            --n12;
                        }
                        n2 += this.rowbytes;
                        --n6;
                    }
                }
                ++n;
                n2 += this.nextpatchoffset;
                --n5;
            }
            n2 += this.nextlineoffset;
            n += 2;
            --n4;
        }
        this.startProduction(this.ic);
        this.uptodate = true;
    }

    void drawPatch(double d, double d2, double d3) {
        this.drawPatch(d, d2, d3, this.sl.patches);
    }

    void drawPatch(double d, double d2, double d3, Patch[] patchArray) {
        this.drawCell((int)d, (int)d2, Colors.colorarrayints[(int)(d3 * 32.0)]);
    }

    void drawPatch(Patch patch) {
        this.drawPatch(patch, this.sl.patches);
    }

    void drawPatch(Patch patch, Patch[] patchArray) {
        this.drawCell((int)patch.xcor - 1, (int)patch.ycor - 1, Colors.colorarrayints[(int)(patch.pc * 32.0)]);
    }

    void drawTurtle(Turtle turtle) {
        this.drawTurtle(turtle, this.sl.patches);
    }

    void drawTurtle(Turtle turtle, Patch[] patchArray) {
        int n;
        int n2 = this.sl.cellsize;
        if (n2 < 8) {
            this.drawCell((int)turtle.xcor, (int)turtle.ycor, Colors.colorarrayints[(int)(turtle.color * 32.0)]);
            return;
        }
        int n3 = (int)turtle.xcor * n2;
        int n4 = (int)turtle.ycor * n2;
        int n5 = n = n3 + n4 * this.rowbytes;
        int n6 = Colors.colorarrayints[(int)(turtle.color * 32.0)];
        int n7 = Colors.colorarrayints[(int)(patchArray[turtle.patch].pc * 32.0)];
        boolean bl = false;
        TurtleShapes turtleShapes = TurtleShapes.getShape(turtle.shape);
        int n8 = (int)((turtle.heading + 11.25) / 22.5 % 16.0);
        double[] dArray = turtleShapes.getColorsForSize(n2)[n8];
        int[] nArray = turtleShapes.getMasksForSize(n2)[n8];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            while (n11 < n2) {
                n9 = n10 * n2 + n11;
                this.pixels[n + n11] = nArray[2 * n9] == -1 ? n6 : (nArray[2 * n9 + 1] == -1 ? n7 : Colors.colorarrayints[(int)(dArray[n9] * 32.0)]);
                ++n11;
            }
            n += this.rowbytes;
            ++n10;
        }
        if (this.ic != null) {
            this.ic.setPixels(n3, n4, n2, n2, Colors.cm, this.pixels, n5, this.rowbytes);
        }
        this.sl.patchesneedalittleredrawingp = true;
        this.uptodate = true;
    }

    void drawCell(int n, int n2, int n3) {
        int n4;
        int n5 = this.sl.cellsize;
        int n6 = n * n5;
        int n7 = n2 * n5;
        int n8 = n4 = n6 + n7 * this.rowbytes;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = 0;
            while (n10 < n5) {
                this.pixels[n4 + n10] = n3;
                ++n10;
            }
            n4 += this.rowbytes;
            ++n9;
        }
        if (this.ic != null) {
            this.ic.setPixels(n6, n7, n5, n5, Colors.cm, this.pixels, n8, this.rowbytes);
        }
        this.sl.patchesneedalittleredrawingp = true;
        this.uptodate = true;
    }

    public void printPixels(int n, int n2) {
        int n3 = this.sl.widthp2 + 1;
        int n4 = 0;
        int n5 = this.sl.height;
        while (n5 != 0) {
            int n6 = this.sl.width;
            while (n6 != 0) {
                Patch patch = this.sl.patches[n3];
                int n7 = Colors.colorarrayints[(int)((patch.topturtle != null && patch.topturtle.shownp ? patch.topturtle.color : patch.pc) * 32.0)];
                if (n != this.sl.width - n6 || n2 == this.sl.height - n5) {
                    // empty if block
                }
                int n8 = this.sl.cellsize;
                while (n8 != 0) {
                    int n9 = this.sl.cellsize - 1;
                    while (n9 >= 0) {
                        this.pixels[n4 + n9] = n7;
                        --n9;
                    }
                    n4 += this.rowbytes;
                    --n8;
                }
                ++n3;
                n4 += this.nextpatchoffset;
                --n6;
            }
            n4 += this.nextlineoffset;
            n3 += 2;
            --n5;
        }
    }

    public void setOffscreen(boolean bl) {
        this.sl.offscreen = bl;
        if (bl) {
            this.sl.locked = true;
            this.updateImage();
            this.xoffset = 0;
            this.yoffset = 0;
        } else {
            this.xoffset = this.position.x;
            this.yoffset = this.position.y;
        }
    }

    public void clearImage() {
        int n = this.position.height * this.position.width;
        int n2 = 0;
        while (n2 < n) {
            this.pixels[n2] = Colors.colorarrayints[0];
            ++n2;
        }
        this.startProduction(this.ic);
    }

    public void refresh() {
        if (this.ic != null) {
            this.ic.imageComplete(2);
            this.startProduction(this.ic);
        }
        this.parent.repaint(this.position);
    }

    public void paint(Graphics graphics) {
        if (this.parent.resizingp() && this.parent.widgetTouched() == this) {
            graphics.drawImage(this.image, this.originalPosition.x, this.originalPosition.y, this);
            graphics.setColor(Color.gray);
            graphics.drawRect(this.position.x, this.position.y, this.position.width, this.position.height);
        } else {
            boolean bl = this.getOffscreen();
            boolean bl2 = false;
            if (bl != this.sl.offscreen) {
                this.setOffscreen(bl);
                boolean bl3 = bl2 = !bl;
            }
            if (!this.uptodate && this.displayp) {
                this.updateImage();
            }
            graphics.drawImage(this.image, this.position.x, this.position.y, this);
            if (bl2 && this.sl.locked) {
                this.sl.locked = false;
                this.sl.runningp.notify();
            }
        }
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.ic = null;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.position.width, this.position.height, Colors.cm, this.pixels, 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (imageConsumer == null) {
            return;
        }
        if (this.ic == null) {
            this.ic = imageConsumer;
            imageConsumer.setColorModel(Colors.cm);
            imageConsumer.setDimensions(this.position.width, this.position.height);
        }
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.position.width, this.position.height, Colors.cm, this.pixels, 0, this.rowbytes);
        imageConsumer.imageComplete(2);
    }

    public void setDrawingSurface() {
    }

    public AltPatchCanvas(StarLogo starLogo) {
        super(starLogo);
    }

    public AltPatchCanvas(StarLogo starLogo, PatchCanvas patchCanvas) {
        super(starLogo, patchCanvas);
    }
}

