/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import starlogo.Colors;
import starlogo.Interface;
import starlogo.Widget;
import starlogo.WidgetLite;

public class Colortool
extends Widget
implements MouseListener {
    static int cellWidth1 = 15;
    static int cellWidth2 = 21;
    static int cellHeight = 24;
    static int cellHeight1 = 15;
    static int cellHeight2 = 21;
    static int cellWidth = 24;
    private Interface iface;
    public FontMetrics fm;
    public Font font;
    public int colorDown = 0;
    public int shadeDown = 5;
    public int curcolor = 5;
    boolean horizontalp;

    public void pointToButton(int n, int n2) {
        if (this.horizontalp) {
            int n3 = (int)Math.floor((n2 - this.position.y) / cellHeight);
            if (n3 == 0) {
                int n4 = (int)Math.floor((n - this.position.x) / cellWidth1);
                this.setColor(n4, this.shadeDown);
            } else {
                int n5 = (int)Math.floor((n - this.position.x) / cellWidth2);
                this.setColor(this.colorDown, n5);
            }
        } else {
            int n6 = (int)Math.floor((n - this.position.x) / cellWidth);
            if (n6 == 0) {
                int n7 = (int)Math.floor((n2 - this.position.y) / cellHeight1);
                this.setColor(n7, this.shadeDown);
            } else {
                int n8 = (int)Math.floor((n2 - this.position.y) / cellHeight2);
                this.setColor(this.colorDown, n8);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.position.contains(new Point(mouseEvent.getX(), mouseEvent.getY()))) {
            return;
        }
        this.pointToButton(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setColor(int n) {
        if (n < 0 || n > 139) {
            this.iface.colorchooser().restoreOld();
            return;
        }
        this.setColor(n / 10, n % 10);
    }

    public void setColor(int n, int n2) {
        if (n == this.colorDown && n2 == this.shadeDown) {
            return;
        }
        this.colorDown = n;
        this.shadeDown = n2;
        this.curcolor = this.colorDown * 10 + this.shadeDown;
        this.parent.colorchooser().setColor(this.curcolor);
        this.parent.paintselect().updateTurtleColor(Colors.colorarray[this.curcolor * 32]);
        this.parent.addToClipRect(this.position);
        this.parent.addToClipRect(this.parent.paintselect().position);
        this.iface.repaint(this.iface.clipRect());
    }

    public void paint(Graphics graphics) {
        graphics.translate(this.position.x, this.position.y);
        Color color = graphics.getColor();
        if (this.horizontalp) {
            int n;
            int n2 = 0;
            while (n2 < 14) {
                n = n2 * 10 + this.shadeDown;
                graphics.setColor(Colors.colorarray[n * 32]);
                graphics.fillRect(n2 * cellWidth1, 0, cellWidth1, cellHeight);
                ++n2;
            }
            Color color2 = Colors.colorarray[this.curcolor * 32];
            n = 255 - color2.getBlue();
            int n3 = 255 - color2.getGreen();
            int n4 = 255 - color2.getRed();
            Color color3 = new Color(n4, n3, n);
            graphics.setColor(color3);
            graphics.drawRect(this.colorDown * cellWidth1, 0, cellWidth1 - 1, cellHeight - 1);
            int n5 = 0;
            while (n5 < 10) {
                int n6 = this.colorDown * 10 + n5;
                graphics.setColor(Colors.colorarray[n6 * 32]);
                graphics.fillRect(n5 * cellWidth2, cellHeight, cellWidth2, cellHeight);
                ++n5;
            }
            graphics.setColor(color3);
            graphics.drawRect(this.shadeDown * cellWidth2, cellHeight, cellWidth2 - 1, cellHeight - 1);
        } else {
            int n;
            int n7 = 0;
            while (n7 < 14) {
                n = n7 * 10 + this.shadeDown;
                graphics.setColor(Colors.colorarray[n * 32]);
                graphics.fillRect(0, n7 * cellHeight1, cellWidth, cellHeight1);
                ++n7;
            }
            Color color4 = Colors.colorarray[this.curcolor * 32];
            n = 255 - color4.getBlue();
            int n8 = 255 - color4.getGreen();
            int n9 = 255 - color4.getRed();
            Color color5 = new Color(n9, n8, n);
            graphics.setColor(color5);
            graphics.drawRect(0, this.colorDown * cellHeight1, cellWidth - 1, cellHeight1 - 1);
            int n10 = 0;
            while (n10 < 10) {
                int n11 = this.colorDown * 10 + n10;
                graphics.setColor(Colors.colorarray[n11 * 32]);
                graphics.fillRect(cellWidth, n10 * cellHeight2, cellWidth, cellHeight2);
                ++n10;
            }
            graphics.setColor(color5);
            graphics.drawRect(cellWidth, this.shadeDown * cellHeight2, cellWidth - 1, cellHeight2 - 1);
        }
        graphics.setColor(color);
        graphics.translate(-this.position.x, -this.position.y);
    }

    public Colortool(Interface interface_) {
        this(interface_, true);
    }

    public Colortool(Interface interface_, boolean bl) {
        super(interface_);
        this.horizontalp = bl;
        this.position = new Rectangle(0, 0, bl ? 210 : 48, bl ? 48 : 210);
        this.iface = interface_;
        this.font = WidgetLite.WIDGET_FONT;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
    }

    public Colortool() {
        this(true);
    }

    public Colortool(boolean bl) {
        this.horizontalp = bl;
        this.position = new Rectangle(0, 0, bl ? 210 : 48, bl ? 48 : 210);
    }
}

