/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.util.Vector;
import starlogo.Observer;
import starlogo.Patch;
import starlogo.StarLogo;
import starlogo.Turtle;
import starlogo.Utilities;

public class ExtraInfo {
    public static final String[] FUNCTIONS = new String[]{"number of", "average of", "min of", "max of", "variance of", "globals"};
    public static final String[] STATS = new String[]{"", "count-", "sum-of-", "min-of-", "max-of-", "sum-of-", ""};
    public static final String[] STATS_END = new String[]{"", "", "/ count-turtles", "", "", "", ""};
    public int id = 0;
    public int order = 0;
    public boolean onExtra = true;
    public int instIndex = 0;
    public int breedIndex = 0;
    public int varIndex = 0;
    public String instString = "number of";
    public String breedString = "turtle";
    public String varString = "";
    public boolean onWith = false;
    public String withText = " true ";
    public boolean onNumber = true;
    public boolean xyOn = false;
    public boolean xVal = false;

    public String getInstFromEI() {
        return this.getInstFromEI(this.instString);
    }

    public String getInstFromEI(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.onExtra) {
            if (string.equals("number of")) {
                if (this.breedString.equals("patches")) {
                    stringBuffer.append("( count-patches-with [");
                    if (this.onWith) {
                        stringBuffer.append(this.withText).append("] )");
                    } else {
                        stringBuffer.append("1 = 1] )");
                    }
                    return stringBuffer.toString();
                }
                stringBuffer.append("( count-").append(this.breedString);
                if (this.onWith) {
                    stringBuffer.append("-with [").append(this.withText).append("] )");
                    return stringBuffer.toString();
                }
                stringBuffer.append(") ");
                return stringBuffer.toString();
            }
            if (string.equals("average of")) {
                if (this.onWith) {
                    stringBuffer.append(" (average-of-");
                    stringBuffer.append(this.breedString);
                    stringBuffer.append("-with ( ");
                    stringBuffer.append(this.withText);
                    stringBuffer.append(" ) [ ");
                    stringBuffer.append(this.varString);
                    stringBuffer.append(" ] ) ");
                } else {
                    stringBuffer.append(" (average-of-");
                    stringBuffer.append(this.breedString);
                    stringBuffer.append(" [ ");
                    stringBuffer.append(this.varString);
                    stringBuffer.append(" ] ) ");
                }
                return stringBuffer.toString();
            }
            if (string.equals("max of") || string.equals("min of")) {
                stringBuffer.append("( ").append(string.substring(0, 3)).append("-of-").append(this.breedString);
                if (this.onWith) {
                    stringBuffer.append("-with (").append(this.withText).append(") ");
                    stringBuffer.append("[").append(this.varString).append("] )");
                    return stringBuffer.toString();
                }
                stringBuffer.append(" [").append(this.varString).append("] )");
                return stringBuffer.toString();
            }
            if (string.equals("variance of")) {
                if (this.onWith) {
                    stringBuffer.append(" ( variance-of-");
                    stringBuffer.append(this.breedString);
                    stringBuffer.append("-with (").append(this.withText).append(") ");
                    stringBuffer.append("[ ").append(this.varString).append("] )");
                } else {
                    stringBuffer.append(" ( variance-of-");
                    stringBuffer.append(this.breedString);
                    stringBuffer.append(" [ ").append(this.varString).append(" ] ");
                }
                return stringBuffer.toString();
            }
            if (string.equals("globals")) {
                stringBuffer.append(this.varString);
                return stringBuffer.toString();
            }
            if (string.equals("histogram")) {
                if (this.onWith) {
                    if (!this.xyOn) {
                        stringBuffer.append(" ask-").append(this.breedString).append(" [ ");
                        stringBuffer.append("if (").append(this.withText).append(") [ %ptolemy-plot " + this.order + " ");
                        stringBuffer.append(this.id + " (" + this.varString + ") ] ]");
                        return stringBuffer.toString();
                    }
                    if (this.xVal) {
                        stringBuffer.append("(").append(this.varString).append(") ] ]");
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(" ask-").append(this.breedString).append(" [ ");
                    stringBuffer.append("if (").append(this.withText).append(") [ %ptolemy-plotxy " + this.order + " ");
                    stringBuffer.append(this.id + " ( " + this.varString + ") ");
                    return stringBuffer.toString();
                }
                if (!this.xyOn) {
                    stringBuffer.append(" ask-").append(this.breedString).append(" [ %ptolemy-plot " + this.order + " ");
                    stringBuffer.append(this.id + " (" + this.varString + ") ]");
                    return stringBuffer.toString();
                }
                if (this.xVal) {
                    stringBuffer.append("(").append(this.varString).append(") ]");
                    return stringBuffer.toString();
                }
                stringBuffer.append(" ask-").append(this.breedString).append(" [ %ptolemy-plotxy " + this.order + " ");
                stringBuffer.append(this.id + " ( " + this.varString + ") ");
                return stringBuffer.toString();
            }
        }
        return "";
    }

    public static String[] getBreeds() {
        String[] stringArray = new String[Turtle.getNumBreeds()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = Turtle.getBreedName(n);
            ++n;
        }
        return stringArray;
    }

    public static String[] getTurtleVars() {
        String[] stringArray = new String[Turtle.getNumVars() + 3];
        stringArray[0] = "Xcor";
        stringArray[1] = "Ycor";
        stringArray[2] = "Heading";
        int n = 3;
        while (n < stringArray.length) {
            stringArray[n] = Turtle.getVarName(n - 3);
            if (StarLogo.DEBUG) {
                System.out.println("variable: " + stringArray[n]);
            }
            ++n;
        }
        return stringArray;
    }

    public static String[] getPatchVars() {
        String[] stringArray = new String[Patch.getNumVars() + 2];
        stringArray[0] = "Xcor";
        stringArray[1] = "Ycor";
        int n = 2;
        while (n < stringArray.length) {
            stringArray[n] = Patch.getVarName(n - 2);
            ++n;
        }
        return stringArray;
    }

    public static String[] getObserverVars() {
        String[] stringArray = new String[Observer.getNumVars()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = Observer.getVarName(n);
            ++n;
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        ExtraInfo extraInfo = new ExtraInfo(1, 1, false);
        extraInfo.onExtra = stringArray[0].equals("true");
        extraInfo.instString = stringArray[1];
        extraInfo.breedString = stringArray[2];
        extraInfo.varString = stringArray[3];
        boolean bl = extraInfo.onWith = stringArray[4].equals("true");
        if (extraInfo.onWith) {
            extraInfo.withText = stringArray[5];
        }
    }

    public static ExtraInfo load(int n, int n2, Vector vector, int n3, int n4) {
        return ExtraInfo.load(n, n2, vector, "", n3, n4);
    }

    public static ExtraInfo load(int n, int n2, Vector vector, String string, int n3, int n4) {
        int n5 = n3;
        String string2 = "extrainfo" + (string.equals("") ? "" : "-" + string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        while (n5 < n4) {
            String string7 = vector.elementAt(n5).toString();
            if (string7.equals(string2 + "-extra?")) {
                bl = vector.elementAt(n5 + 1).toString().equals("true");
                n5 += 2;
                continue;
            }
            if (string7.equals(string2 + "-instruction")) {
                string3 = vector.elementAt(n5 + 1).toString();
                n5 += 2;
                continue;
            }
            if (string7.equals(string2 + "-breed")) {
                string4 = vector.elementAt(n5 + 1).toString();
                n5 += 2;
                continue;
            }
            if (string7.equals(string2 + "-var")) {
                string5 = vector.elementAt(n5 + 1).toString();
                n5 += 2;
                continue;
            }
            if (string7.equals(string2 + "-with?")) {
                bl2 = vector.elementAt(n5 + 1).toString().equals("true");
                n5 += 2;
                continue;
            }
            if (string7.equals(string2 + "-with-text")) {
                string6 = vector.elementAt(n5 + 1).toString();
                n5 += 2;
                continue;
            }
            if (string7.equals(string2 + "-xy?")) {
                bl3 = vector.elementAt(n5 + 1).toString().equals("true");
                n5 += 2;
                continue;
            }
            if (string7.equals(string2 + "-xval?")) {
                bl4 = vector.elementAt(n5 + 1).toString().equals("true");
                n5 += 2;
                continue;
            }
            n5 += 2;
        }
        if (bl) {
            return new ExtraInfo(n, n2, true, string3, string4, string5, bl2, string6, bl3, bl4);
        }
        return new ExtraInfo(n, n2, false);
    }

    public String getSaveString() {
        return this.getSaveString("");
    }

    public String getSaveString(String string) {
        String string2;
        String string3 = "extrainfo" + (string.equals("") ? "" : "-" + string);
        if (this.onExtra) {
            string2 = string3 + "-extra? true\r\n" + string3 + "-instruction \"" + Utilities.printable(this.instString) + "\"\r\n" + string3 + "-breed \"" + Utilities.printable(this.breedString) + "\"\r\n" + string3 + "-var \"" + Utilities.printable(this.varString) + "\"\r\n";
            string2 = this.onWith ? string2 + string3 + "-with? true\r\n" + string3 + "-with-text \"" + Utilities.printable(this.withText) + "\"\r\n" : string2 + string3 + "-with false\r\n";
            string2 = string2 + string3 + "-xy? " + (this.xyOn ? "true" : "false") + "\r\n";
            string2 = string2 + string3 + "-xval? " + (this.xVal ? "true" : "false") + "\r\n";
        } else {
            string2 = string3 + "-extra false\r\n";
        }
        return string2;
    }

    public String toString() {
        return this.getSaveString();
    }

    ExtraInfo copy(int n, int n2) {
        ExtraInfo extraInfo = new ExtraInfo(n, n2);
        extraInfo.onExtra = this.onExtra;
        extraInfo.instIndex = this.instIndex;
        extraInfo.breedIndex = this.breedIndex;
        extraInfo.varIndex = this.varIndex;
        extraInfo.instString = this.instString;
        extraInfo.breedString = this.breedString;
        extraInfo.varString = this.varString;
        extraInfo.onWith = this.onWith;
        extraInfo.withText = this.withText;
        extraInfo.onNumber = this.onNumber;
        extraInfo.xyOn = this.xyOn;
        extraInfo.xVal = this.xVal;
        return extraInfo;
    }

    ExtraInfo(int n, int n2) {
        this.id = n;
        this.order = n2;
    }

    ExtraInfo(int n, int n2, boolean bl) {
        this.id = n;
        this.order = n2;
        this.onExtra = bl;
    }

    ExtraInfo(int n, int n2, boolean bl, String string, String string2, String string3, boolean bl2, String string4) {
        this.id = n;
        this.order = n2;
        this.onExtra = bl;
        this.instString = string;
        this.onNumber = this.instString.equals("number of");
        this.breedString = string2;
        this.varString = string3;
        this.onWith = bl2;
        this.withText = string4;
    }

    ExtraInfo(int n, int n2, boolean bl, String string, String string2, String string3, boolean bl2, String string4, boolean bl3, boolean bl4) {
        this.id = n;
        this.order = n2;
        this.onExtra = bl;
        this.instString = string;
        this.onNumber = this.instString.equals("number of");
        this.breedString = string2;
        this.varString = string3;
        this.onWith = bl2;
        this.withText = string4;
        this.xyOn = bl3;
        this.xVal = bl4;
    }
}

