/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import starlogo.Application;
import starlogo.BlueGrid;
import starlogo.ButtonWidget;
import starlogo.CellSizeSliderWidget;
import starlogo.ColorChooser;
import starlogo.ColorLegendWidget;
import starlogo.Colortool;
import starlogo.DoubleInsets;
import starlogo.DwellTimer;
import starlogo.IKeyListener;
import starlogo.Interface;
import starlogo.InterfaceFrame;
import starlogo.JAboutDialog;
import starlogo.JLineDialogPanel;
import starlogo.JPlotDialog;
import starlogo.JShapeEditorPanel;
import starlogo.JShapeEditorRotatePanel;
import starlogo.JShapeEditorSizeChooserPanel;
import starlogo.JShapePaintSelect;
import starlogo.JShapeRotateMenu;
import starlogo.LineWidget;
import starlogo.MonitorWidget;
import starlogo.PaintSelect;
import starlogo.Painttool;
import starlogo.PatchCanvas;
import starlogo.Print;
import starlogo.PrintDialog;
import starlogo.PrintingCanceledException;
import starlogo.Pushable;
import starlogo.SliderWidget;
import starlogo.SmartRectangle;
import starlogo.SpeedSliderWidget;
import starlogo.StarLogo;
import starlogo.StatusToolbar;
import starlogo.StopWidget;
import starlogo.TextWidget;
import starlogo.ToolbarWidget;
import starlogo.TrashWidget;
import starlogo.VM;
import starlogo.Widget;
import starlogo.WidgetClipboard;
import starlogo.WidgetDrag;
import starlogo.WidgetHolder;
import starlogo.WidgetLite;
import yoyo.Tokenizer;
import yoyo.YoYo;

public class InterfaceDelegate {
    static int toolbarheight = 36;
    static int toolbarwidth = 50;
    static int statusbarheight = 24;
    Image image;
    public ToolbarWidget toolbar;
    public StatusToolbar statusbar;
    public StopWidget stopwidget;
    public TrashWidget trashwidget;
    public Container parent;
    public InterfaceFrame frame;
    public WidgetHolder wh;
    boolean overtrashp = false;
    public Vector buttons;
    public Vector sliders;
    public Vector monitors;
    public Vector linewidgets;
    public Vector textwidgets;
    public Vector legends;
    public WidgetClipboard wclipboard;
    Painttool painttool;
    Colortool colortool;
    PaintSelect paintselect;
    SpeedSliderWidget speedsliderwidget;
    CellSizeSliderWidget cellsizesliderwidget;
    ColorChooser colorchooser;
    BlueGrid bluegrid;
    Point anchor;
    boolean snapToGrid = false;
    int BUT_MASK;
    Rectangle paintRect;
    Widget keyboardFocus = null;
    WidgetLite tooltipShown = null;
    IKeyListener ikeylistener;
    public Application app;
    public StarLogo sl;
    public Interface iface;
    boolean pressedShiftControlp = false;
    boolean doubleClickedp = false;
    Widget widgetTouched = null;
    boolean resizingp = false;
    boolean draggingp = false;
    boolean backgroundp = false;
    boolean firstdragp = false;
    boolean firstresizep = false;
    Rectangle clipRect = null;
    private boolean dwellToggle = false;
    private boolean toolTipStart = false;
    private Point dwellPoint = new Point(0, 0);
    private Point dwellPointSave = new Point(1, 1);
    private DwellTimer dwellTimer;
    private Widget dispWidget;
    private Object toolTipLock = new Object();
    private boolean dwellEnable = true;
    Point oldMousePosition = null;
    Point originalMousePosition = null;
    Point resizeAnchor = null;
    int resizeCorner = 0;
    SmartRectangle outline = null;
    Point outlineAnchor = null;

    public void init() {
        if (YoYo.applet != null) {
            this.parent = YoYo.applet;
            YoYo.applet.setLayout(null);
            YoYo.applet.setBackground(Color.white);
            YoYo.applet.setForeground(Color.black);
        }
        this.loadImages();
        this.setupPlatform();
    }

    public void resizeWidgetsOnInterfaceResize() {
        if (this.bluegrid != null) {
            this.bluegrid.updatePosition();
        }
        if (this.stopwidget != null) {
            this.stopwidget.updatePosition();
        }
        if (this.trashwidget != null) {
            this.trashwidget.updatePosition();
        }
        if (this.statusbar != null) {
            this.statusbar.updatePosition();
        }
    }

    public void setTitle(String string) {
        if (YoYo.applet == null) {
            this.frame.setTitle(string);
        }
    }

    public String getTitle() {
        if (YoYo.applet == null) {
            return this.frame.getTitle();
        }
        return "StarLogo Project";
    }

    private final void setupPlatform() {
        this.BUT_MASK = YoYo.macintoshp ? 1 : 2;
    }

    public void createComponents() {
        this.toolbar = new ToolbarWidget(this.iface, true);
        this.statusbar = new StatusToolbar(this.iface);
        this.stopwidget = new StopWidget(this.iface);
        this.trashwidget = new TrashWidget(this.iface);
        this.statusbar.stopwidget = this.stopwidget;
        this.statusbar.trashwidget = this.trashwidget;
        Insets insets = this.parent.getInsets();
        if (YoYo.applet == null) {
            this.bluegrid = new BlueGrid(this.iface);
            this.wh.addGrid(this.bluegrid);
            this.wh.addToolbarWidget(this.toolbar);
            this.toolbar.setLocation(0, 0);
            this.painttool = new Painttool(this.iface, false);
            this.painttool.setLocation(0, 40);
            this.wh.addToolbarWidget(this.painttool);
            this.colortool = new Colortool(this.iface, false);
            this.colortool.setLocation(0, 195);
            this.wh.addToolbarWidget(this.colortool);
            this.paintselect = new PaintSelect(this.iface, false);
            this.paintselect.setLocation(0, 170);
            this.wh.addToolbarWidget(this.paintselect);
            this.colorchooser = new ColorChooser(this.iface);
            this.colorchooser.setLocation(1, 412);
            this.wh.addToolbarWidget(this.colorchooser);
            this.wh.addToolbarWidget(this.statusbar);
            this.wh.addToolbarWidget(this.stopwidget);
            this.wh.addToolbarWidget(this.trashwidget);
            this.statusbar.setLocation(0, this.iface.getSize().height - statusbarheight);
            this.speedsliderwidget = new SpeedSliderWidget(this.iface, new Rectangle(250, 6, 120, 20));
            this.wh.addToolbarWidget(this.speedsliderwidget);
            this.cellsizesliderwidget = new CellSizeSliderWidget(this.iface, new Rectangle(390, 6, 100, 20));
            this.wh.addToolbarWidget(this.cellsizesliderwidget);
        }
        this.wh.setPatchCanvas(this.sl.patchcanvas);
    }

    public void setOutline(int n, int n2, int n3, int n4) {
        this.outline = new SmartRectangle(n, n2, n3, n4);
    }

    public void resetOutline() {
        this.outline = null;
    }

    public void processTimerEvent() {
        if (this.dwellToggle && this.toolTipStart && this.dwellEnable) {
            this.dwellPointSave.setLocation(this.dwellPoint);
        } else {
            Object object = this.toolTipLock;
            synchronized (object) {
                if (this.dwellPointSave.x == this.dwellPoint.x && this.dwellPointSave.y == this.dwellPoint.y && this.dispWidget == null) {
                    this.dispWidget = this.getWidgetAt(this.dwellPointSave.x, this.dwellPointSave.y);
                    if (this.dispWidget != null) {
                        this.dispWidget.displayToolTip(this.dwellPointSave);
                    }
                }
            }
        }
        this.dwellToggle = !this.dwellToggle;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        try {
            Object object;
            switch (mouseEvent.getID()) {
                case 501: {
                    VM.setMouseDown(true);
                    break;
                }
                case 502: {
                    VM.setMouseDown(false);
                    break;
                }
                case 504: {
                    this.dwellEnable = true;
                    break;
                }
                case 505: {
                    this.dwellEnable = false;
                    object = this.toolTipLock;
                    synchronized (object) {
                        if (this.dispWidget != null) {
                            this.dispWidget.dropToolTip();
                            this.dispWidget = null;
                        }
                        break;
                    }
                }
            }
            this.pressedShiftControlp = (mouseEvent.getModifiers() & this.BUT_MASK) != 0 && YoYo.applet == null;
            this.doubleClickedp = mouseEvent.getClickCount() == 2;
            this.clipRect = new Rectangle();
            if (this.widgetTouched == null) {
                object = this.getWidgetAt(mouseEvent.getX(), mouseEvent.getY());
                if (object != null && !this.backgroundp) {
                    this.processWidgetMouseEvent(mouseEvent, (Widget)object);
                } else {
                    object = this.getCornerAt(mouseEvent.getX(), mouseEvent.getY());
                    if (object != null && !this.backgroundp) {
                        this.processResizeEvent(mouseEvent, (Widget)object);
                    } else {
                        if (YoYo.applet != null) {
                            return;
                        }
                        switch (mouseEvent.getID()) {
                            case 501: {
                                this.backgroundp = true;
                                this.mousePressed(mouseEvent);
                                break;
                            }
                            case 502: {
                                this.mouseReleased(mouseEvent);
                                this.backgroundp = false;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        this.iface.repaint(this.clipRect);
                    }
                }
            } else {
                object = this.widgetTouched;
                if (this.resizingp) {
                    this.processResizeEvent(mouseEvent, (Widget)object);
                } else {
                    this.processWidgetMouseEvent(mouseEvent, (Widget)object);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        try {
            VM.setMousePos(mouseEvent.getX(), mouseEvent.getY());
            this.toolTipStart = true;
            this.dwellPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            Object object = this.toolTipLock;
            synchronized (object) {
                if (this.dispWidget != null) {
                    this.dispWidget.dropToolTip();
                    this.dispWidget = null;
                }
            }
            switch (mouseEvent.getID()) {
                case 506: {
                    VM.setMouseDown(true);
                    break;
                }
                case 503: {
                    VM.setMouseDown(false);
                    break;
                }
            }
            this.pressedShiftControlp = (mouseEvent.getModifiers() & this.BUT_MASK) != 0 && YoYo.applet == null;
            this.doubleClickedp = mouseEvent.getClickCount() == 2;
            this.clipRect = new Rectangle();
            Widget widget = this.widgetTouched;
            if (widget != null) {
                if (this.resizingp) {
                    this.processResizeEvent(mouseEvent, widget);
                } else if (mouseEvent.getID() == 506) {
                    this.processWidgetMouseEvent(mouseEvent, widget);
                }
            } else {
                switch (mouseEvent.getID()) {
                    case 506: {
                        this.mouseDragged(mouseEvent);
                        break;
                    }
                    case 503: {
                        this.mouseMoved(mouseEvent);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.iface.repaint(this.clipRect);
            }
            if (!this.sl.runningnowp) {
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.app.log);
        }
    }

    public void processWidgetMouseEvent(MouseEvent mouseEvent, Widget widget) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.widgetTouched = widget;
                if (widget.draggable(mouseEvent)) {
                    this.originalMousePosition = new Point(mouseEvent.getX(), mouseEvent.getY());
                    this.oldMousePosition = new Point(mouseEvent.getX(), mouseEvent.getY());
                    this.firstdragp = true;
                } else {
                    widget.mousePressed(mouseEvent);
                }
                this.iface.repaint(this.clipRect);
                break;
            }
            case 502: {
                if (this.draggingp || widget instanceof Pushable) {
                    widget.mouseReleased(mouseEvent);
                } else if (this.doubleClickedp) {
                    widget.mouseDoubleClicked(mouseEvent);
                } else {
                    if (this.toolbar.buttonDown != 1 && this.maybeEditWidget(widget)) {
                        this.widgetTouched = null;
                        this.draggingp = false;
                        this.resizingp = false;
                        this.firstdragp = false;
                        this.wh.setGrid(false);
                        this.oldMousePosition = null;
                        this.originalMousePosition = null;
                        this.iface.repaint(this.clipRect);
                        return;
                    }
                    if (this.pressedShiftControlp) {
                        if (widget.isSelected()) {
                            this.deselect(widget);
                            this.addHandlesToClipRect(widget);
                        } else {
                            this.select(widget);
                            this.addHandlesToClipRect(widget);
                        }
                    } else if (widget.isSelected()) {
                        this.deselectAll(false);
                        this.select(widget);
                        this.addHandlesToClipRect(widget);
                    } else {
                        if (this.iface.getBoundaries().contains(mouseEvent.getX(), mouseEvent.getY())) {
                            this.deselectAll(false);
                            this.moveToFront(widget);
                        }
                        if (this.getWidgetAt(mouseEvent.getX(), mouseEvent.getY()) == widget || widget instanceof PatchCanvas) {
                            widget.mouseClicked(mouseEvent);
                        }
                    }
                }
                this.widgetTouched = null;
                if (this.draggingp) {
                    this.app.restoreCursor();
                }
                this.draggingp = false;
                this.firstdragp = false;
                this.resizingp = false;
                this.wh.setGrid(false);
                this.oldMousePosition = null;
                this.originalMousePosition = null;
                this.iface.repaint(this.clipRect);
                break;
            }
            case 506: {
                if (this.trashwidget.onPressable(mouseEvent) && widget != this.trashwidget && this.draggingp) {
                    this.trashwidget.press();
                } else {
                    this.trashwidget.reset();
                }
                if (this.firstdragp) {
                    if (this.distanceSquared(this.originalMousePosition, mouseEvent.getX(), mouseEvent.getY()) > 9) {
                        this.draggingp = true;
                        this.app.setCursor(Cursor.getPredefinedCursor(13));
                        if (this.pressedShiftControlp) {
                            this.moveToFront(widget);
                            if (widget instanceof WidgetDrag) {
                                WidgetDrag[] widgetDragArray = new WidgetDrag[]{(WidgetDrag)widget};
                                this.moveWidgets(mouseEvent, widgetDragArray);
                            }
                        } else if (widget.isSelected()) {
                            WidgetDrag[] widgetDragArray = this.wh.getSelectedWidgets(true);
                            int n = 0;
                            while (n < widgetDragArray.length) {
                                this.moveToFront(widgetDragArray[n]);
                                ++n;
                            }
                            this.moveWidgets(mouseEvent, widgetDragArray);
                        } else {
                            if (this.iface.getBoundaries().contains(mouseEvent.getX(), mouseEvent.getY())) {
                                this.deselectAll(false);
                            }
                            this.moveToFront(widget);
                            if (widget instanceof WidgetDrag) {
                                WidgetDrag[] widgetDragArray = new WidgetDrag[]{(WidgetDrag)widget};
                                this.moveWidgets(mouseEvent, widgetDragArray);
                            }
                        }
                        this.firstdragp = false;
                    }
                } else if (this.draggingp) {
                    if (this.pressedShiftControlp) {
                        if (widget instanceof WidgetDrag) {
                            WidgetDrag[] widgetDragArray = new WidgetDrag[]{(WidgetDrag)widget};
                            this.moveWidgets(mouseEvent, widgetDragArray);
                        }
                    } else if (widget.isSelected()) {
                        WidgetDrag[] widgetDragArray = this.wh.getSelectedWidgets(true);
                        this.moveWidgets(mouseEvent, widgetDragArray);
                    } else if (widget instanceof WidgetDrag) {
                        WidgetDrag[] widgetDragArray = new WidgetDrag[]{(WidgetDrag)widget};
                        this.moveWidgets(mouseEvent, widgetDragArray);
                    }
                } else {
                    widget.mouseDragged(mouseEvent);
                }
                this.iface.repaint(this.clipRect);
                break;
            }
            case 503: {
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void moveWidgets(MouseEvent mouseEvent, WidgetDrag[] widgetDragArray) {
        this.trashwidget.mouseDragged(mouseEvent);
        Point point = this.limitPointToView(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (this.snapToGrid && this.firstdragp) {
            this.wh.setGrid(true);
            int n = 0;
            while (n < widgetDragArray.length) {
                widgetDragArray[n].snapToGrid();
                ++n;
            }
        }
        if (!this.oldMousePosition.equals(point)) {
            Point point2 = this.pointSubtract(point, this.oldMousePosition);
            if (this.snapToGrid) {
                point2.x = BlueGrid.gridunit * (point2.x / BlueGrid.gridunit);
                point2.y = BlueGrid.gridunit * (point2.y / BlueGrid.gridunit);
            }
            if (this.snapToGrid) {
                if (point2.x != 0) {
                    this.oldMousePosition.x += point2.x;
                }
                if (point2.y != 0) {
                    this.oldMousePosition.y += point2.y;
                }
            } else {
                this.oldMousePosition = point;
            }
            int n = 0;
            while (n < widgetDragArray.length) {
                if (widgetDragArray[n].isSelected()) {
                    this.addHandlesToClipRect(widgetDragArray[n]);
                } else {
                    this.addToClipRect(widgetDragArray[n].position);
                }
                widgetDragArray[n].moveBy(point2);
                if (widgetDragArray[n].isSelected()) {
                    this.addHandlesToClipRect(widgetDragArray[n]);
                } else {
                    this.addToClipRect(widgetDragArray[n].position);
                }
                ++n;
            }
        }
    }

    public int distanceSquared(Point point, int n, int n2) {
        return (point.x - n) * (point.x - n) + (point.y - n2) * (point.y - n2);
    }

    public Point pointSubtract(Point point, Point point2) {
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    public Point limitPointToView(Point point) {
        Rectangle rectangle = this.iface.getBoundaries();
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        if (point.x > rectangle.x + rectangle.width) {
            point.x = rectangle.x + rectangle.width;
        }
        if (point.y > rectangle.y + rectangle.height) {
            point.y = rectangle.y + rectangle.height;
        }
        return point;
    }

    protected void processResizeEvent(MouseEvent mouseEvent, Widget widget) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.widgetTouched = widget;
                this.moveToFront(widget);
                if (!widget.resizable()) break;
                this.resizingp = true;
                this.firstresizep = true;
                this.resizeAnchor = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.resizeCorner = widget.resizeWhichCorner(this.resizeAnchor);
                this.app.setCursor(this.resizeCursor(this.resizeCorner));
                this.oldMousePosition = this.resizeAnchor;
                break;
            }
            case 502: {
                widget.endResize(mouseEvent, this.resizeCorner);
                this.resizingp = false;
                this.wh.setGrid(false);
                this.widgetTouched = null;
                this.resizeCorner = 0;
                this.resizeAnchor = null;
                this.oldMousePosition = null;
                this.app.restoreCursor();
                this.resetStatus();
                this.iface.repaint(this.clipRect);
                break;
            }
            case 506: {
                Point point = this.limitPointToView(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (this.snapToGrid) {
                    if (this.firstresizep) {
                        this.wh.setGrid(true);
                    }
                    Point point2 = this.pointSubtract(point, this.resizeAnchor);
                    point.x = BlueGrid.gridunit * ((this.resizeAnchor.x + point2.x) / BlueGrid.gridunit);
                    point.y = BlueGrid.gridunit * ((this.resizeAnchor.y + point2.y) / BlueGrid.gridunit);
                }
                this.resizeWidget(point, widget, this.resizeCorner);
                if (widget instanceof PatchCanvas) {
                    this.setStatus("PatchCanvas width: " + widget.position.width / this.sl.cellsize + " PatchCanvas height: " + widget.position.height / this.sl.cellsize);
                } else {
                    this.setStatus("Widget width: " + widget.position.width + " Widget height: " + widget.position.height);
                }
                this.iface.repaint(this.clipRect);
                if (!this.firstresizep) break;
                this.firstresizep = false;
                break;
            }
        }
    }

    protected void resizeWidget(Point point, Widget widget, int n) {
        if (!this.oldMousePosition.equals(point)) {
            widget.resize(point, n);
            this.oldMousePosition = point;
        }
    }

    public Cursor resizeCursor(int n) {
        switch (n) {
            case 1: {
                return Cursor.getPredefinedCursor(6);
            }
            case 2: {
                return Cursor.getPredefinedCursor(7);
            }
            case 3: {
                return Cursor.getPredefinedCursor(4);
            }
            case 4: {
                return Cursor.getPredefinedCursor(5);
            }
            case 5: {
                return Cursor.getPredefinedCursor(8);
            }
            case 6: {
                return Cursor.getPredefinedCursor(9);
            }
            case 7: {
                return Cursor.getPredefinedCursor(10);
            }
            case 8: {
                return Cursor.getPredefinedCursor(11);
            }
        }
        return null;
    }

    protected boolean maybeEditWidget(Widget widget) {
        if (YoYo.applet != null) {
            return false;
        }
        if (widget instanceof ButtonWidget && this.toolbar.buttonDown == 2 || widget instanceof TextWidget && this.toolbar.buttonDown == 5 || widget instanceof SliderWidget && this.toolbar.buttonDown == 3 || widget instanceof MonitorWidget && this.toolbar.buttonDown == 4 || widget instanceof ColorLegendWidget && this.toolbar.buttonDown == 7 || widget instanceof LineWidget && this.toolbar.buttonDown == 6) {
            widget.edit();
            this.toolbar.setButtonDown(1);
            return true;
        }
        return false;
    }

    public void maybeReleasePatchCanvas() {
        if (!this.isObscured(this.sl.patchcanvas)) {
            Object object = this.sl.runningp;
            synchronized (object) {
                this.sl.locked = false;
                this.sl.runningp.notify();
            }
        }
    }

    protected void mousePressed(MouseEvent mouseEvent) {
        if (this.iface.getBoundaries().contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.outline = new SmartRectangle(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
            this.outlineAnchor = new Point(mouseEvent.getX(), mouseEvent.getY());
            if (!this.pressedShiftControlp && this.iface.getBoundaries().contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.deselectAll(false);
            }
        }
    }

    protected void mouseDragged(MouseEvent mouseEvent) {
        if (this.outline == null) {
            return;
        }
        this.addToClipRect(this.outline);
        Point point = this.limitPointToView(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.outline.setWidth(point.x - this.outlineAnchor.x);
        this.outline.setHeight(point.y - this.outlineAnchor.y);
        this.addToClipRect(this.outline);
        this.growClipRect(1, 1);
    }

    protected void mouseReleased(MouseEvent mouseEvent) {
        this.trashwidget.mouseReleased(mouseEvent);
        if (this.outline == null) {
            return;
        }
        if (this.toolbar.buttonDown == 1 || this.toolbar.paintActivep()) {
            this.selectWidgets(this.outline);
        } else {
            if (YoYo.applet == null) {
                switch (this.toolbar.buttonDown) {
                    case 2: {
                        ButtonWidget.createNew(this.iface);
                        break;
                    }
                    case 3: {
                        SliderWidget.createNew(this.iface);
                        break;
                    }
                    case 4: {
                        MonitorWidget.createNew(this.iface);
                        break;
                    }
                    case 5: {
                        TextWidget.createNew(this.iface);
                        break;
                    }
                    case 7: {
                        ColorLegendWidget.createNew(this.iface);
                        break;
                    }
                    case 6: {
                        LineWidget.createNew(this.iface);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.toolbar.setButtonDown(1);
        }
        this.addToClipRect(this.outline);
        this.growClipRect(1, 1);
        this.outline = null;
        this.outlineAnchor = null;
    }

    protected void selectWidgets(Rectangle rectangle) {
        if (YoYo.applet != null) {
            return;
        }
        Enumeration enumeration = this.wh.listDragWidgets();
        while (enumeration.hasMoreElements()) {
            WidgetDrag widgetDrag = (WidgetDrag)enumeration.nextElement();
            if (!((WidgetLite)widgetDrag).intersects(rectangle) || this.toolbar.paintActivep() && widgetDrag instanceof PatchCanvas) continue;
            this.select(widgetDrag);
        }
        if (this.selecting()) {
            this.frame.getMenu().enableCutCopyClearMenu();
            this.addToClipRect(this.wh.getSelectRect());
            this.growClipRect(8, 8);
        }
    }

    protected void trim(Rectangle rectangle) {
        if (rectangle.getLocation().x < 0) {
            rectangle.setLocation(0, rectangle.getLocation().y);
        }
        if (rectangle.getLocation().y < 0) {
            rectangle.setLocation(rectangle.getLocation().x, 0);
        }
    }

    public PatchCanvas getPatchCanvas() {
        return this.wh.getPatchCanvas();
    }

    protected void paintComponents(Graphics graphics, Rectangle rectangle) {
        Enumeration enumeration = this.wh.listAllWidgets();
        while (enumeration.hasMoreElements()) {
            WidgetDrag widgetDrag;
            Widget widget = (Widget)enumeration.nextElement();
            if (widget == null || !widget.intersects(rectangle)) continue;
            widget.paint(graphics);
            if (!(widget instanceof WidgetDrag) || !(widgetDrag = (WidgetDrag)widget).isSelected()) continue;
            widgetDrag.drawCorners(graphics);
        }
    }

    protected void drawOutline(Graphics graphics) {
        graphics.setColor(Color.gray);
        graphics.drawRect(this.outline.x, this.outline.y, this.outline.width, this.outline.height);
    }

    public Widget getWidgetAt(int n, int n2) {
        Enumeration enumeration = this.wh.listAllWidgetsTopDown();
        while (enumeration.hasMoreElements()) {
            Widget widget = (Widget)enumeration.nextElement();
            if (!widget.contains(n, n2)) continue;
            return widget;
        }
        return null;
    }

    public WidgetDrag getCornerAt(int n, int n2) {
        Point point = new Point(n, n2);
        Enumeration enumeration = this.wh.listDragWidgets();
        while (enumeration.hasMoreElements()) {
            WidgetDrag widgetDrag = (WidgetDrag)enumeration.nextElement();
            if (!widgetDrag.isSelected() || !widgetDrag.cornerContains(point)) continue;
            return widgetDrag;
        }
        return null;
    }

    public void moveToFront(Widget widget) {
        if (!(widget instanceof WidgetDrag)) {
            return;
        }
        this.wh.moveToFront((WidgetDrag)widget);
        if (widget.isSelected()) {
            this.addHandlesToClipRect(widget);
        } else {
            this.addToClipRect(widget.position);
        }
    }

    public void markChanged() {
        this.app.project.markChanged();
    }

    public void clearSelections() {
        if (this.selecting()) {
            Rectangle rectangle = this.wh.getSelectRect();
            PatchCanvas cfr_ignored_0 = this.sl.patchcanvas;
            PatchCanvas cfr_ignored_1 = this.sl.patchcanvas;
            rectangle.grow(WidgetDrag.CORNER_WIDTH, WidgetDrag.CORNER_WIDTH);
            this.wh.clearSelections();
            this.iface.repaint(rectangle);
            if (YoYo.macintoshp) {
                this.frame.getMenu().disableClearMenu();
            } else {
                this.frame.getMenu().disableCutCopyClearMenu();
            }
        }
    }

    public void replacePatchCanvas(PatchCanvas patchCanvas, PatchCanvas patchCanvas2) {
        this.replacePatchCanvas(patchCanvas, patchCanvas2, patchCanvas.getLocation().x, patchCanvas.getLocation().y);
    }

    public void replacePatchCanvas(PatchCanvas patchCanvas, PatchCanvas patchCanvas2, int n, int n2) {
        patchCanvas2.setLocation(n, n2);
        this.wh.setPatchCanvas(patchCanvas2);
        patchCanvas2.init(this.iface);
        this.iface.repaint();
        this.sl.patchcanvas.setOffscreen(this.sl.offscreen);
    }

    public void deleteSelections(boolean bl) {
        if (bl) {
            this.clipRect = new Rectangle();
        }
        this.addToClipRect(this.wh.getSelectRect());
        this.clipRect.grow(8, 8);
        WidgetDrag[] widgetDragArray = this.wh.getSelectedWidgets(false);
        if (widgetDragArray != null) {
            int n = 0;
            while (n < widgetDragArray.length) {
                this.removeWidget(widgetDragArray[n]);
                ++n;
            }
        }
        this.wh.clearSelections();
        this.frame.getMenu().disableCutCopyClearMenu();
        if (bl) {
            this.iface.repaint(this.clipRect);
        }
        if (widgetDragArray != null) {
            this.app.rancompilerp = false;
            this.app.project.markChanged();
        }
    }

    public void select(Widget widget) {
        if (widget instanceof WidgetDrag) {
            this.wh.setSelected((WidgetDrag)widget, true);
            this.frame.getMenu().enableCutCopyClearMenu();
        }
    }

    public void deselect(Widget widget) {
        if (widget instanceof WidgetDrag) {
            this.wh.setSelected((WidgetDrag)widget, false);
            if (!this.wh.hasSelections()) {
                this.frame.getMenu().disableCutCopyClearMenu();
            }
        }
    }

    public void select(Widget widget, boolean bl) {
        if (widget instanceof WidgetDrag) {
            this.wh.setSelected((WidgetDrag)widget, bl);
            if (bl) {
                this.frame.getMenu().enableCutCopyClearMenu();
            } else if (!this.wh.hasSelections()) {
                this.frame.getMenu().disableCutCopyClearMenu();
            }
        }
    }

    public void deselectAll(boolean bl) {
        if (YoYo.applet == null) {
            this.colorchooser.restoreOld();
        }
        if (this.selecting()) {
            if (bl) {
                this.clipRect = new Rectangle();
            }
            Rectangle rectangle = this.wh.getSelectRect();
            this.wh.clearSelections();
            this.frame.getMenu().disableCutCopyClearMenu();
            this.addToClipRect(rectangle);
            this.growClipRect(8, 8);
            if (bl) {
                this.iface.repaint(this.clipRect);
            }
        }
    }

    public void selectAll(boolean bl) {
        if (bl) {
            this.clipRect = new Rectangle();
        }
        Enumeration enumeration = this.wh.listDragWidgets();
        while (enumeration.hasMoreElements()) {
            WidgetDrag widgetDrag = (WidgetDrag)enumeration.nextElement();
            if (widgetDrag instanceof PatchCanvas) {
                if (!this.toolbar.paintActivep()) {
                    this.select(widgetDrag);
                }
            } else {
                this.select(widgetDrag);
            }
            this.addHandlesToClipRect(widgetDrag);
        }
        if (bl) {
            this.iface.repaint(this.clipRect);
        }
    }

    protected void mouseMoved(MouseEvent mouseEvent) {
        if (YoYo.applet == null) {
            this.updatePointerCoordinates(new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
        if (this.toolbar.paintActivep() && this.painttool.buttonDown == 9) {
            this.sl.patchcanvas.mouseMoved(mouseEvent);
        }
    }

    protected void updatePointerCoordinates(Point point) {
        Widget widget = this.getWidgetAt(point.x, point.y);
        if (widget instanceof PatchCanvas) {
            PatchCanvas patchCanvas = (PatchCanvas)widget;
            this.statusbar.xcor = new Integer(1 + (point.x - patchCanvas.position.x) / this.sl.cellsize - this.sl.widthp2 / 2);
            this.statusbar.ycor = new Integer((patchCanvas.position.y - point.y) / this.sl.cellsize + this.sl.heightp2 / 2 - 1);
            this.addToClipRect(this.statusbar.position);
        } else if (this.statusbar.xcor != null) {
            this.statusbar.xcor = null;
            this.statusbar.ycor = null;
            this.addToClipRect(this.statusbar.position);
        }
    }

    public void addToClipRect(Rectangle rectangle) {
        if (this.clipRect.isEmpty()) {
            this.clipRect.setBounds(rectangle);
        } else {
            this.clipRect = this.clipRect.union(rectangle);
        }
    }

    public void growClipRect(int n, int n2) {
        this.clipRect.grow(n, n2);
    }

    public void addHandlesToClipRect(Widget widget) {
        Rectangle rectangle = new Rectangle(widget.position);
        rectangle.grow(8, 8);
        this.addToClipRect(rectangle);
    }

    public void addWidget(Widget widget) {
        if (YoYo.applet == null) {
            this.wh.addWidget(widget);
        } else {
            this.wh.addWidget(widget);
        }
        this.addToClipRect(widget.position);
        if (widget instanceof ButtonWidget) {
            this.buttons.addElement(widget);
            return;
        }
        if (widget instanceof SliderWidget) {
            this.sliders.addElement(widget);
            return;
        }
        if (widget instanceof MonitorWidget) {
            this.monitors.addElement(widget);
            return;
        }
        if (widget instanceof LineWidget) {
            this.linewidgets.addElement(widget);
            return;
        }
        if (widget instanceof TextWidget) {
            this.textwidgets.addElement(widget);
            return;
        }
        this.app.project.markChanged();
    }

    public void removeWidget(Widget widget) {
        if (widget.isSelected()) {
            this.addHandlesToClipRect(widget);
        } else {
            this.addToClipRect(widget.position);
        }
        widget.delete();
        this.wh.removeWidget(widget);
        this.app.project.markChanged();
    }

    public boolean isObscured(Widget widget) {
        Enumeration enumeration = this.wh.listAllWidgetsTopDown();
        while (enumeration.hasMoreElements()) {
            Rectangle rectangle;
            Widget widget2 = (Widget)enumeration.nextElement();
            if (widget2 == widget) break;
            if (widget2.isSelected()) {
                rectangle = new Rectangle(widget2.position);
                rectangle.grow(8, 8);
            } else {
                rectangle = widget2.position;
            }
            if (!widget.position.intersects(rectangle)) continue;
            return true;
        }
        return false;
    }

    public Object[] getSliders() {
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.sliders.elements();
        while (enumeration.hasMoreElements()) {
            SliderWidget sliderWidget = (SliderWidget)enumeration.nextElement();
            vector.addElement(sliderWidget.var);
            vector.addElement(new Integer(sliderWidget.id));
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getSlider(int n) {
        Enumeration enumeration = this.sliders.elements();
        while (enumeration.hasMoreElements()) {
            SliderWidget sliderWidget = (SliderWidget)enumeration.nextElement();
            if (sliderWidget.id != n) continue;
            return sliderWidget;
        }
        return YoYo.symfalse;
    }

    public Object getButton(int n) {
        Enumeration enumeration = this.buttons.elements();
        while (enumeration.hasMoreElements()) {
            ButtonWidget buttonWidget = (ButtonWidget)enumeration.nextElement();
            if (buttonWidget.id != n) continue;
            return buttonWidget;
        }
        return YoYo.symfalse;
    }

    public Object getMonitor(int n) {
        Enumeration enumeration = this.monitors.elements();
        while (enumeration.hasMoreElements()) {
            MonitorWidget monitorWidget = (MonitorWidget)enumeration.nextElement();
            if (monitorWidget.id != n) continue;
            return monitorWidget;
        }
        return YoYo.symfalse;
    }

    public Object getLineWidget(int n) {
        Enumeration enumeration = this.linewidgets.elements();
        while (enumeration.hasMoreElements()) {
            LineWidget lineWidget = (LineWidget)enumeration.nextElement();
            if (lineWidget.id != n) continue;
            return lineWidget;
        }
        return YoYo.symfalse;
    }

    public Object getLineWidgetFromTitle(String string) {
        Enumeration enumeration = this.linewidgets.elements();
        while (enumeration.hasMoreElements()) {
            LineWidget lineWidget = (LineWidget)enumeration.nextElement();
            if (!lineWidget.tbc.getTitle().equals(string)) continue;
            return lineWidget;
        }
        return YoYo.symfalse;
    }

    public LineWidget getOldestLineWidget() {
        LineWidget lineWidget = null;
        int n = 0;
        while (n < this.linewidgets.size()) {
            lineWidget = (LineWidget)this.linewidgets.elementAt(n);
            if (!lineWidget.wizardOn) {
                return lineWidget;
            }
            ++n;
        }
        return null;
    }

    public Object getTextWidget(int n) {
        Enumeration enumeration = this.textwidgets.elements();
        while (enumeration.hasMoreElements()) {
            TextWidget textWidget = (TextWidget)enumeration.nextElement();
            if (textWidget.id != n) continue;
            return textWidget;
        }
        return YoYo.symfalse;
    }

    public MonitorWidget[] getMonitors() {
        Object[] objectArray = new MonitorWidget[this.monitors.size()];
        this.monitors.copyInto(objectArray);
        return objectArray;
    }

    public ButtonWidget[] getButtons() {
        Object[] objectArray = new ButtonWidget[this.buttons.size()];
        this.buttons.copyInto(objectArray);
        return objectArray;
    }

    public LineWidget[] getLineWidgets() {
        Object[] objectArray = new LineWidget[this.linewidgets.size()];
        this.linewidgets.copyInto(objectArray);
        return objectArray;
    }

    public TextWidget[] getTextWidgets() {
        Object[] objectArray = new TextWidget[this.textwidgets.size()];
        this.textwidgets.copyInto(objectArray);
        return objectArray;
    }

    public Object[] getPreButtons() {
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.buttons.elements();
        while (enumeration.hasMoreElements()) {
            ButtonWidget buttonWidget = (ButtonWidget)enumeration.nextElement();
            vector.addElement(buttonWidget.name);
            vector.addElement(new Integer(buttonWidget.id));
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int getHighestButtonID() {
        int n = 0;
        Enumeration enumeration = this.buttons.elements();
        while (enumeration.hasMoreElements()) {
            ButtonWidget buttonWidget = (ButtonWidget)enumeration.nextElement();
            if (buttonWidget.id <= n) continue;
            n = buttonWidget.id;
        }
        return n;
    }

    public void compileWidgets() {
        Enumeration enumeration = this.buttons.elements();
        while (enumeration.hasMoreElements()) {
            ((ButtonWidget)enumeration.nextElement()).compileCommand();
        }
        enumeration = this.monitors.elements();
        while (enumeration.hasMoreElements()) {
            ((MonitorWidget)enumeration.nextElement()).compileCommand();
        }
        enumeration = this.linewidgets.elements();
        while (enumeration.hasMoreElements()) {
            ((LineWidget)enumeration.nextElement()).compileCommand();
        }
    }

    public int numMonitors() {
        return this.monitors.size();
    }

    public int numMonitorsOn() {
        int n = 0;
        Enumeration enumeration = this.monitors.elements();
        while (enumeration.hasMoreElements()) {
            if (((MonitorWidget)enumeration.nextElement()).sp == null) continue;
            ++n;
        }
        return n;
    }

    public void clearLineWidgets() {
        Enumeration enumeration = this.linewidgets.elements();
        while (enumeration.hasMoreElements()) {
            LineWidget lineWidget = (LineWidget)enumeration.nextElement();
            lineWidget.reset();
        }
    }

    public void closeWidgetWindows() {
        Enumeration enumeration = this.linewidgets.elements();
        while (enumeration.hasMoreElements()) {
            LineWidget lineWidget = (LineWidget)enumeration.nextElement();
            ((Component)lineWidget.tbc).setVisible(false);
        }
    }

    public int numLineWidgets() {
        return this.linewidgets.size();
    }

    public int numLineWidgetsOn() {
        int n = 0;
        Enumeration enumeration = this.linewidgets.elements();
        while (enumeration.hasMoreElements()) {
            if (((LineWidget)enumeration.nextElement()).sp == null) continue;
            ++n;
        }
        return n;
    }

    public void erasePointsOnAllWidgets(int n) {
        LineWidget lineWidget = null;
        Enumeration enumeration = this.linewidgets.elements();
        while (enumeration.hasMoreElements()) {
            lineWidget = (LineWidget)enumeration.nextElement();
            lineWidget.erasePoint(n);
        }
    }

    public String getSaveString(boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("\r\n\r\n`interface`\r\n");
        Enumeration enumeration = this.wh.listAllWidgets();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((Widget)enumeration.nextElement()).getSaveString(bl));
        }
        return stringBuffer.toString();
    }

    public void reset() {
        this.closeWidgetWindows();
        this.clearSelections();
        Object var1_1 = null;
        this.wh.removeAllWidgets();
        this.buttons.removeAllElements();
        this.sliders.removeAllElements();
        this.monitors.removeAllElements();
        this.legends.removeAllElements();
        this.linewidgets.removeAllElements();
        this.textwidgets.removeAllElements();
        if (YoYo.applet == null) {
            this.frame.getMenu().removeAllPlotWindows();
        }
        ButtonWidget.idCount = 1;
        SliderWidget.idCount = 0;
        MonitorWidget.idCount = 1;
        ColorLegendWidget.idCount = 1;
        LineWidget.idCount = 2;
        TextWidget.idCount = 1;
    }

    public void loadFromString(String string, boolean bl) {
        String string2 = "`interface`";
        int n = string.indexOf(string2);
        if (n < 0) {
            return;
        }
        int n2 = string.indexOf("`", n + string2.length());
        if (n2 < 0) {
            n2 = string.length();
        }
        string = string.substring(n + string2.length(), n2);
        this.reset();
        this.clipRect = new Rectangle();
        this.readWidgets(string, bl);
        this.iface.repaint(this.clipRect);
    }

    protected void readWidgets(String string, boolean bl) {
        String[] stringArray = new String[]{"SLButton", "SLSlider", "SLMonitor", "SLCanvas", "SLTextWidget", "SLLineWidget", "SLLegend"};
        String[] stringArray2 = new String[]{"BUTTON", "SLIDER", "MONITOR"};
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
        try {
            String string2 = lineNumberReader.readLine();
            while (string2 != null) {
                Vector vector;
                Tokenizer tokenizer;
                StringBuffer stringBuffer;
                String string3 = string2.trim();
                String string4 = InterfaceDelegate.startswithp(string3, stringArray);
                if (string4 == null) {
                    string4 = InterfaceDelegate.startswithp(string3, stringArray2);
                    if (string4 == null) {
                        string2 = lineNumberReader.readLine();
                        continue;
                    }
                    string2 = lineNumberReader.readLine();
                    if (string2 == null) {
                        return;
                    }
                    string3 = string2.trim();
                    stringBuffer = new StringBuffer();
                    while (InterfaceDelegate.startswithp(string3, stringArray2) == null) {
                        stringBuffer.append(string3 + "\r\n");
                        string2 = lineNumberReader.readLine();
                        if (string2 == null) break;
                        string3 = string2.trim();
                    }
                    tokenizer = new Tokenizer(stringBuffer.toString());
                    vector = tokenizer.tokenize();
                    InterfaceDelegate.removeQuotes(vector);
                    if (string4.equals("BUTTON")) {
                        this.addWidget(new ButtonWidget(vector, 0, this.iface, this.sl));
                        continue;
                    }
                    if (string4.equals("SLIDER")) {
                        this.addWidget(new SliderWidget(vector, 0, this.iface));
                        continue;
                    }
                    if (!string4.equals("MONITOR")) continue;
                    this.addWidget(new MonitorWidget(vector, 0, this.iface, this.sl));
                    continue;
                }
                string2 = lineNumberReader.readLine();
                if (string2 == null) {
                    return;
                }
                string3 = string2.trim();
                stringBuffer = new StringBuffer();
                while (InterfaceDelegate.startswithp(string3, stringArray) == null) {
                    stringBuffer.append(string3 + "\r\n");
                    string2 = lineNumberReader.readLine();
                    if (string2 == null) break;
                    string3 = string2.trim();
                }
                tokenizer = new Tokenizer(stringBuffer.toString());
                vector = tokenizer.tokenize();
                InterfaceDelegate.removeQuotes(vector);
                if (string4.equals("SLButton")) {
                    this.addWidget(ButtonWidget.load(vector, this.iface, this.sl, bl));
                    continue;
                }
                if (string4.equals("SLSlider")) {
                    this.addWidget(SliderWidget.load(vector, this.iface, this.sl));
                    continue;
                }
                if (string4.equals("SLMonitor")) {
                    this.addWidget(MonitorWidget.load(vector, this.iface, this.sl, bl));
                    continue;
                }
                if (string4.equals("SLLegend")) {
                    this.addWidget(ColorLegendWidget.load(vector, this.iface, this.sl, bl));
                    continue;
                }
                if (string4.equals("SLTextWidget")) {
                    this.addWidget(TextWidget.load(vector, this.iface, this.sl));
                    continue;
                }
                if (string4.equals("SLCanvas")) {
                    this.sl.patchcanvas.load(vector, this.iface, this.sl);
                    continue;
                }
                if (!string4.equals("SLLineWidget")) continue;
                this.addWidget(LineWidget.load(vector, this.iface, this.sl, bl));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String startswithp(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public static void removeQuotes(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            String string;
            if (vector.elementAt(n) instanceof String && (string = (String)vector.elementAt(n)).startsWith("\"") && string.endsWith("\"")) {
                vector.setElementAt(string.substring(1, string.length() - 1), n);
            }
            ++n;
        }
    }

    public void setCellScroll(int n) {
        if (YoYo.applet == null) {
            this.cellsizesliderwidget.setValueNoResize(n);
        }
    }

    private final void loadImages() {
        block5: {
            String string = "gifs/";
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                MediaTracker mediaTracker = new MediaTracker((Component)((Object)this.iface));
                if (YoYo.applet == null) {
                    ToolbarWidget.loadImages(string, mediaTracker, toolkit);
                    Painttool.loadImages(string, mediaTracker, toolkit);
                    PaintSelect.loadImages(string, mediaTracker, toolkit);
                    JAboutDialog.loadImages(string, mediaTracker, toolkit);
                    JPlotDialog.loadImages(string, mediaTracker, toolkit);
                    StopWidget.loadImages(string, mediaTracker, toolkit);
                    TrashWidget.loadImages(string, mediaTracker, toolkit);
                    JLineDialogPanel.loadImages(string, mediaTracker, toolkit);
                    JShapeEditorSizeChooserPanel.loadImages(string, mediaTracker, toolkit);
                    JShapePaintSelect.loadImages(string, mediaTracker, toolkit);
                    JShapeRotateMenu.loadImages(string, mediaTracker, toolkit);
                    JShapeEditorPanel.loadImages(string, mediaTracker, toolkit);
                    JShapeEditorRotatePanel.loadImages(string, mediaTracker, toolkit);
                }
                ButtonWidget.loadImages(string, mediaTracker, toolkit);
                SliderWidget.loadImages(string, mediaTracker, toolkit);
                MonitorWidget.loadImages(string, mediaTracker, toolkit);
                LineWidget.loadImages(string, mediaTracker, toolkit);
                ColorLegendWidget.loadImages(string, mediaTracker, toolkit);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception exception) {
                this.app.err.println("Error loading images.");
                exception.printStackTrace(this.app.err);
                if (this.app.err == this.app.log) break block5;
                this.app.log.println("Error loading images.");
                exception.printStackTrace(this.app.log);
            }
        }
    }

    public boolean selecting() {
        return this.wh.hasSelections();
    }

    public void print() {
        try {
            PrintDialog printDialog = Application.createPrintDialog((Frame)((Object)this.frame), true, true, true, false);
            printDialog.show();
            if (printDialog.canceledp()) {
                return;
            }
            DoubleInsets doubleInsets = printDialog.getMargins();
            Print print = new Print((Frame)((Object)this.frame), "StarLogo Window", printDialog.getOrientation(), doubleInsets.top, doubleInsets.bottom, doubleInsets.left, doubleInsets.right, false);
            print.displayPrintingMessage(true);
            print.printComponent((Component)((Object)this.iface), printDialog.getResizingOption());
            printDialog.dispose();
            print.print();
        }
        catch (PrintingCanceledException printingCanceledException) {
            // empty catch block
        }
    }

    public void setStatus(String string) {
        this.statusbar.setStatusMessage(string);
        this.iface.repaint(this.clipRect);
    }

    public void resetStatus() {
        this.statusbar.setStatusMessage("");
    }

    public ToolbarWidget getToolbar() {
        return this.toolbar;
    }

    public boolean snapToGrid() {
        return this.snapToGrid;
    }

    public boolean resizingp() {
        return this.resizingp;
    }

    public boolean draggingp() {
        return this.draggingp;
    }

    public Widget widgetTouched() {
        return this.widgetTouched;
    }

    public WidgetHolder wh() {
        return this.wh;
    }

    public StarLogo sl() {
        return this.sl;
    }

    public Application app() {
        return this.app;
    }

    public boolean pressedShiftControlp() {
        return this.pressedShiftControlp;
    }

    public boolean firstresizep() {
        return this.firstresizep;
    }

    public int statusbarheight() {
        return statusbarheight;
    }

    public int toolbarheight() {
        return toolbarheight;
    }

    public int toolbarwidth() {
        return toolbarwidth;
    }

    public Frame frame() {
        return (Frame)((Object)this.frame);
    }

    public Rectangle clipRect() {
        return this.clipRect;
    }

    public void setClipRect(Rectangle rectangle) {
        this.clipRect = rectangle;
    }

    public Widget keyboardFocus() {
        return this.keyboardFocus;
    }

    public void setKeyboardFocus(Widget widget) {
        this.keyboardFocus = widget;
    }

    public PaintSelect paintselect() {
        return this.paintselect;
    }

    public Painttool painttool() {
        return this.painttool;
    }

    public Colortool colortool() {
        return this.colortool;
    }

    public ColorChooser colorchooser() {
        return this.colorchooser;
    }

    public Vector sliders() {
        return this.sliders;
    }

    public Vector legends() {
        return this.legends;
    }

    public Vector linewidgets() {
        return this.linewidgets;
    }

    public Vector buttons() {
        return this.buttons;
    }

    public Vector monitors() {
        return this.monitors;
    }

    public Vector textwidgets() {
        return this.textwidgets;
    }

    public SmartRectangle outline() {
        return this.outline;
    }

    public StatusToolbar statusbar() {
        return this.statusbar;
    }

    public TrashWidget trashwidget() {
        return this.trashwidget;
    }

    public SpeedSliderWidget speedsliderwidget() {
        return this.speedsliderwidget;
    }

    public ToolbarWidget toolbar() {
        return this.toolbar;
    }

    public void addPlotWindow(String string) {
        if (YoYo.applet == null) {
            this.frame.getMenu().addPlotWindow(string);
        }
    }

    public void removePlotWindow(String string) {
        if (YoYo.applet == null) {
            this.frame.getMenu().removePlotWindow(string);
        }
    }

    public void removeAllPlotWindows() {
        if (YoYo.applet == null) {
            this.frame.getMenu().removeAllPlotWindows();
        }
    }

    public void changePlotWindow(String string, String string2) {
        if (YoYo.applet == null) {
            this.frame.getMenu().changePlotWindow(string, string2);
        }
    }

    public void setTooltipWidget(WidgetLite widgetLite) {
        this.tooltipShown = widgetLite;
    }

    public void setBackgroundp(boolean bl) {
        this.backgroundp = bl;
    }

    public InterfaceDelegate(Application application, Interface interface_) {
        this.app = application;
        this.sl = application.sl;
        this.wh = new WidgetHolder(application, interface_);
        this.buttons = new Vector(10, 5);
        this.sliders = new Vector(10, 5);
        this.monitors = new Vector(10, 5);
        this.legends = new Vector(10, 5);
        this.linewidgets = new Vector(10, 5);
        this.textwidgets = new Vector(10, 5);
        this.wclipboard = new WidgetClipboard(interface_);
        this.dwellTimer = new DwellTimer(750, interface_);
        this.iface = interface_;
    }
}

