/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import starlogo.ButtonDialog;
import starlogo.ButtonWidget;
import starlogo.JMessageDialog;
import starlogo.JSLDialog;
import starlogo.JWidgetDialog;
import starlogo.ToolTipWidget;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.YoYo;

final class JButtonDialog
extends JWidgetDialog
implements ButtonDialog,
FocusListener {
    private static JButtonDialog dialog;
    private ButtonGroup commandGroup;
    private ButtonGroup nameGroup;
    private JRadioButton turCheck;
    private JRadioButton obsCheck;
    private JRadioButton instCheck;
    private JRadioButton nameCheck;
    private JCheckBox foreverCheck;
    private JLabel nameLab;
    private JLabel instLab;
    private JPanel commandPanel;
    private JPanel namePanel;
    private JPanel butPanel;
    private JPanel namefieldPanel;
    private JPanel instructionfieldPanel;
    private JTextField commandText;
    private JTextField nameText;
    private JScrollPane descriptScroll;
    private JLabel descriptLab;
    private JTextArea descriptText;
    private String descript;
    public boolean shortcuts = true;

    public static final JButtonDialog create(Frame frame, String string) {
        if (dialog == null) {
            dialog = new JButtonDialog(frame, string);
        } else {
            dialog.setTitle(string);
        }
        dialog.addNotify();
        dialog.setFields("", "button" + ButtonWidget.idCount, true, false, false, "");
        return dialog;
    }

    public static final JButtonDialog create(Frame frame, String string, WidgetDrag widgetDrag) {
        ButtonWidget buttonWidget = (ButtonWidget)widgetDrag;
        if (dialog == null) {
            dialog = new JButtonDialog(frame, string);
        } else {
            dialog.setTitle(string);
        }
        dialog.addNotify();
        dialog.setFields(buttonWidget.command, buttonWidget.name, buttonWidget.turtlep, buttonWidget.forever, buttonWidget.showName, buttonWidget.getToolText());
        return dialog;
    }

    private final void setFields(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.commandText.setText(string);
        this.commandText.setSelectionStart(0);
        this.commandText.setSelectionEnd(string.length());
        this.nameText.setText(string2);
        this.nameText.setCaretPosition(0);
        this.descriptText.setText(string3);
        this.descriptText.setCaretPosition(0);
        if (bl) {
            this.turCheck.setSelected(true);
        } else {
            this.obsCheck.setSelected(true);
        }
        this.foreverCheck.setSelected(bl2);
        if (bl3) {
            this.nameCheck.setSelected(true);
        } else {
            this.instCheck.setSelected(true);
        }
    }

    protected final void setupComponents() {
        if (YoYo.language == 0) {
            this.nameLab = new JLabel("Name:");
            this.instLab = new JLabel("StarLogo Instruction:");
            this.nameText = new JTextField(15);
            this.commandText = new JTextField(30);
            this.descriptLab = new JLabel("Tooltip:");
            this.descriptText = new JTextArea();
            this.descriptText.setLineWrap(true);
            this.descriptText.setWrapStyleWord(true);
            this.descriptScroll = new JScrollPane(this.descriptText);
            this.descriptScroll.setVerticalScrollBarPolicy(20);
            this.descriptScroll.setPreferredSize(new Dimension(YoYo.macosxp ? 30 : 50, 50));
            this.foreverCheck = new JCheckBox("Forever?");
            this.butPanel = new JPanel(new GridLayout(1, 2, 5, 0));
            this.butPanel.add(this.bca);
            this.butPanel.add(this.bok);
            this.commandGroup = new ButtonGroup();
            this.commandPanel = new JPanel(new GridLayout(2, 1, 5, 0));
            this.turCheck = new JRadioButton("Turtle", true);
            this.obsCheck = new JRadioButton("Observer", false);
            this.commandGroup.add(this.turCheck);
            this.commandGroup.add(this.obsCheck);
            this.commandPanel.add(this.turCheck);
            this.commandPanel.add(this.obsCheck);
            this.nameGroup = new ButtonGroup();
            this.namePanel = new JPanel(new GridLayout(2, 1, 5, 0));
            this.instCheck = new JRadioButton("Show Instruction", true);
            this.nameCheck = new JRadioButton("Show Name", false);
            this.nameGroup.add(this.instCheck);
            this.nameGroup.add(this.nameCheck);
            this.namePanel.add(this.nameCheck);
            this.namePanel.add(this.instCheck);
        }
        if (YoYo.language == 1) {
            this.nameLab = new JLabel("Nombre:");
            this.instLab = new JLabel("Instrucci\u00f3n de StarLogo:");
            this.nameText = new JTextField(15);
            this.commandText = new JTextField(30);
            this.descriptLab = new JLabel("Descripci\u00f3n:");
            this.descriptText = new JTextArea("", 3, 40);
            this.foreverCheck = new JCheckBox("Siempre?");
            this.butPanel = new JPanel(new GridLayout(1, 2, 5, 0));
            this.butPanel.add(this.bca);
            this.butPanel.add(this.bok);
            this.commandGroup = new ButtonGroup();
            this.commandPanel = new JPanel(new GridLayout(2, 1, 5, 0));
            this.turCheck = new JRadioButton("Tortuga", true);
            this.obsCheck = new JRadioButton("Observador", false);
            this.commandGroup.add(this.turCheck);
            this.commandGroup.add(this.obsCheck);
            this.commandPanel.add(this.turCheck);
            this.commandPanel.add(this.obsCheck);
            this.nameGroup = new ButtonGroup();
            this.namePanel = new JPanel(new GridLayout(2, 1, 5, 0));
            this.instCheck = new JRadioButton("Muestre Instrucci\u00f3n", true);
            this.nameCheck = new JRadioButton("Muestre Nombre", false);
            this.nameGroup.add(this.instCheck);
            this.nameGroup.add(this.nameCheck);
            this.namePanel.add(this.nameCheck);
            this.namePanel.add(this.instCheck);
        }
        JSLDialog.formatText(this.commandText);
        JSLDialog.formatText(this.nameText);
        JSLDialog.formatLabel(this.nameLab);
        JSLDialog.formatLabel(this.instLab);
        JSLDialog.formatLabel(this.commandPanel);
        JSLDialog.formatLabel(this.turCheck);
        JSLDialog.formatLabel(this.obsCheck);
        JSLDialog.formatLabel(this.namePanel);
        JSLDialog.formatLabel(this.foreverCheck);
        JSLDialog.formatLabel(this.instCheck);
        JSLDialog.formatLabel(this.nameCheck);
        JSLDialog.formatLabel(this.butPanel);
        JSLDialog.formatLabel(this.bca);
        JSLDialog.formatLabel(this.bok);
        JSLDialog.formatText(this.descriptText);
        JSLDialog.formatLabel(this.descriptLab);
    }

    protected final void setupGBC() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.getContentPane().add((Component)this.nameLab, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 20.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 13, 0, 0);
        this.getContentPane().add((Component)this.nameText, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.getContentPane().add((Component)this.instLab, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 20.0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.getContentPane().add((Component)this.commandText, gridBagConstraints);
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.getContentPane().add((Component)this.descriptLab, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 20.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.getContentPane().add((Component)this.descriptScroll, gridBagConstraints);
        gridBagConstraints.weighty = 20.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(YoYo.macintoshp ? 13 : 6, 0, 0, 13);
        this.getContentPane().add((Component)this.namePanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(YoYo.macintoshp ? 13 : 6, 0, 0, 13);
        this.getContentPane().add((Component)this.commandPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(6, 13, 0, 13);
        this.getContentPane().add((Component)this.foreverCheck, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(13, 13, 13, 13);
        this.getContentPane().add((Component)this.butPanel, gridBagConstraints);
    }

    protected final void setupPosition() {
        this.pack();
        this.initLocation();
    }

    protected final boolean valid_inputs() {
        String string = this.nameText.getText().trim();
        String string2 = this.commandText.getText().trim();
        if (string.equals("")) {
            JMessageDialog jMessageDialog = new JMessageDialog(this.parent, "Warning", "Sorry, you must specify a name.");
            jMessageDialog.show();
            return false;
        }
        if (string2.equals("")) {
            JMessageDialog jMessageDialog = new JMessageDialog(this.parent, "Warning", "Sorry, you must specify an instruction.");
            jMessageDialog.show();
            return false;
        }
        return true;
    }

    public final void getValues(WidgetDrag widgetDrag) {
        ButtonWidget buttonWidget = (ButtonWidget)widgetDrag;
        buttonWidget.command = this.commandText.getText();
        buttonWidget.name = this.nameText.getText();
        buttonWidget.forever = this.foreverCheck.isSelected();
        buttonWidget.showName = this.nameCheck.isSelected();
        buttonWidget.font = WidgetLite.WIDGET_FONT;
        boolean bl = buttonWidget.turtlep = !this.getObserverp();
        if (!ToolTipWidget.empty(this.descriptText.getText())) {
            buttonWidget.setToolTip(new ToolTipWidget(buttonWidget.parent, this.descriptText.getText()));
        } else {
            buttonWidget.removeToolTip();
        }
    }

    private final boolean getObserverp() {
        return this.obsCheck.isSelected();
    }

    public final void focusGained(FocusEvent focusEvent) {
        this.shortcuts = false;
    }

    public final void focusLost(FocusEvent focusEvent) {
        this.shortcuts = true;
    }

    public final boolean shortcutsOn() {
        return this.shortcuts;
    }

    private JButtonDialog(Frame frame, String string) {
        super(frame, string);
        this.init();
        this.initFocus(this.commandText);
        this.descriptText.addFocusListener(this);
        this.pack();
    }
}

