/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import starlogo.Application;
import starlogo.ControlCenter;
import starlogo.DoubleInsets;
import starlogo.JControlCenterTextArea;
import starlogo.JSLCommand;
import starlogo.JSLDialog;
import starlogo.JSLMenu;
import starlogo.JSLProc;
import starlogo.NSLMenu;
import starlogo.Print;
import starlogo.PrintDialog;
import starlogo.PrintingCanceledException;
import starlogo.SLCommand;
import starlogo.SLMenu;
import starlogo.SLProc;
import starlogo.StarLogo;
import yoyo.CompoundSymbol;
import yoyo.Context;
import yoyo.Symbol;
import yoyo.YoYo;

public class JControlCenter
extends JFrame
implements ControlCenter,
ChangeListener,
CaretListener {
    public static Font STATUS_FONT;
    static final int minTextHeight = 60;
    public static SLMenu slmenu;
    JPanel[] topcard = new JPanel[2];
    JPanel[] bottomcard = new JPanel[2];
    public JSLCommand[] command = new JSLCommand[2];
    public JSLProc[] proc = new JSLProc[2];
    JLabel[] commandLab = new JLabel[2];
    JLabel[] procLab = new JLabel[2];
    JSplitPane[] drag = new JSplitPane[2];
    JPanel tools;
    JLabel status;
    JTabbedPane tabs;
    int tabHeight;
    int cur;
    JControlCenterTextArea textFocus;
    Insets insets;
    int width;
    public Application app;
    public StarLogo sl;
    ObservableInstance observed = new ObservableInstance();
    String turt;
    String obsv;
    private static /* synthetic */ Class class$Lstarlogo$Pool;

    void setupText() {
        this.proc[0] = new JSLProc(true, this.sl, this);
        this.proc[1] = new JSLProc(false, this.sl, this);
        this.command[0] = new JSLCommand(0, this.sl, this);
        this.command[1] = new JSLCommand(2, this.sl, this);
        this.setFont(JSLProc.PROC_FONT);
    }

    void setupLabels() {
        this.status = new JLabel(this){
            private final /* synthetic */ JControlCenter this$0;

            public final Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((Component)this).getFontMetrics(this.getFont()).getHeight() + 5);
            }
            {
                this.this$0 = jControlCenter;
                this.constructor$0(jControlCenter);
            }

            private final void constructor$0(JControlCenter jControlCenter) {
            }
        };
        JSLDialog.colorControl(this.status);
        this.status.setFont(STATUS_FONT);
    }

    void setupTopBottoms() {
        int n = 0;
        while (n < 2) {
            this.topcard[n] = new JPanel(new BorderLayout());
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            jPanel.add(this.command[n].label);
            jPanel.setBackground(this.proc[n].label.getBackground());
            jPanel.setOpaque(true);
            this.topcard[n].add((Component)jPanel, "North");
            this.topcard[n].add((Component)new JScrollPane(this.command[n], 22, 31), "Center");
            this.bottomcard[n] = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            if (YoYo.language == 1) {
                if (this.proc[n].label.getText().equals("Turtle Procedures")) {
                    this.proc[n].label.setText("Procedemientos de Tortuga");
                }
                if (this.proc[n].label.getText().equals("Observer Procedures")) {
                    this.proc[n].label.setText("Procedemientos de Observador");
                }
            }
            jPanel2.add(this.proc[n].label);
            jPanel2.add(this.proc[n].procMenuList());
            jPanel2.setBackground(this.proc[n].label.getBackground());
            jPanel2.setOpaque(true);
            this.bottomcard[n].add((Component)jPanel2, "North");
            this.bottomcard[n].add((Component)new JScrollPane(this.proc[n], 22, 30), "Center");
            ++n;
        }
    }

    void setupDrag() {
        int n = 0;
        while (n < 2) {
            this.drag[n] = new JSplitPane(0, true, this.topcard[n], this.bottomcard[n]);
            if (YoYo.macintoshp) {
                this.drag[n].setOneTouchExpandable(true);
            }
            this.drag[n].setDividerLocation(150);
            this.drag[n].setBackground(SystemColor.control);
            ++n;
        }
    }

    void setupTabs() {
        this.tabs = new JTabbedPane();
        if (YoYo.language == 0) {
            this.tabs.addTab("Turtle", this.drag[0]);
            this.tabs.addTab("Observer", this.drag[1]);
        }
        if (YoYo.language == 1) {
            this.tabs.addTab("Tortuga", this.drag[0]);
            this.tabs.addTab("Observador", this.drag[1]);
        }
    }

    void setupTools() {
        this.tools = new JPanel(new GridLayout(1, 3));
        JSLDialog.colorControl(this.tools);
        this.setLine(1);
        this.tools.add(this.status);
    }

    void setupLayout() {
        this.getContentPane().add((Component)this.tabs, "Center");
        this.tabs.setDoubleBuffered(true);
        this.tabs.setOpaque(true);
        this.getContentPane().add((Component)this.tools, "South");
        this.tools.setDoubleBuffered(true);
        this.tools.setOpaque(true);
    }

    public void setObsProcs(Object[] objectArray, Integer[] integerArray) {
        this.proc[1].setProcs(objectArray, integerArray);
    }

    public void setTurProcs(Object[] objectArray, Integer[] integerArray) {
        this.proc[0].setProcs(objectArray, integerArray);
    }

    public void clearProcs() {
        this.proc[1].clearUfuns();
        this.proc[0].clearUfuns();
    }

    public boolean lookupUfun(String string, int n) {
        switch (n) {
            case 1: {
                return this.proc[1].lookupUfun(string);
            }
            case 0: {
                return this.proc[0].lookupUfun(string);
            }
        }
        return false;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.validate();
    }

    void setupKeyTrackers() {
        ControlKeyAdapter controlKeyAdapter = new ControlKeyAdapter(this);
        this.addKeyListener(controlKeyAdapter);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.updateLine(this.textFocus);
    }

    public void updateLine(JControlCenterTextArea jControlCenterTextArea) {
        if (jControlCenterTextArea instanceof JTextArea) {
            try {
                JTextArea jTextArea = (JTextArea)((Object)jControlCenterTextArea);
                int n = jTextArea.getLineOfOffset(jTextArea.getSelectionStart());
                this.setLine(n + 1);
            }
            catch (BadLocationException badLocationException) {
                this.app.err.println("badlocationexception in updateLine");
            }
        } else {
            this.setLine(-1);
        }
    }

    private final void setLine(int n) {
        if (n >= 0) {
            this.status.setText((YoYo.language == 0 ? "Line " : "Linea ") + n);
        } else {
            this.status.setText("");
        }
    }

    void setupFocusTrackers() {
        this.tabs.addChangeListener(this);
        this.textFocus = this.command[0];
        this.cur = 0;
    }

    public void toggleTabs() {
        this.tabs.setSelectedIndex(1 - this.cur);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.tabs.getSelectedIndex();
        this.textFocus = this.textFocus instanceof JSLCommand ? this.command[n] : this.proc[n];
        this.updateLine(this.textFocus);
        this.cur = n;
    }

    void init() {
        slmenu = YoYo.macintoshp && !YoYo.macosxp ? new NSLMenu(this, this.app) : new JSLMenu(this, this.app);
        slmenu.setMenuBar(this);
        this.addNotify();
        this.setupKeyTrackers();
        this.setupFocusTrackers();
    }

    public JControlCenterTextArea getTextFocus() {
        return this.textFocus;
    }

    public SLCommand getSLCommand(int n) {
        return this.command[n];
    }

    public SLProc getSLProc(int n) {
        return this.proc[n];
    }

    public int getCCHeight(int n) {
        return this.drag[n].getDividerLocation();
    }

    public void setCCHeight(int n, int n2) {
        this.drag[n].setDividerLocation(n2);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JMenuItem jMenuItem;
        String string;
        if (YoYo.macintoshp && !YoYo.macosxp) {
            CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
            String string2 = checkboxMenuItem.getLabel();
            if (string2.equals("Show Spaces") || string2.equals("Muestre Espacios")) {
                SLProc sLProc;
                int n = 9679;
                sLProc.setShowSpaces(!(sLProc = this.getSLProc(this.cur)).showSpacesp());
                return;
            }
            try {
                int n = Integer.parseInt(string2);
                Font font = this.getFont();
                this.setFont(new Font(font.getName(), font.getStyle(), n));
                slmenu.setCurrentSize(checkboxMenuItem);
                return;
            }
            catch (Exception exception) {
                Font font = this.getFont();
                this.setFont(new Font(string2, font.getStyle(), font.getSize()));
                slmenu.setCurrentFont(checkboxMenuItem);
                return;
            }
        }
        if (itemEvent.getSource() instanceof JCheckBoxMenuItem && ((string = (jMenuItem = (JCheckBoxMenuItem)itemEvent.getSource()).getLabel()).equals("Show Spaces") || string.equals("Muestre Espacios"))) {
            SLProc sLProc;
            int n = 9679;
            sLProc.setShowSpaces(!(sLProc = this.getSLProc(this.tabs.getSelectedIndex())).showSpacesp());
            return;
        }
        if (itemEvent.getSource() instanceof JRadioButtonMenuItem) {
            jMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
            string = jMenuItem.getLabel();
            if (string.equals("Show Spaces") || string.equals("Muestre Espacios")) {
                SLProc sLProc;
                int n = 9679;
                sLProc.setShowSpaces(!(sLProc = this.getSLProc(this.tabs.getSelectedIndex())).showSpacesp());
                return;
            }
            try {
                int n = Integer.parseInt(string);
                Font font = this.getFont();
                this.setFont(new Font(font.getName(), font.getStyle(), n));
                slmenu.setCurrentSize(jMenuItem);
                return;
            }
            catch (Exception exception) {
                Font font = this.getFont();
                this.setFont(new Font(string, font.getStyle(), font.getSize()));
                slmenu.setCurrentFont(jMenuItem);
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        String string = "";
        if (object2 instanceof JMenuItem) {
            object = (JMenuItem)object2;
            string = ((AbstractButton)object).getLabel();
        } else if (object2 instanceof MenuItem) {
            object = (MenuItem)object2;
            string = ((MenuItem)object).getLabel();
        }
        object = this.getTextFocus();
        if (string.equals("Undo") || string.equals("Deshacer")) {
            object.undo();
            return;
        }
        if (string.equals("Redo") || string.equals("Repita")) {
            object.redo();
            return;
        }
        if (string.equals("Cut") || string.equals("Corte")) {
            ((JTextComponent)object).cut();
            if (object instanceof JSLProc) {
                this.app.rancompilerp = false;
                this.app.project.markChanged();
            }
            return;
        }
        if (string.equals("Copy") || string.equals("Copie")) {
            ((JTextComponent)object).copy();
            return;
        }
        if (string.equals("Paste") || string.equals("Pegue")) {
            ((JTextComponent)object).paste();
            if (object instanceof JSLProc) {
                this.app.rancompilerp = false;
                this.app.project.markChanged();
            }
            return;
        }
        if (string.equals("Select All") || string.equals("Seleccione Todo")) {
            ((JTextComponent)object).selectAll();
            return;
        }
        if (string.equals("Clear") || string.equals("Borre")) {
            ((JTextComponent)object).setText("");
            if (object instanceof JSLProc) {
                this.app.rancompilerp = false;
                this.app.project.markChanged();
            }
        }
    }

    public void turtlePrint(String string) {
        this.getSLCommand(0).print(string);
    }

    public void observerPrint(String string) {
        this.getSLCommand(1).print(string);
    }

    public void turtlePrintln(String string) {
        this.getSLCommand(0).println(string);
    }

    public void observerPrintln(String string) {
        this.getSLCommand(1).println(string);
    }

    public void observerClearText() {
        this.getSLProc(1).setText("");
    }

    public void turtleClearText() {
        this.getSLProc(0).setText("");
    }

    public void observerClearCC() {
        this.getSLCommand(1).callerClearText();
    }

    public void turtleClearCC() {
        this.getSLCommand(0).callerClearText();
    }

    public void clearText() {
        this.observerClearText();
        this.turtleClearText();
    }

    public void reset() {
        this.deleteObservers();
        this.clearText();
    }

    public void resetText(String string) {
        int n;
        int n2;
        String string2 = "`turtle`";
        String string3 = "`observer`";
        int n3 = string.indexOf(string2) + string2.length();
        int n4 = string.indexOf("`", n3);
        if (n4 == -1) {
            n4 = string.length();
        }
        if ((n2 = string.indexOf("`", n = string.indexOf(string3) + string3.length())) == -1) {
            n2 = string.length();
        }
        String string4 = string.substring(n3, n4).trim();
        String string5 = string.substring(n, n2).trim();
        this.turt = this.processString(string4, "\n");
        this.getSLProc(0).setText(this.turt);
        this.obsv = this.processString(string5, "\n");
        this.getSLProc(1).setText(this.obsv);
    }

    public String processString(String string, String string2) {
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                String string3;
                if ((string3 = lineNumberReader.readLine()) == null) {
                    return stringBuffer.toString();
                }
                stringBuffer.append(string3);
                stringBuffer.append(string2);
            }
        }
        catch (IOException iOException) {
            this.app.err.println("shit");
            return "Error reading file\n";
        }
    }

    public void compileText(String string) {
        Object object = this.sl.runningp;
        synchronized (object) {
            this.sl.stopAll();
        }
        this.getSLProc(1).clearUfuns();
        this.getSLProc(0).clearUfuns();
        Object[] objectArray = new Object[]{Symbol.lookup("compiler"), Symbol.lookup("read-code")};
        Object[] objectArray2 = new Object[]{new CompoundSymbol(objectArray), this.getSLProc(1).getText(), this.getSLProc(0).getText(), string, this};
        this.app.cc.enqueue(objectArray2, this.app.message, this.app.err, this);
    }

    public String getSaveString() {
        return "`turtle`\r\n" + this.processString(this.getSLProc(0).getText().trim(), "\r\n") + "\r\n\r\n`observer`\r\n" + this.processString(this.getSLProc(1).getText().trim(), "\r\n");
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getSLProc(1) != null) {
            int n = 0;
            while (n < 2) {
                this.getSLProc(n).setFont(font);
                this.getSLCommand(n).setFont(font);
                ++n;
            }
        }
    }

    public void addObserver(Observer observer) {
        this.observed.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observed.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.observed.deleteObservers();
    }

    public void done(Context context) {
        this.observed.doChanged();
    }

    public void displayOneString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error", string, true);
    }

    public void displayAString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error", string, true);
    }

    public void print() {
        try {
            Font font = JSLProc.PROC_FONT;
            PrintDialog printDialog = Application.createPrintDialog(this, true, true, false, true);
            printDialog.show();
            if (printDialog.canceledp()) {
                return;
            }
            DoubleInsets doubleInsets = printDialog.getMargins();
            Print print = new Print(this, "Command Center Window", printDialog.getOrientation(), doubleInsets.top, doubleInsets.bottom, doubleInsets.left, doubleInsets.right, printDialog.getResIndependent());
            printDialog.dispose();
            print.displayPrintingMessage(true);
            print.printText("Observer Commands\n\n", font, true);
            print.printText(this.command[1].getText(), font, true);
            print.printText("\n\nObserver Procedures\n\n", font, true);
            print.printText(this.proc[1].getText(), font, true);
            print.printText("\n\nTurtle Commands\n\n", font, true);
            print.printText(this.command[0].getText(), font, true);
            print.printText("\n\nTurtle Procedures\n\n", font, true);
            print.printText(this.proc[0].getText(), font, true);
            print.print();
        }
        catch (PrintingCanceledException printingCanceledException) {
            // empty catch block
        }
    }

    public void markChanged() {
        this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
    }

    public void clearChanged() {
        this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
    }

    public void flush() {
        this.getSLCommand(0).flush();
        this.getSLCommand(1).flush();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JControlCenter(Application application) {
        super("Control Center");
        if (YoYo.language == 1) {
            this.setTitle("Centro de Mandos");
        }
        this.app = application;
        this.sl = application.sl;
        application.registerCloser(this);
        this.setDefaultCloseOperation(0);
        application.registerFrameTracker(this);
        ((Component)this).setLocation(0, 85);
        if (YoYo.language == 0) {
            ((Component)this).setSize(285, 500);
        }
        if (YoYo.language == 1) {
            ((Component)this).setSize(320, 500);
        }
        if (!YoYo.macintoshp) {
            ImageIcon imageIcon = new ImageIcon((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = JControlCenter.class$("starlogo.Pool"))).getResource("gifs/icon.gif"));
            ((Frame)this).setIconImage(imageIcon.getImage());
        }
        this.setupText();
        this.setupLabels();
        this.setupTopBottoms();
        this.setupDrag();
        this.setupTabs();
        this.setupTools();
        this.setupLayout();
        this.init();
    }

    static {
        try {
            STATUS_FONT = JSLDialog.LABEL_FONT;
            if (YoYo.macintoshp) {
                STATUS_FONT = Font.getFont("starlogo.status-line.font", STATUS_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class ControlKeyAdapter
    extends KeyAdapter {
        JControlCenter parent;

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\t' && keyEvent.isControlDown()) {
                this.parent.toggleTabs();
                keyEvent.consume();
                return;
            }
            if (YoYo.macintoshp && keyEvent.isMetaDown() && keyEvent.getKeyChar() == '.') {
                Object object = this.parent.sl.runningp;
                synchronized (object) {
                    this.parent.sl.stopAll();
                }
                return;
            }
            if (!YoYo.macintoshp && keyEvent.isControlDown() && keyEvent.getKeyChar() == 'c') {
                Object object = this.parent.sl.runningp;
                synchronized (object) {
                    this.parent.sl.stopAll();
                }
                return;
            }
        }

        ControlKeyAdapter(JControlCenter jControlCenter2) {
            this.parent = jControlCenter2;
        }
    }

    protected class ObservableInstance
    extends Observable {
        public void doChanged() {
            this.setChanged();
        }

        ObservableInstance() {
        }
    }
}

