/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import starlogo.Application;
import starlogo.Box;
import starlogo.Colors;
import starlogo.EntityMonitor;
import starlogo.JSLCommand;
import starlogo.JSLDialog;
import starlogo.MenuListener;
import starlogo.SLMenu;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import starlogo.StarLogoError;
import starlogo.StarLogoFrame;
import starlogo.VM;
import starlogo.WidgetLite;
import yoyo.Context;
import yoyo.Reader;
import yoyo.YoYo;

public abstract class JEntityMonitor
extends JFrame
implements EntityMonitor,
MenuListener {
    public static Font EM_FONT;
    public static Font LABEL_FONT;
    static final String[] COLOR_STRING;
    JPanel wholePanel;
    JPanel middleBox;
    JPanel bottomPanel;
    Box wholeBox;
    JScrollPane middlePane;
    CardLayout cl;
    JSLCommand com;
    public boolean closep = false;
    double delay = 0.5;
    protected boolean runningp = false;
    SLMenu slmenu;
    StarLogo sl;
    Application app;
    Clipboard clip;
    Thread thisthr;
    int ccHeight = 54;
    int textHeight;
    boolean lastOwn = false;
    int lastField = -1;
    boolean fieldChanged = false;
    JLabel[] own_lbl;
    JTextField[] own_txt;
    Object[] ownval;
    Vector whichToupdate = new Vector();
    JPanel topBox;
    TextKeyAdapter tka;
    tfFocus tff;
    private Vector spps = new Vector();
    private int sppcount = 0;
    JTextComponent focus;

    void setFields() {
        FontMetrics fontMetrics = this.app.iface.getToolkit().getFontMetrics(EM_FONT);
        this.textHeight = fontMetrics.getHeight() + fontMetrics.getAscent();
        Dimension dimension = new Dimension(67, this.textHeight);
        boolean bl = false;
        this.setStateFields(dimension);
        this.setVariableFields(dimension);
    }

    abstract void setStateFields(Dimension var1);

    void setVariableFields(Dimension dimension) {
        if (this.getNumVars() != 0) {
            this.own_txt = new JTextField[this.getNumVars()];
            this.own_lbl = new JLabel[this.getNumVars()];
            this.ownval = new Object[this.getNumVars()];
            int n = 0;
            while (n < this.getNumVars()) {
                this.own_lbl[n] = new JLabel(" " + this.getVarName(n));
                this.own_txt[n] = new JTextField(" ");
                this.own_txt[n].setName(this.getVarName(n));
                this.own_txt[n].setPreferredSize(dimension);
                JSLDialog.colorControl(this.own_lbl[n]);
                this.own_lbl[n].setFont(LABEL_FONT);
                this.formatText(this.own_txt[n]);
                ++n;
            }
        }
    }

    public void formatText(JTextComponent jTextComponent) {
        jTextComponent.setFont(EM_FONT);
        jTextComponent.setBackground(Color.white);
        jTextComponent.setForeground(Color.black);
        if (YoYo.applet != null) {
            jTextComponent.setEditable(false);
        }
    }

    abstract int getVarPos(int var1);

    abstract boolean getVarEnump(int var1);

    abstract Object getVarValue(int var1);

    synchronized void setOwnInit(int n) {
        int n2 = this.getVarPos(n);
        this.ownval[n] = this.getVarValue(n2);
        if (this.ownval[n] instanceof String) {
            this.own_txt[n].setText("\"" + YoYo.printToString(this.ownval[n]) + "\"");
        } else if (this.getVarEnump(n)) {
            if (this.ownval[n] instanceof Number) {
                int n3 = ((Number)this.ownval[n]).intValue();
                if (n3 >= 1 && n3 <= VM.enumnames.length) {
                    this.own_txt[n].setText(VM.enumnames[n3 - 1]);
                } else {
                    this.own_txt[n].setText(this.clipDigits(YoYo.printToString(this.ownval[n])));
                }
            } else {
                this.own_txt[n].setText(this.clipDigits(YoYo.printToString(this.ownval[n])));
            }
        } else {
            this.own_txt[n].setText(this.clipDigits(YoYo.printToString(this.ownval[n])));
        }
        this.own_txt[n].setCaretPosition(this.own_txt[n].getText().length());
    }

    synchronized void setOwn(int n) {
        int n2 = this.getVarPos(n);
        this.ownval[n] = this.getVarValue(n2);
        this.whichToupdate.addElement(new Integer(n));
        SwingUtilities.invokeLater(new Runnable(this){
            private final /* synthetic */ JEntityMonitor this$0;

            public final void run() {
                Vector vector = this.this$0.whichToupdate;
                synchronized (vector) {
                    Enumeration<E> enumeration = this.this$0.whichToupdate.elements();
                    while (enumeration.hasMoreElements()) {
                        int n = (Integer)enumeration.nextElement();
                        if (this.this$0.ownval[n] instanceof String) {
                            this.this$0.own_txt[n].setText("\"" + YoYo.printToString(this.this$0.ownval[n]) + "\"");
                            continue;
                        }
                        if (this.this$0.getVarEnump(n)) {
                            if (this.this$0.ownval[n] instanceof Number) {
                                int n2 = ((Number)this.this$0.ownval[n]).intValue();
                                if (n2 >= 1 && n2 <= VM.enumnames.length) {
                                    this.this$0.own_txt[n].setText(VM.enumnames[n2 - 1]);
                                    continue;
                                }
                                this.this$0.own_txt[n].setText(this.this$0.clipDigits(YoYo.printToString(this.this$0.ownval[n])));
                                this.this$0.own_txt[n].selectAll();
                                continue;
                            }
                            this.this$0.own_txt[n].setText(this.this$0.clipDigits(YoYo.printToString(this.this$0.ownval[n])));
                            this.this$0.own_txt[n].selectAll();
                            continue;
                        }
                        this.this$0.own_txt[n].setText(this.this$0.clipDigits(YoYo.printToString(this.this$0.ownval[n])));
                        this.this$0.own_txt[n].selectAll();
                    }
                }
                this.this$0.whichToupdate.removeAllElements();
            }
            {
                this.this$0 = jEntityMonitor;
                this.constructor$0(jEntityMonitor);
            }

            private final void constructor$0(JEntityMonitor jEntityMonitor) {
            }
        });
    }

    void startThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    String clipDigits(String string) {
        int n;
        int n2 = 3;
        int n3 = string.indexOf(46);
        int n4 = string.indexOf(69);
        if (n4 != -1 && string.charAt(n4 + 1) != '-') {
            return string.substring(0, n3 + n2 + 1) + string.substring(n4, string.length());
        }
        if (n4 != -1 && string.charAt(n4 + 1) == '-') {
            String string2 = "";
            int n5 = Integer.parseInt(string.substring(n4 + 2, string.length()));
            n = 0;
            while (n < n5 - 1) {
                string2 = string2 + "0";
                ++n;
            }
            string = "0." + string2 + string.substring(0, n3);
            n3 = string.indexOf(46);
        }
        if (n3 == -1) {
            return string;
        }
        if (string.substring(n3 + 1, string.length()).length() <= n2) {
            string = string + "000";
            return string.substring(0, n3 + n2 + 1);
        }
        string = string + "000";
        double d = Double.valueOf(string);
        n = 1;
        int n6 = 1;
        while (n6 <= n2) {
            n = 10 * n;
            ++n6;
        }
        n6 = (int)Math.round(d *= (double)n);
        String string3 = "";
        String string4 = Integer.toString(n6 % n);
        int n7 = string4.length();
        while (n7 < n2) {
            string3 = string3 + "0";
            ++n7;
        }
        string = n6 / n + "." + string3 + string4;
        return string;
    }

    public abstract void setValues(int var1);

    public String doubString(double d) {
        if (d - (double)((int)d) == 0.0) {
            return Integer.toString((int)d);
        }
        return Double.toString((double)((int)(1000.0 * d)) / 1000.0);
    }

    public String colname(double d) {
        if (d == 0.0) {
            return "black";
        }
        if (d == 9.0) {
            return "white";
        }
        if (d % 10.0 != 5.0) {
            return this.doubString(d);
        }
        double d2 = d - 5.0;
        d2 /= 10.0;
        if ((d2 %= 14.0) < 0.0) {
            d2 += 14.0;
        }
        return COLOR_STRING[(int)d2];
    }

    public abstract void initFrame();

    public abstract int getNumVars();

    public abstract JLabel[] getStateLabels();

    public abstract JComponent[] getStateTexts();

    public abstract int getNumStateVariables();

    void addMyComponents(int n) {
        this.addTopBox(this.getNumStateVariables(), this.getStateLabels(), this.getStateTexts());
        this.addMiddleBox();
        this.addBottomBox();
        this.makeWholeBox(this.topBox);
    }

    void addTopBox(int n, JLabel[] jLabelArray, JComponent[] jComponentArray) {
        this.topBox = new JPanel(new GridLayout(n, 2));
        int n2 = 0;
        while (n2 < n) {
            this.topBox.add(jLabelArray[n2]);
            this.topBox.add(jComponentArray[n2]);
            ++n2;
        }
        JSLDialog.colorControl(this.topBox);
    }

    void addMiddleBox() {
        this.middlePane = null;
        if (this.getNumVars() > 0) {
            this.middleBox = new JPanel(new GridLayout(this.getNumVars(), 2));
            int n = 0;
            while (n < this.getNumVars()) {
                this.middleBox.add(this.own_lbl[n]);
                this.middleBox.add(this.own_txt[n]);
                ++n;
            }
            this.middlePane = new JScrollPane(this.middleBox, 20, 31);
            JSLDialog.colorControl(this.middleBox);
            JSLDialog.colorControl(this.middlePane);
        }
    }

    void addBottomBox() {
        Box box = Box.createVerticalBox();
        box.add(this.com.label);
        this.com.label.setForeground(Color.white);
        box.add(new JScrollPane(this, this.com, 22, 30){
            private final /* synthetic */ JEntityMonitor this$0;

            public final Dimension getPreferredSize() {
                return new Dimension(21, 80);
            }
            {
                this.this$0 = jEntityMonitor;
                this.constructor$0(jEntityMonitor, component, n, n2);
            }

            private final void constructor$0(JEntityMonitor jEntityMonitor, Component component, int n, int n2) {
            }
        });
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add(box);
        this.bottomPanel.setBackground(this.com.label.getBackground());
        this.bottomPanel.setOpaque(true);
    }

    void makeWholeBox(JPanel jPanel) {
        this.wholeBox = Box.createVerticalBox();
        this.wholeBox.add(jPanel);
        if (this.getNumVars() > 0) {
            this.wholeBox.add(this.middlePane);
        }
        if (YoYo.applet == null) {
            this.wholeBox.add(this.bottomPanel);
        }
        this.wholePanel = new JPanel(this){
            private final /* synthetic */ JEntityMonitor this$0;

            public final Insets getInsets() {
                return new Insets(4, 4, 4, 4);
            }
            {
                this.this$0 = jEntityMonitor;
                this.constructor$0(jEntityMonitor);
            }

            private final void constructor$0(JEntityMonitor jEntityMonitor) {
            }
        };
        this.wholePanel.setBackground(SystemColor.control);
        this.wholePanel.setBorder(new LineBorder(Colors.colorarray[(int)(this.getEntityColor() * 32.0)], 4));
        this.wholePanel.setOpaque(true);
        this.wholePanel.setDoubleBuffered(true);
    }

    public abstract double getEntityColor();

    public synchronized void updateOwn(boolean bl) {
        if (this.getNumVars() == 0) {
            if (!bl) {
                return;
            }
            this.wholeBox.remove(this.middlePane);
            this.validate();
            return;
        }
        if (!bl) {
            this.middleBox = new JPanel(new GridLayout(this.getNumVars(), 2));
            this.middlePane = new JScrollPane(this.middleBox, 20, 31);
            JSLDialog.colorControl(this.middleBox);
            JSLDialog.colorControl(this.middlePane);
        } else {
            this.middleBox.removeAll();
            this.middleBox.setLayout(new GridLayout(this.getNumVars(), 2));
        }
        FontMetrics fontMetrics = this.app.iface.getToolkit().getFontMetrics(EM_FONT);
        this.textHeight = fontMetrics.getHeight() + fontMetrics.getAscent();
        Dimension dimension = new Dimension(67, this.textHeight);
        boolean bl2 = false;
        this.own_txt = new JTextField[this.getNumVars()];
        this.own_lbl = new JLabel[this.getNumVars()];
        this.ownval = new Object[this.getNumVars()];
        int n = 0;
        while (n < this.getNumVars()) {
            this.own_lbl[n] = new JLabel(" " + this.getVarName(n));
            this.own_txt[n] = new JTextField(" ");
            this.own_txt[n].setName(this.getVarName(n));
            this.own_txt[n].setPreferredSize(dimension);
            this.own_txt[n].addKeyListener(this.tka);
            this.own_txt[n].addFocusListener(this.tff);
            this.formatText(this.own_txt[n]);
            JSLDialog.colorControl(this.own_lbl[n]);
            this.own_lbl[n].setFont(LABEL_FONT);
            this.middleBox.add(this.own_lbl[n]);
            this.middleBox.add(this.own_txt[n]);
            ++n;
        }
        if (!bl) {
            if (YoYo.applet == null) {
                this.wholeBox.remove(this.bottomPanel);
            }
            this.wholeBox.add(this.middlePane);
            if (YoYo.applet == null) {
                this.wholeBox.add(this.bottomPanel);
            }
        }
        this.validate();
    }

    abstract String getVarName(int var1);

    void addListeners() {
        this.tka = new TextKeyAdapter();
        this.tff = new tfFocus();
        int n = 0;
        while (n < this.getNumVars()) {
            this.own_txt[n].addKeyListener(this.tka);
            this.own_txt[n].addFocusListener(this.tff);
            ++n;
        }
        this.com.addFocusListener(this.tff);
    }

    public void registerCloser(Frame frame, Application application) {
        frame.addWindowListener(new Closer(application));
    }

    abstract void closeMonitor();

    public abstract void run();

    void handlecr(JTextField jTextField) {
        String string = jTextField.getName();
        String string2 = jTextField.getText();
        this.runLine(this.getCommand(string, string2));
    }

    abstract String getCommand(String var1, String var2);

    public void done(Context context) {
        this.fieldChanged = false;
    }

    abstract String getCompileCommand(String var1);

    public void runLine(String string) {
        if (!this.sl.app.maybeCompile()) {
            return;
        }
        this.runningp = true;
        if (string != null && string != "") {
            Object[] objectArray = Reader.read(this.getCompileCommand(string));
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = this;
            this.sl.app.cc.enqueue(objectArray2, this.sl.app.message, this.sl.app.err, null);
        }
    }

    public int[] castToIntArray(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        return nArray;
    }

    public abstract void runCompiledCommand(Object[] var1, Object[] var2);

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0 && this.runningp) {
            this.runningp = false;
        }
        if (this.lastField != -1) {
            if (this.lastOwn) {
                this.setOwn(this.lastField);
            } else {
                this.setValues(this.lastField);
            }
        }
        this.lastField = -1;
        this.lastOwn = false;
        this.fieldChanged = false;
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void callerPrintln(String string) {
    }

    public void callerClearText() {
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
    }

    public void displayOneString(String string) {
        if (!this.com.runningp) {
            this.com.displayOneString(string);
        } else {
            StarLogoError.error(this.app, string, false);
        }
    }

    public void displayAString(String string) {
        if (!this.com.runningp) {
            this.com.displayOneString(string);
        } else {
            StarLogoError.error(this.app, string, false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable;
        Object object = itemEvent.getSource();
        String string = "";
        boolean bl = false;
        if (object instanceof JRadioButtonMenuItem) {
            itemSelectable = (JRadioButtonMenuItem)object;
            string = ((AbstractButton)itemSelectable).getLabel();
            bl = ((AbstractButton)itemSelectable).isSelected();
        } else if (object instanceof CheckboxMenuItem) {
            itemSelectable = (CheckboxMenuItem)object;
            string = ((MenuItem)((Object)itemSelectable)).getLabel();
            bl = ((CheckboxMenuItem)itemSelectable).getState();
        }
        try {
            int n = Integer.parseInt(string);
            Font font = this.com.getFont();
            this.com.setFont(new Font(font.getName(), font.getStyle(), n));
            this.slmenu.setCurrentSize(object);
            return;
        }
        catch (Exception exception) {
            Font font = this.com.getFont();
            this.setFont(new Font(string, font.getStyle(), font.getSize()));
            this.slmenu.setCurrentFont(object);
            return;
        }
    }

    public JTextComponent getTextFocus() {
        return this.focus;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Accessible accessible;
        Object object = actionEvent.getSource();
        String string = "";
        if (object instanceof JMenuItem) {
            accessible = (JMenuItem)object;
            string = ((AbstractButton)((Object)accessible)).getLabel();
        } else if (object instanceof MenuItem) {
            accessible = (MenuItem)object;
            string = ((MenuItem)accessible).getLabel();
        }
        accessible = this.getTextFocus();
        if (string.equals("Cut")) {
            ((JTextComponent)accessible).cut();
            return;
        }
        if (string.equals("Copy")) {
            ((JTextComponent)accessible).copy();
            return;
        }
        if (string.equals("Paste")) {
            ((JTextComponent)accessible).paste();
            return;
        }
        if (string.equals("Select All")) {
            ((JTextComponent)accessible).selectAll();
            return;
        }
        if (string.equals("Clear")) {
            ((JTextComponent)accessible).setText("");
        }
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    public JEntityMonitor(String string, double d, Application application) {
        super(string);
        this.setResizable(true);
        this.delay = d;
        this.app = application;
        this.sl = application.sl;
        this.clip = application.clip;
        this.addWindowListener(application.windowHider);
        this.registerCloser(this, application);
        this.setDefaultCloseOperation(0);
        application.registerFrameTracker(this);
        application.addWindow(this);
    }

    static {
        COLOR_STRING = new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "purple", "magenta", "pink"};
        try {
            EM_FONT = WidgetLite.WIDGET_FONT;
            EM_FONT = Font.getFont("starlogo.entity-monitor.font", EM_FONT);
            LABEL_FONT = WidgetLite.WIDGET_FONT;
            LABEL_FONT = Font.getFont("starlogo.entity-label.font", LABEL_FONT);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected class Closer
    extends WindowAdapter {
        Application app;

        public void windowClosing(WindowEvent windowEvent) {
            Closer closer = this;
            synchronized (closer) {
                JEntityMonitor.this.closep = true;
                ((Component)windowEvent.getWindow()).setVisible(false);
                this.app.removeWindow((StarLogoFrame)((Object)windowEvent.getWindow()));
                JEntityMonitor.this.closeMonitor();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public Closer(Application application) {
            this.app = application;
        }
    }

    public class tfFocus
    extends WindowAdapter
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            JEntityMonitor.this.focus = focusEvent.getComponent() instanceof JTextComponent ? (JTextComponent)focusEvent.getComponent() : null;
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class TextKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getComponent();
            char c = keyEvent.getKeyChar();
            if (c == '\r' || c == '\n') {
                JEntityMonitor.this.handlecr(jTextField);
                keyEvent.consume();
                return;
            }
            super.keyPressed(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getComponent();
            char c = keyEvent.getKeyChar();
            if (c == '\r' || c == '\n') {
                keyEvent.consume();
                return;
            }
            JEntityMonitor.this.fieldChanged = true;
            super.keyTyped(keyEvent);
        }

        TextKeyAdapter() {
        }
    }
}

