/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import starlogo.Application;
import starlogo.ButtonWidget;
import starlogo.ColorChooser;
import starlogo.Colortool;
import starlogo.Interface;
import starlogo.InterfaceDelegate;
import starlogo.JInterfaceFrame;
import starlogo.LineWidget;
import starlogo.MonitorWidget;
import starlogo.PaintSelect;
import starlogo.Painttool;
import starlogo.PatchCanvas;
import starlogo.SmartRectangle;
import starlogo.SpeedSliderWidget;
import starlogo.StarLogo;
import starlogo.StatusToolbar;
import starlogo.TextWidget;
import starlogo.ToolbarWidget;
import starlogo.TrashWidget;
import starlogo.Widget;
import starlogo.WidgetClipboard;
import starlogo.WidgetDrag;
import starlogo.WidgetHolder;
import starlogo.WidgetLite;
import yoyo.YoYo;

public class JInterface
extends JComponent
implements Interface {
    public InterfaceDelegate iface;

    public void init() {
        this.iface.init();
        if (YoYo.applet == null) {
            this.iface.frame = new JInterfaceFrame(this.iface.app, this);
            this.iface.parent = (JFrame)((Object)this.iface.frame);
            this.setDoubleBuffered(true);
            this.setOpaque(true);
            this.iface.parent.addNotify();
        }
        this.setupListeners();
        this.iface.createComponents();
        this.setupLayout();
    }

    private final void setupListeners() {
        this.enableEvents(16L);
        this.enableEvents(32L);
        if (YoYo.applet == null) {
            this.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ JInterface this$0;

                public final void componentResized(ComponentEvent componentEvent) {
                    this.this$0.resizeWidgetsOnInterfaceResize();
                }
                {
                    this.this$0 = jInterface;
                    this.constructor$0(jInterface);
                }

                private final void constructor$0(JInterface jInterface) {
                }
            });
        }
    }

    public void resizeWidgetsOnInterfaceResize() {
        this.iface.resizeWidgetsOnInterfaceResize();
    }

    public void setTitle(String string) {
        this.iface.setTitle(string);
    }

    public String getTitle() {
        return this.iface.getTitle();
    }

    private final void setupLayout() {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        Insets insets = this.getInsets();
        this.setLocation(insets.left, insets.top);
        this.setSize(this.iface.parent.getSize().width - insets.left - insets.right, this.iface.parent.getSize().height - insets.top - insets.bottom);
        Rectangle rectangle = this.getBoundaries();
        this.iface.sl.patchcanvas.setLocation(rectangle.x + rectangle.width - this.iface.sl.patchcanvas.position.width - (YoYo.macintoshp ? 5 : 15), rectangle.y + 5);
        if (this.iface.app.doubleBufferp) {
            this.iface.image = this.iface.parent.createImage(this.getSize().width, this.getSize().height);
            if (this.iface.image == null) {
                // empty if block
            }
        }
    }

    public void setOutline(int n, int n2, int n3, int n4) {
        this.iface.setOutline(n, n2, n3, n4);
    }

    public void resetOutline() {
        this.iface.resetOutline();
    }

    public void processTimerEvent() {
        this.iface.processTimerEvent();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        this.iface.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.iface.processMouseMotionEvent(mouseEvent);
    }

    public void processWidgetMouseEvent(MouseEvent mouseEvent, Widget widget) {
        this.iface.processWidgetMouseEvent(mouseEvent, widget);
    }

    protected void moveWidgets(MouseEvent mouseEvent, WidgetDrag[] widgetDragArray) {
        this.iface.moveWidgets(mouseEvent, widgetDragArray);
    }

    public int distanceSquared(Point point, int n, int n2) {
        return this.iface.distanceSquared(point, n, n2);
    }

    public Point pointSubtract(Point point, Point point2) {
        return this.iface.pointSubtract(point, point2);
    }

    public Point limitPointToView(Point point) {
        return this.iface.limitPointToView(point);
    }

    protected void processResizeEvent(MouseEvent mouseEvent, Widget widget) {
        this.iface.processResizeEvent(mouseEvent, widget);
    }

    protected void resizeWidget(Point point, Widget widget, int n) {
        this.iface.resizeWidget(point, widget, n);
    }

    public Cursor resizeCursor(int n) {
        return this.iface.resizeCursor(n);
    }

    protected boolean maybeEditWidget(Widget widget) {
        return this.iface.maybeEditWidget(widget);
    }

    public void maybeReleasePatchCanvas() {
        this.iface.maybeReleasePatchCanvas();
    }

    protected void mousePressed(MouseEvent mouseEvent) {
        this.iface.mousePressed(mouseEvent);
    }

    protected void mouseDragged(MouseEvent mouseEvent) {
        this.iface.mouseDragged(mouseEvent);
    }

    protected void mouseReleased(MouseEvent mouseEvent) {
        this.iface.mouseReleased(mouseEvent);
    }

    protected void selectWidgets(Rectangle rectangle) {
        this.iface.selectWidgets(rectangle);
    }

    public void repaint(Rectangle rectangle) {
        this.trim(rectangle);
        if (!rectangle.isEmpty()) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void trim(Rectangle rectangle) {
        this.iface.trim(rectangle);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics graphics2 = null;
        Dimension dimension = this.getSize();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(dimension.width, dimension.height);
        }
        if (this.iface.app.doubleBufferp) {
            if (this.iface.image == null || this.iface.image.getWidth(this) != dimension.width || this.iface.image.getHeight(this) != dimension.height) {
                if (dimension.width == 0 || dimension.height == 0) {
                    return;
                }
                this.iface.image = this.iface.parent.createImage(dimension.width, dimension.height);
                if (this.iface.image == null) {
                    return;
                }
                graphics2 = this.iface.image.getGraphics();
            } else {
                graphics2 = this.iface.image.getGraphics();
                graphics2.setColor(Color.white);
                graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics2.setClip(rectangle);
        } else {
            graphics.setClip(rectangle);
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(Color.black);
        if (this.getPatchCanvas() != null && rectangle.intersects(this.getPatchCanvas().position)) {
            Object object = this.iface.sl.runningp;
            synchronized (object) {
                this.paintComponents(this.iface.app.doubleBufferp ? graphics2 : graphics, rectangle);
                if (YoYo.applet == null) {
                    this.paintToolbar(this.iface.app.doubleBufferp ? graphics2 : graphics, rectangle);
                }
                if (this.iface.outline != null && rectangle.intersects(this.iface.outline)) {
                    this.drawOutline(this.iface.app.doubleBufferp ? graphics2 : graphics);
                }
                if (this.iface.tooltipShown != null && rectangle.intersects(this.iface.tooltipShown.position)) {
                    this.iface.tooltipShown.paint(this.iface.app.doubleBufferp ? graphics2 : graphics);
                }
                if (this.iface.app.doubleBufferp) {
                    graphics.drawImage(this.iface.image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null, null);
                }
                this.getToolkit().sync();
            }
        } else {
            this.paintComponents(this.iface.app.doubleBufferp ? graphics2 : graphics, rectangle);
            if (YoYo.applet == null) {
                this.paintToolbar(this.iface.app.doubleBufferp ? graphics2 : graphics, rectangle);
            }
            if (this.iface.outline != null && rectangle.intersects(this.iface.outline)) {
                this.drawOutline(this.iface.app.doubleBufferp ? graphics2 : graphics);
            }
            if (this.iface.tooltipShown != null && rectangle.intersects(this.iface.tooltipShown.position)) {
                this.iface.tooltipShown.paint(this.iface.app.doubleBufferp ? graphics2 : graphics);
            }
            if (this.iface.app.doubleBufferp) {
                graphics.drawImage(this.iface.image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null, null);
            }
            this.getToolkit().sync();
        }
        if (this.iface.app.doubleBufferp) {
            graphics2.dispose();
        }
    }

    protected void paintToolbar(Graphics graphics, Rectangle rectangle) {
        if (this.iface.toolbar == null) {
            return;
        }
        Rectangle rectangle2 = new Rectangle();
        Dimension dimension = this.getSize();
        if (YoYo.macosxp) {
            graphics.setColor(UIManager.getColor("window"));
        } else {
            graphics.setColor(SystemColor.control);
        }
        rectangle2.setBounds(0, 0, InterfaceDelegate.toolbarwidth, dimension.height);
        if (rectangle.intersects(rectangle2)) {
            graphics.fillRect(0, 0, InterfaceDelegate.toolbarwidth, dimension.height);
            graphics.draw3DRect(this.iface.toolbar.position.x, 0, InterfaceDelegate.toolbarwidth - 1, dimension.height - 1, true);
        }
        rectangle2.setBounds(0, 0, dimension.width, InterfaceDelegate.toolbarheight);
        if (rectangle.intersects(rectangle2)) {
            graphics.fillRect(0, 0, dimension.width, InterfaceDelegate.toolbarheight);
            graphics.draw3DRect(0, 0, dimension.width - 1, InterfaceDelegate.toolbarheight - 1, true);
        }
        Enumeration enumeration = this.iface.wh.listToolbars();
        while (enumeration.hasMoreElements()) {
            Widget widget = (Widget)enumeration.nextElement();
            if (!widget.intersects(rectangle)) continue;
            widget.paint(graphics);
        }
    }

    public PatchCanvas getPatchCanvas() {
        return this.iface.getPatchCanvas();
    }

    public Rectangle getBoundaries() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        if (YoYo.applet == null) {
            return new Rectangle(InterfaceDelegate.toolbarwidth, InterfaceDelegate.toolbarheight + insets.top, dimension.width - InterfaceDelegate.toolbarwidth, dimension.height - InterfaceDelegate.toolbarheight - InterfaceDelegate.statusbarheight - insets.top);
        }
        return new Rectangle(0, 0, dimension.width, dimension.height);
    }

    public Dimension getVisibleSize() {
        Dimension dimension = this.getSize();
        return new Dimension(dimension.width - InterfaceDelegate.toolbarwidth, Math.max(0, dimension.height - InterfaceDelegate.toolbarheight - InterfaceDelegate.statusbarheight));
    }

    public void setVisibleSize(int n, int n2) {
        if (YoYo.applet == null) {
            int n3 = n + InterfaceDelegate.toolbarwidth;
            int n4 = n2 + InterfaceDelegate.toolbarheight + InterfaceDelegate.statusbarheight;
            this.iface.frame.setVisibleSize(n3, n4);
            this.setSize(n3, n4);
        }
    }

    protected void paintComponents(Graphics graphics, Rectangle rectangle) {
        this.iface.paintComponents(graphics, rectangle);
    }

    protected void drawOutline(Graphics graphics) {
        this.iface.drawOutline(graphics);
    }

    public Widget getWidgetAt(int n, int n2) {
        return this.iface.getWidgetAt(n, n2);
    }

    public WidgetDrag getCornerAt(int n, int n2) {
        return this.iface.getCornerAt(n, n2);
    }

    public void moveToFront(Widget widget) {
        this.iface.moveToFront(widget);
    }

    public void markChanged() {
        this.iface.markChanged();
    }

    public void clearSelections() {
        this.iface.clearSelections();
    }

    public void replacePatchCanvas(PatchCanvas patchCanvas, PatchCanvas patchCanvas2) {
        this.iface.replacePatchCanvas(patchCanvas, patchCanvas2, patchCanvas.getLocation().x, patchCanvas.getLocation().y);
    }

    public void replacePatchCanvas(PatchCanvas patchCanvas, PatchCanvas patchCanvas2, int n, int n2) {
        this.iface.replacePatchCanvas(patchCanvas, patchCanvas2, n, n2);
    }

    public void deleteSelections(boolean bl) {
        this.iface.deleteSelections(bl);
    }

    public void select(Widget widget) {
        this.iface.select(widget);
    }

    public void select(Widget widget, boolean bl) {
        this.iface.select(widget, bl);
    }

    public void deselect(Widget widget) {
        this.iface.deselect(widget);
    }

    public void deselectAll(boolean bl) {
        this.iface.deselectAll(bl);
    }

    public void selectAll(boolean bl) {
        this.iface.selectAll(bl);
    }

    protected void mouseMoved(MouseEvent mouseEvent) {
        this.iface.mouseMoved(mouseEvent);
    }

    protected void updatePointerCoordinates(Point point) {
        this.iface.updatePointerCoordinates(point);
    }

    public void addToClipRect(Rectangle rectangle) {
        this.iface.addToClipRect(rectangle);
    }

    public void growClipRect(int n, int n2) {
        this.iface.growClipRect(n, n2);
    }

    public void addHandlesToClipRect(Widget widget) {
        this.iface.addHandlesToClipRect(widget);
    }

    public void addWidget(Widget widget) {
        this.iface.addWidget(widget);
    }

    public void removeWidget(Widget widget) {
        this.iface.removeWidget(widget);
    }

    public boolean isObscured(Widget widget) {
        return this.iface.isObscured(widget);
    }

    public Object[] getSliders() {
        return this.iface.getSliders();
    }

    public Object getSlider(int n) {
        return this.iface.getSlider(n);
    }

    public Object getButton(int n) {
        return this.iface.getButton(n);
    }

    public Object getMonitor(int n) {
        return this.iface.getMonitor(n);
    }

    public Object getLineWidget(int n) {
        return this.iface.getLineWidget(n);
    }

    public Object getLineWidgetFromTitle(String string) {
        return this.iface.getLineWidgetFromTitle(string);
    }

    public LineWidget getOldestLineWidget() {
        return this.iface.getOldestLineWidget();
    }

    public Object getTextWidget(int n) {
        return this.iface.getTextWidget(n);
    }

    public MonitorWidget[] getMonitors() {
        return this.iface.getMonitors();
    }

    public ButtonWidget[] getButtons() {
        return this.iface.getButtons();
    }

    public LineWidget[] getLineWidgets() {
        return this.iface.getLineWidgets();
    }

    public TextWidget[] getTextWidgets() {
        return this.iface.getTextWidgets();
    }

    public Object[] getPreButtons() {
        return this.iface.getPreButtons();
    }

    public int getHighestButtonID() {
        return this.iface.getHighestButtonID();
    }

    public void compileWidgets() {
        this.iface.compileWidgets();
    }

    public int numMonitors() {
        return this.iface.numMonitors();
    }

    public int numMonitorsOn() {
        return this.iface.numMonitorsOn();
    }

    public void clearLineWidgets() {
        this.iface.clearLineWidgets();
    }

    public void closeWidgetWindows() {
        this.iface.closeWidgetWindows();
    }

    public int numLineWidgets() {
        return this.iface.numLineWidgets();
    }

    public int numLineWidgetsOn() {
        return this.iface.numLineWidgetsOn();
    }

    public void erasePointsOnAllWidgets(int n) {
        this.iface.erasePointsOnAllWidgets(n);
    }

    public String getSaveString(boolean bl) throws IOException {
        return this.iface.getSaveString(bl);
    }

    public void reset() {
        this.iface.reset();
    }

    public void loadFromString(String string, boolean bl) {
        this.iface.loadFromString(string, bl);
    }

    protected void readWidgets(String string, boolean bl) {
        this.iface.readWidgets(string, bl);
    }

    public static String startswithp(String string, String[] stringArray) {
        return InterfaceDelegate.startswithp(string, stringArray);
    }

    public static void removeQuotes(Vector vector) {
        InterfaceDelegate.removeQuotes(vector);
    }

    public void setCellScroll(int n) {
        this.iface.setCellScroll(n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        JMenuItem jMenuItem;
        if (YoYo.macintoshp && !YoYo.macosxp) {
            CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
            String string2 = checkboxMenuItem.getLabel();
            if (string2.equals("Show Shapes") || string2.equals("Muestre Figuras")) {
                StarLogo cfr_ignored_0 = this.iface.sl;
                StarLogo cfr_ignored_1 = this.iface.sl;
                StarLogo.altgraphics = (StarLogo.altgraphics + 1) % 2;
                this.iface.sl.switchPatches();
                this.repaint(this.iface.sl.patchcanvas.position);
                return;
            }
            if (string2.equals("Snap to Grid") || string2.equals("Connecte a Red")) {
                this.iface.snapToGrid = !this.iface.snapToGrid;
                return;
            }
            if (string2.equals("Auto-Compile")) {
                this.iface.app.autocompile = checkboxMenuItem.getState();
                return;
            }
            try {
                int n = Integer.parseInt(string2);
                Font font = this.getFont();
                this.setFont(new Font(font.getName(), font.getStyle(), n));
                this.iface.frame.getMenu().setCurrentSize(checkboxMenuItem);
                return;
            }
            catch (Exception exception) {
                Font font = this.getFont();
                this.setFont(new Font(string2, font.getStyle(), font.getSize()));
                this.iface.frame.getMenu().setCurrentFont(checkboxMenuItem);
                return;
            }
        }
        if (itemEvent.getSource() instanceof JCheckBoxMenuItem) {
            jMenuItem = (JCheckBoxMenuItem)itemEvent.getSource();
            string = jMenuItem.getLabel();
            if (string.equals("Snap to Grid") || string.equals("Connecte a Red")) {
                this.iface.snapToGrid = !this.iface.snapToGrid;
                return;
            }
            if (string.equals("Show Shapes") || string.equals("Muestre Figuras")) {
                StarLogo cfr_ignored_2 = this.iface.sl;
                StarLogo cfr_ignored_3 = this.iface.sl;
                StarLogo.altgraphics = (StarLogo.altgraphics + 1) % 2;
                this.iface.sl.switchPatches();
                this.repaint(this.iface.sl.patchcanvas.position);
                return;
            }
            if (string.equals("Auto-Compile")) {
                this.iface.app.autocompile = ((JCheckBoxMenuItem)jMenuItem).getState();
                return;
            }
        }
        if (itemEvent.getSource() instanceof JRadioButtonMenuItem) {
            jMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
            string = jMenuItem.getLabel();
            if (string.equals("Snap to Grid") || string.equals("Connecte a Red")) {
                this.iface.snapToGrid = !this.iface.snapToGrid;
                return;
            }
            if (string.equals("Show Shapes") || string.equals("Muestre Figuras")) {
                StarLogo cfr_ignored_4 = this.iface.sl;
                StarLogo cfr_ignored_5 = this.iface.sl;
                StarLogo.altgraphics = (StarLogo.altgraphics + 1) % 2;
                this.iface.sl.switchPatches();
                this.repaint(this.iface.sl.patchcanvas.position);
                return;
            }
            try {
                int n = Integer.parseInt(string);
                Font font = this.getFont();
                this.setFont(new Font(font.getName(), font.getStyle(), n));
                this.iface.frame.getMenu().setCurrentSize(jMenuItem);
                return;
            }
            catch (Exception exception) {
                Font font = this.getFont();
                this.setFont(new Font(string, font.getStyle(), font.getSize()));
                this.iface.frame.getMenu().setCurrentFont(jMenuItem);
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Accessible accessible;
        Object object = actionEvent.getSource();
        String string = "";
        if (object instanceof JMenuItem) {
            accessible = (JMenuItem)object;
            string = ((AbstractButton)((Object)accessible)).getLabel();
        } else if (object instanceof MenuItem) {
            accessible = (MenuItem)object;
            string = ((MenuItem)accessible).getLabel();
        }
        if (string.equals("Cut")) {
            accessible = this.iface.wh.getSelectedWidgets(false);
            if (accessible == null) {
                this.deselectAll(true);
                return;
            }
            this.iface.wclipboard.clear();
            this.iface.wclipboard.setWidgets((WidgetDrag[])accessible);
            this.deleteSelections(true);
            this.iface.wclipboard.setState(WidgetClipboard.CUT);
            this.iface.frame.getMenu().enablePasteMenu();
            return;
        }
        if (string.equals("Copy")) {
            accessible = this.iface.wh.getSelectedWidgets(false);
            if (accessible == null) {
                this.deselectAll(true);
                return;
            }
            this.iface.wclipboard.clear();
            this.iface.wclipboard.setWidgets((WidgetDrag[])accessible);
            this.iface.wclipboard.setState(WidgetClipboard.COPY);
            this.iface.frame.getMenu().enablePasteMenu();
            return;
        }
        if (string.equals("Paste")) {
            this.pasteWidgets(true);
            return;
        }
        if (string.equals("Clear")) {
            if (this.selecting()) {
                this.deleteSelections(true);
            }
            return;
        }
        if (string.equals("Select All")) {
            this.selectAll(true);
            return;
        }
    }

    public void pasteWidgets(boolean bl) {
        if (this.iface.wclipboard.empty()) {
            return;
        }
        if (bl) {
            this.iface.clipRect = new Rectangle();
        }
        this.clearSelections();
        WidgetDrag[] widgetDragArray = this.iface.wclipboard.getWidgets();
        int n = this.iface.wclipboard.getCopyNumber();
        int n2 = 0;
        int n3 = 0;
        while (n3 < widgetDragArray.length) {
            WidgetDrag widgetDrag = widgetDragArray[n3];
            WidgetDrag widgetDrag2 = null;
            Rectangle rectangle = this.iface.wclipboard.getState() == WidgetClipboard.CUT ? widgetDrag.position : new Rectangle(widgetDrag.position.x + (n - 1) * 20, widgetDrag.position.y + (n - 1) * 20, widgetDrag.position.width, widgetDrag.position.height);
            if (!this.getBoundaries().contains(rectangle.x, rectangle.y) || !this.getBoundaries().contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) {
                rectangle.x = this.getBoundaries().x + 20 * n2;
                rectangle.y = this.getBoundaries().y + 20 * n2;
                ++n2;
            }
            if (this.iface.snapToGrid) {
                widgetDrag.snapToGrid();
            }
            widgetDrag2 = this.iface.wclipboard.getState() == WidgetClipboard.CUT ? widgetDrag : widgetDrag.copy(n, rectangle);
            this.addWidget(widgetDrag2);
            this.select(widgetDrag2);
            this.addHandlesToClipRect(widgetDrag2);
            ++n3;
        }
        this.iface.wclipboard.setState(WidgetClipboard.PASTE);
        this.iface.frame.getMenu().enableCutCopyClearMenu();
        if (bl) {
            this.repaint(this.iface.clipRect);
        }
        this.iface.app.rancompilerp = false;
        this.iface.app.project.markChanged();
    }

    public boolean selecting() {
        return this.iface.selecting();
    }

    public void print() {
        this.iface.print();
    }

    public void setStatus(String string) {
        this.iface.setStatus(string);
    }

    public void resetStatus() {
        this.iface.resetStatus();
    }

    public ToolbarWidget getToolbar() {
        return this.iface.getToolbar();
    }

    public boolean snapToGrid() {
        return this.iface.snapToGrid();
    }

    public boolean resizingp() {
        return this.iface.resizingp();
    }

    public boolean draggingp() {
        return this.iface.draggingp();
    }

    public Widget widgetTouched() {
        return this.iface.widgetTouched();
    }

    public WidgetHolder wh() {
        return this.iface.wh();
    }

    public StarLogo sl() {
        return this.iface.sl();
    }

    public Application app() {
        return this.iface.app();
    }

    public boolean pressedShiftControlp() {
        return this.iface.pressedShiftControlp();
    }

    public boolean firstresizep() {
        return this.iface.firstresizep();
    }

    public int statusbarheight() {
        return this.iface.statusbarheight();
    }

    public int toolbarheight() {
        return this.iface.toolbarheight();
    }

    public int toolbarwidth() {
        return this.iface.toolbarwidth();
    }

    public Frame frame() {
        return this.iface.frame();
    }

    public Rectangle clipRect() {
        return this.iface.clipRect();
    }

    public void setClipRect(Rectangle rectangle) {
        this.iface.setClipRect(rectangle);
    }

    public Widget keyboardFocus() {
        return this.iface.keyboardFocus();
    }

    public void setKeyboardFocus(Widget widget) {
        this.iface.setKeyboardFocus(widget);
    }

    public PaintSelect paintselect() {
        return this.iface.paintselect;
    }

    public Painttool painttool() {
        return this.iface.painttool;
    }

    public Colortool colortool() {
        return this.iface.colortool;
    }

    public ColorChooser colorchooser() {
        return this.iface.colorchooser;
    }

    public Vector sliders() {
        return this.iface.sliders;
    }

    public Vector legends() {
        return this.iface.legends;
    }

    public Vector linewidgets() {
        return this.iface.linewidgets;
    }

    public Vector buttons() {
        return this.iface.buttons;
    }

    public Vector monitors() {
        return this.iface.monitors;
    }

    public Vector textwidgets() {
        return this.iface.textwidgets;
    }

    public SmartRectangle outline() {
        return this.iface.outline;
    }

    public StatusToolbar statusbar() {
        return this.iface.statusbar;
    }

    public TrashWidget trashwidget() {
        return this.iface.trashwidget;
    }

    public SpeedSliderWidget speedsliderwidget() {
        return this.iface.speedsliderwidget;
    }

    public ToolbarWidget toolbar() {
        return this.iface.toolbar;
    }

    public void addPlotWindow(String string) {
        this.iface.addPlotWindow(string);
    }

    public void removePlotWindow(String string) {
        this.iface.removePlotWindow(string);
    }

    public void removeAllPlotWindows() {
        this.iface.removeAllPlotWindows();
    }

    public void changePlotWindow(String string, String string2) {
        this.iface.changePlotWindow(string, string2);
    }

    public void setTooltipWidget(WidgetLite widgetLite) {
        this.iface.setTooltipWidget(widgetLite);
    }

    public void setBackgroundp(boolean bl) {
        this.iface.setBackgroundp(bl);
    }

    public JInterface(Application application) {
        this.iface = new InterfaceDelegate(application, this);
    }
}

