/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import starlogo.JMessageDialog;
import starlogo.JSLDialog;
import starlogo.JWidgetDialog;
import starlogo.MonitorDialog;
import starlogo.MonitorWidget;
import starlogo.ToolTipWidget;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.YoYo;

public class JMonitorDialog
extends JWidgetDialog
implements MonitorDialog,
FocusListener {
    private static JMonitorDialog dialog;
    private JComboBox digChoice;
    private JComboBox delChoice;
    private JLabel instLab;
    private JLabel digLab;
    private JLabel delLab;
    private JPanel butPanel;
    private JTextField instText;
    private String name;
    private ButtonGroup nameGroup;
    private JRadioButton instCheck;
    private JRadioButton nameCheck;
    private JTextField nameText;
    private JPanel namePanel;
    private JPanel namefieldPanel;
    private JPanel instructionfieldPanel;
    private JLabel nameLab;
    private JScrollPane descriptScroll;
    private JLabel descriptLab;
    private JTextArea descriptText;
    private String descript;
    public boolean shortcuts = true;

    public static JMonitorDialog create(Frame frame, String string, WidgetDrag widgetDrag) {
        MonitorWidget monitorWidget = (MonitorWidget)widgetDrag;
        if (dialog == null) {
            dialog = new JMonitorDialog(frame, string);
        } else {
            dialog.setTitle(string);
        }
        dialog.addNotify();
        dialog.setFields(monitorWidget.name, monitorWidget.inst, monitorWidget.digits, monitorWidget.delay, monitorWidget.showName, monitorWidget.getToolText());
        return dialog;
    }

    public static JMonitorDialog create(Frame frame, String string) {
        String string2 = "monitor" + MonitorWidget.idCount;
        if (YoYo.language == 1) {
            string2 = "monitor" + MonitorWidget.idCount;
        }
        if (dialog == null) {
            dialog = new JMonitorDialog(frame, string);
        } else {
            dialog.setTitle(string);
        }
        dialog.addNotify();
        dialog.setFields(string2, "", 0, 0.5, false, "");
        return dialog;
    }

    private final void setFields(String string, String string2, int n, double d, boolean bl, String string3) {
        this.name = string;
        this.instText.setText(string2);
        this.instText.setCaretPosition(0);
        this.nameText.setText(string);
        this.nameText.setCaretPosition(0);
        this.digChoice.setSelectedIndex(n);
        this.delChoice.setSelectedIndex((int)(10.0 * d) - 1);
        this.descriptText.setText(string3);
        this.descriptText.setCaretPosition(0);
        if (bl) {
            this.nameCheck.setSelected(true);
        } else {
            this.instCheck.setSelected(true);
        }
    }

    public void setupComponents() {
        this.nameLab = new JLabel("Name:");
        this.nameText = new JTextField(15);
        this.instLab = new JLabel("StarLogo Instruction:");
        this.instText = new JTextField(30);
        this.nameGroup = new ButtonGroup();
        this.namePanel = new JPanel(new GridLayout(2, 1, 5, 0));
        this.instCheck = new JRadioButton("Show Instruction", true);
        this.nameCheck = new JRadioButton("Show Name", false);
        this.nameGroup.add(this.instCheck);
        this.nameGroup.add(this.nameCheck);
        this.namePanel.add(this.nameCheck);
        this.namePanel.add(this.instCheck);
        this.digLab = new JLabel("Decimal Places:");
        this.digChoice = new JComboBox<Object>(new Object[]{"0", "1", "2", "3"});
        this.delLab = new JLabel("Update Delay (sec):");
        this.delChoice = new JComboBox<Object>(new Object[]{"0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1.0"});
        this.butPanel = new JPanel();
        this.butPanel.setLayout(new GridLayout(2, 1, 0, 5));
        this.butPanel.add(this.bca);
        this.butPanel.add(this.bok);
        this.descriptLab = new JLabel("Tooltip:");
        this.descriptText = new JTextArea();
        this.descriptText.setLineWrap(true);
        this.descriptText.setWrapStyleWord(true);
        this.descriptScroll = new JScrollPane(this.descriptText);
        this.descriptScroll.setVerticalScrollBarPolicy(20);
        this.descriptScroll.setPreferredSize(new Dimension(50, 70));
        JSLDialog.formatText(this.instText);
        JSLDialog.formatText(this.nameText);
        JSLDialog.formatLabel(this.nameLab);
        JSLDialog.formatLabel(this.instLab);
        JSLDialog.formatLabel(this.namePanel);
        JSLDialog.formatLabel(this.digLab);
        JSLDialog.formatLabel(this.delLab);
        JSLDialog.formatLabel(this.descriptLab);
        JSLDialog.formatLabel(this.butPanel);
        JSLDialog.formatLabel(this.bok);
        JSLDialog.formatLabel(this.bca);
        if (YoYo.language == 1) {
            this.nameLab = new JLabel("Nombre:");
            this.nameText = new JTextField(15);
            this.instLab = new JLabel("Instrucci\u00f3n de StarLogo:");
            this.instText = new JTextField(30);
            this.nameGroup = new ButtonGroup();
            this.namePanel = new JPanel(new GridLayout(2, 1, 5, 0));
            this.instCheck = new JRadioButton("Muestre Instrucci\u00f3n", true);
            this.nameCheck = new JRadioButton("Muestre Nombre", false);
            this.nameGroup.add(this.instCheck);
            this.nameGroup.add(this.nameCheck);
            this.namePanel.add(this.nameCheck);
            this.namePanel.add(this.instCheck);
            this.namePanel.add(this.instCheck);
            this.digLab = new JLabel("Cifras Decimales:");
            this.delLab = new JLabel("Demora de Actualizaci\u00f3n (seg):");
            this.descriptLab = new JLabel("Descripci\u00f3n:");
        }
    }

    protected void setupGBC() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.getContentPane().add((Component)this.nameLab, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 0);
        this.getContentPane().add((Component)this.nameText, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.getContentPane().add((Component)this.instLab, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.getContentPane().add((Component)this.instText, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.getContentPane().add((Component)this.descriptLab, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.getContentPane().add((Component)this.descriptScroll, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(13, 13, 0, 0);
        this.getContentPane().add((Component)this.digLab, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(13, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.digChoice, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 13, 13, 0);
        this.getContentPane().add((Component)this.delLab, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 13, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.delChoice, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(13, 0, 13, 13);
        this.getContentPane().add((Component)this.butPanel, gridBagConstraints);
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(YoYo.macintoshp ? 13 : 6, 13, 0, 13);
        this.getContentPane().add((Component)this.namePanel, gridBagConstraints);
        this.pack();
    }

    protected void setupPosition() {
        ((Component)this).setSize(YoYo.macintoshp && !YoYo.macosxp ? 380 : 350, YoYo.macosxp ? 230 : (YoYo.macintoshp ? 230 : (YoYo.linuxp ? 250 : 300)));
        this.initLocation();
    }

    protected boolean valid_inputs() {
        String string = this.instText.getText().trim();
        if (string.equals("")) {
            JMessageDialog jMessageDialog = new JMessageDialog(this.parent, "Warning", "Sorry, you must specify an instruction to run.");
            jMessageDialog.show();
            return false;
        }
        return true;
    }

    public void getValues(WidgetDrag widgetDrag) {
        MonitorWidget monitorWidget = (MonitorWidget)widgetDrag;
        monitorWidget.inst = this.instText.getText().trim();
        monitorWidget.name = this.nameText.getText();
        monitorWidget.showName = this.nameCheck.isSelected();
        monitorWidget.digits = this.digChoice.getSelectedIndex();
        monitorWidget.font = WidgetLite.WIDGET_FONT;
        monitorWidget.delay = (double)(this.delChoice.getSelectedIndex() + 1) / 10.0;
        monitorWidget.update();
        if (!ToolTipWidget.empty(this.descriptText.getText())) {
            monitorWidget.setToolTip(new ToolTipWidget(monitorWidget.parent, this.descriptText.getText()));
        } else {
            monitorWidget.removeToolTip();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.shortcuts = false;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.shortcuts = true;
    }

    public boolean shortcutsOn() {
        return this.shortcuts;
    }

    private JMonitorDialog(Frame frame, String string) {
        super(frame, string);
        this.init();
        this.initFocus(this.instText);
        this.descriptText.addFocusListener(this);
    }
}

