/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import starlogo.Application;
import starlogo.Colors;
import starlogo.JEntityMonitor;
import starlogo.JSLCommand;
import starlogo.JSLMenu;
import starlogo.NSLMenu;
import starlogo.Patch;
import starlogo.PatchMonitor;
import starlogo.StackProcessParent;
import starlogo.WindowPosition;
import yoyo.YoYo;

public class JPatchMonitor
extends JEntityMonitor
implements PatchMonitor {
    static Hashtable pmhash = new Hashtable();
    public static final int XCOR = 1;
    public static final int YCOR = 2;
    public static final int PC = 3;
    static double delayTime = 0.5;
    static int numVars;
    Patch pat;
    JLabel color_lbl = new JLabel(" PC", 2);
    JTextField color_txt = new JTextField();
    double colorval;
    JLabel xcor_lbl = new JLabel(" Xcor", 2);
    JLabel xcor_txt;
    double xcorval;
    JLabel ycor_lbl = new JLabel(" Ycor", 2);
    JLabel ycor_txt;
    double ycorval;

    public int getNumVars() {
        return numVars;
    }

    void setStateFields(Dimension dimension) {
        this.xcor_txt = new JLabel(Integer.toString((int)(this.pat.xcor - 1.0 - (double)this.sl.halfwidth)), 2);
        this.ycor_txt = new JLabel(Integer.toString((int)((double)this.sl.halfheight - (this.pat.ycor - 1.0))), 2);
        this.color_txt.setName("PC");
        this.color_txt.setPreferredSize(dimension);
        this.xcor_txt.setPreferredSize(dimension);
        this.ycor_txt.setPreferredSize(dimension);
        this.color_lbl.setPreferredSize(dimension);
        this.xcor_lbl.setPreferredSize(dimension);
        this.ycor_lbl.setPreferredSize(dimension);
        this.color_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.xcor_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.ycor_lbl.setFont(JEntityMonitor.LABEL_FONT);
        this.formatText(this.color_txt);
    }

    public String getVarName(int n) {
        return Patch.getVarName(n);
    }

    public int getVarPos(int n) {
        return Patch.getVarPos(n);
    }

    public Object getVarValue(int n) {
        return this.pat.turtlesown[n];
    }

    public boolean getVarEnump(int n) {
        return Patch.getVarEnump(n);
    }

    public synchronized void setValues(int n) {
        switch (n) {
            case 3: {
                this.colorval = this.pat.pc;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JPatchMonitor this$0;

                    public final void run() {
                        this.this$0.color_txt.setText(this.this$0.colname(this.this$0.colorval));
                        this.this$0.color_txt.setCaretPosition(this.this$0.color_txt.getText().length());
                        this.this$0.wholePanel.setBorder(new LineBorder(Colors.colorarray[(int)(this.this$0.getEntityColor() * 32.0)], 4));
                    }
                    {
                        this.this$0 = jPatchMonitor;
                        this.constructor$0(jPatchMonitor);
                    }

                    private final void constructor$0(JPatchMonitor jPatchMonitor) {
                    }
                });
                break;
            }
        }
    }

    public void initFrame() {
        if (this.pat == null) {
            return;
        }
        if (YoYo.macintoshp) {
            this.slmenu = !YoYo.macosxp ? new NSLMenu(this, this.app) : new JSLMenu(this, this.app);
            this.slmenu.setMenuBar(this);
        }
        numVars = Patch.numVars;
        this.setFields();
        int n = this.own_txt == null ? 0 : this.own_txt[0].getPreferredSize().height;
        n = 22;
        this.addMyComponents(n);
        this.com.callerClearText();
        if (YoYo.applet == null) {
            this.addListeners();
        }
        this.setValues(3);
        int n2 = 0;
        while (n2 < numVars) {
            this.setOwn(n2);
            ++n2;
        }
    }

    public JLabel[] getStateLabels() {
        JLabel[] jLabelArray = new JLabel[]{this.xcor_lbl, this.ycor_lbl, this.color_lbl};
        return jLabelArray;
    }

    public JComponent[] getStateTexts() {
        JComponent[] jComponentArray = new JComponent[]{this.xcor_txt, this.ycor_txt, this.color_txt};
        return jComponentArray;
    }

    public int getNumStateVariables() {
        return 3;
    }

    void addMyComponents(int n) {
        super.addMyComponents(n);
        this.cl = new CardLayout();
        this.wholePanel.setLayout(this.cl);
        this.wholePanel.add((Component)this.wholeBox, "alive");
        this.cl.show(this.wholePanel, "alive");
        this.getContentPane().add(this.wholePanel);
        this.addNotify();
        this.pack();
        this.xcor_txt.requestFocus();
    }

    public double getEntityColor() {
        return this.pat.pc;
    }

    public static void updateOpen() {
        boolean bl = numVars > 0;
        numVars = Patch.numVars;
        Enumeration enumeration = pmhash.elements();
        while (enumeration.hasMoreElements()) {
            JPatchMonitor jPatchMonitor;
            JPatchMonitor jPatchMonitor2 = jPatchMonitor = (JPatchMonitor)enumeration.nextElement();
            synchronized (jPatchMonitor2) {
                jPatchMonitor.updateOwn(bl);
            }
        }
    }

    void addListeners() {
        super.addListeners();
        this.xcor_txt.addFocusListener(this.tff);
        this.ycor_txt.addFocusListener(this.tff);
        this.color_txt.addKeyListener(this.tka);
        this.color_txt.addFocusListener(this.tff);
    }

    public static void flushCommandCenters() {
        Enumeration enumeration = pmhash.elements();
        while (enumeration.hasMoreElements()) {
            JPatchMonitor jPatchMonitor = (JPatchMonitor)enumeration.nextElement();
            jPatchMonitor.com.flush();
        }
    }

    public static void setPatch(Patch patch) {
        JPatchMonitor jPatchMonitor = (JPatchMonitor)pmhash.get(patch);
        if (jPatchMonitor != null) {
            jPatchMonitor.pat = patch;
            patch.hasPMp = true;
            patch.pm = jPatchMonitor;
            jPatchMonitor.com.callerClearText();
            jPatchMonitor.setValues(3);
            int n = 0;
            while (n < numVars) {
                jPatchMonitor.setOwn(n);
                ++n;
            }
            jPatchMonitor.show();
        }
    }

    public void closeMonitor() {
        if (this.pat != null) {
            this.pat.hasPMp = false;
            this.pat.pm = null;
            pmhash.remove(this.pat);
            this.pat = null;
            WindowPosition.closed(this);
        }
    }

    public void run() {
    }

    String getCommand(String string, String string2) {
        if (string.equals(this.color_txt.getName())) {
            this.lastField = 3;
            return "setpc " + string2;
        }
        int n = 0;
        while (n < numVars) {
            if (string.equals(this.own_txt[n].getName())) {
                this.lastField = n;
                this.lastOwn = true;
                return "set" + this.own_lbl[n].getText() + " " + string2;
            }
            ++n;
        }
        return "internal jpatchmonitor error";
    }

    public String getCompileCommand(String string) {
        return "compile-patch-monitor [" + string + "]";
    }

    public void runCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = this.castToIntArray(objectArray);
        if (this.sl.locked) {
            this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
        } else {
            Object object = this.sl.runningp;
            synchronized (object) {
                int n = this.sl.internalSetInstructions("patch-monitor: " + this.xcorval + ", " + this.ycorval, nArray, objectArray2);
                StackProcessParent.runPatch(this.sl, n, this.pat, false, this);
            }
        }
    }

    public void displayOneString(String string) {
        super.displayOneString(string);
        if (!this.color_txt.getText().equals(this.colname(this.colorval))) {
            this.setValues(3);
            this.color_txt.selectAll();
        }
        int n = 0;
        while (n < numVars) {
            this.setOwn(n);
            ++n;
        }
    }

    public void displayAString(String string) {
        this.displayOneString(string);
    }

    public JPatchMonitor(Patch patch, double d, Application application) {
        super("Patch " + patch.toString(), d, application);
        this.pat = patch;
        if (YoYo.language == 1) {
            this.setTitle("Mancha # " + patch.toString());
            this.color_lbl.setText(" CM");
            this.xcor_lbl.setText("CoorX");
            this.ycor_lbl.setText("CoorY");
        }
        this.com = new JSLCommand(1, this.sl, patch, application);
        numVars = Patch.numVars;
        pmhash.put(patch, this);
    }

    static {
        new Thread(new Runnable(){

            public final void run() {
                while (true) {
                    if (pmhash != null) {
                        Hashtable hashtable = pmhash;
                        synchronized (hashtable) {
                            Enumeration<V> enumeration = pmhash.elements();
                            while (enumeration.hasMoreElements()) {
                                JPatchMonitor jPatchMonitor;
                                JPatchMonitor jPatchMonitor2 = jPatchMonitor = (JPatchMonitor)enumeration.nextElement();
                                synchronized (jPatchMonitor2) {
                                    Patch patch = jPatchMonitor.pat;
                                    if (patch != null && !jPatchMonitor.closep) {
                                        if (jPatchMonitor.colorval != patch.pc && (jPatchMonitor.color_txt != jPatchMonitor.focus || jPatchMonitor.app.activeFrame != jPatchMonitor)) {
                                            jPatchMonitor.setValues(3);
                                        }
                                        try {
                                            int n = 0;
                                            while (n < numVars) {
                                                if (!(patch.turtlesown.length <= n || jPatchMonitor.ownval.length <= n || patch.turtlesown[n].equals(jPatchMonitor.ownval[n]) || jPatchMonitor.own_txt[n] == jPatchMonitor.focus && jPatchMonitor.app.activeFrame == jPatchMonitor)) {
                                                    jPatchMonitor.setOwn(n);
                                                }
                                                ++n;
                                            }
                                        }
                                        catch (NullPointerException nullPointerException) {
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                        }
                    }
                    try {
                        Thread.sleep((long)(delayTime * 1000.0));
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        }).start();
    }
}

