/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import ptolemy.Plot;
import ptolemy.PlotBox;
import starlogo.Application;
import starlogo.JSLDialog;
import starlogo.JWidgetDialog;
import starlogo.LineWidget;
import starlogo.PlotDialog;
import starlogo.WidgetDrag;
import yoyo.YoYo;

public class JPlotDialog
extends JWidgetDialog
implements PlotDialog {
    public static Image linechartImage = null;
    public static Image barchartImage = null;
    public static Image histogramImage = null;
    public static Image scatterplotImage = null;
    public static Image xyplotImage = null;
    public static Image grid = null;
    String title = "title";
    String xlabel = "time";
    String ylabel = "";
    double xmin = 0.0;
    double xmax = 100.0;
    double ymin = 0.0;
    double ymax = 100.0;
    boolean gridOn = true;
    boolean connected = true;
    boolean manual = false;
    int type;
    int pts = 0;
    Application app;
    PlotBox plot;
    JPanel main;
    JPanel top;
    JPanel bottom;
    JPanel west;
    JTextField xminT;
    JTextField xmaxT;
    JTextField yminT;
    JTextField ymaxT;
    JTextField xlabelT;
    JTextField ylabelT;
    JTextField titleT;
    JLabel xminL;
    JLabel xmaxL;
    JLabel yminL;
    JLabel ymaxL;
    JLabel xlabelL;
    JLabel ylabelL;
    JLabel titleL;
    JLabel delChoiceLabel;
    JCheckBox gridBox;
    JCheckBox connectedBox;
    JCheckBox autoScaleBox;
    JRadioButton ptsR;
    JRadioButton noneR;
    JRadioButton dotsR;
    JRadioButton xsR;
    ButtonGroup cbg;
    JComboBox delChoice;
    LineWidget lw = null;
    private static /* synthetic */ Class class$Lstarlogo$PlotDialog;

    public JPanel createGridPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        return jPanel;
    }

    private final String round(double d) {
        return (double)((int)(10000.0 * d)) / 10000.0 + "";
    }

    public void setupComponents() {
        this.cbg = new ButtonGroup();
        this.main = new JPanel();
        this.top = new JPanel();
        this.bottom = new JPanel();
        this.west = new JPanel();
        this.xminT = new JTextField(2);
        this.xmaxT = new JTextField(2);
        this.yminT = new JTextField(2);
        this.ymaxT = new JTextField(2);
        this.xlabelT = new JTextField(6);
        this.ylabelT = new JTextField(6);
        this.titleT = new JTextField(10);
        this.xminL = new JLabel("X-Axis Min", 0);
        this.xmaxL = new JLabel("X-Axis Max", 0);
        this.yminL = new JLabel("Y-Axis Min", 0);
        this.ymaxL = new JLabel("Y-Axis Max", 0);
        this.xlabelL = new JLabel("X-Axis Label", 0);
        this.ylabelL = new JLabel("Y-Axis Label", 0);
        this.titleL = new JLabel("Plot Title", 0);
        this.gridBox = new JCheckBox("Show Grid");
        this.connectedBox = new JCheckBox("Connect the Points");
        this.autoScaleBox = new JCheckBox("Auto-scale Axes");
        this.delChoice = new JComboBox<Object>(new Object[]{"0.1", "0.2", "0.3", "0.4", "0.5", "1.0", "1.5", "2.0", "2.5", "5.0"});
        this.delChoiceLabel = new JLabel("Update Delay (sec): ");
        this.initializeFields();
        JSLDialog.formatText(this.xminT);
        JSLDialog.formatText(this.xmaxT);
        JSLDialog.formatText(this.yminT);
        JSLDialog.formatText(this.ymaxT);
        JSLDialog.formatText(this.xlabelT);
        JSLDialog.formatText(this.ylabelT);
        JSLDialog.formatText(this.titleT);
        JSLDialog.formatLabel(this.xminL);
        JSLDialog.formatLabel(this.xmaxL);
        JSLDialog.formatLabel(this.yminL);
        JSLDialog.formatLabel(this.ymaxL);
        JSLDialog.formatLabel(this.xlabelL);
        JSLDialog.formatLabel(this.ylabelL);
        JSLDialog.formatLabel(this.titleL);
        JSLDialog.formatLabel(this.delChoice);
        JSLDialog.formatLabel(this.delChoiceLabel);
        JSLDialog.formatLabel(this.gridBox);
        JSLDialog.formatLabel(this.connectedBox);
        JSLDialog.formatLabel(this.autoScaleBox);
    }

    public void setupGBC() {
        this.main.setLayout(new BorderLayout());
        this.west.setLayout(new BorderLayout());
        this.bottom.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.titleL);
        jPanel.add(this.titleT);
        this.top.add("Center", jPanel);
        JPanel jPanel2 = this.createGridPanel();
        jPanel2.add(this.ymaxT);
        jPanel2.add(this.ymaxL);
        JPanel jPanel3 = this.createGridPanel();
        jPanel3.add(this.yminL);
        jPanel3.add(this.yminT);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel4.add(jPanel2);
        jPanel5.add(jPanel3);
        this.west.add("North", jPanel4);
        this.west.add("South", jPanel5);
        JPanel jPanel6 = this.createGridPanel();
        jPanel6.add(this.ylabelL);
        jPanel6.add(this.ylabelT);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(jPanel6);
        this.west.add("Center", jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(2, 2));
        jPanel8.add(new JPanel());
        if (this.type != 0) {
            jPanel8.add(this.xminT);
        } else {
            jPanel8.add(new JPanel());
        }
        jPanel8.add(new JPanel());
        if (this.type != 0) {
            jPanel8.add(this.xminL);
        } else {
            jPanel8.add(new JPanel());
        }
        JPanel jPanel9 = new JPanel();
        jPanel9.add(jPanel8);
        this.bottom.add("West", jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayout(2, 1));
        if (this.type != 0) {
            jPanel10.add(this.xmaxT);
            jPanel10.add(this.xmaxL);
        } else {
            jPanel10.add(new JPanel());
            jPanel10.add(new JPanel());
        }
        JPanel jPanel11 = new JPanel();
        jPanel11.add(jPanel10);
        this.bottom.add("East", jPanel11);
        JPanel jPanel12 = this.createGridPanel();
        jPanel12.add(this.xlabelT);
        jPanel12.add(this.xlabelL);
        JPanel jPanel13 = new JPanel();
        jPanel13.add(jPanel12);
        this.bottom.add("Center", jPanel13);
        this.main.add("North", this.top);
        this.getContentPane().setBackground(UIManager.getColor("window"));
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        JPanel jPanel14 = new JPanel();
        JPanel jPanel15 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel15.setLayout(gridBagLayout);
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.gridBox, gridBagConstraints);
        jPanel15.add(this.gridBox);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new BorderLayout());
        jPanel16.add((Component)this.delChoiceLabel, "West");
        jPanel16.add((Component)this.delChoice, "Center");
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel16, gridBagConstraints);
        jPanel15.add(jPanel16);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(YoYo.macintoshp ? this.bca : this.bok, gridBagConstraints);
        jPanel15.add(YoYo.macintoshp ? this.bca : this.bok);
        gridBagConstraints.gridy = 1;
        if (this.type != 0 && this.type != 2) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagLayout.setConstraints(this.connectedBox, gridBagConstraints);
            jPanel15.add(this.connectedBox);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 10;
        } else {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
        }
        gridBagLayout.setConstraints(this.autoScaleBox, gridBagConstraints);
        jPanel15.add(this.autoScaleBox);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(YoYo.macintoshp ? this.bok : this.bca, gridBagConstraints);
        jPanel15.add(YoYo.macintoshp ? this.bok : this.bca);
        this.main.add("South", this.bottom);
        this.main.add("West", this.west);
        if (this.type == 1) {
            this.main.add("East", new DrawPanel(linechartImage));
        }
        if (this.type == 0) {
            this.main.add("East", new DrawPanel(barchartImage));
        }
        if (this.type == 2) {
            this.main.add("East", new DrawPanel(histogramImage));
        }
        if (this.type == 3) {
            this.main.add("East", new DrawPanel(scatterplotImage));
        }
        if (this.type == 4) {
            this.main.add("East", new DrawPanel(xyplotImage));
        }
        this.getContentPane().add("Center", new JPanel());
        this.getContentPane().add("West", this.main);
        this.getContentPane().add("South", jPanel15);
    }

    public void setupPosition() {
        ((Component)this).setSize(this.getPreferredSize());
        this.initLocation();
    }

    private final void initializeFields() {
        this.xminT.setText(this.round(this.plot.getXRange()[0]));
        this.xmaxT.setText(this.round(this.plot.getXRange()[1]));
        this.yminT.setText(this.round(this.plot.getYRange()[0]));
        this.ymaxT.setText(this.round(this.plot.getYRange()[1]));
        this.xlabelT.setText(this.plot.getXLabel());
        this.ylabelT.setText(this.plot.getYLabel());
        this.titleT.setText(this.plot.getTitle());
        if (this.plot.getGrid()) {
            this.gridBox.setSelected(true);
        }
        if (this.type != 2 && this.type != 0) {
            this.connectedBox.setSelected(((Plot)this.plot).getConnected());
            this.autoScaleBox.setSelected(this.lw.tbc.autoscale);
        }
        this.delChoice.setSelectedItem(this.lw.delayStr);
    }

    public void show() {
        this.initializeFields();
        super.show();
    }

    public double doubleParser(String string) {
        return new Double(string);
    }

    public void getValues(LineWidget lineWidget, PlotBox plotBox) {
        plotBox.setTitle(this.titleT.getText(), lineWidget.tbc.getPreTitle());
        plotBox.setXLabel(this.xlabelT.getText());
        plotBox.setYLabel(this.ylabelT.getText());
        lineWidget.delayStr = (String)this.delChoice.getSelectedItem();
        this.manual = !this.autoScaleBox.isSelected();
        lineWidget.tbc.autoscale = !this.manual;
        plotBox.setXRange(this.doubleParser(this.xminT.getText()), this.doubleParser(this.xmaxT.getText()), this.manual);
        plotBox.setYRange(this.doubleParser(this.yminT.getText()), this.doubleParser(this.ymaxT.getText()), this.manual);
        plotBox.setGrid(this.gridBox.isSelected());
        if (this.connectedBox.isSelected()) {
            if (this.type != 2 && this.type != 0) {
                lineWidget.tbc.ppd(plotBox);
            }
        } else if (this.type != 2 && this.type != 0) {
            lineWidget.tbc.ppu(plotBox);
        }
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        linechartImage = toolkit.getImage((class$Lstarlogo$PlotDialog != null ? class$Lstarlogo$PlotDialog : (class$Lstarlogo$PlotDialog = JPlotDialog.class$("starlogo.PlotDialog"))).getResource(string + "linegraphlarge.gif"));
        barchartImage = toolkit.getImage((class$Lstarlogo$PlotDialog != null ? class$Lstarlogo$PlotDialog : (class$Lstarlogo$PlotDialog = JPlotDialog.class$("starlogo.PlotDialog"))).getResource(string + "bargraphlarge.gif"));
        histogramImage = toolkit.getImage((class$Lstarlogo$PlotDialog != null ? class$Lstarlogo$PlotDialog : (class$Lstarlogo$PlotDialog = JPlotDialog.class$("starlogo.PlotDialog"))).getResource(string + "histogramlarge.gif"));
        scatterplotImage = toolkit.getImage((class$Lstarlogo$PlotDialog != null ? class$Lstarlogo$PlotDialog : (class$Lstarlogo$PlotDialog = JPlotDialog.class$("starlogo.PlotDialog"))).getResource(string + "scatterplotlarge.gif"));
        xyplotImage = toolkit.getImage((class$Lstarlogo$PlotDialog != null ? class$Lstarlogo$PlotDialog : (class$Lstarlogo$PlotDialog = JPlotDialog.class$("starlogo.PlotDialog"))).getResource(string + "xyplotlarge.gif"));
        grid = toolkit.getImage((class$Lstarlogo$PlotDialog != null ? class$Lstarlogo$PlotDialog : (class$Lstarlogo$PlotDialog = JPlotDialog.class$("starlogo.PlotDialog"))).getResource(string + "linegrid.gif"));
    }

    public void getValues(WidgetDrag widgetDrag) {
    }

    protected boolean valid_inputs() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JPlotDialog(Frame frame, int n, PlotBox plotBox, LineWidget lineWidget, Application application) {
        super(frame, "Plot Properties");
        this.plot = plotBox;
        this.app = application;
        this.type = n;
        this.lw = lineWidget;
        this.init();
        this.initFocus(this.bok);
    }

    class DrawPanel
    extends JPanel {
        Image im = null;
        Image imgrid = null;
        LineWidget lw = null;

        public Dimension getPreferredSize() {
            return new Dimension(340, 185);
        }

        public void paintComponent(Graphics graphics) {
            if (this.im != null) {
                graphics.drawImage(this.im, 0, 0, this);
            }
        }

        public DrawPanel(Image image) {
            this.im = image;
            this.setSize(340, 185);
        }
    }
}

