/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;
import starlogo.Application;
import starlogo.ControlCenter;
import starlogo.JControlCenter;
import starlogo.JControlCenterTextArea;
import starlogo.JProcMouseAdapter;
import starlogo.JSLCommand;
import starlogo.JSLDialog;
import starlogo.Patch;
import starlogo.SLCommand;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import yoyo.Context;
import yoyo.JCommandCenter;
import yoyo.Reader;
import yoyo.YoYo;

public class JSLCommand
extends JCommandCenter
implements SLCommand,
JControlCenterTextArea {
    public static final String obsPrefix = "compile-observer-cc ";
    public static final String turPrefix = "compile-turtle-cc ";
    public static final String patPrefix = "compile-patch-cc ";
    public static final String whoPrefix = "[if who = ";
    public static Font PROC_FONT;
    String who;
    StarLogo sl;
    public boolean runningp = false;
    int which;
    boolean whop = false;
    Patch patch = null;
    JLabel label;
    JControlCenter jcc;
    UndoManager undoManager = new 1(this);
    private Vector spps = new Vector();
    private int sppcount = 0;

    private final JLabel getLabel(String string, Color color) {
        JLabel jLabel = new JLabel(this, string, 2){
            private final /* synthetic */ JSLCommand this$0;

            public final Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((Component)this).getFontMetrics(this.getFont()).getHeight() + ControlCenter.LABEL_VERTICAL_SPACE);
            }
            {
                this.this$0 = jSLCommand;
                this.constructor$0(jSLCommand, string, n);
            }

            private final void constructor$0(JSLCommand jSLCommand, String string, int n) {
            }
        };
        jLabel.setBackground(color);
        return jLabel;
    }

    public void formatText(JTextComponent jTextComponent) {
        jTextComponent.setFont(PROC_FONT);
        jTextComponent.setBackground(Color.white);
        jTextComponent.setForeground(Color.black);
    }

    public void setupKeys() {
        KeyStroke keyStroke = YoYo.macintoshp ? KeyStroke.getKeyStroke(46, 4) : KeyStroke.getKeyStroke(67, 2);
        TextAction textAction = new TextAction(this, "Break"){
            private final /* synthetic */ JSLCommand this$0;

            public final void actionPerformed(ActionEvent actionEvent) {
                Object object = this.this$0.sl.runningp;
                synchronized (object) {
                    this.this$0.sl.stopAll();
                }
            }
            {
                this.this$0 = jSLCommand;
                this.constructor$0(jSLCommand, string);
            }

            private final void constructor$0(JSLCommand jSLCommand, String string) {
            }
        };
        this.km.addActionForKeyStroke(keyStroke, textAction);
    }

    public void runLine(String string) {
        if (this.runningp) {
            this.c.stop();
            this.stopAll();
        }
        if (!this.sl.app.maybeCompile()) {
            super.done(this.c);
            return;
        }
        this.runningp = true;
        if (string.equalsIgnoreCase("cc") || string.equalsIgnoreCase("clear-command-center")) {
            this.callerClearText();
        }
        if (string != "" && string != null) {
            Object[] objectArray = null;
            switch (this.which) {
                case 0: {
                    objectArray = Reader.read(turPrefix + (this.whop ? whoPrefix + this.who : "") + "[" + string + "]");
                    break;
                }
                case 2: {
                    objectArray = Reader.read("compile-observer-cc [" + string + "]");
                    break;
                }
                case 1: {
                    objectArray = Reader.read("compile-patch-cc [" + string + "]");
                    break;
                }
            }
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = this;
            this.sl.app.cc.enqueue(objectArray2, this.sl.app.message, this.sl.app.err, this);
        }
    }

    public void runCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        if (this.sl.locked) {
            this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
        } else {
            Object object = this.sl.runningp;
            synchronized (object) {
                int n2 = this.sl.internalSetInstructions(this.toString(), nArray, objectArray2);
                switch (this.which) {
                    case 0: {
                        StackProcessParent.runTurtles(this.sl, n2, false, this);
                        break;
                    }
                    case 2: {
                        StackProcessParent.runObserver(this.sl, n2, false, this);
                        break;
                    }
                    case 1: {
                        StackProcessParent.runPatch(this.sl, n2, this.patch, false, this);
                        break;
                    }
                }
            }
        }
    }

    public void done(Context context) {
    }

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0 && this.runningp) {
            super.done(this.c);
            this.runningp = false;
        }
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
    }

    public void displayOneString(String string) {
        if (YoYo.applet != null) {
            this.sl.app.err.println(string);
        }
        string = string + "\n";
        this.print(string);
        this.getOut().flush();
        super.done(this.c);
        this.runningp = false;
    }

    public void displayAString(String string) {
        if (YoYo.applet != null) {
            this.sl.app.err.println(string);
        }
        this.print(string);
        this.getOut().flush();
    }

    public void callerPrintln(String string) {
        this.println(string);
    }

    public void callerClearText() {
        if (!this.getText().equals("")) {
            this.setText("");
        }
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void print(String string) {
        PrintWriter printWriter = this.getOut();
        printWriter.print(string);
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public JSLCommand(int n, StarLogo starLogo, JControlCenter jControlCenter) {
        this.sl = starLogo;
        this.jcc = jControlCenter;
        this.c = jControlCenter.app.cc;
        this.which = n;
        this.setFont(PROC_FONT);
        if (YoYo.language == 0) {
            switch (n) {
                case 0: {
                    this.label = this.getLabel("Turtle Command Center", new Color(23, 118, 51));
                    break;
                }
                case 2: {
                    this.label = this.getLabel("Observer Command Center", new Color(92, 61, 36));
                    break;
                }
                case 1: {
                    this.label = this.getLabel("Patch Command Center", new Color(23, 118, 51));
                    break;
                }
            }
        }
        if (YoYo.language == 1) {
            switch (n) {
                case 0: {
                    this.label = this.getLabel("Centro de Mandos de Tortuga", new Color(23, 118, 51));
                    break;
                }
                case 2: {
                    this.label = this.getLabel("Centro de Mandos de Observador", new Color(92, 61, 36));
                    break;
                }
                case 1: {
                    this.label = this.getLabel("Centro de Mandos de Mancha", new Color(23, 118, 51));
                    break;
                }
            }
        }
        this.label.setFont(JSLDialog.LABEL_FONT);
        this.label.setForeground(Color.white);
        this.label.setBackground(new Color(23, 118, 51));
        this.setupKeys();
        this.addCaretListener(jControlCenter);
        this.addMouseListener(new ControlMouseAdapter(this));
    }

    public JSLCommand(int n, StarLogo starLogo, int n2, Application application) {
        this.sl = starLogo;
        this.which = n;
        this.c = application.cc;
        this.setFont(PROC_FONT);
        this.whop = true;
        this.who = new String(Integer.toString(n2));
        if (YoYo.language == 0) {
            this.label = this.getLabel("Turtle #" + this.who + " Command Center", new Color(23, 118, 51));
        }
        if (YoYo.language == 1) {
            this.label = this.getLabel("Tortuga #" + this.who + " Centro de Mandos", new Color(23, 118, 51));
        }
        this.label.setFont(new Font("Dialog", 0, 12));
        this.label.setForeground(Color.white);
        this.setupKeys();
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    public JSLCommand(int n, StarLogo starLogo, Patch patch, Application application) {
        this.sl = starLogo;
        this.which = n;
        this.c = application.cc;
        this.patch = patch;
        this.setFont(PROC_FONT);
        if (YoYo.language == 0) {
            this.label = this.getLabel("Patch " + patch.toString() + " Command Center", new Color(23, 118, 51));
        }
        if (YoYo.language == 1) {
            this.label = this.getLabel("Mancha " + patch.toString() + " Centro de Mandos", new Color(23, 118, 51));
        }
        this.label.setFont(new Font("Dialog", 0, 12));
        this.label.setForeground(Color.white);
        this.label.setBackground(new Color(23, 118, 51));
        this.setupKeys();
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    static {
        try {
            PROC_FONT = new Font("Monospaced", 0, 12);
            if (YoYo.macintoshp) {
                PROC_FONT = Font.getFont("starlogo.procedures.font", PROC_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class CommandKeyAdapter
    extends KeyAdapter {
        JSLCommand parent;

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (this.parent.c.runningnowp) {
                keyEvent.consume();
                return;
            }
            if (!this.parent.donep()) {
                keyEvent.consume();
                return;
            }
            if (c == '\t' && keyEvent.isControlDown()) {
                if (this.parent.jcc != null) {
                    this.parent.jcc.toggleTabs();
                }
                keyEvent.consume();
                return;
            }
            if (YoYo.macintoshp && keyEvent.isMetaDown() && keyEvent.getKeyChar() == '.') {
                Object object = this.parent.sl.runningp;
                synchronized (object) {
                    this.parent.sl.stopAll();
                }
                return;
            }
            if (!YoYo.macintoshp && keyEvent.isControlDown() && keyEvent.getKeyChar() == 'c') {
                Object object = this.parent.sl.runningp;
                synchronized (object) {
                    this.parent.sl.stopAll();
                }
                return;
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (this.parent.c.runningnowp) {
                this.parent.c.stop();
                Object object = JSLCommand.this.sl.runningp;
                synchronized (object) {
                    this.parent.stopAll();
                }
                keyEvent.consume();
                return;
            }
            if (!this.parent.donep()) {
                Object object = JSLCommand.this.sl.runningp;
                synchronized (object) {
                    this.parent.stopAll();
                }
                keyEvent.consume();
                return;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
        }

        public CommandKeyAdapter(JSLCommand jSLCommand2) {
            this.parent = jSLCommand2;
        }
    }

    public class ControlMouseAdapter
    extends JProcMouseAdapter {
        JSLCommand parent;

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            this.parent.requestFocus();
            this.parent.jcc.textFocus = this.parent;
            this.parent.jcc.updateLine(this.parent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
        }

        public ControlMouseAdapter(JSLCommand jSLCommand2) {
            super(jSLCommand2);
            this.parent = jSLCommand2;
        }
    }
}

