/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import starlogo.Application;
import starlogo.JRestoreShapesDialog;
import starlogo.JSLMenu;
import starlogo.JShapeChooserPanel;
import starlogo.JShapeChooserStatusPanel;
import starlogo.MenuListener;
import starlogo.NSLMenu;
import starlogo.Project;
import starlogo.SLMenu;
import starlogo.SLURL;
import starlogo.ShapeChooser;
import starlogo.StarLogoFrame;
import starlogo.TurtleShapes;
import yoyo.LogoError;
import yoyo.PrimFile;
import yoyo.YoYo;

public class JShapeChooser
extends JFrame
implements ShapeChooser,
StarLogoFrame,
MenuListener {
    static JShapeChooser chooser;
    Application app;
    JShapeChooserPanel mainPanel;
    JShapeChooserStatusPanel statusPanel;
    SLMenu slmenu;
    private static /* synthetic */ Class class$Lstarlogo$Pool;

    public static JShapeChooser create(Application application) {
        if (chooser != null) {
            return chooser;
        }
        chooser = new JShapeChooser(application);
        return chooser;
    }

    public void updateName(String string, int n) {
        this.statusPanel.updateString(string, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Cut") || string.equals("Corte")) {
            TurtleShapes.cutShape(this.mainPanel.selectedShape, this.app);
            this.app.rancompilerp = false;
            this.app.project.markChanged();
            this.slmenu.enablePasteMenu();
            this.mainPanel.refresh();
        } else if (string.equals("Copy") || string.equals("Copie")) {
            TurtleShapes.copyShape(this.mainPanel.selectedShape, this.app);
            this.slmenu.enablePasteMenu();
        } else if (string.equals("Paste") || string.equals("Pegue")) {
            TurtleShapes.pasteShape(this.mainPanel.selectedShape);
            this.updateName(TurtleShapes.getShapeNames()[this.mainPanel.selectedShape], this.mainPanel.selectedShape);
            this.app.rancompilerp = false;
            this.app.project.markChanged();
            this.mainPanel.refresh();
        } else if (string.equals("Restore Default Shapes") || string.equals("Restore Figuras del Defacto")) {
            JRestoreShapesDialog jRestoreShapesDialog = YoYo.language == 1 ? new JRestoreShapesDialog(this, "Mensaje de StarLogo", "\u00bfTiene seguro que quiere restaurar las figuras del defacto?", "S\u00ed", "Cancele") : new JRestoreShapesDialog(this, "StarLogo Message", "Are you sure you want to restore the default shapes?", "Yes", "Cancel");
            String string2 = jRestoreShapesDialog.getResult();
            if (string2.equals("Yes") || string2.equals("S\u00ed")) {
                TurtleShapes.loadDefaultShapes(this.app);
                this.updateName(TurtleShapes.getShapeNames()[this.mainPanel.selectedShape], this.mainPanel.selectedShape);
                this.app.rancompilerp = false;
                this.app.project.markChanged();
                this.mainPanel.refresh();
            }
        } else if (string.equals("Import Shape...") || string.equals("Importe una Figura...")) {
            this.importShape();
            this.updateName(TurtleShapes.getShapeNames()[this.mainPanel.selectedShape], this.mainPanel.selectedShape);
            this.app.rancompilerp = false;
            this.app.project.markChanged();
            this.mainPanel.refresh();
        } else if (string.equals("Export Shape...") || string.equals("Exporte una Figura...")) {
            this.exportShape();
        }
    }

    public void refresh() {
        this.mainPanel.refresh();
    }

    public void refreshShape(int n) {
        this.mainPanel.refreshShape(n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void setTurtleColor(Color color) {
        this.mainPanel.tcolmask = color.getRGB();
        this.mainPanel.refresh();
    }

    public void setPatchColor(Color color) {
        this.mainPanel.pcolmask = color.getRGB();
        this.mainPanel.refresh();
    }

    public int selectedShape() {
        return this.mainPanel.selectedShape;
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    public boolean exportShape() {
        FileDialog fileDialog = new FileDialog((Frame)((Object)this.app.activeFrame), "Export Shape...", 1);
        if (YoYo.language == 1) {
            fileDialog = new FileDialog((Frame)((Object)this.app.activeFrame), "Exporte una Figura...", 1);
        }
        Project cfr_ignored_0 = this.app.project;
        if (Project.curDir != null) {
            Project cfr_ignored_1 = this.app.project;
            fileDialog.setDirectory(Project.curDir.getPath());
        }
        fileDialog.setFilenameFilter(this.app.shapeFileFilter);
        fileDialog.show();
        SLURL sLURL = new SLURL(3, fileDialog.getDirectory());
        if (fileDialog.getFile() != null) {
            SLURL sLURL2 = new SLURL(3, sLURL.getPath(), fileDialog.getFile());
            try {
                try {
                    this.app.setCursor(Cursor.getPredefinedCursor(3));
                    if (!(YoYo.macintoshp && YoYo.macosxp || sLURL2.getFileExtension().toLowerCase().equals("sls"))) {
                        sLURL2.setFileExtension("sls");
                    }
                    String string = TurtleShapes.saveShapes(this.selectedShape());
                    File file = new File(sLURL2.getFullPath());
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write(string);
                    bufferedWriter.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Application.createMessageDialog((Frame)((Object)this.app.activeFrame), "StarLogo Message", "Error saving shape: " + fileNotFoundException.getMessage(), false);
                    boolean bl = false;
                    Object var5_10 = null;
                    this.app.restoreCursor();
                    return bl;
                }
                catch (IOException iOException) {
                    Application.createMessageDialog((Frame)((Object)this.app.activeFrame), "StarLogo Message", "Error saving shape: " + iOException.getMessage(), false);
                    boolean bl = false;
                    Object var5_11 = null;
                    this.app.restoreCursor();
                    return bl;
                }
                Object var5_9 = null;
                this.app.restoreCursor();
            }
            catch (Throwable throwable) {
                Object var5_12 = null;
                this.app.restoreCursor();
                throw throwable;
            }
            return true;
        }
        return false;
    }

    public boolean importShape() {
        FileDialog fileDialog = new FileDialog((Frame)((Object)this.app.activeFrame), "Import Shape...", 0);
        if (YoYo.language == 1) {
            fileDialog = new FileDialog((Frame)((Object)this.app.activeFrame), "Importe una Figura...", 0);
        }
        Project cfr_ignored_0 = this.app.project;
        if (Project.curDir != null) {
            Project cfr_ignored_1 = this.app.project;
            fileDialog.setDirectory(Project.curDir.getPath());
        }
        fileDialog.setFilenameFilter(this.app.shapeFileFilter);
        fileDialog.show();
        SLURL sLURL = new SLURL(3, fileDialog.getDirectory());
        if (fileDialog.getFile() != null) {
            SLURL sLURL2 = new SLURL(3, sLURL.getPath(), fileDialog.getFile());
            try {
                try {
                    this.app.setCursor(Cursor.getPredefinedCursor(3));
                    String string = (String)PrimFile.prim_filetostring(sLURL2.toString(), this.app.sl.c);
                    TurtleShapes.loadShapes(string, this.selectedShape(), false, this.app);
                }
                catch (LogoError logoError) {
                    Application.createMessageDialog((Frame)((Object)this.app.activeFrame), "StarLogo Message", "Error loading shape: " + logoError.getMessage(), false);
                    boolean bl = false;
                    Object var5_7 = null;
                    this.app.restoreCursor();
                    return bl;
                }
                Object var5_6 = null;
                this.app.restoreCursor();
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.app.restoreCursor();
                throw throwable;
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JShapeChooser(Application application) {
        super("Shape Chooser");
        Accessible accessible;
        this.app = application;
        this.addNotify();
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + 288 + 2, insets.top + 72 + 1 + 25 + insets.bottom + (YoYo.macintoshp ? 0 : 23));
        if (!YoYo.macintoshp) {
            accessible = new ImageIcon((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = JShapeChooser.class$("starlogo.Pool"))).getResource("gifs/icon.gif"));
            ((Frame)this).setIconImage(((ImageIcon)accessible).getImage());
        }
        accessible = new JPanel();
        ((Container)((Object)accessible)).setLayout(null);
        this.getContentPane().add((Component)((Object)accessible));
        this.statusPanel = new JShapeChooserStatusPanel(this);
        this.mainPanel = new JShapeChooserPanel(this, application);
        ((Container)((Object)accessible)).add(this.mainPanel);
        this.mainPanel.setLocation(0, 0);
        ((Container)((Object)accessible)).add(this.statusPanel);
        this.statusPanel.setLocation(0, 73);
        this.slmenu = YoYo.macintoshp && !YoYo.macosxp ? new NSLMenu(this, application) : new JSLMenu(this, application);
        this.slmenu.disablePasteMenu();
        this.slmenu.setMenuBar(this);
        application.registerFrameTracker(this);
        this.addKeyListener(this.mainPanel);
        this.setResizable(false);
        ((Component)this).setLocation(100, 100);
    }
}

