/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import javax.swing.JComponent;
import starlogo.Application;
import starlogo.Colors;
import starlogo.JShapeChooser;
import starlogo.JShapeEditor;
import starlogo.TurtleShapes;
import yoyo.YoYo;

public class JShapeChooserPanel
extends JComponent
implements ImageProducer,
KeyListener {
    static final int LINEWIDTH = 2;
    static final int ROWS = 4;
    static final int COLUMNS = 16;
    JShapeChooser chooser;
    int selectedShape;
    String selectedname;
    int tcolmask = Colors.colorarrayints[1760];
    int pcolmask = Colors.colorarrayints[0];
    boolean editorOpen = false;
    Image image;
    ImageConsumer ic;
    int[] pixels;
    int width = 290;
    int height = 74;
    int rowbytes = this.width;
    Application app;

    public void refresh() {
        int n = 0;
        while (n < 64) {
            this.drawShape(n);
            ++n;
        }
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    public void refreshShape(int n) {
        this.drawShape(n);
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    public int[] drawShape(int n) {
        int n2 = n % 16;
        int n3 = n / 16;
        int n4 = n2 * 18 + 2;
        int n5 = n3 * 18 + 2;
        int n6 = n4 + n5 * this.rowbytes;
        int[] nArray = new int[256];
        int n7 = 0;
        TurtleShapes turtleShapes = TurtleShapes.getShape(n);
        double[] dArray = turtleShapes.getColorsForSize(16)[0];
        int[] nArray2 = turtleShapes.getMasksForSize(16)[0];
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n9 < 16) {
            int n11 = 0;
            while (n11 < 16) {
                n8 = nArray2[2 * n10] == -1 ? this.tcolmask : (nArray2[2 * n10 + 1] == -1 ? this.pcolmask : Colors.colorarrayints[(int)(dArray[n10] * 32.0)]);
                this.pixels[n6 + n11] = n8;
                nArray[n7++] = n8;
                ++n10;
                ++n11;
            }
            n6 += this.rowbytes;
            ++n9;
        }
        return nArray;
    }

    public void drawSquare(int n, boolean bl) {
        int n2;
        int n3 = n % 16;
        int n4 = n / 16;
        int n5 = n3 * 18;
        int n6 = n4 * 18;
        int n7 = n5 + n6 * this.rowbytes;
        int n8 = bl ? Colors.colorarrayints[3360] : Colors.colorarrayints[160];
        int n9 = 0;
        while (n9 < 19) {
            n2 = 0;
            while (n2 < 2) {
                this.pixels[n7 + n9 + this.rowbytes * n2] = n8;
                this.pixels[n7 + this.rowbytes * (18 + n2) + n9] = n8;
                ++n2;
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < 20) {
            n2 = 0;
            while (n2 < 2) {
                this.pixels[n7 + n9 * this.rowbytes + n2] = n8;
                this.pixels[n7 + n9 * this.rowbytes + 18 + n2] = n8;
                ++n2;
            }
            ++n9;
        }
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    public void paintComponent(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }

    void select(int n) {
        this.drawSquare(this.selectedShape, false);
        this.selectedShape = n;
        this.drawSquare(this.selectedShape, true);
        this.selectedname = TurtleShapes.getShape((int)n).name;
        if (this.selectedname == null) {
            this.selectedname = (YoYo.language == 0 ? "shape-" : "figura-") + n;
        }
        this.chooser.updateName(this.selectedname, n);
        this.repaint();
    }

    public void openEditor(int n) {
        if (this.editorOpen) {
            return;
        }
        this.editorOpen = true;
        int n2 = this.chooser.app.sl.cellsize;
        if (n2 < 8) {
            n2 = 8;
        }
        new JShapeEditor(TurtleShapes.getShape(n), n, this.selectedname, n2, this.chooser, this.app);
    }

    int eventToShape(MouseEvent mouseEvent) {
        int n = Math.max(mouseEvent.getX() - 2, 0) / 18;
        int n2 = Math.max(mouseEvent.getY() - 2, 0) / 18;
        return n2 * 16 + n;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.ic = null;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.pixels, 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (imageConsumer == null) {
            return;
        }
        if (this.ic == null) {
            this.ic = imageConsumer;
            imageConsumer.setColorModel(Colors.cm);
            imageConsumer.setDimensions(this.width, this.height);
        }
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.pixels, 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.select((this.selectedShape + 16) % 64);
        } else if (keyEvent.getKeyCode() == 38) {
            int n = (this.selectedShape + 48) % 64;
            this.select(n);
        } else if (keyEvent.getKeyCode() == 39) {
            int n = (this.selectedShape + 1) % 64;
            this.select(n);
        } else if (keyEvent.getKeyCode() == 37) {
            int n = (this.selectedShape + 63) % 64;
            this.select(n);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.openEditor(this.selectedShape);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    JShapeChooserPanel(JShapeChooser jShapeChooser, Application application) {
        int n;
        int n2;
        this.chooser = jShapeChooser;
        this.app = application;
        this.setSize(this.width, this.height);
        this.setOpaque(true);
        this.pixels = new int[this.width * this.height];
        this.image = jShapeChooser.createImage(this);
        this.refresh();
        int n3 = Colors.colorarrayints[160];
        int n4 = 0;
        while (n4 < this.pixels.length) {
            n2 = 0;
            n = 0;
            while (n2 < 2) {
                int n5 = 0;
                while (n5 < this.width) {
                    this.pixels[n4 + n + n5] = n3;
                    ++n5;
                }
                ++n2;
                n += this.width;
            }
            n4 += this.width * 18;
        }
        n4 = 0;
        while (n4 < this.width) {
            n2 = 0;
            while (n2 < this.pixels.length) {
                n = 0;
                while (n < 2) {
                    this.pixels[n4 + n2 + n] = n3;
                    ++n;
                }
                n2 += this.width;
            }
            n4 += 18;
        }
        this.selectedShape = 0;
        this.select(this.selectedShape);
        this.addMouseListener(new MouseAdapter(this){
            private final /* synthetic */ JShapeChooserPanel this$0;

            public final void mousePressed(MouseEvent mouseEvent) {
                int n = this.this$0.eventToShape(mouseEvent);
                if (n < 0 || n >= 64) {
                    return;
                }
                this.this$0.select(n);
                if (mouseEvent.getClickCount() > 1) {
                    this.this$0.openEditor(n);
                }
            }

            public final void mouseReleased(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }
            {
                this.this$0 = jShapeChooserPanel;
                this.constructor$0(jShapeChooserPanel);
            }

            private final void constructor$0(JShapeChooserPanel jShapeChooserPanel) {
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            private final /* synthetic */ JShapeChooserPanel this$0;

            public final void mouseDragged(MouseEvent mouseEvent) {
                int n = this.this$0.eventToShape(mouseEvent);
                if (n < 0 || n >= 64) {
                    return;
                }
                this.this$0.select(n);
                if (mouseEvent.getClickCount() > 1) {
                    this.this$0.openEditor(n);
                }
            }
            {
                this.this$0 = jShapeChooserPanel;
                this.constructor$0(jShapeChooserPanel);
            }

            private final void constructor$0(JShapeChooserPanel jShapeChooserPanel) {
            }
        });
        this.addKeyListener(this);
    }
}

