/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import ptolemy.LineChart;
import starlogo.Application;
import starlogo.Colors;
import starlogo.DisplayMessage;
import starlogo.Interface;
import starlogo.LineDialog;
import starlogo.LineSet;
import starlogo.Patch;
import starlogo.SLMenu;
import starlogo.SmartRectangle;
import starlogo.StackProcess;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import starlogo.Turtle;
import starlogo.Utilities;
import starlogo.Widget;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.Context;
import yoyo.Reader;
import yoyo.YoYo;

public class LineWidget
extends WidgetDrag
implements StarLogoCaller,
DisplayMessage {
    public static Font LINEWIDGET_FONT;
    public static int idCount;
    public static final int MIN_HEIGHT = 70;
    public static final int MIN_WIDTH = 70;
    public static final int BAR = 0;
    public static final int LINE = 1;
    public static final int HISTOGRAM = 2;
    public static final int XYPLOT = 3;
    public static final int PHASE = 4;
    public static final int PIE = 5;
    static Image graph;
    public String delayStr = "1.0";
    public LineChart tbc;
    public Vector sets;
    public int whichip = -1;
    public int onewhichip = -1;
    public StackProcess sp;
    public Font font;
    public FontMetrics fm;
    NumberFormat nf;
    String insttorun;
    public StarLogo sl;
    public Application app;
    public int id;
    public int order;
    public int type;
    public boolean wizardOn = true;
    public boolean deleted = false;
    public int plotpen = 1;
    private Vector spps = new Vector();
    private int sppcount = 0;
    private static /* synthetic */ Class class$Lstarlogo$Pool;

    public static LineWidget load(Vector vector, Interface interface_, StarLogo starLogo, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        int n3 = 50;
        int n4 = 50;
        int n5 = 1;
        int n6 = 1;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var31_27 = null;
        String string4 = null;
        while (n10 < vector.size()) {
            object3 = vector.elementAt(n10).toString();
            if (((String)object3).equals("top-left")) {
                object2 = vector.elementAt(n10 + 1).toString();
                object = vector.elementAt(n10 + 2).toString();
                n = Integer.parseInt((String)object2);
                n2 = Integer.parseInt((String)object);
                n10 += 3;
                continue;
            }
            if (((String)object3).equals("width-height")) {
                object2 = vector.elementAt(n10 + 1).toString();
                object = vector.elementAt(n10 + 2).toString();
                n3 = Integer.parseInt((String)object2);
                n4 = Integer.parseInt((String)object);
                n10 += 3;
                continue;
            }
            if (((String)object3).equals("id")) {
                object2 = vector.elementAt(n10 + 1).toString();
                n5 = Integer.parseInt((String)object2);
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("order")) {
                n9 = Integer.parseInt(vector.elementAt(n10 + 1).toString());
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("type")) {
                n6 = Integer.parseInt(vector.elementAt(n10 + 1).toString());
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("title")) {
                string = vector.elementAt(n10 + 1).toString();
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("delay-string")) {
                string4 = vector.elementAt(n10 + 1).toString();
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("ymin")) {
                d2 = Double.valueOf(vector.elementAt(n10 + 1).toString());
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("ymax")) {
                d4 = Double.valueOf(vector.elementAt(n10 + 1).toString());
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("xmin")) {
                d = Double.valueOf(vector.elementAt(n10 + 1).toString());
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("xmax")) {
                d3 = Double.valueOf(vector.elementAt(n10 + 1).toString());
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("xlabel")) {
                string2 = vector.elementAt(n10 + 1).toString();
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("ylabel")) {
                string3 = vector.elementAt(n10 + 1).toString();
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("grid")) {
                bl2 = vector.elementAt(n10 + 1).toString().equals("true");
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("connected")) {
                bl3 = vector.elementAt(n10 + 1).toString().equals("true");
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("autoscale")) {
                bl5 = vector.elementAt(n10 + 1).toString().equals("true");
                n10 += 2;
                continue;
            }
            if (((String)object3).equals("location")) {
                n11 = Integer.parseInt(vector.elementAt(n10 + 1).toString());
                n12 = Integer.parseInt(vector.elementAt(n10 + 2).toString());
                n10 += 3;
                continue;
            }
            if (bl) {
                if (((String)object3).equals("whichip")) {
                    object2 = vector.elementAt(n10 + 1).toString();
                    n7 = Integer.parseInt((String)object2);
                    n10 += 2;
                    continue;
                }
                if (((String)object3).equals("onewhichip")) {
                    object2 = vector.elementAt(n10 + 1).toString();
                    n8 = Integer.parseInt((String)object2);
                    n10 += 2;
                    continue;
                }
            }
            if (((String)object3).equals("wizard-on")) {
                object2 = vector.elementAt(n10 + 1).toString();
                bl4 = ((String)object2).equals("true");
                n10 += 2;
                continue;
            }
            n10 += 2;
        }
        object3 = null;
        object3 = bl4 ? LineSet.loadLineSets(vector) : new Vector();
        object2 = interface_.getBoundaries();
        object = new Rectangle(n2 + ((Rectangle)object2).x, n + ((Rectangle)object2).y, n3, n4);
        Point point = new Point(n11, n12);
        if (n5 >= idCount) {
            idCount = n5 + 1;
        }
        if (bl) {
            return new LineWidget(n5, n9, n6, (Vector)object3, bl4, string, string2, string3, string4, d, d3, d2, d4, bl2, bl3, bl5, (Rectangle)object, point, interface_, starLogo, n7, n8);
        }
        return new LineWidget(n5, n9, n6, (Vector)object3, bl4, string, string2, string3, string4, d, d3, d2, d4, bl2, bl3, bl5, (Rectangle)object, point, interface_, starLogo);
    }

    public void addLegend(int n, String string) {
        this.tbc.addLegend(n, string);
    }

    public int getId() {
        return this.id;
    }

    public String getLineSetString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.wizardOn) {
            stringBuffer.append("wizard-on true\r\n");
            int n = 0;
            while (n < this.sets.size()) {
                stringBuffer.append(((LineSet)this.sets.elementAt(n)).getSaveString());
                ++n;
            }
        } else {
            stringBuffer.append("wizard-on false\r\n");
        }
        return stringBuffer.toString();
    }

    public String getSaveString(boolean bl) throws IOException {
        Rectangle rectangle = this.parent.getBoundaries();
        String string = "SLLineWidget\r\ntop-left " + (this.position.y - rectangle.y) + " " + (this.position.x - rectangle.x) + "\r\n" + "width-height " + this.position.width + " " + this.position.height + "\r\n" + "id " + this.id + "\r\n" + "order " + this.id + "\r\n" + "type " + this.type + "\r\n" + "title \"" + Utilities.printable(this.tbc.getTitle()) + "\"\r\n" + "delay-string \"" + Utilities.printable(this.delayStr) + "\"\r\n";
        string = string + "xlabel \"" + (this.tbc.getFrameXLabel() == null ? "" : Utilities.printable(this.tbc.getFrameXLabel())) + "\"\r\n" + "ylabel \"" + (this.tbc.getFrameYLabel() == null ? "" : Utilities.printable(this.tbc.getFrameYLabel())) + "\"\r\n" + "grid " + (this.tbc.getGrid() ? "true" : "false") + "\r\n" + (this.type != 2 ? "connected " + (this.tbc.getConnected() ? "true" : "false") + "\r\n" : "") + "autoscale" + (this.tbc.autoscale ? "true" : "false") + "\r\n" + "location " + this.tbc.getLocation().x + " " + this.tbc.getLocation().y + "\r\n" + (bl && this.whichip >= 0 && this.onewhichip >= 0 ? "whichip " + this.whichip + "\r\n" + "onewhichip " + this.onewhichip + "\r\n" : "") + this.getLineSetString() + "\r\n";
        return string;
    }

    public static void createNew(Interface interface_) {
        LineDialog lineDialog = Application.createLineDialog(interface_.frame(), "New Plot");
        if (YoYo.language == 1) {
            lineDialog = Application.createLineDialog(interface_.frame(), "Gr\u00e1fica Nueva");
        }
        lineDialog.show();
        if (lineDialog.pressedOK()) {
            LineWidget lineWidget = new LineWidget(interface_, interface_.sl());
            lineDialog.getValues(lineWidget);
            interface_.addWidget(lineWidget);
            lineWidget.id = idCount;
            lineWidget.order = idCount++;
            lineWidget.setupLineWidget(interface_);
        }
    }

    public static void createNew(Interface interface_, SLMenu sLMenu) {
        LineDialog lineDialog = Application.createLineDialog(interface_.frame(), "New Plot");
        if (YoYo.language == 1) {
            lineDialog = Application.createLineDialog(interface_.frame(), "Gr\u00e1fica Nueva");
        }
        lineDialog.show();
        if (lineDialog.pressedOK()) {
            LineWidget lineWidget = new LineWidget(interface_, interface_.sl(), true);
            int n = 3;
            lineWidget.position = new Rectangle(52 + n, interface_.getSize().height - MIN_HEIGHT - n - 24, MIN_WIDTH, MIN_HEIGHT);
            lineDialog.getValues(lineWidget);
            interface_.addWidget(lineWidget);
            lineWidget.id = idCount;
            lineWidget.order = idCount++;
            lineWidget.setupLineWidget(interface_);
            interface_.repaint(lineWidget.position);
        }
    }

    public static LineWidget createNew(int n, Interface interface_) {
        LineWidget lineWidget = new LineWidget(interface_, interface_.sl(), true);
        int n2 = 3;
        lineWidget.position = new Rectangle(52 + n2, interface_.getSize().height - MIN_HEIGHT - n2 - 24, MIN_WIDTH, MIN_HEIGHT);
        if (interface_.clipRect() == null) {
            interface_.setClipRect(new Rectangle());
        }
        interface_.addWidget(lineWidget);
        lineWidget.id = 1;
        lineWidget.order = 1;
        lineWidget.wizardOn = false;
        lineWidget.type = 1;
        lineWidget.setupLineWidget(interface_);
        interface_.repaint(lineWidget.position);
        return lineWidget;
    }

    public void setupLineWidget(Interface interface_) {
        this.sets = new Vector(10);
        int n = 1;
        while (n <= 10) {
            this.sets.addElement(new LineSet(n, this.type, this.id));
            ++n;
        }
        this.tbc = new LineChart(interface_.app(), this.id, this.id, this.sets, this.type, this);
        if (!this.wizardOn) {
            this.tbc.disableDataInFormatMenu();
        }
        this.show();
        this.tbc.setWidgetSize(100, 110);
        this.tbc.validate();
        this.tbc.repaintWidget();
        interface_.app().rancompilerp = false;
        interface_.addPlotWindow(this.tbc.getTitle());
    }

    public void resize(Point point, int n) {
        super.resize(point, n);
        this.tbc.setWidgetSize(30 + this.position.width, 40 + this.position.height);
    }

    public void mouseDoubleClicked(MouseEvent mouseEvent) {
        if (YoYo.applet == null) {
            ((Component)this.tbc).setVisible(true);
        }
    }

    public void edit() {
        this.parent.addHandlesToClipRect(this);
        this.show();
        super.edit();
    }

    public void show() {
        if (YoYo.applet == null) {
            ((Component)this.tbc).setVisible(true);
        }
    }

    public void reset() {
        this.tbc.reset();
    }

    public void erasePoint(int n) {
        if (this.type == 2) {
            this.tbc.removeHistoHashPoint(n);
        }
        if (this.type == 3) {
            this.tbc.removeLiveHashPoint(n);
        }
        this.tbc.repaintWithInterface();
    }

    public void delete() {
        ((Component)this.tbc).setVisible(false);
        this.parent.linewidgets().removeElement(this);
        this.parent.removePlotWindow(this.tbc.getTitle());
        super.delete();
        this.deleted = true;
    }

    public String getCommandToCompile(String string) {
        String string2 = "compile-line-command " + this.id + " ";
        String string3 = "[loop [";
        String string4 = " wait ";
        String string5 = " ] ] ";
        String string6 = " [";
        String string7 = " ]";
        if (string.trim().equals("")) {
            return string.trim();
        }
        String string8 = this.type == 0 ? string2 + string3 + string + string4 + this.delayStr + string5 + string6 + string + string7 : (this.type == 3 || this.type == 2 ? string2 + string3 + string + string4 + this.delayStr + string5 + string6 + string + string7 : string2 + string3 + string + string4 + this.delayStr + string5 + string6 + string + string7);
        return string8;
    }

    private final String stringBufferDelete(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < string.length()) {
            if (n3 < n || n3 >= n2) {
                stringBuffer.append(string.charAt(n3));
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String removeLoop(String string) {
        String string2 = "loop [";
        int n = 0;
        while (n < string.length()) {
            if (string.indexOf(string2, n) != -1) {
                int n2 = string.indexOf(string2, n);
                string = this.stringBufferDelete(string, n2, n2 + string2.length());
                n2 = string.indexOf("]", n);
                string = this.stringBufferDelete(string, n2, n2 + string2.length());
                n = n2 + 1;
            }
            ++n;
        }
        return string;
    }

    public static String getType(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Bar Chart: ";
                break;
            }
            case 1: {
                string = "Line Chart: ";
                break;
            }
            case 2: {
                string = "Histogram: ";
                break;
            }
            case 3: {
                string = "Scatterplot: ";
                break;
            }
            case 4: {
                string = "X-Y plot: ";
                break;
            }
        }
        return string;
    }

    public void compileCommand() {
        if (this.wizardOn) {
            this.whichip = -1;
            this.onewhichip = -1;
            Object object = this.sl.runningp;
            synchronized (object) {
                this.sl.stopAll();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.sets.size()) {
                stringBuffer.append(((LineSet)this.sets.elementAt(n)).getCommandToCompile());
                ++n;
            }
            String string = stringBuffer.toString().trim();
            if (!string.equals("")) {
                String string2 = this.getCommandToCompile(string);
                Object[] objectArray = Reader.read(string2);
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = this;
                if (StarLogo.DEBUG) {
                    System.out.println("Trying to compile lineWidget: " + this + " Line: " + string2);
                }
                this.app.cc.enqueue(objectArray2, this.app.message, this.app.err, this);
            }
        }
    }

    public void setCompiledCommand(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4) {
        if (StarLogo.DEBUG) {
            System.out.println("Finished compiling line widget: " + this);
        }
        int[] nArray = new int[objectArray.length];
        int[] nArray2 = new int[objectArray3.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        n = 0;
        while (n < objectArray3.length) {
            nArray2[n] = ((Number)objectArray3[n]).intValue();
            ++n;
        }
        if (StarLogo.DEBUG) {
            System.out.println("line widget ilist: " + YoYo.printToString(objectArray));
            System.out.println("line widget olist: " + YoYo.printToString(objectArray2));
            System.out.println("line widget ilist2: " + YoYo.printToString(objectArray3));
            System.out.println("line widget olist2: " + YoYo.printToString(objectArray4));
        }
        this.whichip = this.sl.internalSetInstructions(this.toString(), nArray, objectArray2);
        this.onewhichip = this.sl.internalSetInstructions(this.toString(), nArray2, objectArray4);
        if (StarLogo.DEBUG) {
            this.app.log.println("line widget whichip = " + this.whichip + " onewhichip " + this.onewhichip);
        }
        Object object = this.sl.runningp;
        synchronized (object) {
            if (this.onewhichip >= 0) {
                StackProcessParent.runMonitor(this.sl, this.onewhichip, false, this);
            }
        }
        this.sp = null;
    }

    public String toString() {
        return "Line Widget: " + this.id;
    }

    public void paint(Graphics graphics) {
        graphics.translate(this.position.x, this.position.y);
        graphics.setColor(SystemColor.control);
        graphics.fill3DRect(0, 0, this.position.width, this.position.height, true);
        if (this.wizardOn) {
            graphics.setColor(new Color(0, 153, 255));
        } else {
            graphics.setColor(SystemColor.control);
        }
        graphics.fill3DRect(0, 0, this.position.width, this.position.height, true);
        Image image = this.parent.createImage(this.tbc.getWidgetSize().width, this.tbc.getWidgetSize().height);
        Graphics graphics2 = image.getGraphics();
        this.tbc.paintWidget(graphics2);
        graphics2.dispose();
        graphics.drawImage(image, 5, 10, this.position.width - 5, this.position.height - 5, 10, 35, -1 + this.position.width, 8 + this.position.height, this.parent);
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        if (this.fm.stringWidth(this.tbc.getPreTitle() + this.tbc.getTitle()) > this.position.width - 6) {
            graphics.drawString(this.tbc.getPreTitle() + "Plot", 3, 9);
        } else {
            graphics.drawString(this.tbc.getPreTitle() + this.tbc.getTitle(), 3, 9);
        }
        graphics.drawString(this.nf.format(this.tbc.getWidgetYRange()[1]), 8, 20);
        graphics.drawString(this.nf.format(this.tbc.getWidgetYRange()[0]), 8, this.position.height - 18);
        if (this.type == 1 || this.type == 4 || this.type == 3) {
            double d = this.tbc.getWidgetXRange()[1];
            int n = (int)(Math.log(d) / Math.log(Math.E));
            graphics.drawString(this.nf.format(d), this.position.width - 12 - 3 * n, this.position.height - 8);
            d = this.tbc.getWidgetXRange()[0];
            n = (int)(Math.log(d) / Math.log(Math.E));
            graphics.drawString(this.nf.format(d), 12, this.position.height - 8);
        }
        graphics.translate(-this.position.x, -this.position.y);
    }

    public void done(Context context) {
    }

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0) {
            this.sp = null;
            this.parent.repaint(this.position);
        }
    }

    public void callerPrintln(String string) {
    }

    public void callerClearText() {
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
    }

    public void displayOneString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error in " + this.toString(), string, true);
    }

    public void displayAString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error in " + this.toString(), string, true);
    }

    public boolean wizardOn() {
        if (this.wizardOn) {
            this.displayAString("Cannot use plot commands on plots controlled by plot wizard.");
            return true;
        }
        return false;
    }

    public int getToolbarButton() {
        return 6;
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        graph = toolkit.getImage((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = LineWidget.class$("starlogo.Pool"))).getResource(string + "line-obj.gif"));
        mediaTracker.addImage(graph, Widget.trackerID++);
    }

    public WidgetDrag copy(int n, Rectangle rectangle) {
        LineWidget lineWidget = new LineWidget(rectangle, this.parent, this.sl);
        lineWidget.type = this.type;
        lineWidget.id = idCount;
        lineWidget.order = idCount++;
        lineWidget.wizardOn = this.wizardOn;
        lineWidget.plotpen = this.plotpen;
        int n2 = this.sets.size();
        lineWidget.sets = new Vector(n2);
        int n3 = 1;
        while (n3 <= n2) {
            lineWidget.sets.addElement(((LineSet)this.sets.elementAt(n3 - 1)).copy(n3, n3));
            ++n3;
        }
        lineWidget.tbc = this.tbc.copy(this.app, lineWidget);
        if (!lineWidget.wizardOn) {
            lineWidget.tbc.disableDataInFormatMenu();
        }
        lineWidget.tbc.setPlotTitle(this.tbc.getTitle() + " copy" + WidgetDrag.editionString(n));
        lineWidget.tbc.setWidgetSize(this.tbc.getWidgetSize().width, this.tbc.getWidgetSize().height);
        lineWidget.tbc.validate();
        lineWidget.tbc.repaint();
        lineWidget.parent.addPlotWindow(lineWidget.tbc.getTitle());
        lineWidget.app.rancompilerp = false;
        this.app.project.markChanged();
        return lineWidget;
    }

    public void plot(int n, double d) {
        if (this.type != 2) {
            if (this.type == 1) {
                this.tbc.addDataPoint(n, d);
                this.tbc.repaintWithInterface();
            } else if (this.type == 0) {
                this.tbc.addDataPointToHash(1, n, n, d);
                this.tbc.repaintWithInterface();
            }
        }
    }

    public void setplotppc(int n, int n2) {
        this.tbc.setColor(n, Colors.colorarray[n2 * 32]);
        this.tbc.setSLColor(n, n2);
        this.tbc.repaintWithInterface();
    }

    public void setplotxmin(double d) {
        this.tbc.setXMin(d);
        this.tbc.repaintWithInterface();
    }

    public void setplotxmax(double d) {
        this.tbc.setXMax(d);
        this.tbc.repaintWithInterface();
    }

    public void setplotymin(double d) {
        this.tbc.setYMin(d);
        this.tbc.repaintWithInterface();
    }

    public void setplotymax(double d) {
        this.tbc.setYMax(d);
        this.tbc.repaintWithInterface();
    }

    public void setplotxrange(double d, double d2) {
        this.tbc.setXRange(d, d2);
        this.tbc.repaintWithInterface();
    }

    public void setplotyrange(double d, double d2) {
        this.tbc.setYRange(d, d2);
        this.tbc.repaintWithInterface();
    }

    public void ppreset(int n) {
    }

    public void setGrid(boolean bl) {
        this.tbc.setGrid(bl);
        this.tbc.repaintWithInterface();
    }

    public void ppd(int n) {
        if (this.type != 2 && this.type != 0) {
            this.tbc.ppd();
            this.tbc.repaintWithInterface();
        }
    }

    public void ppu(int n) {
        if (this.type != 2 && this.type != 0) {
            this.tbc.ppu();
            this.tbc.repaintWithInterface();
        }
    }

    public void setplottitle(String string) {
        this.parent.changePlotWindow(this.tbc.getTitle(), string);
        this.tbc.setPlotTitle(string);
        this.tbc.repaintWithInterface();
    }

    public void setplotxlabel(String string) {
        this.tbc.setXLabel(string);
        this.tbc.repaintWithInterface();
    }

    public void setplotylabel(String string) {
        this.tbc.setYLabel(string);
        this.tbc.repaintWithInterface();
    }

    public void setnumplotpens(int n) {
        if (this.type == 2) {
            this.tbc.setHistoNum(n);
        } else {
            this.tbc.setLineNum(n);
        }
    }

    public void plotdistribution(int n, int n2, double d) {
        if (this.type == 2) {
            this.tbc.addHistoDataPointToHash(n, n2, d, this.sl.numturtles);
            this.tbc.repaintWithInterface();
        }
    }

    public void plotscatter(int n, int n2, double d, double d2) {
        if (this.type == 3) {
            this.tbc.addDataPointToHash(n, n2, d, d2);
            if (this.tbc.getLineNum() > 50) {
                this.tbc.setLineNum(0);
            }
            this.tbc.setLineNum(1 + this.tbc.getLineNum());
            this.tbc.repaintWithInterface();
        } else {
            this.displayOneString("cannot use plot-turtle-scatterplot/plot-patch-scatterplot for this plot");
        }
    }

    public void plotxy(int n, double d, double d2) {
        this.tbc.addDataPoint(n, d, d2);
        this.tbc.repaintWithInterface();
    }

    public void setbarwidth(int n, double d) {
        this.tbc.setBinWidth(n, d);
        this.tbc.repaintWithInterface();
    }

    public void plotpen(int n) {
        this.plotpen = n;
    }

    public Integer plotppc(int n) {
        return new Integer(this.tbc.getSLColor(n));
    }

    public Double ppxcor(int n) {
        if (this.type == 2) {
            return new Double(0.0);
        }
        return new Double(this.tbc.getPPXCor(n));
    }

    public Double ppycor(int n) {
        if (this.type == 2) {
            return new Double(0.0);
        }
        return new Double(this.tbc.getPPYCor(n));
    }

    public Double plotxmin() {
        return new Double(this.tbc.getFrameXRange()[0]);
    }

    public Double plotxmax() {
        return new Double(this.tbc.getFrameXRange()[1]);
    }

    public Double plotymin() {
        return new Double(this.tbc.getFrameYRange()[0]);
    }

    public Double plotymax() {
        return new Double(this.tbc.getFrameYRange()[1]);
    }

    public String plottitle() {
        return this.tbc.getTitle();
    }

    public String plotxlabel() {
        return this.tbc.getFrameXLabel();
    }

    public String plotylabel() {
        return this.tbc.getFrameYLabel();
    }

    public Integer countplotpens() {
        if (this.type == 2) {
            return new Integer(this.tbc.getHistoNum());
        }
        return new Integer(this.tbc.getLineNum());
    }

    public void ptolemyplot(int n, double d, Turtle turtle, Patch patch, int n2) {
        block3: {
            block2: {
                if (this.type != 1 && this.type != 0) break block2;
                this.plot(n, d);
                break block3;
            }
            if (this.type != 2) break block3;
            if (turtle != null) {
                this.plotdistribution(n, turtle.who, d);
            } else {
                this.plotdistribution(n, (int)(patch.xcor * (double)this.sl.width + patch.ycor), d);
            }
        }
    }

    public void ptolemyplotxy(int n, double d, double d2, Turtle turtle, Patch patch, int n2) {
        block3: {
            block2: {
                if (this.type != 4) break block2;
                this.plotxy(n, d, d2);
                break block3;
            }
            if (this.type != 3) break block3;
            if (turtle != null) {
                this.plotscatter(n, turtle.who, d, d2);
            } else {
                this.plotscatter(n, (int)(patch.xcor * (double)this.sl.width + patch.ycor), d, d2);
            }
        }
    }

    public boolean plotgrid() {
        return this.tbc.getGrid();
    }

    public void setPlotGrid(boolean bl) {
        this.tbc.setGrid(bl);
        this.tbc.repaintWithInterface();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LineWidget(int n, int n2, int n3, Vector vector, boolean bl, String string, String string2, String string3, String string4, double d, double d2, double d3, double d4, boolean bl2, boolean bl3, boolean bl4, Rectangle rectangle, Point point, Interface interface_, StarLogo starLogo) {
        Object object;
        this.position = new Rectangle(rectangle);
        this.delayStr = string4;
        this.id = n;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.sets = vector;
        this.type = n3;
        this.wizardOn = bl;
        this.font = LINEWIDGET_FONT;
        this.fm = this.parent.getToolkit().getFontMetrics(this.font);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(0);
        this.tbc = new LineChart(interface_.app(), this.id, this.id, this.sets, this.type, this);
        if (string != null && !string.equals("null")) {
            this.tbc.setPlotTitle(string);
        }
        if (string2 != null && !string2.equals("null")) {
            this.tbc.setXLabel(string2);
        }
        if (string3 != null && !string3.equals("null")) {
            this.tbc.setYLabel(string3);
        }
        this.tbc.setGrid(bl2);
        if (n3 != 2) {
            this.tbc.setConnected(bl3);
        }
        this.tbc.autoscale = bl4;
        ((Component)this.tbc).setLocation(point);
        this.tbc.setWidgetSize(30 + this.position.width, 40 + this.position.height);
        this.parent.repaint();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < vector.size()) {
            object = (LineSet)this.sets.elementAt(n6);
            this.tbc.setColor(((LineSet)object).id % 10, ((LineSet)object).color);
            if (((LineSet)object).displayed) {
                ++n4;
                n5 = n6;
            }
            ++n6;
        }
        if (this.type == 0) {
            this.tbc.setPointsPersistence(n4);
            this.tbc.setPointsPersistence(n4);
            this.tbc.explicitLineXRange(0.5, 1.5 + (double)n5);
            this.tbc.explicitWidgetXRange(0.5, 1.5 + (double)n5);
            n6 = 1;
            object = vector.elements();
            while (object.hasMoreElements()) {
                LineSet lineSet = (LineSet)object.nextElement();
                if (!lineSet.displayed) continue;
                char c = ' ';
                char c2 = '-';
                this.tbc.addXTick(lineSet.name.replace(c, c2), n6++);
            }
        } else if (this.type == 2) {
            this.tbc.setHistoNum(n4);
        } else {
            this.tbc.setLineNum(n4);
        }
        if (!this.wizardOn) {
            this.tbc.disableDataInFormatMenu();
        }
        this.parent.addPlotWindow(this.tbc.getTitle());
    }

    public LineWidget(int n, int n2, int n3, Vector vector, boolean bl, String string, String string2, String string3, String string4, double d, double d2, double d3, double d4, boolean bl2, boolean bl3, boolean bl4, Rectangle rectangle, Point point, Interface interface_, StarLogo starLogo, int n4, int n5) {
        this(n, n2, n3, vector, bl, string, string2, string3, string4, d, d2, d3, d4, bl2, bl3, bl4, rectangle, point, interface_, starLogo);
        this.whichip = n4;
        this.onewhichip = n5;
    }

    public LineWidget(Interface interface_, StarLogo starLogo) {
        Dimension dimension = interface_.getSize();
        SmartRectangle smartRectangle = interface_.outline();
        if (interface_.outline().x + 70 > interface_.getSize().width) {
            interface_.outline().width = interface_.outline().width + interface_.outline().x - interface_.getSize().width + 70;
            interface_.outline().x = interface_.getSize().width - 70;
        }
        if (interface_.outline().width < 70) {
            interface_.outline().width = 70;
        }
        if (interface_.outline().y + 70 > interface_.getSize().height) {
            interface_.outline().height = interface_.outline().height + interface_.outline().y - interface_.getSize().height + 70;
            interface_.outline().y = interface_.getSize().height - 70;
        }
        if (interface_.outline().height < 70) {
            interface_.outline().height = 70;
        }
        this.position = new Rectangle(smartRectangle);
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = LINEWIDGET_FONT;
        this.fm = this.parent.getToolkit().getFontMetrics(this.font);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(0);
    }

    public LineWidget(Rectangle rectangle, Interface interface_, StarLogo starLogo) {
        this.position = new Rectangle(rectangle);
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = LINEWIDGET_FONT;
        this.fm = this.parent.getToolkit().getFontMetrics(this.font);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(0);
    }

    public LineWidget() {
    }

    public LineWidget(Interface interface_, StarLogo starLogo, boolean bl) {
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = LINEWIDGET_FONT;
        this.fm = this.parent.getToolkit().getFontMetrics(this.font);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(0);
    }

    static {
        idCount = 2;
        try {
            LINEWIDGET_FONT = WidgetLite.WIDGET_FONT;
            if (YoYo.macintoshp) {
                LINEWIDGET_FONT = Font.getFont("starlogo.linewidget.font", LINEWIDGET_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

