/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import starlogo.Application;
import starlogo.DisplayMessage;
import starlogo.Interface;
import starlogo.MonitorDialog;
import starlogo.Project;
import starlogo.SLProc;
import starlogo.SmartRectangle;
import starlogo.StackProcess;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import starlogo.ToolTipWidget;
import starlogo.Utilities;
import starlogo.VM;
import starlogo.Widget;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.Context;
import yoyo.Reader;
import yoyo.YoYo;

public class MonitorWidget
extends WidgetDrag
implements StarLogoCaller,
Observer,
DisplayMessage {
    public static int idCount = 1;
    public static int MONITOR_WIDTH = 30;
    public static int MONITOR_EDGE_WIDTH = 14;
    public static int MONITOR_HEIGHT = 36;
    static Image monEdges;
    static Image monMiddle;
    static Font MONITOR_FONT;
    public int cindex = 0;
    public boolean isVis = false;
    public boolean selected = false;
    public String inst;
    public String name;
    public boolean showName;
    public int digits;
    public Font font;
    public double delay = 0.5;
    Object value = VM.zeroInt;
    String valuestring = "0";
    public int whichip = -1;
    public int onewhichip = -1;
    public StackProcess sp;
    public FontMetrics fm;
    public int textHeight;
    public int textDescent;
    String insttorun;
    StarLogo sl;
    Application app;
    public int id;
    private Vector spps = new Vector();
    private int sppcount = 0;
    private static /* synthetic */ Class class$Lstarlogo$MonitorWidget;

    public static MonitorWidget load(Vector vector, Interface interface_, StarLogo starLogo, boolean bl) {
        Object object;
        Object object2;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 50;
        int n4 = 20;
        int n5 = 1;
        int n6 = 0;
        double d = 0.5;
        String string = "monitor1";
        String string2 = "nothing";
        Object object3 = "";
        int n7 = -1;
        int n8 = -1;
        boolean bl3 = false;
        int n9 = 0;
        while (n9 < vector.size()) {
            String string3;
            object2 = vector.elementAt(n9).toString();
            if (((String)object2).equals("top-left")) {
                object = vector.elementAt(n9 + 1).toString();
                string3 = vector.elementAt(n9 + 2).toString();
                n = Integer.parseInt((String)object);
                n2 = Integer.parseInt(string3);
                n9 += 3;
                continue;
            }
            if (((String)object2).equals("width-height")) {
                object = vector.elementAt(n9 + 1).toString();
                string3 = vector.elementAt(n9 + 2).toString();
                n3 = Integer.parseInt((String)object);
                n4 = Integer.parseInt(string3);
                n9 += 3;
                continue;
            }
            if (((String)object2).equals("name")) {
                string = vector.elementAt(n9 + 1).toString();
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("show-name?")) {
                object = vector.elementAt(n9 + 1).toString();
                bl2 = ((String)object).equals("true");
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("isVis")) {
                object = vector.elementAt(n9 + 1).toString();
                bl3 = ((String)object).equals("true");
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("list-to-run")) {
                string2 = vector.elementAt(n9 + 1).toString();
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("monitor-number")) {
                object = vector.elementAt(n9 + 1).toString();
                n5 = Integer.parseInt((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("digits")) {
                object = vector.elementAt(n9 + 1).toString();
                n6 = Integer.parseInt((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("delay")) {
                object = vector.elementAt(n9 + 1).toString();
                d = Double.valueOf((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("toolTip-text")) {
                object3 = object = vector.elementAt(n9 + 1).toString();
                n9 += 2;
                continue;
            }
            if (bl) {
                if (((String)object2).equals("whichip")) {
                    object = vector.elementAt(n9 + 1).toString();
                    n7 = Integer.parseInt((String)object);
                    n9 += 2;
                    continue;
                }
                if (((String)object2).equals("onewhichip")) {
                    object = vector.elementAt(n9 + 1).toString();
                    n8 = Integer.parseInt((String)object);
                    n9 += 2;
                    continue;
                }
            }
            n9 += 2;
        }
        object2 = interface_.getBoundaries();
        object = new Rectangle(n2 + ((Rectangle)object2).x, n + ((Rectangle)object2).y, n3, n4);
        if (n5 >= idCount) {
            idCount = n5 + 1;
        }
        if (bl) {
            return new MonitorWidget(string, string2, (Rectangle)object, n6, d, bl2, bl3, n5, interface_, n7, n8, starLogo, (String)object3);
        }
        return new MonitorWidget(string, string2, (Rectangle)object, n6, d, bl2, bl3, n5, interface_, starLogo, (String)object3);
    }

    public int getId() {
        return this.id;
    }

    public String getSaveString(boolean bl) throws IOException {
        Rectangle rectangle = this.parent.getBoundaries();
        return "SLMonitor\r\ntop-left " + (this.position.y - rectangle.y) + " " + (this.position.x - rectangle.x) + "\r\n" + "width-height " + this.position.width + " " + this.position.height + "\r\n" + "name \"" + this.name + "\"\r\n" + "list-to-run \"" + Utilities.printable(this.inst) + "\"\r\n" + "digits " + this.digits + "\r\n" + "delay " + this.delay + "\r\n" + "monitor-number " + this.id + "\r\n" + "show-name? " + (this.showName ? "true\r\n" : "false\r\n") + this.getToolTipSaveString() + (bl && this.whichip >= 0 && this.onewhichip >= 0 ? "whichip " + this.whichip + "\r\n" + "onewhichip " + this.onewhichip + "\r\n" : "") + "\r\n";
    }

    public static void createNew(Interface interface_) {
        MonitorDialog monitorDialog = Application.createMonitorDialog(interface_.frame(), "New Monitor");
        if (YoYo.language == 1) {
            monitorDialog = Application.createMonitorDialog(interface_.frame(), "Monitor Nuevo");
        }
        monitorDialog.show();
        if (monitorDialog.pressedOK()) {
            MonitorWidget monitorWidget = new MonitorWidget(interface_, interface_.sl());
            monitorDialog.getValues(monitorWidget);
            monitorWidget.updateMinSize();
            interface_.addWidget(monitorWidget);
            interface_.app().rancompilerp = false;
        }
        monitorDialog.dispose();
    }

    public void setIndex(int n) {
        this.cindex = n;
    }

    public static int createNewFromPtolemy(Interface interface_, int n) {
        MonitorDialog monitorDialog = Application.createMonitorDialog(interface_.frame(), "New Monitor");
        monitorDialog.show();
        if (monitorDialog.pressedOK()) {
            MonitorWidget monitorWidget = new MonitorWidget(interface_, interface_.sl(), true);
            monitorDialog.getValues(monitorWidget);
            interface_.addWidget(monitorWidget);
            interface_.app().rancompilerp = false;
            monitorWidget.setIndex(n);
            monitorWidget.setVis(true);
        }
        monitorDialog.dispose();
        return idCount - 1;
    }

    public void setVis(boolean bl) {
        this.isVis = true;
    }

    public void edit() {
        MonitorDialog monitorDialog = Application.createMonitorDialog(this.parent.frame(), "Edit Monitor", this);
        monitorDialog.show();
        if (monitorDialog.pressedOK()) {
            boolean bl = this.showName;
            String string = this.name;
            String string2 = this.inst;
            this.parent.addHandlesToClipRect(this);
            monitorDialog.getValues(this);
            if (bl != this.showName || this.showName && !string.equals(this.name) || !this.showName && !string2.equals(this.inst)) {
                this.updateMinSize();
            }
            this.update(this.position);
            this.app.rancompilerp = false;
            this.app.project.markChanged();
        }
        monitorDialog.dispose();
        super.edit();
    }

    public void setValue(Object object) {
        this.value = object;
        this.valuestring = this.formatValue();
        this.parent.repaint(this.position);
    }

    public void delete() {
        this.parent.monitors().removeElement(this);
        super.delete();
    }

    public String getCommandToCompile() {
        String string = "compile-monitor-command " + this.id + " ";
        String string2 = "[loop [%print-to-monitor " + this.id + " ";
        if (YoYo.language == 1) {
            string2 = "[siempre [%print-to-monitor " + this.id + " ";
        }
        String string3 = " wait ";
        String string4 = " ] ] ";
        String string5 = " [%print-to-monitor " + this.id + " ";
        String string6 = " ]";
        return string + string2 + this.inst + string3 + this.delay + string4 + string5 + this.inst + string6;
    }

    public void update() {
    }

    public void update(Observable observable, Object object) {
        if (object instanceof SLProc) {
            this.update();
        }
    }

    public void update(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public void compileCommand() {
        this.whichip = -1;
        this.onewhichip = -1;
        Object object = this.sl.runningp;
        synchronized (object) {
            this.sl.stopAll();
        }
        Object[] objectArray = Reader.read(this.getCommandToCompile());
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray2.length - 1] = this;
        if (StarLogo.DEBUG) {
            this.app.log.println("Trying to compile monitor: " + this);
        }
        this.app.cc.enqueue(objectArray2, this.app.message, this.app.err, this);
    }

    public void setCompiledCommand(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4) {
        if (StarLogo.DEBUG) {
            this.app.log.println("Finished compiling monitor: " + this);
        }
        int[] nArray = new int[objectArray.length];
        int[] nArray2 = new int[objectArray3.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        n = 0;
        while (n < objectArray3.length) {
            nArray2[n] = ((Number)objectArray3[n]).intValue();
            ++n;
        }
        if (StarLogo.DEBUG) {
            this.app.log.println("monitor ilist: " + YoYo.printToString(objectArray));
            this.app.log.println("monitor olist: " + YoYo.printToString(objectArray2));
            this.app.log.println("monitor ilist2: " + YoYo.printToString(objectArray3));
            this.app.log.println("monitor olist2: " + YoYo.printToString(objectArray4));
        }
        this.whichip = this.sl.internalSetInstructions(this.toString(), nArray, objectArray2);
        this.onewhichip = this.sl.internalSetInstructions(this.toString(), nArray2, objectArray4);
        if (StarLogo.DEBUG) {
            this.app.log.println("monitor whichip = " + this.whichip + " onewhichip " + this.onewhichip);
        }
        this.sp = null;
    }

    public String toString() {
        return "Monitor: " + this.inst;
    }

    public void paint(Graphics graphics) {
        graphics.translate(this.position.x, this.position.y);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, MONITOR_EDGE_WIDTH, MONITOR_HEIGHT);
        graphics.drawImage(monEdges, 0, 0, null);
        graphics.setClip(shape);
        graphics.clipRect(this.position.width - MONITOR_EDGE_WIDTH, 0, MONITOR_EDGE_WIDTH, MONITOR_HEIGHT);
        graphics.drawImage(monEdges, this.position.width - 2 * MONITOR_EDGE_WIDTH, 0, null);
        graphics.setClip(shape);
        graphics.drawImage(monMiddle, MONITOR_EDGE_WIDTH, 0, this.position.width - 2 * MONITOR_EDGE_WIDTH, MONITOR_HEIGHT, null);
        graphics.translate(-this.position.x, -this.position.y);
        this.paintText(graphics);
    }

    public void paintText(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        int n = this.fm.stringWidth(this.showName ? this.name : this.inst);
        graphics.translate(this.position.x, this.position.y);
        Shape shape = graphics.getClip();
        graphics.clipRect(5, 23, this.position.width - 10, 10);
        graphics.drawString(this.showName ? this.name : this.inst, 5, 28 + this.textHeight / 2 - this.textDescent);
        graphics.setClip(shape);
        graphics.clipRect(10, 7, this.position.width - 20, 12);
        graphics.drawString(this.valuestring, 10, 13 + this.textHeight / 2 - this.textDescent);
        graphics.setClip(shape);
        graphics.translate(-this.position.x, -this.position.y);
        graphics.setColor(color);
    }

    public void updateMinSize() {
        int n = this.fm.stringWidth(this.showName ? this.name : this.inst);
        int n2 = 10 + n;
        if (this.position.width < n2) {
            this.position.width = n2;
        }
        if (this.parent.outline() != null) {
            this.parent.outline().width = this.position.width;
        }
    }

    public void done(Context context) {
    }

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0) {
            this.sp = null;
            this.parent.repaint(this.position);
        }
    }

    public void callerPrintln(String string) {
    }

    public void callerClearText() {
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
    }

    public void displayOneString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error in " + this.name, string, true);
    }

    public void displayAString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error in " + this.name, string, true);
    }

    String formatValue() {
        if (this.value instanceof Number) {
            return this.clipDigits(this.value.toString());
        }
        return YoYo.printToString(this.value);
    }

    String clipDigits(String string) {
        int n;
        String string2;
        int n2 = string.indexOf(69);
        int n3 = string.indexOf(46);
        int n4 = string.indexOf(45);
        if (n4 == 0) {
            string2 = string.substring(1, string.length());
            n4 = string2.indexOf(45);
        }
        if (n2 == -1 && n4 != -1) {
            string = string.substring(0, n4);
            n4 = string.indexOf(45);
        }
        if (n2 != -1) {
            if (string.charAt(n2 + 1) != '-') {
                return string;
            }
            string2 = "";
            int n5 = Integer.parseInt(string.substring(n2 + 2, string.length()));
            n = 0;
            while (n < n5 - 1) {
                string2 = string2 + "0";
                ++n;
            }
            string = n4 == 0 ? "-0." + string2 + string.substring(0, n3) : "0." + string2 + string.substring(0, n3);
            if ((n4 = string.substring(1, string.length()).indexOf(45)) != -1) {
                string = string.substring(0, n4);
            }
            n3 = string.indexOf(46);
        }
        if (n3 == -1 && this.digits == 0) {
            return string;
        }
        if (n3 == -1 && this.digits != 0) {
            string = string + ".000";
            n3 = string.indexOf(46);
            return string.substring(0, n3 + this.digits + 1);
        }
        if (this.digits == 0) {
            float f = Float.valueOf(string).floatValue();
            string = Float.toString(Math.round(f));
            n3 = string.indexOf(46);
            return string.substring(0, n3);
        }
        if (string.substring(n3 + 1, string.length()).length() <= this.digits) {
            string = string + "000";
            return string.substring(0, n3 + this.digits + 1);
        }
        n4 = string.indexOf(45);
        string = string + "000";
        double d = Double.valueOf(string);
        n = 1;
        int n6 = 1;
        while (n6 <= this.digits) {
            n = 10 * n;
            ++n6;
        }
        n6 = (int)Math.round(d *= (double)n);
        String string3 = "";
        String string4 = Integer.toString(n6 % n);
        if (string4.charAt(0) == '-') {
            string4 = string4.substring(1, string4.length());
        }
        int n7 = string4.length();
        while (n7 < this.digits) {
            string3 = string3 + "0";
            ++n7;
        }
        string = n4 == -1 ? n6 / n + "." + string3 + string4 : "-" + n6 / n + "." + string3 + string4;
        return string;
    }

    public void handleMouseClick(MouseEvent mouseEvent) {
        if (this.parent.getToolbar().buttonDown == 4 && YoYo.applet == null) {
            this.edit();
        }
    }

    public int getToolbarButton() {
        return 4;
    }

    public int resizeWhichCorner(Point point) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.position.x - 8, this.position.y - 8, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 7;
        }
        rectangle.setBounds(this.position.x + this.position.width, this.position.y - 8, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 8;
        }
        rectangle.setBounds(this.position.x - 8, this.position.y + this.position.height, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 7;
        }
        rectangle.setBounds(this.position.x + this.position.width, this.position.y + this.position.height, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 8;
        }
        return 0;
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        monEdges = toolkit.getImage((class$Lstarlogo$MonitorWidget != null ? class$Lstarlogo$MonitorWidget : (class$Lstarlogo$MonitorWidget = MonitorWidget.class$("starlogo.MonitorWidget"))).getResource(string + "monitor.gif"));
        monMiddle = toolkit.getImage((class$Lstarlogo$MonitorWidget != null ? class$Lstarlogo$MonitorWidget : (class$Lstarlogo$MonitorWidget = MonitorWidget.class$("starlogo.MonitorWidget"))).getResource(string + "mon-mid.gif"));
        mediaTracker.addImage(monEdges, Widget.trackerID++);
        mediaTracker.addImage(monMiddle, Widget.trackerID++);
    }

    public WidgetDrag copy(int n, Rectangle rectangle) {
        String string = this.name + " copy" + WidgetDrag.editionString(n);
        return new MonitorWidget(string, this.inst, rectangle, this.digits, this.delay, this.showName, this.isVis, ++idCount, this.parent, this.whichip, this.onewhichip, this.sl, this.getToolText());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MonitorWidget(String string, String string2, Rectangle rectangle, int n, double d, boolean bl, boolean bl2, int n2, Interface interface_, StarLogo starLogo, String string3) {
        this.name = string;
        this.showName = bl;
        this.isVis = bl2;
        this.inst = string2;
        this.position = new Rectangle(rectangle);
        this.position.height = MONITOR_HEIGHT;
        this.digits = n;
        this.delay = d;
        this.id = n2;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = MONITOR_FONT;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        if (!ToolTipWidget.empty(string3)) {
            this.setToolTip(new ToolTipWidget(this.parent, string3));
        }
    }

    public MonitorWidget(String string, String string2, Rectangle rectangle, int n, double d, boolean bl, boolean bl2, int n2, Interface interface_, int n3, int n4, StarLogo starLogo, String string3) {
        this(string, string2, rectangle, n, d, bl, bl2, n2, interface_, starLogo, string3);
        this.whichip = n3;
        this.onewhichip = n4;
    }

    public MonitorWidget(Interface interface_, StarLogo starLogo) {
        Dimension dimension = interface_.getSize();
        SmartRectangle smartRectangle = interface_.outline();
        if (smartRectangle.width < MONITOR_WIDTH) {
            smartRectangle.width = MONITOR_WIDTH;
        }
        if (smartRectangle.x + MONITOR_WIDTH > dimension.width) {
            smartRectangle.x = this.parent.getSize().width - MONITOR_WIDTH;
        }
        if (smartRectangle.y + MONITOR_HEIGHT > dimension.height) {
            smartRectangle.height = smartRectangle.height + smartRectangle.y - dimension.height + MONITOR_HEIGHT;
            smartRectangle.y = dimension.height - MONITOR_HEIGHT;
        }
        if (smartRectangle.height < MONITOR_HEIGHT) {
            smartRectangle.height = MONITOR_HEIGHT;
        }
        this.position = new Rectangle(smartRectangle);
        this.position.height = MONITOR_HEIGHT;
        this.id = idCount++;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = WidgetLite.WIDGET_FONT;
        this.showName = false;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
    }

    public MonitorWidget(Vector vector, int n, Interface interface_, StarLogo starLogo) {
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        String string = this.app.project.version;
        this.position = new Rectangle();
        this.position.x = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().x;
        this.position.y = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().y;
        this.position.width = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().x - this.position.x;
        this.position.height = MONITOR_HEIGHT;
        int n2 = ++n;
        this.name = vector.elementAt(n2).toString();
        int n3 = ++n;
        this.inst = vector.elementAt(n3).toString();
        int n4 = ++n;
        ++n;
        this.digits = new Integer(vector.elementAt(n4).toString());
        this.delay = string.equals(Project.MAC_VERSION) ? 0.5 : Double.valueOf(vector.elementAt(n++).toString());
        this.font = WidgetLite.WIDGET_FONT;
        this.id = new Integer(vector.elementAt(n++).toString());
        if (this.id >= idCount) {
            idCount = this.id + 1;
        }
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.updateMinSize();
    }

    public MonitorWidget(Interface interface_, StarLogo starLogo, boolean bl) {
        this.id = idCount++;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = WidgetLite.WIDGET_FONT;
        this.showName = false;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
    }

    static {
        try {
            MONITOR_FONT = WidgetLite.WIDGET_FONT;
            if (YoYo.macintoshp) {
                MONITOR_FONT = Font.getFont("starlogo.monitor.font", MONITOR_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

