/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import starlogo.Colors;
import starlogo.NShapeEditor;
import starlogo.NShapePaintSelect;
import starlogo.NShapePaintTool;

public class NShapeEditorPanel
extends Panel
implements ImageProducer,
MouseListener,
MouseMotionListener {
    static int GRAY = 0;
    static int WHITE = 0;
    public NShapePaintTool painttool;
    public NShapePaintSelect paintselect;
    NShapeEditor parent;
    int[] shapepixels;
    int[] panelpixels;
    int gridlength;
    int width;
    int height;
    int size;
    Image image;
    ImageConsumer ic;
    boolean startOfPoly = true;
    int polyHeadx;
    int polyHeady;
    private int mousedownx;
    private int mousedowny;
    private int mousedragx;
    private int mousedragy;

    public void init(int[] nArray, int n) {
        this.size = n;
        this.gridlength = 256 / n + 1;
        this.height = this.width = n * this.gridlength + 1;
        this.shapepixels = nArray;
        this.panelpixels = new int[this.width * this.height];
        this.setSize(this.width, this.height);
    }

    public void update(int[] nArray, int n) {
        this.init(nArray, n);
        this.removeConsumer(null);
        this.image = this.parent.createImage(this);
        this.drawGrid();
        this.refresh();
        this.parent.repaint();
    }

    public void refresh() {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                this.refreshSquare(n, n2);
                ++n2;
            }
            ++n;
        }
    }

    public void drawGrid() {
        int n;
        int n2 = 0;
        while (n2 < this.width) {
            n = 0;
            while (n < this.height) {
                this.panelpixels[n * this.width + n2] = GRAY;
                ++n;
            }
            n2 += this.gridlength;
        }
        n2 = 0;
        while (n2 < this.height) {
            n = 0;
            while (n < this.width) {
                this.panelpixels[n2 * this.width + n] = GRAY;
                ++n;
            }
            n2 += this.gridlength;
        }
    }

    public void colorSquare(int n, int n2, int n3) {
        int n4 = n * this.gridlength + 1;
        int n5 = n2 * this.gridlength + 1;
        int n6 = n5 * this.width + n4;
        int n7 = 0;
        while (n7 < this.gridlength - 1) {
            int n8 = 0;
            while (n8 < this.gridlength - 1) {
                this.panelpixels[n6 + n8 * this.width + n7] = n3;
                ++n8;
            }
            ++n7;
        }
    }

    public void colorSquareTurtleTransparent(int n, int n2) {
        int n3 = n * this.gridlength + 1;
        int n4 = n2 * this.gridlength + 1;
        int n5 = n4 * this.width + n3;
        int n6 = 0;
        boolean bl = false;
        while (n6 < this.gridlength - 1) {
            int n7 = 0;
            while (n7 < this.gridlength - 1) {
                this.panelpixels[n5 + n6 * this.width + n7] = GRAY;
                ++n7;
            }
            ++n6;
        }
    }

    public void colorSquarePatchTransparent(int n, int n2) {
        int n3 = n * this.gridlength + 1;
        int n4 = n2 * this.gridlength + 1;
        int n5 = n4 * this.width + n3;
        int n6 = WHITE;
        int n7 = 0;
        while (n7 < this.gridlength - 1) {
            int n8 = 0;
            while (n8 < this.gridlength - 1) {
                this.panelpixels[n5 + n8 * this.width + n7] = n6;
                n6 = n6 == WHITE ? GRAY : WHITE;
                ++n8;
            }
            n6 = n6 == WHITE ? GRAY : WHITE;
            ++n7;
        }
    }

    private final void refreshSquare(int n, int n2) {
        int n3;
        int n4;
        int n5 = 3 * (n2 * this.size + n);
        if ((n4 = this.shapepixels[n5++]) == -1) {
            this.colorSquareTurtleTransparent(n, n2);
            return;
        }
        if ((n3 = this.shapepixels[n5++]) == -1) {
            this.colorSquarePatchTransparent(n, n2);
            return;
        }
        int n6 = this.shapepixels[n5];
        int n7 = Colors.colorarrayints[(int)(32.0 * Colors.mapColorToStarLogoColor(n4 & this.parent.jsc.mainPanel.tcolmask | n3 & this.parent.jsc.mainPanel.pcolmask | n6))];
        this.colorSquare(n, n2, n7);
    }

    public void paintComponent(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.ic = null;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.panelpixels, 0, this.width);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    private final Point eventToPixel(MouseEvent mouseEvent) {
        return new Point(Math.min(this.size - 1, mouseEvent.getX() / this.gridlength), Math.min(this.size - 1, mouseEvent.getY() / this.gridlength));
    }

    private final void paintPixel(Point point) {
        int n = 3 * (point.y * this.size + point.x);
        if (this.paintselect.patch) {
            this.shapepixels[n] = 0;
            this.shapepixels[n + 1] = -1;
            this.shapepixels[n + 2] = 0;
            this.colorSquarePatchTransparent(point.x, point.y);
        } else if (this.paintselect.turtle) {
            this.shapepixels[n] = -1;
            this.shapepixels[n + 1] = 0;
            this.shapepixels[n + 2] = 0;
            this.colorSquareTurtleTransparent(point.x, point.y);
        } else {
            this.shapepixels[n] = 0;
            this.shapepixels[n + 1] = 0;
            this.shapepixels[n + 2] = this.parent.colortool.getColorInt();
            this.colorSquare(point.x, point.y, this.parent.colortool.getColorInt());
        }
    }

    private final void clearPixel(Point point) {
        int n = 3 * (point.y * this.size + point.x);
        this.shapepixels[n] = 0;
        this.shapepixels[n + 1] = -1;
        this.shapepixels[n + 2] = 0;
        this.colorSquarePatchTransparent(point.x, point.y);
    }

    private final void yoinkPixel(Point point) {
        int n = 3 * (point.y * this.size + point.x);
        if (this.shapepixels[n++] == -1) {
            this.paintselect.mouseClicked(new MouseEvent(this.paintselect, -1, 0L, 0, 31, 3, 0, false));
        } else if (this.shapepixels[n++] == -1) {
            this.paintselect.mouseClicked(new MouseEvent(this.paintselect, -1, 0L, 0, 6, 4, 0, false));
        } else {
            this.paintselect.deselect();
            this.parent.colortool.setColor((int)Colors.mapColorToStarLogoColor(this.shapepixels[n]));
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (imageConsumer == null) {
            return;
        }
        if (this.ic == null) {
            this.ic = imageConsumer;
            imageConsumer.setColorModel(Colors.cm);
            imageConsumer.setDimensions(this.width, this.height);
        }
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.panelpixels, 0, this.width);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        switch (NShapePaintTool.buttonDown) {
            case 0: {
                return;
            }
            case 1: {
                this.paintPixel(this.eventToPixel(mouseEvent));
                break;
            }
            case 2: {
                this.clearPixel(this.eventToPixel(mouseEvent));
                break;
            }
            case 4: {
                this.yoinkPixel(this.eventToPixel(mouseEvent));
            }
            default: {
                return;
            }
        }
        this.update(this.shapepixels, this.size);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (NShapePaintTool.buttonDown) {
            case 5: {
                this.rectangleMouseDragged(this.eventToPixel(mouseEvent));
                break;
            }
        }
        this.update(this.shapepixels, this.size);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        switch (NShapePaintTool.buttonDown) {
            case 0: {
                return;
            }
            case 1: 
            case 2: 
            case 4: {
                this.mouseClicked(mouseEvent);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.shapeMousePressed(this.eventToPixel(mouseEvent));
                break;
            }
            case 9: {
                this.polygonMousePressed(this.eventToPixel(mouseEvent));
                break;
            }
            case 10: {
                this.fillArea(this.eventToPixel(mouseEvent));
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (NShapePaintTool.buttonDown) {
            case 3: {
                this.lineMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 5: {
                this.rectangleMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 6: {
                this.fillRectangleMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 7: {
                this.ovalMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 8: {
                this.fillOvalMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
            case 9: {
                this.polygonMouseReleased(this.eventToPixel(mouseEvent));
                break;
            }
        }
        this.update(this.shapepixels, this.size);
    }

    void shapeMousePressed(Point point) {
        this.mousedownx = point.x;
        this.mousedowny = point.y;
    }

    void lineMouseDragged(Point point) {
    }

    void lineMouseReleased(Point point) {
        Point[] pointArray = this.patchesInLine(this.mousedownx, this.mousedowny, point.x, point.y);
        int n = 0;
        while (n < pointArray.length) {
            if (pointArray[n] == null) {
                return;
            }
            this.paintPixel(pointArray[n]);
            ++n;
        }
    }

    private final Point[] patchesInLine(int n, int n2, int n3, int n4) {
        int n5 = n < n3 ? n3 - n : n - n3;
        int n6 = n2 < n4 ? n4 - n2 : n2 - n4;
        Point[] pointArray = new Point[2 * (n5 + n6) + 1];
        int n7 = 0;
        if (n5 > n6) {
            if (n < n3) {
                int n8 = n;
                while (n8 <= n3) {
                    int n9 = (n4 - n2) * (n8 - n) / n5 + n2;
                    pointArray[n7++] = new Point(n8, n9);
                    ++n8;
                }
            } else if (n > n3) {
                int n10 = n3;
                while (n10 <= n) {
                    int n11 = (n4 - n2) * (n10 - n) / (n3 - n) + n2;
                    pointArray[n7++] = new Point(n10, n11);
                    ++n10;
                }
            }
        } else if (n2 < n4) {
            int n12 = n2;
            while (n12 <= n4) {
                int n13 = (n3 - n) * (n12 - n2) / n6 + n;
                pointArray[n7++] = new Point(n13, n12);
                ++n12;
            }
        } else if (n2 > n4) {
            int n14 = n4;
            while (n14 <= n2) {
                int n15 = (n3 - n) * (n14 - n2) / (n4 - n2) + n;
                pointArray[n7++] = new Point(n15, n14);
                ++n14;
            }
        } else {
            pointArray[n7++] = new Point(this.mousedownx, this.mousedowny);
        }
        return pointArray;
    }

    void rectangleMouseDragged(Point point) {
    }

    void rectangleMouseReleased(Point point) {
        int n = Math.min(this.mousedownx, point.x);
        int n2 = Math.min(this.mousedowny, point.y);
        int n3 = Math.max(this.mousedownx, point.x);
        int n4 = Math.max(this.mousedowny, point.y);
        int n5 = n;
        while (n5 <= n3) {
            this.paintPixel(new Point(n5, n2));
            ++n5;
        }
        n5 = n;
        while (n5 <= n3) {
            this.paintPixel(new Point(n5, n4));
            ++n5;
        }
        n5 = n2;
        while (n5 <= n4) {
            this.paintPixel(new Point(n, n5));
            ++n5;
        }
        n5 = n2;
        while (n5 <= n4) {
            this.paintPixel(new Point(n3, n5));
            ++n5;
        }
    }

    void fillRectangleMouseDragged(Point point) {
    }

    void fillRectangleMouseReleased(Point point) {
        int n = Math.min(this.mousedownx, point.x);
        int n2 = Math.min(this.mousedowny, point.y);
        int n3 = Math.max(this.mousedownx, point.x);
        int n4 = Math.max(this.mousedowny, point.y);
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                this.paintPixel(new Point(n5, n6));
                ++n6;
            }
            ++n5;
        }
    }

    void ovalMouseDragged(Point point) {
    }

    void ovalMouseReleased(Point point) {
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.size) {
            point.x = this.size - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.size) {
            point.y = this.size - 1;
        }
        this.paintPatchesOval(this.mousedownx, this.mousedowny, point.x, point.y, 0);
    }

    void fillOvalMouseDragged(Point point) {
    }

    void fillOvalMouseReleased(Point point) {
        if (point.x < 0) {
            point.x = 0;
        } else if (point.x >= this.size) {
            point.x = this.size - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        } else if (point.y >= this.size) {
            point.y = this.size - 1;
        }
        this.paintPatchesOval(this.mousedownx, this.mousedowny, point.x, point.y, 1);
    }

    private final void paintPatchesOval(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (n > n3) {
            n7 = n;
            n = n3;
            n3 = n7;
        }
        if (n2 > n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        n7 = n3 - n;
        n6 = n4 - n2;
        if (n7 < 2) {
            this.paintBlock(n, n2, n3, n4);
            return;
        }
        if (n6 < 2) {
            this.paintBlock(n, n2, n3, n4);
            return;
        }
        int n8 = n + n3 + 1;
        int n9 = n2 + n4 + 1;
        int n10 = n6 * n6;
        int n11 = n7 * n7;
        int n12 = n8 % 2 == 0 ? 1 : 0;
        int n13 = (int)Math.sqrt((double)n10 * (1.0 - (double)(n12 * n12) / (double)n11));
        while ((double)(n6 * n12) / ((double)n11 * Math.sqrt(1.0 - (double)(n12 * n12) / (double)n11)) < 1.0 && n13 >= 0) {
            this.paintPointInOval(n8, n9, n12, n13, n5);
            n13 = (int)Math.sqrt((double)n10 * (1.0 - (double)((n12 += 2) * n12) / (double)n11));
        }
        this.paintPointInOval(n8, n9, n12, n13, n5);
        n13 = n9 % 2 == 0 ? 1 : 0;
        n12 = (int)Math.sqrt((double)n11 * (1.0 - (double)(n13 * n13) / (double)n10));
        while ((double)(n7 * n13) / ((double)n10 * Math.sqrt(1.0 - (double)(n13 * n13) / (double)n10)) < 1.0 && n12 >= 0) {
            this.paintPointInOval(n8, n9, n12, n13, n5);
            n12 = (int)Math.sqrt((double)n11 * (1.0 - (double)((n13 += 2) * n13) / (double)n10));
        }
    }

    private final void paintBlock(int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                this.paintPixel(new Point(n5, n6));
                ++n6;
            }
            ++n5;
        }
    }

    void paintPointInOval(int n, int n2, int n3, int n4, int n5) {
        int n6 = (n + n3) / 2;
        int n7 = (n2 + n4) / 2;
        int n8 = (n - n3 - 1) / 2;
        int n9 = (n2 - n4 - 1) / 2;
        if (n5 == 1) {
            int n10 = n8;
            while (n10 <= n6) {
                this.paintPixel(new Point(n10, n9));
                this.paintPixel(new Point(n10, n7));
                ++n10;
            }
        } else {
            this.paintPixel(new Point(n8, n9));
            this.paintPixel(new Point(n6, n9));
            this.paintPixel(new Point(n8, n7));
            this.paintPixel(new Point(n6, n7));
        }
    }

    void polygonMousePressed(Point point) {
        if (this.startOfPoly) {
            this.mousedownx = point.x;
            this.mousedowny = point.y;
            this.mousedragx = this.mousedownx;
            this.mousedragy = this.mousedowny;
            this.paintPixel(point);
            this.startOfPoly = false;
            this.polyHeadx = point.x;
            this.polyHeady = point.y;
            return;
        }
        this.mousedragx = point.x;
        this.mousedragy = point.y;
        Point[] pointArray = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n = 0;
        while (n < pointArray.length) {
            if (pointArray[n] == null) break;
            this.paintPixel(pointArray[n]);
            ++n;
        }
        this.mousedownx = this.mousedragx;
        this.mousedowny = this.mousedragy;
        if (point.x == this.polyHeadx && point.y == this.polyHeady) {
            this.startOfPoly = true;
        }
    }

    void polygonMouseReleased(Point point) {
        if (NShapePaintTool.buttonDown == 9) {
            return;
        }
        Point[] pointArray = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n = 0;
        while (n < pointArray.length) {
            if (pointArray[n] == null) break;
            this.paintPixel(pointArray[n]);
            ++n;
        }
        this.startOfPoly = true;
    }

    void fillArea(Point point) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public NShapeEditorPanel(NShapeEditor nShapeEditor, int[] nArray, int n) {
        this.parent = nShapeEditor;
        this.init(nArray, n);
        this.image = nShapeEditor.createImage(this);
        this.drawGrid();
        this.refresh();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    static {
        try {
            GRAY = Colors.colorarrayints[160];
            WHITE = Colors.colorarrayints[288];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

