/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Hashtable;
import starlogo.Application;
import starlogo.Colors;
import starlogo.NEntityMonitor;
import starlogo.NSLCommand;
import starlogo.NSLMenu;
import starlogo.StackProcessParent;
import starlogo.Turtle;
import starlogo.TurtleMonitor;
import starlogo.VM;
import starlogo.WindowPosition;
import yoyo.YoYo;

public class NTurtleMonitor
extends NEntityMonitor
implements TurtleMonitor {
    static Hashtable tmhash = new Hashtable();
    public static final int XCOR = 1;
    public static final int YCOR = 2;
    public static final int HEADING = 3;
    public static final int BREED = 4;
    public static final int SHAPE = 5;
    public static final int COLOR = 6;
    public static final int GRABBED = 7;
    public static final int OWN = 8;
    static int numVars;
    Turtle tur;
    int who;
    String brname;
    CardLayout cl;
    Label who_lbl = new Label("Who");
    Label who_txt;
    Label grabbed_lbl = new Label("Grabbed?");
    Label grabbed_txt = new Label("false");
    VM grabbedval = null;
    Label breed_lbl = new Label("Breed");
    TextField breed_txt = new TextField();
    double breedval;
    Label shape_lbl = new Label("Shape");
    TextField shape_txt = new TextField();
    double shapeval;
    Label color_lbl = new Label("Color");
    TextField color_txt = new TextField();
    double colorval;
    Label xcor_lbl = new Label("Xcor");
    TextField xcor_txt = new TextField();
    double xcorval;
    Label ycor_lbl = new Label("Ycor");
    TextField ycor_txt = new TextField();
    double ycorval;
    Label heading_lbl = new Label("Heading");
    TextField heading_txt = new TextField();
    double headingval;

    public int getNumVars() {
        return numVars;
    }

    void setStateFields(Dimension dimension) {
        this.who_txt = new Label(Integer.toString(this.tur.who));
        this.grabbedval = this.tur.grabber;
        this.grabbed_txt = new Label(this.grabbedval == null ? "false" : this.grabbedval.niceToString());
        this.grabbed_lbl.setText(this.grabbedval == null ? "Grabbed?" : "Grabbed By");
        this.who_txt.setSize(dimension);
        this.grabbed_txt.setSize(dimension);
        this.breed_txt.setSize(dimension);
        this.shape_txt.setSize(dimension);
        this.color_txt.setSize(dimension);
        this.xcor_txt.setSize(dimension);
        this.ycor_txt.setSize(dimension);
        this.heading_txt.setSize(dimension);
        this.who_lbl.setSize(dimension);
        this.grabbed_lbl.setSize(dimension);
        this.breed_lbl.setSize(dimension);
        this.shape_lbl.setSize(dimension);
        this.color_lbl.setSize(dimension);
        this.xcor_lbl.setSize(dimension);
        this.ycor_lbl.setSize(dimension);
        this.heading_lbl.setSize(dimension);
        this.formatText(this.xcor_txt);
        this.formatText(this.ycor_txt);
        this.formatText(this.heading_txt);
        this.formatText(this.breed_txt);
        this.formatText(this.color_txt);
        this.formatText(this.shape_txt);
        this.who_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.grabbed_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.xcor_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.ycor_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.color_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.heading_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.breed_lbl.setFont(NEntityMonitor.LABEL_FONT);
        this.shape_lbl.setFont(NEntityMonitor.LABEL_FONT);
    }

    public String getVarName(int n) {
        return Turtle.getVarName(n);
    }

    public int getVarPos(int n) {
        return Turtle.getVarPos(n);
    }

    public Object getVarValue(int n) {
        return this.tur.turtlesown[n];
    }

    public boolean getVarEnump(int n) {
        return Turtle.getVarEnump(n);
    }

    public synchronized void setValues(int n) {
        switch (n) {
            case 1: {
                this.xcorval = this.tur.xcor;
                this.xcor_txt.setText(this.doubString(this.xcorval - this.sl.turhalfwidth));
                this.xcor_txt.setCaretPosition(this.xcor_txt.getText().length());
                break;
            }
            case 2: {
                this.ycorval = this.tur.ycor;
                this.ycor_txt.setText(this.doubString(this.sl.turhalfheight - this.ycorval));
                this.ycor_txt.setCaretPosition(this.ycor_txt.getText().length());
                break;
            }
            case 3: {
                this.headingval = this.tur.heading;
                this.heading_txt.setText(this.doubString(this.headingval));
                this.heading_txt.setCaretPosition(this.heading_txt.getText().length());
                break;
            }
            case 4: {
                this.breedval = this.tur.breed;
                this.breed_txt.setText(this.breedString(this.breedval));
                this.breed_txt.setCaretPosition(this.breed_txt.getText().length());
                break;
            }
            case 5: {
                this.shapeval = this.tur.shape;
                this.shape_txt.setText(this.doubString(this.shapeval));
                this.shape_txt.setCaretPosition(this.shape_txt.getText().length());
                break;
            }
            case 6: {
                this.colorval = this.tur.color;
                this.color_txt.setText(this.colname(this.colorval));
                this.color_txt.setCaretPosition(this.color_txt.getText().length());
                this.wholePanel.setBackground(Colors.colorarray[(int)(this.tur.color * 32.0)]);
                this.wholePanel.repaint();
                break;
            }
            case 7: {
                this.grabbedval = this.tur.grabber;
                this.grabbed_txt.setText(this.grabbedval == null ? "false" : this.grabbedval.niceToString());
                this.grabbed_lbl.setText(this.grabbedval == null ? "Grabbed?" : "Grabbed By");
                break;
            }
        }
    }

    String breedString(double d) {
        if (d - (double)((int)d) != 0.0) {
            return this.doubString(d);
        }
        int n = 0;
        while (n < Turtle.breednames.length) {
            if ((int)d == Turtle.breednums[n]) {
                return Turtle.breednames[n];
            }
            ++n;
        }
        return this.doubString(d);
    }

    public void initFrame() {
        if (this.tur == null || !this.tur.alive) {
            return;
        }
        if (YoYo.macintoshp) {
            this.slmenu = new NSLMenu(this, this.app);
            this.slmenu.setMenuBar(this);
        }
        numVars = Turtle.numVars;
        this.setFields();
        int n = 22;
        this.addMyComponents(n);
        this.com.callerClearText();
        if (YoYo.applet == null) {
            this.addListeners();
        }
        int n2 = 1;
        while (n2 <= 7) {
            this.setValues(n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < numVars) {
            this.setOwnInit(n2);
            ++n2;
        }
        this.startThread();
    }

    public Label[] getStateLabels() {
        Label[] labelArray = new Label[]{this.who_lbl, this.color_lbl, this.shape_lbl, this.xcor_lbl, this.ycor_lbl, this.heading_lbl, this.breed_lbl, this.grabbed_lbl};
        return labelArray;
    }

    public Component[] getStateTexts() {
        Component[] componentArray = new Component[]{this.who_txt, this.color_txt, this.shape_txt, this.xcor_txt, this.ycor_txt, this.heading_txt, this.breed_txt, this.grabbed_txt};
        return componentArray;
    }

    public int getNumStateVariables() {
        return 8;
    }

    void addMyComponents(int n) {
        super.addMyComponents(n, "turtle");
        Label label = new Label("This turtle is dead");
        label.setBackground(Color.black);
        label.setForeground(Color.white);
        label.setFont(NEntityMonitor.LABEL_FONT);
        this.cl = new CardLayout();
        this.wholePanel.setLayout(this.cl);
        this.wholePanel.add((Component)label, "dead");
        this.wholePanel.add((Component)this.wholeBox, "alive");
        this.cl.show(this.wholePanel, "alive");
        this.add(this.wholePanel);
        this.addNotify();
        this.pack();
        this.who_txt.requestFocus();
    }

    public double getEntityColor() {
        return this.tur.color;
    }

    public static void updateOpen() {
        boolean bl = numVars > 0;
        numVars = Turtle.numVars;
        Enumeration enumeration = tmhash.elements();
        while (enumeration.hasMoreElements()) {
            NTurtleMonitor nTurtleMonitor;
            NTurtleMonitor nTurtleMonitor2 = nTurtleMonitor = (NTurtleMonitor)enumeration.nextElement();
            synchronized (nTurtleMonitor2) {
                if (nTurtleMonitor.tur != null && nTurtleMonitor.tur.alive) {
                    nTurtleMonitor.updateOwn(bl);
                }
            }
        }
    }

    void addListeners() {
        super.addListeners();
        this.who_txt.addFocusListener(this.tff);
        this.grabbed_txt.addFocusListener(this.tff);
        this.xcor_txt.addKeyListener(this.tka);
        this.xcor_txt.addFocusListener(this.tff);
        this.ycor_txt.addKeyListener(this.tka);
        this.ycor_txt.addFocusListener(this.tff);
        this.heading_txt.addKeyListener(this.tka);
        this.heading_txt.addFocusListener(this.tff);
        this.breed_txt.addKeyListener(this.tka);
        this.breed_txt.addFocusListener(this.tff);
        this.shape_txt.addKeyListener(this.tka);
        this.shape_txt.addFocusListener(this.tff);
        this.color_txt.addKeyListener(this.tka);
        this.color_txt.addFocusListener(this.tff);
    }

    public void die() {
        this.wholePanel.setBackground(Color.black);
        this.pack();
        this.repaint();
        this.cl.show(this.wholePanel, "dead");
    }

    public static void flushCommandCenters() {
        Enumeration enumeration = tmhash.elements();
        while (enumeration.hasMoreElements()) {
            NTurtleMonitor nTurtleMonitor = (NTurtleMonitor)enumeration.nextElement();
            nTurtleMonitor.com.flush();
        }
    }

    public static void setTurtle(Turtle turtle) {
        NTurtleMonitor nTurtleMonitor = (NTurtleMonitor)tmhash.get(turtle);
        if (nTurtleMonitor != null) {
            int n;
            nTurtleMonitor.tur = turtle;
            turtle.hasTMp = true;
            turtle.tm = nTurtleMonitor;
            NTurtleMonitor nTurtleMonitor2 = nTurtleMonitor;
            synchronized (nTurtleMonitor2) {
                n = nTurtleMonitor.middlePane == null ? 0 : (numVars <= 0 ? 0 : 1);
                nTurtleMonitor.updateOwn(n != 0);
            }
            nTurtleMonitor.cl.show(nTurtleMonitor.wholePanel, "alive");
            nTurtleMonitor.com.callerClearText();
            n = 1;
            while (n <= 7) {
                nTurtleMonitor.setValues(n);
                ++n;
            }
            n = 0;
            while (n < numVars) {
                nTurtleMonitor.setOwnInit(n);
                ++n;
            }
            nTurtleMonitor.startThread();
            nTurtleMonitor.show();
        }
    }

    public void closeMonitor() {
        if (this.tur != null) {
            this.tur.hasTMp = false;
            this.tur.tm = null;
            tmhash.remove(this.tur);
            this.tur = null;
            WindowPosition.closed(this);
        }
    }

    public void run() {
        while (this.tur != null && this.tur.alive && !this.closep) {
            NTurtleMonitor nTurtleMonitor = this;
            synchronized (nTurtleMonitor) {
                if (this.tur != null && this.breedval != this.tur.breed && (this.breed_txt != this.focus || this.app.activeFrame != this)) {
                    this.setValues(4);
                }
                if (this.tur != null && this.colorval != this.tur.color && (this.color_txt != this.focus || this.app.activeFrame != this)) {
                    this.setValues(6);
                }
                if (this.tur != null && this.shapeval != (double)this.tur.shape && (this.shape_txt != this.focus || this.app.activeFrame != this)) {
                    this.setValues(5);
                }
                if (this.tur != null && this.xcorval != this.tur.xcor && (this.xcor_txt != this.focus || this.app.activeFrame != this)) {
                    this.setValues(1);
                }
                if (this.tur != null && this.ycorval != this.tur.ycor && (this.ycor_txt != this.focus || this.app.activeFrame != this)) {
                    this.setValues(2);
                }
                if (this.tur != null && this.headingval != this.tur.heading && (this.heading_txt != this.focus || this.app.activeFrame != this)) {
                    this.setValues(3);
                }
                if (this.tur != null && this.grabbedval != this.tur.grabber) {
                    this.setValues(7);
                }
                try {
                    int n = 0;
                    while (n < this.getNumVars()) {
                        if (!(this.tur == null || this.tur.turtlesown.length <= n || this.ownval.length <= n || this.tur.turtlesown[n].equals(this.ownval[n]) || this.own_txt[n] == this.focus && this.app.activeFrame == this)) {
                            this.setOwnInit(n);
                        }
                        ++n;
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep((long)(this.delay * 1000.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    String getCommand(String string, String string2) {
        if (string.equals(this.xcor_txt.getName())) {
            this.lastField = 1;
            return "setx " + string2;
        }
        if (string.equals(this.ycor_txt.getName())) {
            this.lastField = 2;
            return "sety " + string2;
        }
        if (string.equals(this.heading_txt.getName())) {
            this.lastField = 3;
            return "setheading " + string2;
        }
        if (string.equals(this.shape_txt.getName())) {
            this.lastField = 5;
            return "setshape " + string2;
        }
        if (string.equals(this.color_txt.getName())) {
            this.lastField = 6;
            return "setcolor " + string2;
        }
        if (string.equals(this.breed_txt.getName())) {
            this.lastField = 4;
            return "setbreed " + string2;
        }
        int n = 0;
        while (n < numVars) {
            if (string.equals(this.own_txt[n].getName())) {
                this.lastField = n;
                this.lastOwn = true;
                return "set" + this.own_lbl[n].getText() + " " + string2;
            }
            ++n;
        }
        return "internal nturtlemonitor error";
    }

    public String getCompileCommand(String string) {
        return "compile-turtle-monitor [" + string + "]";
    }

    public void runCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = this.castToIntArray(objectArray);
        if (this.sl.locked) {
            this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
        } else {
            Object object = this.sl.runningp;
            synchronized (object) {
                int n = this.sl.internalSetInstructions("turtle-monitor: " + this.who_txt.getText(), nArray, objectArray2);
                StackProcessParent.runTurtle(this.sl, n, this.tur, false, this);
            }
        }
    }

    public void displayOneString(String string) {
        super.displayOneString(string);
        if (!this.breed_txt.getText().equals(this.breedString(this.breedval))) {
            this.setValues(4);
            this.breed_txt.selectAll();
        }
        if (!this.color_txt.getText().equals(this.colname(this.colorval))) {
            this.setValues(6);
            this.color_txt.selectAll();
        }
        if (!this.shape_txt.getText().equals(this.doubString(this.shapeval))) {
            this.setValues(5);
            this.shape_txt.selectAll();
        }
        if (!this.xcor_txt.getText().equals(this.doubString(this.xcorval - this.sl.turhalfwidth))) {
            this.setValues(1);
            this.xcor_txt.selectAll();
        }
        if (!this.ycor_txt.getText().equals(this.doubString(this.sl.turhalfheight - this.ycorval))) {
            this.setValues(2);
            this.ycor_txt.selectAll();
        }
        if (!this.heading_txt.getText().equals(this.doubString(this.headingval))) {
            this.setValues(3);
            this.heading_txt.selectAll();
        }
        int n = 0;
        while (n < numVars) {
            this.setOwn(n);
            ++n;
        }
    }

    public void displayAString(String string) {
        super.displayAString(string);
        if (!this.breed_txt.getText().equals(this.breedString(this.breedval))) {
            this.setValues(4);
        }
        if (!this.color_txt.getText().equals(this.colname(this.colorval))) {
            this.setValues(6);
        }
        if (!this.shape_txt.getText().equals(this.doubString(this.shapeval))) {
            this.setValues(5);
        }
        if (!this.xcor_txt.getText().equals(this.doubString(this.xcorval - this.sl.turhalfwidth))) {
            this.setValues(1);
        }
        if (!this.ycor_txt.getText().equals(this.doubString(this.sl.turhalfheight - this.ycorval))) {
            this.setValues(2);
        }
        if (!this.heading_txt.getText().equals(this.doubString(this.headingval))) {
            this.setValues(3);
        }
        int n = 0;
        while (n < numVars) {
            this.setOwn(n);
            ++n;
        }
    }

    public NTurtleMonitor(Turtle turtle, double d, Application application) {
        super("Turtle # " + turtle.who, d, application);
        this.tur = turtle;
        this.com = new NSLCommand(0, this.sl, turtle.who, application);
        this.who = turtle.who;
        numVars = Turtle.numVars;
        tmhash.put(turtle, this);
    }
}

