/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Graphics;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import starlogo.Interface;
import starlogo.Patch;
import starlogo.PatchCanvas;
import starlogo.StarLogo;
import starlogo.Turtle;

public class NetworkPatchCanvas
extends PatchCanvas {
    static int numsent = 0;
    Socket socket;
    OutputStream out;
    byte[] bytes = new byte[600];
    int ptr = 0;

    public void setClientSocket(Socket socket) {
        this.socket = socket;
        try {
            this.out = new BufferedOutputStream(socket.getOutputStream(), 4096);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void init(Interface interface_) {
        this.parent = interface_;
        this.image = interface_.createImage(this.position.width, this.position.height);
        this.xoffset = this.position.x;
        this.yoffset = this.position.y;
        this.updateImage();
    }

    public void updateGraphics(Graphics graphics) {
        int n = this.sl.cellsize;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.sl.widthp2;
        while (n2 < this.sl.height) {
            int n5 = n4 + 1;
            int n6 = 0;
            int n7 = 0;
            while (n6 < this.sl.width) {
                Patch patch = this.sl.patches[n5++];
                if (patch.topturtle != null) {
                    this.addToPacket(n6, n2, (int)patch.topturtle.color);
                } else {
                    this.addToPacket(n6, n2, (int)patch.pc);
                }
                ++n6;
                n7 += n;
            }
            ++n2;
            n3 += n;
            n4 += this.sl.widthp2;
        }
    }

    void drawPatch(double d, double d2, double d3) {
        this.drawPatch(d, d2, d3, this.sl.patches);
    }

    void drawPatch(double d, double d2, double d3, Patch[] patchArray) {
        if (!this.displayp) {
            return;
        }
        int n = this.sl.cellsize;
        int n2 = (int)d;
        int n3 = (int)d2;
        if (!this.sl.offscreen) {
            this.uptodate = false;
        }
        this.addToPacket(n2, n3, (int)d3);
    }

    void drawPatch(Patch patch) {
        this.drawPatch(patch, this.sl.patches);
    }

    void drawPatch(Patch patch, Patch[] patchArray) {
        if (!this.displayp) {
            return;
        }
        int n = this.sl.cellsize;
        int n2 = (int)patch.xcor - 1;
        int n3 = (int)patch.ycor - 1;
        if (!this.sl.offscreen) {
            this.uptodate = false;
        }
        this.addToPacket(n2, n3, (int)patch.pc);
    }

    void drawTurtle(Turtle turtle) {
        this.drawTurtle(turtle, this.sl.patches);
    }

    void drawTurtle(Turtle turtle, Patch[] patchArray) {
        if (!this.displayp) {
            return;
        }
        int n = this.sl.cellsize;
        int n2 = (int)turtle.xcor;
        int n3 = (int)turtle.ycor;
        if (!this.sl.offscreen) {
            this.uptodate = false;
        }
        this.addToPacket(n2, n3, (int)turtle.color);
    }

    public void clearImage() {
        super.clearImage();
    }

    synchronized void addToPacket(int n, int n2, int n3) {
        this.bytes[this.ptr] = (byte)n;
        this.bytes[this.ptr + 1] = (byte)n2;
        this.bytes[this.ptr + 2] = (byte)n3;
        this.ptr += 3;
        if (this.ptr < 600) {
            return;
        }
        this.sendpacket(this.bytes);
        this.ptr = 0;
    }

    public void sendpacket(byte[] byArray) {
        if (this.socket == null) {
            return;
        }
        try {
            if (numsent > 2) {
                this.waitForAck();
            }
            NetworkPatchCanvas.writeInt(byArray.length, this.out);
            this.out.write(byArray);
            this.out.flush();
            ++numsent;
        }
        catch (IOException iOException) {
            this.socket = null;
            this.out = null;
            iOException.printStackTrace();
        }
    }

    public void waitForAck() throws IOException {
        InputStream inputStream = this.socket.getInputStream();
        inputStream.read();
    }

    public static void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 24 & 0xFF));
        outputStream.write((byte)(n >> 16 & 0xFF));
        outputStream.write((byte)(n >> 8 & 0xFF));
        outputStream.write((byte)(n & 0xFF));
    }

    public NetworkPatchCanvas(StarLogo starLogo, Socket socket) {
        super(starLogo);
        this.setClientSocket(socket);
    }

    public NetworkPatchCanvas(StarLogo starLogo, PatchCanvas patchCanvas) {
        super(starLogo, patchCanvas);
        if (patchCanvas instanceof NetworkPatchCanvas) {
            NetworkPatchCanvas networkPatchCanvas = (NetworkPatchCanvas)patchCanvas;
            if (networkPatchCanvas.socket != null) {
                this.socket = networkPatchCanvas.socket;
                this.out = networkPatchCanvas.out;
            }
        }
    }
}

