/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import starlogo.Application;
import starlogo.Colors;
import starlogo.GifEncoder;
import starlogo.ImageWaiter;
import starlogo.MessageDialog;
import starlogo.NSLDialog;
import starlogo.Patch;
import starlogo.PatchCanvas;
import starlogo.Pictures;
import starlogo.Project;
import starlogo.SLURL;
import starlogo.StarLogo;
import starlogo.StarLogoError;
import yoyo.YoYo;

public class NonQTPictures
extends Pictures {
    public MessageDialog busyLoadingDialog;

    public SLURL getLoadFileName(StarLogo starLogo) {
        FileDialog fileDialog = new FileDialog((Frame)((Object)starLogo.app.activeFrame), YoYo.language == 1 ? "Carge Imagen..." : "Load Picture...", 0);
        Project cfr_ignored_0 = starLogo.app.project;
        if (Project.curDir != null) {
            Project cfr_ignored_1 = starLogo.app.project;
            fileDialog.setDirectory(Project.curDir.getPath());
        }
        fileDialog.setFilenameFilter(starLogo.app.pictureFileFilter);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        Project cfr_ignored_2 = starLogo.app.project;
        Project.curDir = new SLURL(3, string);
        if (fileDialog.getFile() != null) {
            Project cfr_ignored_3 = starLogo.app.project;
            SLURL sLURL = new SLURL(3, Project.curDir.getPath(), fileDialog.getFile());
            return sLURL;
        }
        return null;
    }

    public void loadPictureInternal(StarLogo starLogo, SLURL sLURL) {
        Image image = this.getImage(starLogo, sLURL);
        int n = ImageWaiter.getValue(image, 1);
        int n2 = ImageWaiter.getValue(image, 2);
        if (n < 1 || n2 < 1) {
            StarLogoError.error(starLogo.app, "Error loading image " + sLURL, true);
        }
        this.loadPictureInternal(starLogo, image, n, n2);
    }

    public Image getImage(StarLogo starLogo, SLURL sLURL) {
        byte[] byArray = sLURL.loadBinary(starLogo.c);
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }

    public void loadPictureInternal(StarLogo starLogo, Image image, int n, int n2) {
        PatchCanvas cfr_ignored_0 = starLogo.patchcanvas;
        PatchCanvas.readImage(starLogo, image.getSource(), n, n2, this);
    }

    public void savePicture(StarLogo starLogo) {
        ImageDialog imageDialog = new ImageDialog(starLogo);
        if (!imageDialog.canceled) {
            this.savePicture(starLogo, imageDialog.getImage());
        }
        imageDialog.dispose();
    }

    public void savePicture(StarLogo starLogo, String string) {
        ImageDialog imageDialog = new ImageDialog(starLogo);
        if (!imageDialog.canceled) {
            this.savePicture(starLogo, string, imageDialog.getImage());
        }
        imageDialog.dispose();
    }

    public void VMsavePicture(StarLogo starLogo) {
        ImageDialog imageDialog = new ImageDialog(starLogo);
        if (!imageDialog.canceled) {
            this.savePicture(starLogo, imageDialog.getImage());
        }
        imageDialog.dispose();
    }

    public void VMsavePicture(StarLogo starLogo, String string) {
        ImageDialog imageDialog = new ImageDialog(starLogo);
        if (!imageDialog.canceled) {
            this.savePicture(starLogo, string, imageDialog.getImage());
        }
        imageDialog.dispose();
    }

    public void savePicture(StarLogo starLogo, Image image) {
        String string = this.getSaveFileName(starLogo);
        if (string != null && !string.equals("")) {
            this.savePicture(starLogo, string, image);
        }
    }

    public void savePicture(StarLogo starLogo, String string, Image image) {
        Object object;
        Object object2;
        if (!YoYo.macintoshp && !string.toLowerCase().endsWith(".gif") && ((File)(object2 = new File(string = string + ".gif"))).exists()) {
            object = Application.createMessageDialog((Frame)((Object)starLogo.app.activeFrame), "Warning -- File Already Exists", "Warning the file: " + string + "\n" + "already exists. Continuing will overwrite this file", true, true, true, false, 1);
            object.show();
            if (object.canceled()) {
                object.dispose();
                return;
            }
            object.dispose();
        }
        object2 = null;
        object = null;
        try {
            object = new File(string);
            object2 = new BufferedOutputStream(new FileOutputStream((File)object));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            Application.createMessageDialog((Frame)((Object)starLogo.app.activeFrame), "StarLogo Message", "Error opening or creating image file: " + string + "\n" + exception.getMessage(), false);
        }
        int n = -1;
        int n2 = -1;
        if (image != null) {
            n = ImageWaiter.getValue(image, 1);
            n2 = ImageWaiter.getValue(image, 2);
        }
        if (image == null || n == -1 || n2 == -1) {
            Application.createMessageDialog((Frame)((Object)starLogo.app.activeFrame), "StarLogo Message", "Error creating save image", false);
        }
        try {
            GifEncoder gifEncoder = new GifEncoder(image, (OutputStream)object2);
            gifEncoder.encodeStart(n, n2);
            gifEncoder.encode();
            ((OutputStream)object2).close();
            if (YoYo.macintoshp) {
                starLogo.app.macutils.setGifFileType((File)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            Application.createMessageDialog((Frame)((Object)starLogo.app.activeFrame), "StarLogo Message", "Error saving image to file: " + exception.getMessage(), false);
        }
    }

    public String getSaveFileName(StarLogo starLogo) {
        FileDialog fileDialog = new FileDialog((Frame)((Object)starLogo.app.activeFrame), "Save Picture...", 1);
        if (YoYo.language == 1) {
            fileDialog = new FileDialog((Frame)((Object)starLogo.app.activeFrame), "Guarde Imagen...", 1);
        }
        Project cfr_ignored_0 = starLogo.app.project;
        if (Project.curDir != null) {
            Project cfr_ignored_1 = starLogo.app.project;
            fileDialog.setDirectory(Project.curDir.getPath());
        }
        fileDialog.setFilenameFilter(starLogo.app.pictureFileFilter);
        fileDialog.show();
        Project cfr_ignored_2 = starLogo.app.project;
        Project.curDir = new SLURL(3, fileDialog.getDirectory());
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        fileDialog.dispose();
        if (string2 == null || string2 == "") {
            return string2;
        }
        return string + string2;
    }

    private class FileExistsDialog
    extends NSLDialog {
        public boolean canceled = false;
        public String filename;
        public Button bok = new Button("OK");
        public Button bca = new Button("Cancel");
        public Panel okcapanel;
        public Label messageLabel;

        public void setupComponents() {
            this.messageLabel = new Label("Warning the file:\n" + this.filename + "\n" + "Already exists, continuing will overwrite this file");
            this.okcapanel = new Panel(new GridLayout(1, 2, 4, 4));
            this.okcapanel.add(this.bok);
            this.okcapanel.add(this.bca);
            NSLDialog.formatLabel(this.bok);
            NSLDialog.formatLabel(this.bca);
            NSLDialog.formatLabel(this.messageLabel);
        }

        public void setupGBC() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(6, 13, 0, 0);
            this.add((Component)this.messageLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            this.add((Component)this.okcapanel, gridBagConstraints);
        }

        public void setupPosition() {
            ((Component)this).setSize(360, YoYo.solarisp ? 200 : (YoYo.linuxp ? 240 : (YoYo.pcp ? 200 : 170)));
            this.initLocation();
        }

        public void ok() {
            this.canceled = false;
            ((Component)this).setVisible(false);
        }

        public void cancel() {
            this.canceled = true;
            ((Component)this).setVisible(false);
        }

        public FileExistsDialog(StarLogo starLogo, String string) {
            super((Frame)((Object)starLogo.app.activeFrame), "Warning -- File Already Exists", true);
            this.filename = string;
            this.setupComponents();
            this.setupGBC();
            this.setupPosition();
            this.initOKCancel(this.bok, this.bca);
            this.initShortcuts();
            this.pack();
            this.show();
        }
    }

    private class ImageDialog
    extends NSLDialog {
        public StarLogo starlogo;
        public boolean canceled = false;
        public Image image;
        public Button bok = new Button("OK");
        public Button bca = new Button("Cancel");
        public CheckboxGroup imageSelectGroup;
        public Checkbox p;
        public Checkbox pt;
        public Checkbox all;
        public Panel okcapanel;
        public Panel imagepanel;
        public Label imageSelectLabel;

        public void createImage() {
            Graphics graphics;
            if (this.p.getState()) {
                this.image = this.starlogo.app.iface.createImage(this.starlogo.width, this.starlogo.height);
                graphics = this.image.getGraphics();
                int n = 0;
                int n2 = this.starlogo.widthp2;
                while (n < this.starlogo.height) {
                    int n3 = n2 + 1;
                    int n4 = 0;
                    while (n4 < this.starlogo.width) {
                        Patch patch = this.starlogo.patches[n3++];
                        graphics.setColor(Colors.colorarray[(int)(patch.pc * 32.0)]);
                        graphics.fillRect(n4, n, 1, 1);
                        ++n4;
                    }
                    ++n;
                    n2 += this.starlogo.widthp2;
                }
            }
            if (this.pt.getState()) {
                this.image = this.starlogo.patchcanvas.parent.createImage(this.starlogo.patchcanvas.position.width, this.starlogo.patchcanvas.position.height);
                graphics = this.image.getGraphics();
                this.starlogo.patchcanvas.updateGraphics(graphics);
                graphics.dispose();
            }
            if (this.all.getState()) {
                this.image = this.starlogo.app.iface.createImage(this.starlogo.app.iface.getSize().width, this.starlogo.app.iface.getSize().height);
                graphics = this.image.getGraphics();
                this.starlogo.app.iface.paint(graphics);
                graphics.dispose();
            }
        }

        public void setupComponents() {
            this.imageSelectLabel = new Label("Select Image to Save");
            this.imagepanel = new Panel(new GridLayout(4, 1, 4, 4));
            this.imageSelectGroup = new CheckboxGroup();
            this.p = new Checkbox("just patches", true, this.imageSelectGroup);
            this.pt = new Checkbox("patches and turtles", false, this.imageSelectGroup);
            this.all = new Checkbox("whole starlogo window", false, this.imageSelectGroup);
            if (YoYo.language == 1) {
                this.imageSelectLabel = new Label("Escoja Imagen para Guardar");
                this.imagepanel = new Panel(new GridLayout(4, 1, 4, 4));
                this.imageSelectGroup = new CheckboxGroup();
                this.p = new Checkbox("solo manchas", true, this.imageSelectGroup);
                this.pt = new Checkbox("manchas y tortugas", false, this.imageSelectGroup);
                this.all = new Checkbox("ventana de starlogo entera", false, this.imageSelectGroup);
            }
            this.imagepanel.add(this.imageSelectLabel);
            this.imagepanel.add(this.p);
            this.imagepanel.add(this.pt);
            this.imagepanel.add(this.all);
            this.okcapanel = new Panel(new GridLayout(1, 2, 4, 4));
            this.okcapanel.add(this.bok);
            this.okcapanel.add(this.bca);
            NSLDialog.formatLabel(this.bok);
            NSLDialog.formatLabel(this.bca);
            NSLDialog.formatLabel(this.imageSelectLabel);
        }

        public void setupGBC() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(6, 13, 0, 0);
            this.add((Component)this.imagepanel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.okcapanel, gridBagConstraints);
        }

        public void setupPosition() {
            ((Component)this).setSize(360, YoYo.solarisp ? 200 : (YoYo.linuxp ? 240 : (YoYo.pcp ? 200 : 170)));
            this.initLocation();
        }

        public void ok() {
            this.createImage();
            this.canceled = false;
            ((Component)this).setVisible(false);
        }

        public void cancel() {
            this.canceled = true;
            ((Component)this).setVisible(false);
        }

        public Image getImage() {
            return this.image;
        }

        public ImageDialog(StarLogo starLogo) {
            super((Frame)((Object)starLogo.app.activeFrame), "Save Picture", true);
            if (YoYo.language == 1) {
                this.setTitle("Guarde Imagen");
            }
            this.starlogo = starLogo;
            this.setupComponents();
            this.setupGBC();
            this.setupPosition();
            this.initOKCancel(this.bok, this.bca);
            this.initShortcuts();
            this.pack();
            this.show();
        }
    }
}

