/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import starlogo.Patch;
import starlogo.StarLogo;
import starlogo.Turtle;
import starlogo.Utilities;
import starlogo.VM;
import yoyo.Context;
import yoyo.YoYo;

public class Observer
extends VM
implements Serializable {
    public static Hashtable stateOffsetTable = Observer.initStateOffsets();
    static int numVars = 0;
    static String[] varnames;
    static boolean[] varenums;
    static int[] varposes;

    public static Observer restore(StarLogo starLogo, byte[] byArray, int n) {
        int n2 = 1;
        int n3 = 1;
        int n4 = Observer.getOffset("plotpen");
        if (n4 >= 0) {
            n2 = Utilities.readIntFromByteArray(byArray, n + n4);
        }
        if ((n4 = Observer.getOffset("plotwidget")) >= 0) {
            n3 = Utilities.readIntFromByteArray(byArray, n + n4);
        }
        Object[] objectArray = Observer.restoreVariables(byArray, n + Observer.getStateLength());
        return new Observer(n2, n3, objectArray, starLogo);
    }

    public void save(byte[] byArray, int n) {
        int n2 = Observer.getOffset("plotpen");
        if (n2 >= 0) {
            Utilities.writeIntoByteArray(this.plotpen, byArray, n + n2);
        }
        if ((n2 = Observer.getOffset("plotwidget")) >= 0) {
            Utilities.writeIntoByteArray(this.plotwidget, byArray, n + n2);
        }
        this.saveVariables(byArray, n + Observer.getStateLength());
    }

    public void saveVariables(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < numVars) {
            int n4 = Observer.getVarPos(n3);
            Object object = this.turtlesown[n4];
            int n5 = Utilities.addIntoTable(object, VM.sl);
            Utilities.writeIntoByteArray(n5, byArray, n + n2);
            n2 += 4;
            ++n3;
        }
    }

    public static Object[] restoreVariables(byte[] byArray, int n) {
        Object[] objectArray = new Object[numVars];
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Object object;
            int n4 = Utilities.readIntFromByteArray(byArray, n + n2);
            n2 += 4;
            objectArray[Observer.getVarPos((int)n3)] = object = Utilities.lookupInTable(n4);
            ++n3;
        }
        return objectArray;
    }

    public static Hashtable initStateOffsets() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("plotpen", new Integer(0));
        hashtable.put("plotwidget", new Integer(4));
        hashtable.put("statelength", new Integer(8));
        hashtable.put("length", new Integer(8));
        return hashtable;
    }

    public static int getLength() {
        return Observer.getOffset("length");
    }

    public static void setLength(Integer n) {
        stateOffsetTable.put("length", n);
    }

    public static int getStateLength() {
        return Observer.getOffset("statelength");
    }

    public static int getOffset(String string) {
        if (stateOffsetTable.containsKey(string)) {
            return (Integer)stateOffsetTable.get(string);
        }
        return -1000;
    }

    public static byte[] getStateDesc() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Enumeration enumeration = stateOffsetTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = (Integer)stateOffsetTable.get(string);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(n);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void setStateDesc(byte[] byArray) throws IOException {
        stateOffsetTable.clear();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        while (dataInputStream.available() > 0) {
            String string = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            stateOffsetTable.put(string, new Integer(n));
        }
        dataInputStream.close();
    }

    void diffuse(int n, double d) {
        double d2 = d / 8.0;
        int n2 = VM.sl.widthp2;
        int n3 = 1;
        while (n3 < VM.sl.height + 1) {
            int n4 = 1;
            while (n4 < VM.sl.width + 1) {
                double[] dArray = VM.sl.patches[n2 + n4].patchesowndoubles;
                double d3 = dArray[n];
                dArray[Patch.numVars] = d3 * d2;
                dArray[n] = d3 - d3 * d;
                ++n4;
            }
            n2 += VM.sl.widthp2;
            ++n3;
        }
        this.nsum(Patch.numVars, n, false);
    }

    void diffusePC(double d) {
        double d2 = d / 8.0;
        int n = VM.sl.widthp2;
        int n2 = 1;
        while (n2 < VM.sl.height + 1) {
            int n3 = 1;
            while (n3 < VM.sl.width + 1) {
                Patch patch = VM.sl.patches[n + n3];
                double[] dArray = patch.patchesowndoubles;
                double d3 = patch.pc;
                dArray[Patch.numVars] = d3 * d2;
                patch.pc = d3 - d3 * d;
                ++n3;
            }
            n += VM.sl.widthp2;
            ++n2;
        }
        this.nsumPC(Patch.numVars, false);
    }

    void diffuse4PC(double d) {
        double d2 = d / 4.0;
        int n = VM.sl.widthp2;
        int n2 = 1;
        while (n2 < VM.sl.height + 1) {
            int n3 = 1;
            while (n3 < VM.sl.width + 1) {
                Patch patch = VM.sl.patches[n + n3];
                double[] dArray = patch.patchesowndoubles;
                double d3 = patch.pc;
                dArray[Patch.numVars] = d3 * d2;
                patch.pc = d3 - d3 * d;
                ++n3;
            }
            n += VM.sl.widthp2;
            ++n2;
        }
        this.nsum4PC(Patch.numVars, false);
    }

    void diffuse4(int n, double d) {
        double d2 = d / 4.0;
        int n2 = VM.sl.widthp2;
        int n3 = 1;
        while (n3 < VM.sl.height + 1) {
            int n4 = 1;
            while (n4 < VM.sl.width + 1) {
                double[] dArray = VM.sl.patches[n2 + n4].patchesowndoubles;
                double d3 = dArray[n];
                dArray[Patch.numVars] = d3 * d2;
                dArray[n] = d3 - d3 * d;
                ++n4;
            }
            n2 += VM.sl.widthp2;
            ++n3;
        }
        this.nsum4(Patch.numVars, n, false);
    }

    void setupNsum(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = VM.sl.width + 1;
        int n5 = 0;
        while (n5 < VM.sl.heightp2) {
            VM.sl.patches[n3].patchesowndoubles[n2] = 0.0;
            VM.sl.patches[n4].patchesowndoubles[n2] = 0.0;
            n3 += VM.sl.widthp2;
            n4 += VM.sl.widthp2;
            ++n5;
        }
        n3 = VM.sl.widthp2 * (VM.sl.height + 1) + 1;
        n5 = 1;
        while (n5 < VM.sl.width + 1) {
            VM.sl.patches[n5].patchesowndoubles[n2] = 0.0;
            VM.sl.patches[n3].patchesowndoubles[n2] = 0.0;
            ++n3;
            ++n5;
        }
        n5 = VM.sl.widthp2;
        if (bl) {
            int n6 = 1;
            while (n6 < VM.sl.height + 1) {
                int n7 = 1;
                while (n7 < VM.sl.width + 1) {
                    Patch patch = VM.sl.patches[n5 + n7];
                    patch.patchesowndoubles[n2] = 0.0;
                    ++n7;
                }
                n5 += VM.sl.widthp2;
                ++n6;
            }
        }
    }

    void setupNsumPC(int n, boolean bl) {
        int n2 = 0;
        int n3 = VM.sl.width + 1;
        int n4 = 0;
        while (n4 < VM.sl.heightp2) {
            VM.sl.patches[n2].pc = 0.0;
            VM.sl.patches[n3].pc = 0.0;
            n2 += VM.sl.widthp2;
            n3 += VM.sl.widthp2;
            ++n4;
        }
        n2 = VM.sl.widthp2 * (VM.sl.height + 1) + 1;
        n4 = 1;
        while (n4 < VM.sl.width + 1) {
            VM.sl.patches[n4].pc = 0.0;
            VM.sl.patches[n2].pc = 0.0;
            ++n2;
            ++n4;
        }
        n4 = VM.sl.widthp2;
        if (bl) {
            int n5 = 1;
            while (n5 < VM.sl.height + 1) {
                int n6 = 1;
                while (n6 < VM.sl.width + 1) {
                    Patch patch = VM.sl.patches[n4 + n6];
                    patch.pc = 0.0;
                    ++n6;
                }
                n4 += VM.sl.widthp2;
                ++n5;
            }
        }
    }

    void copyBack(int n) {
        int n2 = VM.sl.widthp2;
        int n3 = 1;
        while (n3 < VM.sl.height + 1) {
            int n4 = 1;
            while (n4 < VM.sl.width + 1) {
                Patch patch = VM.sl.patches[n2 + n4];
                patch.turtlesown[n] = new Double(patch.patchesowndoubles[n]);
                ++n4;
            }
            n2 += VM.sl.widthp2;
            ++n3;
        }
    }

    void nsum(int n, int n2) {
        this.nsum(n, n2, true);
    }

    void nsumPC(int n) {
        this.nsumPC(n, true);
    }

    void nsum(int n, int n2, boolean bl) {
        this.setupNsum(n, n2, bl);
        int n3 = VM.sl.widthp2;
        int n4 = 1;
        while (n4 < VM.sl.height + 1) {
            int n5 = 1;
            while (n5 < VM.sl.width + 1) {
                int n6 = n3 + n5;
                double d = VM.sl.patches[n6].patchesowndoubles[n];
                if (d != 0.0) {
                    int n7 = n6 + VM.sl.widthp2;
                    int n8 = n6 - VM.sl.widthp2;
                    int n9 = n2;
                    VM.sl.patches[n6 + 1].patchesowndoubles[n9] = VM.sl.patches[n6 + 1].patchesowndoubles[n9] + d;
                    int n10 = n2;
                    VM.sl.patches[n6 - 1].patchesowndoubles[n10] = VM.sl.patches[n6 - 1].patchesowndoubles[n10] + d;
                    int n11 = n2;
                    VM.sl.patches[n7 + 1].patchesowndoubles[n11] = VM.sl.patches[n7 + 1].patchesowndoubles[n11] + d;
                    int n12 = n2;
                    VM.sl.patches[n7].patchesowndoubles[n12] = VM.sl.patches[n7].patchesowndoubles[n12] + d;
                    int n13 = n2;
                    VM.sl.patches[n7 - 1].patchesowndoubles[n13] = VM.sl.patches[n7 - 1].patchesowndoubles[n13] + d;
                    int n14 = n2;
                    VM.sl.patches[n8 + 1].patchesowndoubles[n14] = VM.sl.patches[n8 + 1].patchesowndoubles[n14] + d;
                    int n15 = n2;
                    VM.sl.patches[n8].patchesowndoubles[n15] = VM.sl.patches[n8].patchesowndoubles[n15] + d;
                    int n16 = n2;
                    VM.sl.patches[n8 - 1].patchesowndoubles[n16] = VM.sl.patches[n8 - 1].patchesowndoubles[n16] + d;
                }
                ++n5;
            }
            n3 += VM.sl.widthp2;
            ++n4;
        }
        this.fixVertical(n2);
        this.fixHorizontal(n2);
        this.fixCorners(n2);
        this.copyBack(n2);
    }

    void nsumPC(int n, boolean bl) {
        this.setupNsumPC(n, bl);
        int n2 = VM.sl.widthp2;
        int n3 = 1;
        while (n3 < VM.sl.height + 1) {
            int n4 = 1;
            while (n4 < VM.sl.width + 1) {
                int n5 = n2 + n4;
                double d = VM.sl.patches[n5].patchesowndoubles[n];
                if (d != 0.0) {
                    int n6 = n5 + VM.sl.widthp2;
                    int n7 = n5 - VM.sl.widthp2;
                    VM.sl.patches[n5 + 1].pc += d;
                    VM.sl.patches[n5 - 1].pc += d;
                    VM.sl.patches[n6 + 1].pc += d;
                    VM.sl.patches[n6].pc += d;
                    VM.sl.patches[n6 - 1].pc += d;
                    VM.sl.patches[n7 + 1].pc += d;
                    VM.sl.patches[n7].pc += d;
                    VM.sl.patches[n7 - 1].pc += d;
                }
                ++n4;
            }
            n2 += VM.sl.widthp2;
            ++n3;
        }
        this.fixVerticalPC();
        this.fixHorizontalPC();
        this.fixCornersPC();
    }

    void nsum4(int n, int n2) {
        this.nsum4(n, n2, true);
    }

    void nsum4PC(int n) {
        this.nsum4PC(n, true);
    }

    void nsum4(int n, int n2, boolean bl) {
        this.setupNsum(n, n2, bl);
        int n3 = VM.sl.widthp2;
        int n4 = 1;
        while (n4 < VM.sl.height + 1) {
            int n5 = 1;
            while (n5 < VM.sl.width + 1) {
                int n6 = n3 + n5;
                double d = VM.sl.patches[n6].patchesowndoubles[n];
                if (d != 0.0) {
                    int n7 = n6 + VM.sl.widthp2;
                    int n8 = n6 - VM.sl.widthp2;
                    int n9 = n2;
                    VM.sl.patches[n6 + 1].patchesowndoubles[n9] = VM.sl.patches[n6 + 1].patchesowndoubles[n9] + d;
                    int n10 = n2;
                    VM.sl.patches[n6 - 1].patchesowndoubles[n10] = VM.sl.patches[n6 - 1].patchesowndoubles[n10] + d;
                    int n11 = n2;
                    VM.sl.patches[n7].patchesowndoubles[n11] = VM.sl.patches[n7].patchesowndoubles[n11] + d;
                    int n12 = n2;
                    VM.sl.patches[n8].patchesowndoubles[n12] = VM.sl.patches[n8].patchesowndoubles[n12] + d;
                }
                ++n5;
            }
            n3 += VM.sl.widthp2;
            ++n4;
        }
        this.fixVertical(n2);
        this.fixHorizontal(n2);
        this.copyBack(n2);
    }

    void nsum4PC(int n, boolean bl) {
        this.setupNsumPC(n, bl);
        int n2 = VM.sl.widthp2;
        int n3 = 1;
        while (n3 < VM.sl.height + 1) {
            int n4 = 1;
            while (n4 < VM.sl.width + 1) {
                int n5 = n2 + n4;
                double d = VM.sl.patches[n5].patchesowndoubles[n];
                if (d != 0.0) {
                    int n6 = n5 + VM.sl.widthp2;
                    int n7 = n5 - VM.sl.widthp2;
                    VM.sl.patches[n5 + 1].pc += d;
                    VM.sl.patches[n5 - 1].pc += d;
                    VM.sl.patches[n6].pc += d;
                    VM.sl.patches[n7].pc += d;
                }
                ++n4;
            }
            n2 += VM.sl.widthp2;
            ++n3;
        }
        this.fixVerticalPC();
        this.fixHorizontalPC();
    }

    void fixVertical(int n) {
        int n2 = VM.sl.widthp2;
        int n3 = VM.sl.widthp2 + VM.sl.width + 1;
        int n4 = 1;
        while (n4 < VM.sl.height + 1) {
            int n5 = n;
            VM.sl.patches[n2 + VM.sl.width].patchesowndoubles[n5] = VM.sl.patches[n2 + VM.sl.width].patchesowndoubles[n5] + VM.sl.patches[n2].patchesowndoubles[n];
            int n6 = n;
            VM.sl.patches[n3 - VM.sl.width].patchesowndoubles[n6] = VM.sl.patches[n3 - VM.sl.width].patchesowndoubles[n6] + VM.sl.patches[n3].patchesowndoubles[n];
            n2 += VM.sl.widthp2;
            n3 += VM.sl.widthp2;
            ++n4;
        }
    }

    void fixHorizontal(int n) {
        int n2 = VM.sl.widthp2 * VM.sl.height + 1;
        int n3 = 1;
        while (n3 < VM.sl.width + 1) {
            int n4 = n;
            VM.sl.patches[n2].patchesowndoubles[n4] = VM.sl.patches[n2].patchesowndoubles[n4] + VM.sl.patches[n3].patchesowndoubles[n];
            int n5 = n;
            VM.sl.patches[n3 + VM.sl.widthp2].patchesowndoubles[n5] = VM.sl.patches[n3 + VM.sl.widthp2].patchesowndoubles[n5] + VM.sl.patches[n2 + VM.sl.widthp2].patchesowndoubles[n];
            ++n2;
            ++n3;
        }
    }

    void fixCorners(int n) {
        double d = VM.sl.patches[0].patchesowndoubles[n];
        int n2 = n;
        VM.sl.patches[VM.sl.widthp2 * (VM.sl.heightp2 - 1) - 2].patchesowndoubles[n2] = VM.sl.patches[VM.sl.widthp2 * (VM.sl.heightp2 - 1) - 2].patchesowndoubles[n2] + d;
        d = VM.sl.patches[VM.sl.widthp2 * VM.sl.heightp2 - 1].patchesowndoubles[n];
        int n3 = n;
        VM.sl.patches[VM.sl.widthp2 + 1].patchesowndoubles[n3] = VM.sl.patches[VM.sl.widthp2 + 1].patchesowndoubles[n3] + d;
        d = VM.sl.patches[VM.sl.widthp2 - 1].patchesowndoubles[n];
        int n4 = n;
        VM.sl.patches[VM.sl.widthp2 * (VM.sl.heightp2 - 2) + 1].patchesowndoubles[n4] = VM.sl.patches[VM.sl.widthp2 * (VM.sl.heightp2 - 2) + 1].patchesowndoubles[n4] + d;
        d = VM.sl.patches[VM.sl.widthp2 * (VM.sl.heightp2 - 1)].patchesowndoubles[n];
        int n5 = n;
        VM.sl.patches[2 * (VM.sl.widthp2 - 1)].patchesowndoubles[n5] = VM.sl.patches[2 * (VM.sl.widthp2 - 1)].patchesowndoubles[n5] + d;
    }

    void fixVerticalPC() {
        int n = VM.sl.widthp2;
        int n2 = VM.sl.widthp2 + VM.sl.width + 1;
        int n3 = 1;
        while (n3 < VM.sl.height + 1) {
            VM.sl.patches[n + VM.sl.width].pc += VM.sl.patches[n].pc;
            VM.sl.patches[n2 - VM.sl.width].pc += VM.sl.patches[n2].pc;
            n += VM.sl.widthp2;
            n2 += VM.sl.widthp2;
            ++n3;
        }
    }

    void fixHorizontalPC() {
        int n = VM.sl.widthp2 * VM.sl.height + 1;
        int n2 = 1;
        while (n2 < VM.sl.width + 1) {
            VM.sl.patches[n].pc += VM.sl.patches[n2].pc;
            VM.sl.patches[n2 + VM.sl.widthp2].pc += VM.sl.patches[n + VM.sl.widthp2].pc;
            ++n;
            ++n2;
        }
    }

    void fixCornersPC() {
        double d = VM.sl.patches[0].pc;
        VM.sl.patches[VM.sl.widthp2 * (VM.sl.heightp2 - 1) - 2].pc += d;
        d = VM.sl.patches[VM.sl.widthp2 * VM.sl.heightp2 - 1].pc;
        VM.sl.patches[VM.sl.widthp2 + 1].pc += d;
        d = VM.sl.patches[VM.sl.widthp2 - 1].pc;
        VM.sl.patches[VM.sl.widthp2 * (VM.sl.heightp2 - 2) + 1].pc += d;
        d = VM.sl.patches[VM.sl.widthp2 * (VM.sl.heightp2 - 1)].pc;
        VM.sl.patches[2 * (VM.sl.widthp2 - 1)].pc += d;
    }

    public final boolean grab(Object object) {
        if (object instanceof Number) {
            Turtle turtle = VM.sl.getWho(((Number)object).intValue());
            if (turtle != null && turtle.grabber == null && turtle.partner == null) {
                this.ostack[this.sp++] = turtle;
                this.ostack[this.sp++] = VM.grabbedMarker;
                this.partner = turtle;
                turtle.grabber = this;
                int n = this.istack[--this.isp];
                this.istack[this.isp++] = 1;
                this.istack[this.isp++] = this.ip;
                this.ip = n;
                this.istack[this.isp++] = 204799;
                return true;
            }
            return false;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            int n2 = objectArray.length - 1;
            while (n2 >= 0) {
                Turtle turtle = VM.sl.getWho(this.aInteger(objectArray[n2]));
                if (turtle != null && turtle.grabber == null && turtle.partner == null) {
                    this.ostack[this.sp++] = turtle;
                    this.ostack[this.sp++] = VM.grabbedMarker;
                    this.partner = turtle;
                    turtle.grabber = this;
                    ++n;
                }
                --n2;
            }
            if (n > 0) {
                int n3 = this.istack[--this.isp];
                this.istack[this.isp++] = n;
                this.istack[this.isp++] = this.ip;
                this.ip = n3;
                this.istack[this.isp++] = 204799;
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean grabPatch(Patch patch) {
        if (!patch.grabbedp && patch.patchpartner == null) {
            this.ostack[this.sp++] = patch;
            this.ostack[this.sp++] = VM.grabbedPatchMarker;
            this.patchpartner = patch;
            patch.grabbedp = true;
            int n = this.istack[--this.isp];
            this.istack[this.isp++] = 1;
            this.istack[this.isp++] = this.ip;
            this.ip = n;
            this.istack[this.isp++] = 204798;
            return true;
        }
        return false;
    }

    public static void setVars(Object[] objectArray, StarLogo starLogo, Context context) {
        Object[] objectArray2;
        numVars = objectArray.length;
        Observer.setLength(new Integer(Observer.getStateLength() + 4 * numVars));
        varnames = new String[numVars];
        varposes = new int[numVars];
        varenums = new boolean[numVars];
        if (starLogo.observer.turtlesown.length < numVars) {
            objectArray2 = new Object[numVars];
            System.arraycopy(starLogo.observer.turtlesown, 0, objectArray2, 0, starLogo.observer.turtlesown.length);
            int n = starLogo.observer.turtlesown.length;
            while (n < numVars) {
                objectArray2[n] = VM.zeroInt;
                ++n;
            }
            starLogo.observer.turtlesown = objectArray2;
        } else if (starLogo.observer.turtlesown.length > numVars / 2) {
            objectArray2 = new Object[numVars];
            System.arraycopy(starLogo.observer.turtlesown, 0, objectArray2, 0, numVars);
            starLogo.observer.turtlesown = objectArray2;
        }
        int n = 0;
        while (n < numVars) {
            Object[] objectArray3 = YoYo.aList(context, objectArray[n]);
            Observer.varnames[n] = YoYo.aString(context, objectArray3[0]);
            Observer.varposes[n] = YoYo.aInteger(context, objectArray3[1]);
            Observer.varenums[n] = YoYo.aBoolean(context, objectArray3[2]);
            ++n;
        }
    }

    public static int getNumVars() {
        return numVars;
    }

    public static String getVarName(int n) {
        return varnames[n];
    }

    public static int getVarPos(int n) {
        return varposes[n];
    }

    public static boolean getVarEnump(int n) {
        return varenums[n];
    }

    public String toString() {
        return "Observer";
    }

    public String niceToString() {
        return this.toString();
    }

    Observer(StarLogo starLogo) {
        this(1, 1, new Object[numVars], starLogo);
        int n = 0;
        while (n < numVars) {
            this.turtlesown[n] = VM.zeroInt;
            ++n;
        }
    }

    Observer(int n, int n2, Object[] objectArray, StarLogo starLogo) {
        VM.sl = starLogo;
        this.plotpen = n;
        this.plotwidget = n2;
        this.turtlesown = objectArray;
    }
}

