/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import starlogo.Application;
import starlogo.InfoWindow;
import starlogo.JSLDialog;
import starlogo.JSLMenu;
import starlogo.NSLMenu;
import yoyo.JTEStream;
import yoyo.YoYo;

public class OutputWindow
extends InfoWindow {
    private static Font OUT_FONT;
    StringBuffer tempsb = new StringBuffer();

    public void init() {
        ((Component)this).setLocation(0, 0);
        ((Component)this).setSize(300, 200);
        this.setFont(OUT_FONT);
        this.setupText();
        this.setupLayout();
        this.slmenu = YoYo.macintoshp && !YoYo.macosxp ? new NSLMenu(this, this.app) : new JSLMenu(this, this.app);
        this.slmenu.setMenuBar(this);
        this.addNotify();
        this.setupKeyTrackers();
    }

    public void setupText() {
        this.ta = new JTextArea("", 10, 10);
        JScrollPane jScrollPane = new JScrollPane(this.ta, YoYo.macintoshp ? 22 : 20, 31);
        this.ta.setFont(OUT_FONT);
        JSLDialog.colorText(this.ta);
        this.pw = new PrintWriter(new JTEStream(this.ta), true);
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        String string = "";
        if (object2 instanceof JMenuItem) {
            object = (JMenuItem)object2;
            string = ((AbstractButton)object).getLabel();
        } else if (object2 instanceof MenuItem) {
            object = (MenuItem)object2;
            string = ((MenuItem)object).getLabel();
        }
        if (string.equals("Cut")) {
            object = this.ta.getSelectedText();
            if (((String)object).equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection((String)object);
            this.clip.setContents(stringSelection, this);
            int n = this.ta.getSelectionStart();
            this.ta.replaceRange("", n, this.ta.getSelectionEnd());
            this.ta.select(n, n);
            return;
        }
        if (string.equals("Copy")) {
            object = this.ta.getSelectedText();
            if (((String)object).equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection((String)object);
            this.clip.setContents(stringSelection, this);
            return;
        }
        if (string.equals("Paste")) {
            object = this.clip.getContents(this);
            if (object != null) {
                try {
                    Object object3 = object.getTransferData(DataFlavor.stringFlavor);
                    if (object3 instanceof String) {
                        String string2 = (String)object3;
                        int n = string2.length();
                        int n2 = this.ta.getCaretPosition();
                        if (n == 0) {
                            this.ta.insert(string2, n2);
                            this.ta.select(n2 + n, n2 + n);
                        } else {
                            int n3 = this.ta.getSelectionStart();
                            this.ta.replaceRange(string2, n3, this.ta.getSelectionEnd());
                            this.ta.select(n3 + n, n3 + n);
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return;
        }
        if (string.equals("Select All")) {
            this.ta.selectAll();
            return;
        }
        if (string.equals("Clear")) {
            this.ta.setText("");
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void registerCloser(Frame frame, Application application) {
        frame.addWindowListener(new Closer(application));
    }

    public String getContents() {
        return this.ta.getText();
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public synchronized void print(String string) {
        this.tempsb.append(string);
        SwingUtilities.invokeLater(new Runnable(this){
            private final /* synthetic */ OutputWindow this$0;

            public final void run() {
                StringBuffer stringBuffer = this.this$0.tempsb;
                synchronized (stringBuffer) {
                    if (this.this$0.tempsb.length() > 0) {
                        int n = this.this$0.ta.getCaretPosition();
                        this.this$0.ta.insert(this.this$0.tempsb.toString(), n);
                        this.this$0.ta.setCaretPosition(n + this.this$0.tempsb.length());
                        this.this$0.tempsb.setLength(0);
                    }
                }
            }
            {
                this.this$0 = outputWindow;
                this.constructor$0(outputWindow);
            }

            private final void constructor$0(OutputWindow outputWindow) {
            }
        });
    }

    public OutputWindow(Application application) {
        super(application, "Output Window");
        if (YoYo.language == 1) {
            this.setTitle("Ventana de Salida");
        }
        OUT_FONT = Font.getFont("starlogo.procedures.font", OUT_FONT);
    }

    static {
        try {
            OUT_FONT = new Font("Monospaced", 0, 12);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class ControlKeyAdapter
    extends KeyAdapter {
        JFrame parent;

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (YoYo.macintoshp && keyEvent.isMetaDown() && c == '.') {
                Object object = OutputWindow.this.sl.runningp;
                synchronized (object) {
                    OutputWindow.this.sl.stopAll();
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
        }

        public void keyReleased(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
        }

        ControlKeyAdapter(JFrame jFrame) {
            this.parent = jFrame;
        }
    }

    private class Closer
    extends WindowAdapter {
        Application app;

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)windowEvent.getWindow()).setVisible(false);
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public Closer(Application application) {
            this.app = application;
        }
    }
}

