/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import starlogo.PatchMonitor;
import starlogo.StarLogo;
import starlogo.Turtle;
import starlogo.Utilities;
import starlogo.VM;
import yoyo.Context;
import yoyo.YoYo;

class Patch
extends VM
implements Serializable {
    static int numVars = 0;
    public static Hashtable stateOffsetTable = Patch.initStateOffsets();
    static String[] varnames;
    static int[] varposes;
    static boolean[] varenums;
    double pc = 0.0;
    transient double[] patchesowndoubles;
    transient Turtle topturtle = null;
    transient Turtle tophiddenturtle = null;
    transient boolean grabbedp = false;
    double xcor;
    double ycor;
    transient boolean hasPMp = false;
    transient PatchMonitor pm;
    public boolean checked;

    public static Patch restore(StarLogo starLogo, byte[] byArray, int n) {
        double d = 0.0;
        int n2 = 1;
        int n3 = 1;
        double d2 = starLogo.halfwidth;
        double d3 = starLogo.halfheight;
        int n4 = Patch.getOffset("xcor");
        if (n4 >= 0) {
            d2 = Utilities.readDoubleFromByteArray(byArray, n + n4);
        }
        if ((n4 = Patch.getOffset("ycor")) >= 0) {
            d3 = Utilities.readDoubleFromByteArray(byArray, n + n4);
        }
        if ((n4 = Patch.getOffset("pc")) >= 0) {
            d = Utilities.readDoubleFromByteArray(byArray, n + n4);
        }
        if ((n4 = Patch.getOffset("plotpen")) >= 0) {
            n2 = Utilities.readIntFromByteArray(byArray, n + n4);
        }
        if ((n4 = Patch.getOffset("plotwidget")) >= 0) {
            n3 = Utilities.readIntFromByteArray(byArray, n + n4);
        }
        Object[] objectArray = Patch.restoreVariables(byArray, n + Patch.getStateLength());
        return new Patch(d2, d3, d, n2, n3, objectArray, starLogo);
    }

    public void save(byte[] byArray, int n) {
        int n2 = Patch.getOffset("xcor");
        if (n2 >= 0) {
            Utilities.writeIntoByteArray(this.xcor, byArray, n + n2);
        }
        if ((n2 = Patch.getOffset("ycor")) >= 0) {
            Utilities.writeIntoByteArray(this.ycor, byArray, n + n2);
        }
        if ((n2 = Patch.getOffset("pc")) >= 0) {
            Utilities.writeIntoByteArray(this.pc, byArray, n + n2);
        }
        if ((n2 = Patch.getOffset("plotpen")) >= 0) {
            Utilities.writeIntoByteArray(this.plotpen, byArray, n + n2);
        }
        if ((n2 = Patch.getOffset("plotwidget")) >= 0) {
            Utilities.writeIntoByteArray(this.plotwidget, byArray, n + n2);
        }
        this.saveVariables(byArray, n + Patch.getStateLength());
    }

    public void saveVariables(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < numVars) {
            int n4 = Patch.getVarPos(n3);
            Object object = this.turtlesown[n4];
            int n5 = Utilities.addIntoTable(object, VM.sl);
            Utilities.writeIntoByteArray(n5, byArray, n + n2);
            n2 += 4;
            ++n3;
        }
    }

    public static Object[] restoreVariables(byte[] byArray, int n) {
        Object[] objectArray = new Object[numVars];
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Object object;
            int n4 = Utilities.readIntFromByteArray(byArray, n + n2);
            n2 += 4;
            objectArray[Patch.getVarPos((int)n3)] = object = Utilities.lookupInTable(n4);
            ++n3;
        }
        return objectArray;
    }

    public static Hashtable initStateOffsets() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("xcor", new Integer(0));
        hashtable.put("ycor", new Integer(8));
        hashtable.put("pc", new Integer(16));
        hashtable.put("plotpen", new Integer(24));
        hashtable.put("plotwidget", new Integer(28));
        hashtable.put("statelength", new Integer(32));
        hashtable.put("length", new Integer(32));
        return hashtable;
    }

    public static int getLength() {
        return Patch.getOffset("length");
    }

    public static void setLength(Integer n) {
        stateOffsetTable.put("length", n);
    }

    public static int getStateLength() {
        return Patch.getOffset("statelength");
    }

    public static int getOffset(String string) {
        if (stateOffsetTable.containsKey(string)) {
            return (Integer)stateOffsetTable.get(string);
        }
        return -1000;
    }

    public static byte[] getStateDesc() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Enumeration enumeration = stateOffsetTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = (Integer)stateOffsetTable.get(string);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(n);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void setStateDesc(byte[] byArray) throws IOException {
        stateOffsetTable.clear();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        while (dataInputStream.available() > 0) {
            String string = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            stateOffsetTable.put(string, new Integer(n));
        }
        dataInputStream.close();
    }

    public final boolean grab(Object object) {
        if (object instanceof Number) {
            Turtle turtle = VM.sl.getWho(((Number)object).intValue());
            if (turtle != null && turtle.grabber == null && turtle.partner == null) {
                this.ostack[this.sp++] = turtle;
                this.ostack[this.sp++] = VM.grabbedMarker;
                this.partner = turtle;
                turtle.grabber = this;
                int n = this.istack[--this.isp];
                this.istack[this.isp++] = 1;
                this.istack[this.isp++] = this.ip;
                this.ip = n;
                this.istack[this.isp++] = 204799;
                return true;
            }
            return false;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            int n2 = objectArray.length - 1;
            while (n2 >= 0) {
                Turtle turtle = VM.sl.getWho(this.aInteger(objectArray[n2]));
                if (turtle != null && turtle.grabber == null && turtle.partner == null) {
                    this.ostack[this.sp++] = turtle;
                    this.ostack[this.sp++] = VM.grabbedMarker;
                    this.partner = turtle;
                    turtle.grabber = this;
                    ++n;
                }
                --n2;
            }
            if (n > 0) {
                int n3 = this.istack[--this.isp];
                this.istack[this.isp++] = n;
                this.istack[this.isp++] = this.ip;
                this.ip = n3;
                this.istack[this.isp++] = 204799;
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean grabPatch(Patch patch) {
        if (this.grabbedp) {
            return false;
        }
        if (patch != this && !patch.grabbedp && patch.patchpartner == null) {
            this.ostack[this.sp++] = patch;
            this.ostack[this.sp++] = VM.grabbedPatchMarker;
            this.patchpartner = patch;
            patch.grabbedp = true;
            int n = this.istack[--this.isp];
            this.istack[this.isp++] = 1;
            this.istack[this.isp++] = this.ip;
            this.ip = n;
            this.istack[this.isp++] = 204798;
            return true;
        }
        return false;
    }

    public static void setVars(Object[] objectArray, StarLogo starLogo, Context context) {
        Object object;
        int n;
        numVars = objectArray.length;
        Patch.setLength(new Integer(Patch.getStateLength() + 4 * numVars));
        varnames = new String[numVars];
        varposes = new int[numVars];
        varenums = new boolean[numVars];
        if (starLogo.patches != null) {
            n = 0;
            while (n < starLogo.patches.length) {
                double[] dArray;
                Object[] objectArray2;
                object = starLogo.patches[n];
                if (object == null) {
                    starLogo.app.err.println("uh oh, patch " + n + " doesn't exist");
                }
                if (object.turtlesown.length < numVars) {
                    objectArray2 = new Object[numVars];
                    dArray = new double[numVars + 1];
                    System.arraycopy(object.turtlesown, 0, objectArray2, 0, object.turtlesown.length);
                    System.arraycopy(object.patchesowndoubles, 0, dArray, 0, object.patchesowndoubles.length);
                    int n2 = object.turtlesown.length;
                    while (n2 < numVars) {
                        objectArray2[n2] = VM.zeroInt;
                        dArray[n2] = 0.0;
                        ++n2;
                    }
                    dArray[Patch.numVars] = 0.0;
                    object.turtlesown = objectArray2;
                    object.patchesowndoubles = dArray;
                } else if (object.turtlesown.length > numVars / 2 + 1) {
                    objectArray2 = new Object[numVars];
                    dArray = new double[numVars + 1];
                    System.arraycopy(object.turtlesown, 0, objectArray2, 0, numVars);
                    System.arraycopy(object.patchesowndoubles, 0, dArray, 0, numVars);
                    dArray[Patch.numVars] = 0.0;
                    object.turtlesown = objectArray2;
                    object.patchesowndoubles = dArray;
                }
                ++n;
            }
        }
        n = 0;
        while (n < numVars) {
            object = YoYo.aList(context, objectArray[n]);
            Patch.varnames[n] = YoYo.aString(context, object[0]);
            Patch.varposes[n] = YoYo.aInteger(context, object[1]);
            Patch.varenums[n] = YoYo.aBoolean(context, object[2]);
            ++n;
        }
    }

    public static int getNumVars() {
        return numVars;
    }

    public static String getVarName(int n) {
        return varnames[n];
    }

    public static int getVarPos(int n) {
        return varposes[n];
    }

    public static boolean getVarEnump(int n) {
        return varenums[n];
    }

    public String toString() {
        return "(" + (int)(this.xcor - 1.0 - (double)VM.sl.halfwidth) + ", " + (int)((double)VM.sl.halfheight - (this.ycor - 1.0)) + ")";
    }

    public String niceToString() {
        return "Patch " + this.toString();
    }

    Patch(double d, double d2, StarLogo starLogo) {
        this(d, d2, 0.0, 1, 1, new Object[numVars], starLogo);
        int n = 0;
        while (n < numVars) {
            this.turtlesown[n] = VM.zeroInt;
            this.patchesowndoubles[n] = 0.0;
            ++n;
        }
        this.patchesowndoubles[Patch.numVars] = 0.0;
    }

    Patch(double d, double d2, double d3, int n, int n2, Object[] objectArray, StarLogo starLogo) {
        this.xcor = d;
        this.ycor = d2;
        this.pc = d3;
        this.plotpen = n;
        this.plotwidget = n2;
        VM.sl = starLogo;
        this.turtlesown = objectArray;
        this.patchesowndoubles = new double[numVars + 1];
        int n3 = 0;
        while (n3 < numVars) {
            this.patchesowndoubles[n3] = this.turtlesown[n3] instanceof Double ? (Double)this.turtlesown[n3] : 0.0;
            ++n3;
        }
        this.patchesowndoubles[Patch.numVars] = 0.0;
        starLogo.list.create(this);
    }
}

