/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;
import starlogo.Application;
import starlogo.Colors;
import starlogo.Colortool;
import starlogo.Interface;
import starlogo.Patch;
import starlogo.Pictures;
import starlogo.StarLogo;
import starlogo.Turtle;
import starlogo.TurtleShapes;
import starlogo.WidgetDrag;
import starlogo.WindowPosition;
import yoyo.YoYo;

public class PatchCanvas
extends WidgetDrag
implements ImageConsumer {
    public static int TRANSPARENT_COLOR = 0;
    public static boolean loadCanceled;
    public StarLogo sl;
    boolean obscured = false;
    boolean uptodate = false;
    boolean displayp = true;
    Rectangle originalPosition;
    public int xoffset;
    public int yoffset;
    public int mousedownx;
    public int mousedowny;
    public int mousedragx;
    public int mousedragy;
    boolean startOfPoly = true;
    int polyHeadx;
    int polyHeady;
    boolean mousePressed;
    int ovalMaxX;
    int ovalMaxY;
    Graphics g;
    public int pcdraws = 0;
    public int count = 0;
    Turtle turtleTouched = null;
    Patch patchTouched = null;
    ImageProducer ip;
    Pictures pictures;
    double[] rerror;
    double[] gerror;
    double[] berror;
    int widthIP;
    int heightIP;

    public void init(Interface interface_) {
        this.parent = interface_;
        this.image = interface_.createImage(this.position.width, this.position.height);
        this.xoffset = this.position.x;
        this.yoffset = this.position.y;
        this.setDrawingSurface();
        this.updateImage();
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (!this.sl.offscreen) {
            this.xoffset = n;
            this.yoffset = n2;
        }
    }

    public void display() {
        if (!this.displayp) {
            this.displayp = true;
            this.uptodate = false;
            this.refresh();
        }
    }

    public void noDisplay() {
        this.displayp = false;
    }

    public void updateGraphics(Graphics graphics) {
        int n = this.sl.cellsize;
        Shape shape = graphics.getClip();
        if (n < 8) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.sl.widthp2;
            while (n2 < this.sl.height) {
                int n5 = n4 + 1;
                int n6 = 0;
                int n7 = 0;
                while (n6 < this.sl.width) {
                    Patch patch = this.sl.patches[n5++];
                    Turtle turtle = patch.topturtle;
                    if (turtle != null) {
                        graphics.setColor(Colors.colorarray[(int)(turtle.color * 32.0)]);
                        graphics.fillRect(n7, n3, n, n);
                    } else {
                        graphics.setColor(Colors.colorarray[(int)(patch.pc * 32.0)]);
                        graphics.fillRect(n7, n3, n, n);
                    }
                    ++n6;
                    n7 += n;
                }
                ++n2;
                n3 += n;
                n4 += this.sl.widthp2;
            }
        } else {
            int n8 = 0;
            int n9 = 0;
            int n10 = this.sl.widthp2;
            while (n8 < this.sl.height) {
                int n11 = n10 + 1;
                int n12 = 0;
                int n13 = 0;
                while (n12 < this.sl.width) {
                    Patch patch = this.sl.patches[n11++];
                    graphics.setColor(Colors.colorarray[(int)(patch.pc * 32.0)]);
                    graphics.fillRect(n13, n9, n, n);
                    Turtle turtle = patch.topturtle;
                    if (turtle != null) {
                        int n14 = (int)((turtle.heading + 11.25) / 22.5 % 16.0);
                        int n15 = n14 * n;
                        int n16 = 0;
                        graphics.setClip(n13, n9, n, n);
                        graphics.drawImage(TurtleShapes.getShapeAsImage(turtle, n, this.sl.app), n13, n9, n13 + n, n9 + n, n15, n16, n15 + n, n16 + n, this);
                        graphics.setClip(shape);
                    }
                    ++n12;
                    n13 += n;
                }
                ++n8;
                n9 += n;
                n10 += this.sl.widthp2;
            }
        }
    }

    void drawPatch(double d, double d2, double d3) {
        this.drawPatch(d, d2, d3, this.sl.patches);
    }

    void drawPatch(double d, double d2, double d3, Patch[] patchArray) {
        if (!this.displayp) {
            return;
        }
        ++this.pcdraws;
        int n = this.sl.cellsize;
        int n2 = (int)d;
        int n3 = (int)d2;
        this.g.setColor(Colors.colorarray[(int)(d3 * 32.0)]);
        if (!this.sl.offscreen) {
            this.uptodate = false;
        }
        this.g.fillRect(n2 * n + this.xoffset, n3 * n + this.yoffset, n, n);
    }

    void drawPatch(Patch patch) {
        this.drawPatch(patch, this.sl.patches);
    }

    void drawPatch(Patch patch, Patch[] patchArray) {
        if (!this.displayp) {
            return;
        }
        ++this.pcdraws;
        int n = this.sl.cellsize;
        int n2 = (int)patch.xcor - 1;
        int n3 = (int)patch.ycor - 1;
        this.g.setColor(Colors.colorarray[(int)(patch.pc * 32.0)]);
        if (!this.sl.offscreen) {
            this.uptodate = false;
        }
        this.g.fillRect(n2 * n + this.xoffset, n3 * n + this.yoffset, n, n);
    }

    void drawTurtle(Turtle turtle) {
        this.drawTurtle(turtle, this.sl.patches);
    }

    void drawTurtle(Turtle turtle, Patch[] patchArray) {
        if (!this.displayp) {
            return;
        }
        int n = this.sl.cellsize;
        int n2 = (int)turtle.xcor;
        int n3 = (int)turtle.ycor;
        if (n2 < this.sl.width && n3 <= this.sl.height) {
            if (n < 8) {
                this.drawPatch(n2, n3, turtle.color, patchArray);
                return;
            }
            ++this.pcdraws;
            int n4 = n2 * n + this.xoffset;
            int n5 = n3 * n + this.yoffset;
            this.g.setColor(Colors.colorarray[(int)(patchArray[turtle.patch].pc * 32.0)]);
            this.g.fillRect(n4, n5, n, n);
            if (!this.sl.offscreen) {
                this.uptodate = false;
            }
            int n6 = (int)((turtle.heading + 11.25) / 22.5 % 16.0);
            Shape shape = this.g.getClip();
            int n7 = n6 * n;
            int n8 = 0;
            this.g.setClip(n4, n5, n, n);
            this.g.drawImage(TurtleShapes.getShapeAsImage(turtle, n, this.sl.app), n4, n5, n4 + n, n5 + n, n7, n8, n7 + n, n8 + n, this);
            this.g.setClip(shape);
        }
    }

    protected Graphics getDrawingSurface() {
        return this.sl.offscreen ? this.image.getGraphics() : this.parent.getGraphics();
    }

    public void setDrawingSurface() {
        if (this.g != null) {
            this.g.dispose();
        }
        this.g = this.getDrawingSurface();
    }

    public void deleteDrawingSurface() {
        if (this.g != null) {
            Toolkit.getDefaultToolkit().sync();
            this.g.dispose();
            this.g = null;
        }
    }

    public void setOffscreen(boolean bl) {
        Object object = this.sl.runningp;
        synchronized (object) {
            this.sl.offscreen = bl;
            if (bl) {
                this.sl.locked = true;
                this.updateImage();
                this.xoffset = 0;
                this.yoffset = 0;
            } else {
                this.xoffset = this.position.x;
                this.yoffset = this.position.y;
            }
        }
    }

    public void clearImage() {
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.image.getWidth(this.parent), this.image.getHeight(this.parent));
        graphics.dispose();
    }

    public void updateImage() {
        Graphics graphics = this.image.getGraphics();
        this.updateGraphics(graphics);
        this.uptodate = true;
        graphics.dispose();
    }

    public void refresh() {
        if (!this.displayp) {
            return;
        }
        this.parent.repaint(this.position);
    }

    boolean getOffscreen() {
        if (this.parent.getToolbar().paintActivep()) {
            return false;
        }
        if (this.parent.outline() != null && this.position.intersects(this.parent.outline())) {
            return true;
        }
        Rectangle rectangle = this.parent.getBoundaries();
        if (!rectangle.contains(this.position.x, this.position.y) || !rectangle.contains(this.position.x + this.position.width, this.position.y + this.position.height)) {
            return true;
        }
        if (this.parent.draggingp() && (!this.parent.widgetTouched().isSelected() && this.parent.widgetTouched() == this || this.parent.widgetTouched().isSelected() && this.isSelected())) {
            return true;
        }
        if (this.parent.draggingp() && (!this.parent.widgetTouched().isSelected() && this.position.intersects(this.parent.widgetTouched().position) || this.parent.widgetTouched().isSelected() && this.position.intersects(this.parent.wh().getSelectRectWithHandles()))) {
            return true;
        }
        return this.parent.isObscured(this);
    }

    public void paint(Graphics graphics) {
        if (this.parent.resizingp() && this.parent.widgetTouched() == this && this.originalPosition != null) {
            graphics.drawImage(this.image, this.originalPosition.x, this.originalPosition.y, this);
            graphics.setColor(Color.gray);
            graphics.drawRect(this.position.x, this.position.y, this.position.width, this.position.height);
        } else {
            boolean bl = this.getOffscreen();
            boolean bl2 = false;
            if (bl != this.sl.offscreen) {
                this.setOffscreen(bl);
                boolean bl3 = bl2 = !bl;
            }
            if (!this.uptodate && this.displayp) {
                this.updateImage();
            }
            super.paint(graphics);
            if (bl2 && this.sl.locked) {
                this.sl.locked = false;
                this.sl.runningp.notify();
            }
        }
    }

    public void load(Vector vector, Interface interface_, StarLogo starLogo) {
        Rectangle rectangle = interface_.getBoundaries();
        int n = this.position.x - rectangle.x;
        int n2 = this.position.y - rectangle.y;
        int n3 = 0;
        while (n3 < vector.size()) {
            String string = vector.elementAt(n3).toString();
            if (string.equals("top-left")) {
                String string2 = vector.elementAt(n3 + 1).toString();
                String string3 = vector.elementAt(n3 + 2).toString();
                n2 = Integer.parseInt(string2);
                n = Integer.parseInt(string3);
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        this.setLocation(n + rectangle.x, n2 + rectangle.y);
    }

    public String getSaveString(boolean bl) {
        return this.getSaveString();
    }

    public String getSaveString() {
        Rectangle rectangle = this.parent.getBoundaries();
        return "SLCanvas\r\ntop-left " + (this.position.y - rectangle.y) + " " + (this.position.x - rectangle.x) + "\r\n\r\n";
    }

    void moveToFront() {
    }

    public void setSelected(boolean bl) {
        if (YoYo.applet != null) {
            return;
        }
        super.setSelected(bl);
        if (!bl) {
            // empty if block
        }
    }

    public void drawPCSize() {
    }

    void moveTurtleTo(Turtle turtle, int n, int n2) {
        Object object = this.sl.runningp;
        synchronized (object) {
            this.setDrawingSurface();
            double d = n / this.sl.cellsize;
            double d2 = n2 / this.sl.cellsize;
            this.sl.unlink(turtle);
            turtle.ycor = d2 + 0.5;
            turtle.xcor = d + 0.5;
            this.sl.wrapandlink(turtle);
            this.parent.repaint(this.position);
            this.deleteDrawingSurface();
        }
    }

    private final int getPatchDim(int n) {
        int n2 = (int)Math.round((double)n / (double)this.sl.cellsize);
        n2 -= 1 - (n2 & 1);
        return n2;
    }

    private final Dimension getPatchDim(int n, int n2, boolean bl) {
        n = this.getPatchDim(n);
        n2 = this.getPatchDim(n2);
        if (bl) {
            if (n > n2) {
                n = n2;
            } else {
                n2 = n;
            }
        }
        Dimension dimension = new Dimension(n, n2);
        return dimension;
    }

    public void endResize(MouseEvent mouseEvent, int n) {
        int n2 = this.position.width / this.sl.cellsize;
        int n3 = this.position.height / this.sl.cellsize;
        boolean bl = this.sl.resizePatches((n2 - 1) / 2, (n3 - 1) / 2, this.sl.cellsize, this.position.x, this.position.y, n);
    }

    public void resize(Point point, int n) {
        if (this.parent.firstresizep()) {
            this.originalPosition = new Rectangle(this.position);
        }
        super.resize(point, n);
        Dimension dimension = this.getPatchDim(this.position.width, this.position.height, this.parent.pressedShiftControlp());
        int n2 = dimension.width * this.sl.cellsize;
        int n3 = dimension.height * this.sl.cellsize;
        int n4 = this.position.width - n2;
        int n5 = this.position.height - n3;
        this.position.width = n2;
        this.position.height = n3;
        switch (n) {
            case 1: {
                this.position.x += n4;
                this.position.y += n5;
                break;
            }
            case 3: {
                this.position.x += n4;
                break;
            }
            case 2: {
                this.position.y += n5;
                break;
            }
        }
        this.parent.addHandlesToClipRect(this);
    }

    public void checkBounds(Rectangle rectangle) {
        if (this.position.x < rectangle.x) {
            this.position.x = rectangle.x;
        }
        if (this.position.y < rectangle.y) {
            this.position.y = rectangle.y;
        }
    }

    public boolean draggable(MouseEvent mouseEvent) {
        if (YoYo.applet != null) {
            return false;
        }
        if (!this.displayp) {
            return true;
        }
        if (this.parent.getToolbar().paintActivep()) {
            return false;
        }
        int n = mouseEvent.getX() - this.position.x;
        int n2 = mouseEvent.getY() - this.position.y;
        this.turtleTouched = this.touchingTurtle(n, n2);
        if (this.turtleTouched == null) {
            this.patchTouched = this.touchingPatch(n, n2);
        }
        return this.turtleTouched == null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.displayp) {
            return;
        }
        if (this.parent.getToolbar().paintActivep()) {
            this.paintMousePressed(mouseEvent);
        }
    }

    public void castShape(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < this.position.x) {
            n = this.position.x;
        } else if (n > this.position.x + this.position.width) {
            n = this.position.x + this.position.width - 1;
        }
        if (n2 < this.position.y) {
            n2 = this.position.y;
        } else if (n2 > this.position.y + this.position.height) {
            n2 = this.position.y + this.position.height - 1;
        }
        Patch patch = this.getPatchAt(n, n2);
        Turtle turtle = patch.topturtle;
        if (turtle == null) {
            return;
        }
        turtle.shape = this.sl.app.shapeChooser.selectedShape();
        this.drawTurtle(turtle);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.displayp) {
            return;
        }
        if (this.parent.getToolbar().paintActivep()) {
            this.paintMouseDragged(mouseEvent);
        } else if (this.turtleTouched != null) {
            int n = mouseEvent.getX() - this.position.x;
            int n2 = mouseEvent.getY() - this.position.y;
            if (n < 0) {
                n = 0;
            } else if (n >= this.position.width) {
                n = this.position.width - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= this.position.height) {
                n2 = this.position.height - 1;
            }
            this.moveTurtleTo(this.turtleTouched, n, n2);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.displayp) {
            return;
        }
        Colortool colortool = this.parent.colortool();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < this.position.x) {
            n = this.position.x;
        } else if (n > this.position.x + this.position.width) {
            n = this.position.x + this.position.width - 1;
        }
        if (n2 < this.position.y) {
            n2 = this.position.y;
        } else if (n2 > this.position.y + this.position.height) {
            n2 = this.position.y + this.position.height - 1;
        }
        if (!this.startOfPoly) {
            Patch patch;
            Vector vector = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
            this.mousedragx = n;
            this.mousedragy = n2;
            Vector vector2 = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
            this.setDrawingSurface();
            int n3 = 0;
            while (n3 < vector.size()) {
                patch = (Patch)vector.elementAt(n3);
                if (patch.topturtle == null) {
                    this.drawPatch(patch);
                } else {
                    this.drawTurtle(patch.topturtle);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < vector2.size()) {
                patch = (Patch)vector2.elementAt(n3);
                this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, colortool.curcolor);
                ++n3;
            }
            this.deleteDrawingSurface();
        }
    }

    void mouseDoubleClicked(MouseEvent mouseEvent) {
        if (!this.displayp) {
            return;
        }
        if (this.parent.getToolbar().paintActivep()) {
            if (this.parent.painttool().buttonDown == 9) {
                Colortool colortool = this.parent.colortool();
                Vector vector = this.patchesInLine(mouseEvent.getX(), mouseEvent.getY(), this.polyHeadx, this.polyHeady);
                this.setDrawingSurface();
                if (this.parent.paintselect().buttonDown == 0) {
                    int n = 0;
                    while (n < vector.size()) {
                        Patch patch = (Patch)vector.elementAt(n);
                        patch.pc = colortool.curcolor;
                        this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, patch.pc);
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < vector.size()) {
                        Patch patch = (Patch)vector.elementAt(n);
                        this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, colortool.curcolor, 0.0, 0);
                        ++n;
                    }
                }
                this.deleteDrawingSurface();
                this.startOfPoly = true;
                this.refresh();
                this.parent.maybeReleasePatchCanvas();
            }
        } else if (this.turtleTouched != null) {
            if (!this.turtleTouched.hasTMp) {
                this.turtleTouched.tm = Application.newTurtleMonitor(this.turtleTouched, 0.5, this.sl.app);
                this.turtleTouched.tm.initFrame();
                this.turtleTouched.hasTMp = true;
                this.turtleTouched.tm.setLocation(WindowPosition.nextPoint(this.turtleTouched.tm));
            }
            this.turtleTouched.tm.show();
            this.turtleTouched = null;
        } else if (this.patchTouched != null) {
            if (!this.patchTouched.hasPMp) {
                this.patchTouched.pm = Application.newPatchMonitor(this.patchTouched, 0.5, this.sl.app);
                this.patchTouched.pm.initFrame();
                this.patchTouched.hasPMp = true;
                this.patchTouched.pm.setLocation(WindowPosition.nextPoint(this.patchTouched.pm));
            }
            this.patchTouched.pm.show();
            this.patchTouched = null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.setDrawingSurface();
        if (this.parent.getToolbar().paintActivep() && this.displayp) {
            this.paintMouseReleased(mouseEvent);
            if (this.startOfPoly) {
                this.parent.maybeReleasePatchCanvas();
            }
            return;
        }
        this.turtleTouched = null;
        this.patchTouched = null;
        this.parent.maybeReleasePatchCanvas();
        this.deleteDrawingSurface();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.turtleTouched = null;
        this.patchTouched = null;
        this.parent.addToClipRect(this.position);
        super.mouseReleased(mouseEvent);
    }

    public void moveBy(Point point) {
        if (!this.displayp) {
            return;
        }
        super.moveBy(point);
        if (!this.sl.offscreen) {
            this.xoffset = this.position.x;
            this.yoffset = this.position.y;
        }
    }

    void paintMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Object object = this.parent.sl().runningp;
        synchronized (object) {
            this.parent.sl().locked = true;
        }
        if (n < this.position.x) {
            n = this.position.x;
        } else if (n > this.position.x + this.position.width) {
            n = this.position.x + this.position.width - 1;
        }
        if (n2 < this.position.y) {
            n2 = this.position.y;
        } else if (n2 > this.position.y + this.position.height) {
            n2 = this.position.y + this.position.height - 1;
        }
        Colortool colortool = this.parent.colortool();
        try {
            this.setDrawingSurface();
            switch (this.parent.painttool().buttonDown) {
                case 1: {
                    this.penMousePressed(n, n2);
                    break;
                }
                case 2: {
                    this.eraserMousePressed(n, n2);
                    break;
                }
                case 4: {
                    this.eyeDropperMousePressed(n, n2);
                    break;
                }
                case 3: 
                case 5: {
                    this.rectangleAndLineMousePressed(n, n2);
                    break;
                }
                case 6: {
                    this.fillRectangleMousePressed(n, n2);
                    break;
                }
                case 9: {
                    this.polygonMousePressed(n, n2);
                    break;
                }
                case 10: {
                    this.fillArea(mouseEvent);
                    break;
                }
                case 7: 
                case 8: {
                    this.ovalMousePressed(n, n2);
                    break;
                }
            }
            this.sl.app.project.markChanged();
        }
        finally {
            Object var5_7 = null;
            this.deleteDrawingSurface();
        }
    }

    void paintMouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < this.position.x) {
            n = this.position.x;
        } else if (n + 1 >= this.position.x + this.position.width) {
            n = this.position.x + this.position.width - 2;
        }
        if (n2 < this.position.y) {
            n2 = this.position.y;
        } else if (n2 + 1 >= this.position.y + this.position.height) {
            n2 = this.position.y + this.position.height - 2;
        }
        Colortool colortool = this.parent.colortool();
        try {
            this.setDrawingSurface();
            switch (this.parent.painttool().buttonDown) {
                case 1: {
                    this.penMouseDragged(n, n2);
                    break;
                }
                case 2: {
                    this.eraserMouseDragged(n, n2);
                    break;
                }
                case 4: {
                    this.eyeDropperMouseDragged(n, n2);
                    break;
                }
                case 5: {
                    this.rectangleMouseDragged(n, n2);
                    break;
                }
                case 6: {
                    this.fillRectangleMouseDragged(n, n2);
                    break;
                }
                case 3: {
                    this.lineMouseDragged(n, n2);
                    break;
                }
                case 9: {
                    this.polygonMouseDragged(n, n2);
                    break;
                }
                case 7: {
                    this.ovalMouseDragged(n, n2);
                    break;
                }
                case 8: {
                    this.fillOvalMouseDragged(n, n2);
                    break;
                }
            }
            this.sl.app.project.markChanged();
        }
        finally {
            Object var6_5 = null;
            this.deleteDrawingSurface();
        }
    }

    void paintMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < this.position.x) {
            n = this.position.x;
        } else if (n > this.position.x + this.position.width) {
            n = this.position.x + this.position.width - 1;
        }
        if (n2 < this.position.y) {
            n2 = this.position.y;
        } else if (n2 > this.position.y + this.position.height) {
            n2 = this.position.y + this.position.height - 1;
        }
        Colortool colortool = this.parent.colortool();
        try {
            switch (this.parent.painttool().buttonDown) {
                case 5: {
                    this.rectangleMouseReleased(n, n2);
                    break;
                }
                case 6: {
                    this.fillRectangleMouseReleased(n, n2);
                    break;
                }
                case 3: {
                    this.lineMouseReleased(n, n2);
                    break;
                }
                case 9: {
                    this.polygonMouseReleased(n, n2);
                    break;
                }
                case 7: {
                    this.ovalMouseReleased(n, n2);
                    break;
                }
                case 8: {
                    this.fillOvalMouseReleased(n, n2);
                    break;
                }
            }
            this.sl.app.project.markChanged();
        }
        finally {
            Object var6_5 = null;
            this.deleteDrawingSurface();
        }
    }

    void penMousePressed(int n, int n2) {
        Patch patch = this.getPatchAt(n, n2);
        if (this.parent.paintselect().buttonDown == 0) {
            patch.pc = this.parent.colortool().curcolor;
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            }
        } else {
            this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, this.parent.colortool().curcolor, 0.0, 0);
            this.mousedownx = (int)patch.xcor;
            this.mousedowny = (int)patch.ycor;
        }
    }

    void penMouseDragged(int n, int n2) {
        Patch patch = this.getPatchAt(n, n2);
        if (this.parent.paintselect().buttonDown == 0) {
            patch.pc = this.parent.colortool().curcolor;
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            }
        } else if (this.mousedownx != (int)patch.xcor || this.mousedowny != (int)patch.ycor) {
            this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, this.parent.colortool().curcolor, 0.0, 0);
            this.mousedownx = (int)patch.xcor;
            this.mousedowny = (int)patch.ycor;
        }
    }

    void eraserMousePressed(int n, int n2) {
        Patch patch = this.getPatchAt(n, n2);
        if (this.parent.paintselect().buttonDown == 0) {
            patch.pc = 0.0;
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            }
        } else {
            Turtle turtle = patch.topturtle;
            Turtle turtle2 = patch.tophiddenturtle;
            if (turtle != null) {
                this.sl.unlink(turtle);
                this.sl.die(turtle);
            }
            if (turtle2 != null) {
                this.sl.unlink(turtle2);
                this.sl.die(turtle2);
            }
            if (turtle != null || turtle2 != null) {
                this.mousedownx = (int)patch.xcor;
                this.mousedowny = (int)patch.ycor;
            } else {
                this.mousedownx = -1;
                this.mousedowny = -1;
            }
        }
    }

    void eraserMouseDragged(int n, int n2) {
        Patch patch = this.getPatchAt(n, n2);
        if (this.parent.paintselect().buttonDown == 0) {
            patch.pc = 0.0;
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            }
        } else if (this.mousedownx != (int)patch.xcor || this.mousedowny != (int)patch.ycor) {
            Turtle turtle = patch.topturtle;
            Turtle turtle2 = patch.tophiddenturtle;
            if (turtle != null) {
                this.sl.unlink(turtle);
                this.sl.die(turtle);
            }
            if (turtle2 != null) {
                this.sl.unlink(turtle2);
                this.sl.die(turtle2);
            }
            this.mousedownx = (int)patch.xcor;
            this.mousedowny = (int)patch.ycor;
        }
    }

    void eyeDropperMousePressed(int n, int n2) {
        Patch patch = this.getPatchAt(n, n2);
        if (this.parent.paintselect().buttonDown == 0) {
            if (this.parent.colortool().curcolor != (int)patch.pc) {
                this.parent.colortool().setColor((int)patch.pc);
            }
        } else {
            Turtle turtle = patch.topturtle;
            if (turtle != null && turtle.color != (double)this.parent.colortool().curcolor) {
                this.parent.colortool().setColor((int)turtle.color);
            }
        }
    }

    void eyeDropperMouseDragged(int n, int n2) {
        Patch patch = this.getPatchAt(n, n2);
        if (this.parent.paintselect().buttonDown == 0) {
            this.parent.colortool().setColor((int)patch.pc);
        } else {
            Turtle turtle = patch.topturtle;
            if (turtle != null) {
                this.parent.colortool().setColor((int)turtle.color);
            }
        }
    }

    void rectangleAndLineMousePressed(int n, int n2) {
        this.mousedownx = n;
        this.mousedowny = n2;
        this.mousedragx = this.mousedownx;
        this.mousedragy = this.mousedowny;
        Patch patch = this.getPatchAt(this.mousedownx, this.mousedowny);
        this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
    }

    void rectangleMouseDragged(int n, int n2) {
        Patch patch;
        Vector vector = this.patchesInRec(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        this.mousedragx = n;
        this.mousedragy = n2;
        Vector vector2 = this.patchesInRec(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (vector2.contains(patch)) {
                vector.removeElement(patch);
                vector2.removeElement(patch);
                --n3;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector2.size()) {
            patch = (Patch)vector2.elementAt(n3);
            this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
            ++n3;
        }
    }

    void rectangleMouseReleased(int n, int n2) {
        Patch patch;
        Vector vector = this.patchesInRec(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        this.mousedragx = n;
        this.mousedragy = n2;
        Vector vector2 = this.patchesInRec(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (vector2.contains(patch)) {
                vector.removeElement(patch);
                --n3;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        if (this.parent.paintselect().buttonDown == 0) {
            n3 = 0;
            while (n3 < vector2.size()) {
                patch = (Patch)vector2.elementAt(n3);
                patch.pc = this.parent.colortool().curcolor;
                if (patch.topturtle == null) {
                    this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, patch.pc);
                } else {
                    this.drawTurtle(patch.topturtle);
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < vector2.size()) {
                patch = (Patch)vector2.elementAt(n3);
                this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, this.parent.colortool().curcolor, 0.0, 0);
                ++n3;
            }
        }
    }

    void fillRectangleMousePressed(int n, int n2) {
        Patch patch = this.getPatchAt(n, n2);
        this.mousedownx = this.xoffset + ((int)patch.xcor - 1) * this.sl.cellsize;
        this.mousedowny = this.yoffset + ((int)patch.ycor - 1) * this.sl.cellsize;
        this.mousedragx = this.mousedownx;
        this.mousedragy = this.mousedowny;
        this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
    }

    void fillRectangleMouseDragged(int n, int n2) {
        boolean bl = this.mousedownx < this.mousedragx;
        boolean bl2 = this.mousedownx < n;
        boolean bl3 = this.mousedowny < this.mousedragy;
        boolean bl4 = this.mousedowny < n2;
        Patch patch = this.getPatchAt(n, n2);
        int n3 = ((int)patch.xcor - 1) * this.sl.cellsize + this.xoffset;
        int n4 = ((int)patch.ycor - 1) * this.sl.cellsize + this.yoffset;
        if ((bl && bl2 || !bl && !bl2) && (bl3 && bl4 || !bl3 && !bl4)) {
            this.handleFillRecDrag(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy, n, n2, this.parent.colortool().curcolor);
            this.mousedragx = n3;
            this.mousedragy = n4;
        } else {
            Vector vector = this.patchesInFillRec(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
            this.mousedragx = n3;
            this.mousedragy = n4;
            Vector vector2 = this.patchesInFillRec(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
            int n5 = 0;
            while (n5 < vector.size()) {
                patch = (Patch)vector.elementAt(n5);
                if (vector2.contains(patch)) {
                    vector.removeElement(patch);
                    vector2.removeElement(patch);
                    --n5;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < vector.size()) {
                patch = (Patch)vector.elementAt(n5);
                if (patch.topturtle == null) {
                    this.drawPatch(patch);
                } else {
                    this.drawTurtle(patch.topturtle);
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < vector2.size()) {
                patch = (Patch)vector2.elementAt(n5);
                this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
                ++n5;
            }
        }
    }

    void fillRectangleMouseReleased(int n, int n2) {
        Patch patch;
        int n3;
        Vector vector = this.patchesInFillRec(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        Patch patch2 = this.getPatchAt(n, n2);
        this.mousedragx = this.xoffset + ((int)patch2.xcor - 1) * this.sl.cellsize;
        this.mousedragy = this.yoffset + ((int)patch2.ycor - 1) * this.sl.cellsize;
        Vector vector2 = this.patchesInFillRec(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        if (this.parent.paintselect().buttonDown == 0) {
            n3 = 0;
            while (n3 < vector2.size()) {
                patch = (Patch)vector2.elementAt(n3);
                patch.pc = this.parent.colortool().curcolor;
                if (patch.topturtle == null) {
                    this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, patch.pc);
                } else {
                    this.drawTurtle(patch.topturtle);
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < vector2.size()) {
                patch = (Patch)vector2.elementAt(n3);
                this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, this.parent.colortool().curcolor, 0.0, 0);
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (vector2.contains(patch)) {
                if (this.parent.paintselect().buttonDown == 0 && patch.topturtle != null) {
                    this.drawTurtle(patch.topturtle);
                }
                vector.removeElement(patch);
                vector2.removeElement(patch);
                --n3;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector2.size()) {
            patch = (Patch)vector2.elementAt(n3);
            this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
            ++n3;
        }
    }

    void ovalMousePressed(int n, int n2) {
        this.mousedownx = n;
        this.mousedowny = n2;
        this.mousedragx = this.mousedownx;
        this.mousedragy = this.mousedowny;
    }

    void ovalMouseDragged(int n, int n2) {
        Patch patch;
        Vector vector = this.patchesInOval(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy, 0);
        this.mousedragx = n;
        this.mousedragy = n2;
        Vector vector2 = this.patchesInOval(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy, 0);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector2.size()) {
            patch = (Patch)vector2.elementAt(n3);
            this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
            ++n3;
        }
    }

    void ovalMouseReleased(int n, int n2) {
        Vector vector = this.patchesInOval(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy, 0);
        if (this.parent.paintselect().buttonDown == 0) {
            int n3 = 0;
            while (n3 < vector.size()) {
                Patch patch = (Patch)vector.elementAt(n3);
                patch.pc = this.parent.colortool().curcolor;
                if (patch.topturtle == null) {
                    this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, patch.pc);
                } else {
                    this.drawTurtle(patch.topturtle);
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < vector.size()) {
                Patch patch = (Patch)vector.elementAt(n4);
                this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, this.parent.colortool().curcolor, 0.0, 0);
                ++n4;
            }
        }
    }

    void fillOvalMouseDragged(int n, int n2) {
        Patch patch;
        Vector vector = this.patchesInOval(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy, 1);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        this.mousedragx = n;
        this.mousedragy = n2;
        vector = this.patchesInOval(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy, 1);
        n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
            ++n3;
        }
    }

    void fillOvalMouseReleased(int n, int n2) {
        Patch patch;
        Vector vector = this.patchesInOval(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy, 1);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        this.mousedragx = n;
        this.mousedragy = n2;
        vector = this.patchesInOval(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy, 1);
        if (this.parent.paintselect().buttonDown == 0) {
            n3 = 0;
            while (n3 < vector.size()) {
                patch = (Patch)vector.elementAt(n3);
                patch.pc = this.parent.colortool().curcolor;
                if (patch.topturtle == null) {
                    this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, patch.pc);
                } else {
                    this.drawTurtle(patch.topturtle);
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < vector.size()) {
                patch = (Patch)vector.elementAt(n3);
                this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, this.parent.colortool().curcolor, 0.0, 0);
                ++n3;
            }
        }
    }

    void lineMouseDragged(int n, int n2) {
        Patch patch;
        Vector vector = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        this.mousedragx = n;
        this.mousedragy = n2;
        Vector vector2 = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector2.size()) {
            patch = (Patch)vector2.elementAt(n3);
            this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
            ++n3;
        }
    }

    void lineMouseReleased(int n, int n2) {
        Patch patch;
        Vector vector = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        this.mousedragx = n;
        this.mousedragy = n2;
        Vector vector2 = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        if (this.parent.paintselect().buttonDown == 0) {
            n3 = 0;
            while (n3 < vector2.size()) {
                patch = (Patch)vector2.elementAt(n3);
                patch.pc = this.parent.colortool().curcolor;
                if (patch.topturtle == null) {
                    this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, patch.pc);
                } else {
                    this.drawTurtle(patch.topturtle);
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < vector2.size()) {
                patch = (Patch)vector2.elementAt(n3);
                this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, this.parent.colortool().curcolor, 0.0, 0);
                ++n3;
            }
        }
    }

    void polygonMousePressed(int n, int n2) {
        Patch patch;
        if (this.startOfPoly) {
            this.mousedownx = n;
            this.mousedowny = n2;
            this.mousedragx = this.mousedownx;
            this.mousedragy = this.mousedowny;
            Patch patch2 = this.getPatchAt(this.mousedownx, this.mousedowny);
            this.drawPatch(patch2.xcor - 1.0, patch2.ycor - 1.0, this.parent.colortool().curcolor);
            this.startOfPoly = false;
            this.polyHeadx = n;
            this.polyHeady = n2;
            return;
        }
        Vector vector = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        this.mousedragx = n;
        this.mousedragy = n2;
        Vector vector2 = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector2.size()) {
            patch = (Patch)vector2.elementAt(n3);
            if (this.parent.paintselect().buttonDown == 0) {
                patch.pc = this.parent.colortool().curcolor;
                this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, patch.pc);
            } else {
                this.sl.cct(patch.xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (patch.ycor - 1.0), 0.0, this.parent.colortool().curcolor, 0.0, 0);
            }
            ++n3;
        }
        this.mousedownx = this.mousedragx;
        this.mousedowny = this.mousedragy;
    }

    void polygonMouseDragged(int n, int n2) {
        Patch patch;
        Vector vector = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        this.mousedragx = n;
        this.mousedragy = n2;
        Vector vector2 = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
        int n3 = 0;
        while (n3 < vector.size()) {
            patch = (Patch)vector.elementAt(n3);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < vector2.size()) {
            patch = (Patch)vector2.elementAt(n3);
            this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, this.parent.colortool().curcolor);
            ++n3;
        }
    }

    void polygonMouseReleased(int n, int n2) {
        if (!this.parent.toolbar().paintActivep() || this.parent.painttool().buttonDown != 9) {
            Vector vector = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
            int n3 = 0;
            while (n3 < vector.size()) {
                Patch patch = (Patch)vector.elementAt(n3);
                if (patch.topturtle == null) {
                    this.drawPatch(patch);
                } else {
                    this.drawTurtle(patch.topturtle);
                }
                ++n3;
            }
            this.startOfPoly = true;
        }
    }

    public void clearPoly(MouseEvent mouseEvent) {
        if (!this.startOfPoly) {
            Vector vector = this.patchesInLine(this.mousedownx, this.mousedowny, this.mousedragx, this.mousedragy);
            int n = 0;
            while (n < vector.size()) {
                Patch patch = (Patch)vector.elementAt(n);
                this.drawPatch(patch);
                ++n;
            }
            this.startOfPoly = true;
            this.refresh();
        }
    }

    void fillArea(MouseEvent mouseEvent) {
        Object object;
        Colortool colortool = this.parent.colortool();
        Patch patch = this.getPatchAt(mouseEvent.getX(), mouseEvent.getY());
        Vector<Patch> vector = new Vector<Patch>(100);
        Vector<Integer> vector2 = new Vector<Integer>(100);
        Vector<Integer> vector3 = new Vector<Integer>(100);
        vector.addElement(patch);
        vector2.addElement(new Integer(mouseEvent.getX()));
        vector3.addElement(new Integer(mouseEvent.getY()));
        patch.checked = true;
        int n = (int)patch.pc;
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (Patch)vector.elementAt(n2);
            int n3 = (Integer)vector2.elementAt(n2);
            int n4 = (Integer)vector3.elementAt(n2);
            Patch patch2 = this.getPatchAt(n3 - this.sl.cellsize, n4);
            if (!patch2.checked && (int)patch2.pc == n && patch2.xcor < ((Patch)object).xcor) {
                vector.addElement(patch2);
                patch2.checked = true;
                vector2.addElement(new Integer(n3 - this.sl.cellsize));
                vector3.addElement(new Integer(n4));
            }
            patch2 = this.getPatchAt(n3 + this.sl.cellsize, n4);
            if (!patch2.checked && (int)patch2.pc == n && patch2.xcor > ((Patch)object).xcor) {
                vector.addElement(patch2);
                patch2.checked = true;
                vector2.addElement(new Integer(n3 + this.sl.cellsize));
                vector3.addElement(new Integer(n4));
            }
            patch2 = this.getPatchAt(n3, n4 - this.sl.cellsize);
            if (!patch2.checked && (int)patch2.pc == n && patch2.ycor < ((Patch)object).ycor) {
                vector.addElement(patch2);
                patch2.checked = true;
                vector2.addElement(new Integer(n3));
                vector3.addElement(new Integer(n4 - this.sl.cellsize));
            }
            patch2 = this.getPatchAt(n3, n4 + this.sl.cellsize);
            if (!patch2.checked && (int)patch2.pc == n && patch2.ycor > ((Patch)object).ycor) {
                vector.addElement(patch2);
                patch2.checked = true;
                vector2.addElement(new Integer(n3));
                vector3.addElement(new Integer(n4 + this.sl.cellsize));
            }
            ++n2;
        }
        if (this.parent.paintselect().buttonDown == 0) {
            n2 = 0;
            while (n2 < vector.size()) {
                object = (Patch)vector.elementAt(n2);
                ((Patch)object).checked = false;
                ((Patch)object).pc = colortool.curcolor;
                if (((Patch)object).topturtle == null) {
                    this.drawPatch((Patch)object);
                }
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < vector.size()) {
                object = (Patch)vector.elementAt(n2);
                ((Patch)object).checked = false;
                this.sl.cct(((Patch)object).xcor - 1.0 - (double)this.sl.halfwidth, (double)this.sl.halfheight - (((Patch)object).ycor - 1.0), 0.0, colortool.curcolor, 0.0, 0);
                ++n2;
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                Patch patch3 = (Patch)object.nextElement();
                this.drawTurtle(patch3.topturtle);
            }
        }
    }

    private final void handleFillRecDrag(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        Patch patch = this.getPatchAt(n, n2);
        n = this.xoffset + ((int)patch.xcor - 1) * this.sl.cellsize;
        n2 = this.yoffset + ((int)patch.ycor - 1) * this.sl.cellsize;
        patch = this.getPatchAt(n3, n4);
        n3 = this.xoffset + ((int)patch.xcor - 1) * this.sl.cellsize;
        n4 = this.yoffset + ((int)patch.ycor - 1) * this.sl.cellsize;
        patch = this.getPatchAt(n5, n6);
        n5 = this.xoffset + ((int)patch.xcor - 1) * this.sl.cellsize;
        n6 = this.yoffset + ((int)patch.ycor - 1) * this.sl.cellsize;
        Vector<Patch> vector = new Vector<Patch>();
        Vector<Patch> vector2 = new Vector<Patch>();
        if (n2 < n4) {
            n13 = n2;
            n12 = n4;
        } else {
            n13 = n4;
            n12 = n2;
        }
        if (n < n5 || n < n3) {
            n11 = n;
            n10 = n5;
            if (n3 < n5) {
                n9 = n3 + this.sl.cellsize;
                while (n9 <= n5) {
                    n8 = n13;
                    while (n8 <= n12) {
                        vector2.addElement(this.getPatchAt(n9, n8));
                        n8 += this.sl.cellsize;
                    }
                    n9 += this.sl.cellsize;
                }
            } else {
                n9 = n5 + this.sl.cellsize;
                while (n9 <= n3) {
                    n8 = n13;
                    while (n8 <= n12) {
                        vector.addElement(this.getPatchAt(n9, n8));
                        n8 += this.sl.cellsize;
                    }
                    n9 += this.sl.cellsize;
                }
            }
        } else {
            n11 = n5;
            n10 = n;
            if (n3 > n5) {
                n9 = n5;
                while (n9 <= n3 - this.sl.cellsize) {
                    n8 = n13;
                    while (n8 <= n12) {
                        vector2.addElement(this.getPatchAt(n9, n8));
                        n8 += this.sl.cellsize;
                    }
                    n9 += this.sl.cellsize;
                }
            } else {
                n9 = n3;
                while (n9 <= n5 - this.sl.cellsize) {
                    n8 = n13;
                    while (n8 <= n12) {
                        vector.addElement(this.getPatchAt(n9, n8));
                        n8 += this.sl.cellsize;
                    }
                    n9 += this.sl.cellsize;
                }
            }
        }
        n9 = 0;
        while (n9 < vector.size()) {
            patch = (Patch)vector.elementAt(n9);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < vector2.size()) {
            patch = (Patch)vector2.elementAt(n9);
            this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, n7);
            ++n9;
        }
        vector = new Vector();
        vector2 = new Vector();
        if (n2 < n6 || n2 < n4) {
            if (n4 < n6) {
                n9 = n4 + this.sl.cellsize;
                while (n9 <= n6) {
                    n8 = n11;
                    while (n8 <= n10) {
                        vector2.addElement(this.getPatchAt(n8, n9));
                        n8 += this.sl.cellsize;
                    }
                    n9 += this.sl.cellsize;
                }
            } else {
                n9 = n6 + this.sl.cellsize;
                while (n9 <= n4) {
                    n8 = n11;
                    while (n8 <= n10) {
                        vector.addElement(this.getPatchAt(n8, n9));
                        n8 += this.sl.cellsize;
                    }
                    n9 += this.sl.cellsize;
                }
            }
        } else if (n4 > n6) {
            n9 = n6;
            while (n9 <= n4 - this.sl.cellsize) {
                n8 = n11;
                while (n8 <= n10) {
                    vector2.addElement(this.getPatchAt(n8, n9));
                    n8 += this.sl.cellsize;
                }
                n9 += this.sl.cellsize;
            }
        } else {
            n9 = n4;
            while (n9 <= n6 - this.sl.cellsize) {
                n8 = n11;
                while (n8 <= n10) {
                    vector.addElement(this.getPatchAt(n8, n9));
                    n8 += this.sl.cellsize;
                }
                n9 += this.sl.cellsize;
            }
        }
        n9 = 0;
        while (n9 < vector.size()) {
            patch = (Patch)vector.elementAt(n9);
            if (patch.topturtle == null) {
                this.drawPatch(patch);
            } else {
                this.drawTurtle(patch.topturtle);
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < vector2.size()) {
            patch = (Patch)vector2.elementAt(n9);
            this.drawPatch(patch.xcor - 1.0, patch.ycor - 1.0, n7);
            ++n9;
        }
    }

    private final Vector patchesInRec(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n < n3) {
            n8 = n;
            n7 = n3;
        } else {
            n8 = n3;
            n7 = n;
        }
        if (n2 < n4) {
            n6 = n2;
            n5 = n4;
        } else {
            n6 = n4;
            n5 = n2;
        }
        int n9 = n < n3 ? n3 - n : n - n3;
        int n10 = n2 < n4 ? n4 - n2 : n2 - n4;
        Vector<Patch> vector = new Vector<Patch>(n9 + n9 + n10 + n10);
        int n11 = n8;
        while (n11 <= n7) {
            if (!vector.contains(this.getPatchAt(n11, n6))) {
                vector.addElement(this.getPatchAt(n11, n6));
            }
            ++n11;
        }
        if (n6 != n5) {
            n11 = n8;
            while (n11 <= n7) {
                if (!vector.contains(this.getPatchAt(n11, n5))) {
                    vector.addElement(this.getPatchAt(n11, n5));
                }
                ++n11;
            }
        }
        n11 = n6 + 1;
        while (n11 <= n5 - 1) {
            if (!vector.contains(this.getPatchAt(n8, n11))) {
                vector.addElement(this.getPatchAt(n8, n11));
            }
            ++n11;
        }
        if (n8 != n7) {
            n11 = n6 + 1;
            while (n11 <= n5 - 1) {
                if (!vector.contains(this.getPatchAt(n7, n11))) {
                    vector.addElement(this.getPatchAt(n7, n11));
                }
                ++n11;
            }
        }
        return vector;
    }

    private final Vector patchesInFillRec(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n < n3) {
            n8 = n;
            n7 = n3;
        } else {
            n8 = n3;
            n7 = n;
        }
        if (n2 < n4) {
            n6 = n2;
            n5 = n4;
        } else {
            n6 = n4;
            n5 = n2;
        }
        int n9 = n < n3 ? n3 - n : n - n3;
        int n10 = n2 < n4 ? n4 - n2 : n2 - n4;
        Vector<Patch> vector = new Vector<Patch>(n9 * n10);
        int n11 = n8;
        while (n11 <= n7) {
            int n12 = n6;
            while (n12 <= n5) {
                vector.addElement(this.getPatchAt(n11, n12));
                n12 += this.sl.cellsize;
            }
            n11 += this.sl.cellsize;
        }
        return vector;
    }

    private final Vector patchesInLine(int n, int n2, int n3, int n4) {
        int n5 = n < n3 ? n3 - n : n - n3;
        int n6 = n2 < n4 ? n4 - n2 : n2 - n4;
        Vector<Patch> vector = new Vector<Patch>(n5 + n6);
        if (n5 > n6) {
            if (n < n3) {
                int n7 = n;
                while (n7 <= n3) {
                    int n8 = (n4 - n2) * (n7 - n) / n5 + n2;
                    vector.addElement(this.getPatchAt(n7, n8));
                    n7 += this.sl.cellsize;
                }
            } else if (n > n3) {
                int n9 = n3;
                while (n9 <= n) {
                    int n10 = (n4 - n2) * (n9 - n) / (n3 - n) + n2;
                    vector.addElement(this.getPatchAt(n9, n10));
                    n9 += this.sl.cellsize;
                }
            }
        } else if (n2 < n4) {
            int n11 = n2;
            while (n11 <= n4) {
                int n12 = (n3 - n) * (n11 - n2) / n6 + n;
                vector.addElement(this.getPatchAt(n12, n11));
                n11 += this.sl.cellsize;
            }
        } else if (n2 > n4) {
            int n13 = n4;
            while (n13 <= n2) {
                int n14 = (n3 - n) * (n13 - n2) / (n4 - n2) + n;
                vector.addElement(this.getPatchAt(n14, n13));
                n13 += this.sl.cellsize;
            }
        } else {
            vector.addElement(this.getPatchAt(n, n2));
        }
        return vector;
    }

    void addPointToOval(Vector vector, int n, int n2, int n3, int n4, int n5) {
        Patch patch = this.getPatchAt(0, 0);
        boolean bl = true;
        int n6 = (n + n3) / 2;
        int n7 = (n2 + n4) / 2;
        int n8 = (n - n3 - this.sl.cellsize) / 2;
        int n9 = (n2 - n4 - this.sl.cellsize) / 2;
        if (n3 / this.sl.cellsize > this.ovalMaxX) {
            this.ovalMaxX = n3 / this.sl.cellsize;
        }
        if (n4 / this.sl.cellsize > this.ovalMaxY) {
            this.ovalMaxY = n4 / this.sl.cellsize;
        }
        if (n5 == 1) {
            int n10 = n8;
            while (bl || patch.xcor < this.getPatchAt((int)n6, (int)n7).xcor) {
                bl = false;
                patch = this.getPatchAt(n10, n9);
                if (!vector.contains(patch)) {
                    vector.addElement(patch);
                }
                if (!vector.contains(patch = this.getPatchAt(n10, n7))) {
                    vector.addElement(patch);
                }
                n10 += this.sl.cellsize;
            }
        } else {
            patch = this.getPatchAt(n8, n9);
            if (!vector.contains(patch)) {
                vector.addElement(patch);
            }
            if (!vector.contains(patch = this.getPatchAt(n6, n9))) {
                vector.addElement(patch);
            }
            if (!vector.contains(patch = this.getPatchAt(n8, n7))) {
                vector.addElement(patch);
            }
            if (!vector.contains(patch = this.getPatchAt(n6, n7))) {
                vector.addElement(patch);
            }
        }
    }

    private final Vector patchesInOval(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (n > n3) {
            n7 = n;
            n = n3;
            n3 = n7;
        }
        if (n2 > n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        n7 = (n3 -= this.sl.cellsize / 2) - n;
        n6 = (n4 -= this.sl.cellsize / 2) - n2;
        if (n7 < 2 * this.sl.cellsize) {
            return this.patchesInRec(n, n2, n3, n4);
        }
        if (n6 < 2 * this.sl.cellsize) {
            return this.patchesInRec(n, n2, n3, n4);
        }
        Vector vector = n5 == 1 ? new Vector((1 + n7 / this.sl.cellsize) * (1 + n6 / this.sl.cellsize)) : new Vector(2 * (1 + n7 / this.sl.cellsize) + 2 * (1 + n6 / this.sl.cellsize));
        int n8 = n + n3 + this.sl.cellsize;
        int n9 = n2 + n4 + this.sl.cellsize;
        int n10 = n6 * n6;
        int n11 = n7 * n7;
        int n12 = 0;
        int n13 = n6;
        while ((double)(n6 * n12) / ((double)n11 * Math.sqrt(1.0 - (double)(n12 * n12) / (double)n11)) <= 1.05) {
            this.addPointToOval(vector, n8, n9, n12, n13, n5);
            n13 = (int)Math.sqrt((double)n10 * (1.0 - (double)((n12 += 2 * this.sl.cellsize) * n12) / (double)n11));
        }
        this.addPointToOval(vector, n8, n9, n12, n13, n5);
        n13 = 0;
        n12 = n7;
        while ((double)(n7 * n13) / ((double)n10 * Math.sqrt(1.0 - (double)(n13 * n13) / (double)n10)) <= 1.05) {
            this.addPointToOval(vector, n8, n9, n12, n13, n5);
            n12 = (int)Math.sqrt((double)n11 * (1.0 - (double)((n13 += 2 * this.sl.cellsize) * n13) / (double)n10));
        }
        this.addPointToOval(vector, n8, n9, 0, n6, n5);
        this.addPointToOval(vector, n8, n9, n7, 0, n5);
        return vector;
    }

    Turtle touchingTurtle(int n, int n2) {
        double d = n / this.sl.cellsize;
        double d2 = n2 / this.sl.cellsize;
        int n3 = this.sl.patchat(d, d2);
        return this.sl.patches[n3].topturtle;
    }

    Patch touchingPatch(int n, int n2) {
        double d = n / this.sl.cellsize;
        double d2 = n2 / this.sl.cellsize;
        int n3 = this.sl.patchat(d, d2);
        return this.sl.patches[n3];
    }

    Patch getPatchAt(int n, int n2) {
        double d = (n - this.position.x) / this.sl.cellsize;
        double d2 = (n2 - this.position.y) / this.sl.cellsize;
        int n3 = this.sl.patchat(d, d2);
        return this.sl.patches[n3];
    }

    public static void readImage(StarLogo starLogo, ImageProducer imageProducer, int n, int n2, Pictures pictures) {
        Thread.currentThread();
        Thread.yield();
        if (!(n == starLogo.width && n2 == starLogo.height || loadCanceled)) {
            starLogo.resizePatches(n / 2, n2 / 2, starLogo.cellsize);
        }
        Thread.currentThread();
        Thread.yield();
        starLogo.patchcanvas.loadImage(imageProducer, pictures, n, n2);
    }

    public void loadImage(ImageProducer imageProducer, Pictures pictures, int n, int n2) {
        if (!loadCanceled) {
            this.ip = imageProducer;
            imageProducer.addConsumer(this);
            this.pictures = pictures;
            this.setDimensions(n, n2);
            imageProducer.startProduction(this);
        }
    }

    public void cancelImageLoad() {
        loadCanceled = true;
        if (this.ip != null) {
            this.ip.removeConsumer(this);
        }
        this.ip = null;
        this.rerror = null;
        this.gerror = null;
        this.berror = null;
        this.uptodate = false;
        this.parent.repaint(this.position);
    }

    public void imageComplete(int n) {
        this.ip.removeConsumer(this);
        this.ip = null;
        this.rerror = null;
        this.gerror = null;
        this.berror = null;
        this.uptodate = false;
        this.parent.repaint(this.position);
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        this.rerror = new double[n * n2];
        this.gerror = new double[n * n2];
        this.berror = new double[n * n2];
        this.widthIP = n;
        this.heightIP = n;
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        try {
            int n7 = this.sl.widthp2 * (n2 + 1) + n;
            int n8 = this.widthIP * n2 + n;
            int n9 = n2;
            while (n9 < n2 + n4) {
                int n10 = n;
                while (n10 < n + n3) {
                    double d;
                    int n11;
                    int n12;
                    byte by = byArray[(n9 - n2) * n6 + n10 - n + n5];
                    int n13 = colorModel.getRGB(by & 0xFF);
                    int n14 = n13 >> 16 & 0xFF;
                    int n15 = n13 >> 8 & 0xFF;
                    int n16 = n13 & 0xFF;
                    int n17 = (int)((double)n14 + this.rerror[n8 + n10]);
                    if (n17 > 255) {
                        n17 = 255;
                    }
                    if (n17 < 0) {
                        n17 = 0;
                    }
                    if ((n12 = (int)((double)n15 + this.gerror[n8 + n10])) > 255) {
                        n12 = 255;
                    }
                    if (n12 < 0) {
                        n12 = 0;
                    }
                    if ((n11 = (int)((double)n16 + this.berror[n8 + n10])) > 255) {
                        n11 = 255;
                    }
                    if (n11 < 0) {
                        n11 = 0;
                    }
                    int n18 = n17 << 16 | n12 << 8 | n11;
                    this.sl.patches[n7 + n10].pc = d = Colors.mapColorToStarLogoColor(n18);
                    int n19 = Colors.colorarrayints[(int)(d * 32.0)];
                    int n20 = n19 >> 16 & 0xFF;
                    int n21 = n19 >> 8 & 0xFF;
                    int n22 = n19 & 0xFF;
                    int n23 = n17 - n20;
                    int n24 = n12 - n21;
                    int n25 = n11 - n22;
                    if (n10 < n3 - 1) {
                        this.rerror[n8 + n10 + 1] = (double)n23 * 0.4375;
                        this.gerror[n8 + n10 + 1] = (double)n24 * 0.4375;
                        this.berror[n8 + n10 + 1] = (double)n25 * 0.4375;
                        if (n9 < n4 - 1) {
                            this.rerror[n8 + n10 + this.widthIP + 1] = (double)n23 * 0.0625;
                            this.gerror[n8 + n10 + this.widthIP + 1] = (double)n24 * 0.0625;
                            this.berror[n8 + n10 + this.widthIP + 1] = (double)n25 * 0.0625;
                        }
                    }
                    if (n9 < n4 - 1) {
                        this.rerror[n8 + n10 + this.widthIP] = (double)n23 * 0.3125;
                        this.gerror[n8 + n10 + this.widthIP] = (double)n24 * 0.3125;
                        this.berror[n8 + n10 + this.widthIP] = (double)n25 * 0.3125;
                        if (n10 > 1) {
                            this.rerror[n8 + n10 + this.widthIP - 1] = (double)n23 * 0.1875;
                            this.gerror[n8 + n10 + this.widthIP - 1] = (double)n24 * 0.1875;
                            this.berror[n8 + n10 + this.widthIP - 1] = (double)n25 * 0.1875;
                        }
                    }
                    ++n10;
                }
                n7 += this.sl.widthp2;
                n8 += this.widthIP;
                ++n9;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        try {
            int n7 = this.sl.widthp2 * (n2 + 1) + n;
            int n8 = this.widthIP * n2 + n;
            int n9 = n2;
            while (n9 < n2 + n4) {
                int n10 = n;
                while (n10 < n + n3) {
                    double d;
                    int n11;
                    int n12;
                    int n13 = nArray[(n9 - n2) * n6 + n10 - n + n5];
                    int n14 = colorModel.getRGB(n13);
                    int n15 = n14 >> 16 & 0xFF;
                    int n16 = n14 >> 8 & 0xFF;
                    int n17 = n14 & 0xFF;
                    int n18 = (int)((double)n15 + this.rerror[n8 + n10]);
                    if (n18 > 255) {
                        n18 = 255;
                    }
                    if (n18 < 0) {
                        n18 = 0;
                    }
                    if ((n12 = (int)((double)n16 + this.gerror[n8 + n10])) > 255) {
                        n12 = 255;
                    }
                    if (n12 < 0) {
                        n12 = 0;
                    }
                    if ((n11 = (int)((double)n17 + this.berror[n8 + n10])) > 255) {
                        n11 = 255;
                    }
                    if (n11 < 0) {
                        n11 = 0;
                    }
                    int n19 = n18 << 16 | n12 << 8 | n11;
                    this.sl.patches[n7 + n10].pc = d = Colors.mapColorToStarLogoColor(n19);
                    int n20 = Colors.colorarrayints[(int)(d * 32.0)];
                    int n21 = n20 >> 16 & 0xFF;
                    int n22 = n20 >> 8 & 0xFF;
                    int n23 = n20 & 0xFF;
                    int n24 = n18 - n21;
                    int n25 = n12 - n22;
                    int n26 = n11 - n23;
                    if (n10 < n3 - 1) {
                        this.rerror[n8 + n10 + 1] = (double)n24 * 0.4375;
                        this.gerror[n8 + n10 + 1] = (double)n25 * 0.4375;
                        this.berror[n8 + n10 + 1] = (double)n26 * 0.4375;
                        if (n9 < n4 - 1) {
                            this.rerror[n8 + n10 + this.widthIP + 1] = (double)n24 * 0.0625;
                            this.gerror[n8 + n10 + this.widthIP + 1] = (double)n25 * 0.0625;
                            this.berror[n8 + n10 + this.widthIP + 1] = (double)n26 * 0.0625;
                        }
                    }
                    if (n9 < n4 - 1) {
                        this.rerror[n8 + n10 + this.widthIP] = (double)n24 * 0.3125;
                        this.gerror[n8 + n10 + this.widthIP] = (double)n25 * 0.3125;
                        this.berror[n8 + n10 + this.widthIP] = (double)n26 * 0.3125;
                        if (n10 > 1) {
                            this.rerror[n8 + n10 + this.widthIP - 1] = (double)n24 * 0.1875;
                            this.gerror[n8 + n10 + this.widthIP - 1] = (double)n25 * 0.1875;
                            this.berror[n8 + n10 + this.widthIP - 1] = (double)n26 * 0.1875;
                        }
                    }
                    ++n10;
                }
                n7 += this.sl.widthp2;
                n8 += this.widthIP;
                ++n9;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setProperties(Hashtable hashtable) {
    }

    public PatchCanvas(StarLogo starLogo) {
        this.sl = starLogo;
        this.setSize(starLogo.width * starLogo.cellsize, starLogo.height * starLogo.cellsize);
        this.MIN_WIDTH = 3 * starLogo.cellsize;
        this.MIN_HEIGHT = 3 * starLogo.cellsize;
    }

    public PatchCanvas(StarLogo starLogo, PatchCanvas patchCanvas) {
        super(patchCanvas);
        this.sl = starLogo;
        this.setSize(starLogo.width * starLogo.cellsize, starLogo.height * starLogo.cellsize);
        this.obscured = patchCanvas.obscured;
        this.MIN_WIDTH = patchCanvas.MIN_WIDTH;
        this.MIN_HEIGHT = patchCanvas.MIN_HEIGHT;
    }
}

