/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REFilterInputStream;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import starlogo.Application;
import starlogo.ChoiceDialog;
import starlogo.ControlCenter;
import starlogo.FastPatchStackProcess;
import starlogo.InfoWindow;
import starlogo.Interface;
import starlogo.JBackupChoiceDialog;
import starlogo.OutputWindow;
import starlogo.SLURL;
import starlogo.StackProcess;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.TextDialog;
import starlogo.Timer;
import starlogo.TimerNotify;
import starlogo.TurtleShapes;
import template.Template;
import yoyo.Context;
import yoyo.PrimFile;
import yoyo.Symbol;
import yoyo.Tokenizer;
import yoyo.YoYo;
import yoyo.YoYoCaller;

public class Project
implements YoYoCaller,
TimerNotify {
    public static String HEADER = "Java StarLogo";
    public static String CURRENT_VERSION = "2.0";
    public static String MAC_VERSION = "MAC";
    static Timer timer;
    private static int BACKUP_DELAY;
    static SLURL curDir;
    static final int YES = 0;
    static final int NO = 1;
    static final int CANCEL = 2;
    public static final int SAVE_OUTPUT = 1;
    public static final int SAVE_INFO = 2;
    private boolean contentsChanged;
    SLURL filename;
    SLURL outputFilename;
    SLURL infoFilename;
    StarLogo sl;
    ControlCenter procWin;
    InfoWindow infoWin;
    OutputWindow outWin;
    Interface iface;
    String version;
    Template theTemplate;
    SLURL backupPendingDeletion;
    Application app;
    public boolean quittingp = false;
    boolean compilingp = false;
    private static /* synthetic */ Class class$Lstarlogo$Project;

    public static Project newProject(Application application) {
        StarLogo starLogo = application.sl;
        ControlCenter controlCenter = application.procWin;
        InfoWindow infoWindow = application.infoWin;
        OutputWindow outputWindow = application.outWin;
        Interface interface_ = application.iface;
        Project project = application.project;
        if (project.saveChanges(application) == 2) {
            return project;
        }
        Object object = starLogo.runningp;
        synchronized (object) {
            starLogo.stopAll();
        }
        application.iface.setTitle("StarLogo");
        application.procWin.setTitle("Control Center");
        if (YoYo.language == 1) {
            application.procWin.setTitle("Centro de Mandos");
        }
        controlCenter.reset();
        controlCenter.clearProcs();
        interface_.reset();
        infoWindow.reset();
        outputWindow.reset();
        interface_.repaint();
        StackProcess.pool.clearPool();
        FastPatchStackProcess.pool.clearPool();
        Project project2 = new Project(application);
        project2.compile(application);
        starLogo.CA();
        starLogo.crt(100);
        starLogo.redraw();
        project2.clearChanged();
        application.project = project2;
        return project2;
    }

    public static Project openProject(Application application) {
        if (application.project.saveChanges(application) == 2) {
            return application.project;
        }
        SLURL sLURL = null;
        if (YoYo.applet == null) {
            FileDialog fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Open Project...", 0);
            if (YoYo.language == 1) {
                fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Abra Proyecto...", 0);
            }
            if (curDir != null && curDir.getProtocol() == 3) {
                fileDialog.setDirectory(curDir.getFullPath());
            }
            fileDialog.setFilenameFilter(application.projectFileFilter);
            fileDialog.show();
            curDir = new SLURL(3, fileDialog.getDirectory());
            sLURL = fileDialog.getFile() != null ? new SLURL(3, curDir.getPath(), fileDialog.getFile()) : null;
            fileDialog.dispose();
        } else {
            TextDialog textDialog = Application.createTextDialog((Frame)((Object)application.activeFrame), "Open Project...", "Please type in the filename (relative to this web page):");
            if (YoYo.language == 1) {
                textDialog = Application.createTextDialog((Frame)((Object)application.activeFrame), "Abra Proyecto...", "Escriba el nombre del archivo (relativo a esta pagina web):");
            }
            sLURL = new SLURL(YoYo.applet.getCodeBase());
            sLURL.setFile(textDialog.getResult());
            textDialog.dispose();
        }
        if (sLURL != null) {
            application.project = Project.loadFile(sLURL, application, false);
            Project.runStartup(application);
        }
        return application.project;
    }

    public static void runStartup(Application application) {
        if (YoYo.applet != null) {
            int n = application.sl.internalGetWhichip("startup");
            if (n == -1) {
                return;
            }
            int[] nArray = new int[]{1792, n, 0, 0, 0};
            Object[] objectArray = new Object[]{};
            String string = "run-startup";
            n = application.sl.internalSetInstructions(string, nArray, objectArray);
            StackProcessParent.runObserver(application.sl, n, false, null);
        } else {
            Object[] objectArray = new Object[]{Symbol.lookup("compile-run-startup")};
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = application.procWin.getSLCommand(1);
            application.cc.enqueue(objectArray2, application.message, application.err, null);
            ControlCenter cfr_ignored_0 = application.procWin;
            application.procWin.getSLProc(ControlCenter.tur).gotoLine(0);
            ControlCenter cfr_ignored_1 = application.procWin;
            application.procWin.getSLProc(ControlCenter.obs).gotoLine(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Project loadFile(SLURL sLURL, Application application, boolean bl) {
        Project project;
        block15: {
            Project project2;
            block16: {
                project = application.project;
                try {
                    try {
                        application.setCursor(Cursor.getPredefinedCursor(3));
                        String string = sLURL.load(application.sl.c);
                        String string2 = sLURL.getFileNoExtension();
                        if (timer != null) {
                            timer.abort();
                        }
                        timer = null;
                        if (sLURL.getProtocol() == 3 && YoYo.applet == null) {
                            boolean bl2;
                            boolean bl3 = bl2 = YoYo.language == 1;
                            if (sLURL.getFileNoExtension().indexOf(Project.getBackupTag()) >= 0) {
                                SLURL sLURL2 = Project.getFileFromBackup(sLURL);
                                File file = new File(sLURL2.getFullPath());
                                if (file.exists()) {
                                    File file2;
                                    JBackupChoiceDialog jBackupChoiceDialog = bl2 ? new JBackupChoiceDialog((Frame)((Object)application.activeFrame), "Mensaje de StarLogo", "El proyecto que ha elegido es un archivo de reserva. \u00bfTiene gusto de restaurarlo? (Si no, la reserva ser\u00e1 quitado.)", "S\u00ed", "Cancele", "No") : new JBackupChoiceDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "The project you have selected is a backup file. Would you like to restore it? (the backup will be removed otherwise.)", "Yes", "Cancel", "No");
                                    String string3 = jBackupChoiceDialog.getResult();
                                    if (string3.equals("Yes") || string3.equals("S\u00ed")) {
                                        file2 = new File(Project.getFileFromBackup(sLURL).getFullPath());
                                        file2.delete();
                                        File file3 = new File(sLURL.getFullPath());
                                        file3.renameTo(file2);
                                        project = Project.loadFile(Project.getFileFromBackup(sLURL), application, bl);
                                    } else {
                                        if (!string3.equals("No")) {
                                            Project project3 = project;
                                            Object var5_21 = null;
                                            application.restoreCursor();
                                            return project3;
                                        }
                                        file2 = new File(sLURL.getFullPath());
                                        file2.delete();
                                        project = Project.loadFile(Project.getFileFromBackup(sLURL), application, bl);
                                    }
                                    file2 = new File(sLURL.getFullPath());
                                    file2.renameTo(file);
                                    project = Project.loadFile(Project.getFileFromBackup(sLURL), application, bl);
                                }
                                break block15;
                            }
                            SLURL sLURL3 = Project.getBackupFromFile(sLURL);
                            File file = new File(sLURL3.getFullPath());
                            if (file.exists()) {
                                JBackupChoiceDialog jBackupChoiceDialog = bl2 ? new JBackupChoiceDialog((Frame)((Object)application.activeFrame), "Mensaje de StarLogo", "El proyecto que ha elegido tiene un archivo de reserva. \u00bfTiene gusto de restaurarlo? (Si no, la reserva ser\u00e1 quitado.)", "S\u00ed", "Cancele", "No") : new JBackupChoiceDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "The project you have selected has a backup file. Would you like to restore it? (The backup will be removed otherwise.)", "Yes", "Cancel", "No");
                                String string4 = jBackupChoiceDialog.getResult();
                                if (string4.equals("Yes") || string4.equals("S\u00ed")) {
                                    File file4 = new File(sLURL.getFullPath());
                                    file4.delete();
                                    file.renameTo(file4);
                                    project = Project.loadFile(sLURL, application, bl);
                                    break block15;
                                }
                                if (string4.equals("No")) {
                                    file.delete();
                                    project = Project.loadFile(sLURL, application, bl);
                                    break block15;
                                }
                                project2 = project;
                                break block16;
                            }
                            project = Project.loadFromString(application, string, string2, sLURL, application.project, bl);
                            timer = new Timer(project, BACKUP_DELAY);
                            break block15;
                        }
                        project = Project.loadFromString(application, string, string2, sLURL, application.project, bl);
                        break block15;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error loading project file: " + exception.toString(), false);
                        Object var5_24 = null;
                        application.restoreCursor();
                        return project;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_25 = null;
                    application.restoreCursor();
                    throw throwable;
                }
            }
            Object var5_22 = null;
            application.restoreCursor();
            return project2;
        }
        Object var5_23 = null;
        application.restoreCursor();
        return project;
    }

    public static Project openURLProject(Application application) {
        Project project;
        block8: {
            if (application.project.saveChanges(application) == 2) {
                return application.project;
            }
            TextDialog textDialog = Application.createTextDialog((Frame)((Object)application.activeFrame), "Open Project...", "Please type in the complete URL:");
            if (YoYo.language == 1) {
                textDialog = Application.createTextDialog((Frame)((Object)application.activeFrame), "Abra Proyecto...", "Escriba el URL completo:");
            }
            String string = textDialog.getResult();
            textDialog.dispose();
            project = application.project;
            if (string != null) {
                try {
                    try {
                        application.setCursor(Cursor.getPredefinedCursor(3));
                        SLURL sLURL = new SLURL(new URL(string));
                        String string2 = sLURL.load(application.sl.c);
                        String string3 = sLURL.getFileNoExtension();
                        project = Project.loadFromString(application, string2, string3, sLURL, application.project, false);
                        project.filename = sLURL;
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                        Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error loading project file:  The specified URL does not exist.", false);
                        Object var5_10 = null;
                        application.restoreCursor();
                        break block8;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error loading project file: " + exception.getMessage(), false);
                        Object var5_11 = null;
                        application.restoreCursor();
                    }
                    Object var5_9 = null;
                    application.restoreCursor();
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    application.restoreCursor();
                    throw throwable;
                }
            }
        }
        application.project = project;
        Project.runStartup(application);
        return project;
    }

    private static final Project loadFromString(Application application, String string, String string2, SLURL sLURL, Project project, boolean bl) throws Exception {
        block12: {
            try {
                string = string.trim();
                if (!string.startsWith(HEADER)) {
                    string = Project.convertFormat(string);
                }
                if (string.startsWith(HEADER)) {
                    Object object = project.sl.runningp;
                    synchronized (object) {
                        project.sl.stopAll();
                    }
                    application.project = project = new Project(application);
                    project.setVersion(string);
                    if (!bl) {
                        project.procWin.deleteObservers();
                    }
                    project.sl.restoreTables(string, project.sl.c);
                    project.iface.loadFromString(string, bl);
                    TurtleShapes.loadShapes(string, true, application);
                    if (!bl) {
                        // empty if block
                    }
                    project.sl.restoreSettings(string, bl);
                    project.sl.restoreWorld(string, project.sl.c);
                    if (!bl) {
                        project.procWin.clearProcs();
                        project.procWin.resetText(string);
                        project.infoWin.resetText(string);
                        project.outWin.reset();
                        if (YoYo.swingavailablep && !YoYo.macintoshp) {
                            project.theTemplate.load(string);
                        }
                    }
                    StackProcess.pool.clearPool();
                    FastPatchStackProcess.pool.clearPool();
                    project.filename = sLURL;
                    if (!bl) {
                        application.iface.setTitle("StarLogo - " + string2);
                        application.procWin.setTitle("Control Center - " + string2);
                    }
                    project.iface.repaint();
                    project.compile(application);
                    project.clearChanged();
                    break block12;
                }
                Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", sLURL.toString() + " is not a valid StarLogo file.", false);
            }
            catch (Exception exception) {
                exception.printStackTrace(application.log);
                throw exception;
            }
        }
        return project;
    }

    public boolean quit(Application application) {
        boolean bl;
        if (this.quittingp) {
            return false;
        }
        try {
            this.quittingp = true;
            if (this.saveChanges(application) != 2) {
                System.exit(0);
                boolean bl2 = true;
                Object var3_4 = null;
                this.quittingp = false;
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.quittingp = false;
            throw throwable;
        }
        Object var3_5 = null;
        this.quittingp = false;
        return bl;
    }

    public void markChanged() {
        this.contentsChanged = true;
        this.app.markChanged();
    }

    public void clearChanged() {
        this.contentsChanged = false;
        this.app.clearChanged();
    }

    int saveChanges(Application application) {
        if (this.contentsChanged) {
            if (YoYo.language == 0) {
                ChoiceDialog choiceDialog = Application.createChoiceDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Do you want to save the changes you made to the current project?", "Save", "Cancel", "Don't Save");
                String string = choiceDialog.getResult();
                if (string.equals("Save")) {
                    return this.saveProject(application, false) ? 0 : 2;
                }
                if (string.equals("Don't Save")) {
                    if (this.backupPendingDeletion != null) {
                        File file = new File(this.backupPendingDeletion.getFullPath());
                        file.delete();
                        this.backupPendingDeletion = null;
                    }
                    return 1;
                }
                return 2;
            }
            if (YoYo.language == 1) {
                ChoiceDialog choiceDialog = Application.createChoiceDialog((Frame)((Object)application.activeFrame), "Mensaje de StarLogo", "Guarde cambios al proyecto corriente?", "Guarde", "Cancele", "No Guarde");
                String string = choiceDialog.getResult();
                if (string.equals("Guarde")) {
                    return this.saveProject(application, false) ? 0 : 2;
                }
                if (string.equals("No Guarde")) {
                    if (this.backupPendingDeletion != null) {
                        File file = new File(this.backupPendingDeletion.getFullPath());
                        file.delete();
                        this.backupPendingDeletion = null;
                    }
                    return 1;
                }
                return 2;
            }
        }
        return 0;
    }

    public boolean saveProject(Application application, boolean bl) {
        this.sl.app.maybeCompile();
        if (this.filename == null) {
            return this.saveProjectAs(application, bl);
        }
        return this.saveFile(this.filename, application, bl);
    }

    public boolean saveVersion(Application application) {
        if (this.filename == null) {
            return this.saveProjectAs(application, false);
        }
        return this.saveProjectVersion(this.filename, application, false);
    }

    public void setProjectFilename(Application application, String string) {
        if (string != null && !string.equals("")) {
            try {
                if (curDir == null) {
                    FileDialog fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Save Project...", 1);
                    if (YoYo.language == 1) {
                        fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Guarde Proyecto...", 1);
                    }
                    curDir = new SLURL(3, fileDialog.getDirectory());
                }
                this.filename = new SLURL(3, curDir.getPath(), string);
                application.iface.setTitle("StarLogo - " + this.filename.getFileNoExtension());
                if (YoYo.applet == null) {
                    application.procWin.setTitle("Control Center - " + this.filename.getFileNoExtension());
                }
            }
            catch (Exception exception) {
                Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error setting project filename:  " + exception.getMessage(), false);
            }
        }
    }

    public boolean saveText(Application application, int n) {
        SLURL sLURL = null;
        switch (n) {
            case 1: {
                sLURL = this.outputFilename;
                break;
            }
            case 2: {
                sLURL = this.infoFilename;
                break;
            }
        }
        if (sLURL == null) {
            return this.saveTextAs(application, n);
        }
        return this.saveTextFile(sLURL, application, n);
    }

    public void setTextFilename(Application application, String string, int n) {
        String string2 = "unknown";
        switch (n) {
            case 1: {
                string2 = "Output";
                break;
            }
            case 2: {
                string2 = "Info";
                break;
            }
        }
        if (string != null && !string.equals("")) {
            try {
                if (curDir == null) {
                    FileDialog fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Save " + string2 + " Window...", 1);
                    if (YoYo.language == 1) {
                        fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Guarde Ventana de " + string2 + "...", 1);
                    }
                    curDir = new SLURL(3, fileDialog.getDirectory());
                }
                switch (n) {
                    case 1: {
                        this.outputFilename = new SLURL(3, curDir.getPath(), string);
                        break;
                    }
                    case 2: {
                        this.infoFilename = new SLURL(3, curDir.getPath(), string);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                string2 = "unknown";
                switch (n) {
                    case 1: {
                        string2 = "output";
                        break;
                    }
                    case 2: {
                        string2 = "info";
                        break;
                    }
                }
                exception.printStackTrace(System.err);
                Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error setting " + string2 + " filename:  " + exception.getMessage(), false);
            }
        }
    }

    public boolean saveTextAs(Application application, int n) {
        String string = "unknown";
        switch (n) {
            case 1: {
                string = "Output";
                break;
            }
            case 2: {
                string = "Info";
                break;
            }
        }
        if (YoYo.language == 1) {
            switch (n) {
                case 1: {
                    string = "Salida";
                    break;
                }
                case 2: {
                    string = "Info";
                    break;
                }
            }
        }
        FileDialog fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Save " + string + " Window...", 1);
        if (YoYo.language == 1) {
            fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Guarde Ventana de " + string + "...", 1);
        }
        if (curDir != null && curDir.getProtocol() == 3) {
            fileDialog.setDirectory(curDir.getPath());
        }
        fileDialog.setFilenameFilter(application.textFileFilter);
        fileDialog.show();
        curDir = new SLURL(3, fileDialog.getDirectory());
        if (fileDialog.getFile() != null) {
            SLURL sLURL = new SLURL(3, curDir.getPath(), fileDialog.getFile());
            this.saveTextFile(sLURL, application, n);
            return true;
        }
        return false;
    }

    private final boolean saveTextFile(SLURL sLURL, Application application, int n) {
        try {
            try {
                application.setCursor(Cursor.getPredefinedCursor(3));
                if (!(YoYo.macintoshp && YoYo.macosxp || sLURL.getFileExtension().toLowerCase().equals("txt"))) {
                    sLURL.setFileExtension("txt");
                }
                File file = new File(sLURL.getFullPath());
                if (YoYo.macintoshp) {
                    application.macutils.setTextFileType(file);
                }
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                String string = "";
                Object object = this.sl.runningp;
                synchronized (object) {
                    switch (n) {
                        case 1: {
                            string = this.outWin.getContents();
                            break;
                        }
                        case 2: {
                            string = this.infoWin.getContents();
                            break;
                        }
                    }
                }
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.close();
                switch (n) {
                    case 1: {
                        this.outputFilename = sLURL;
                        break;
                    }
                    case 2: {
                        this.infoFilename = sLURL;
                        break;
                    }
                }
                boolean bl = true;
                Object var5_12 = null;
                application.restoreCursor();
                return bl;
            }
            catch (Exception exception) {
                String string = "unknown";
                switch (n) {
                    case 1: {
                        string = "output";
                        break;
                    }
                    case 2: {
                        string = "info";
                        break;
                    }
                }
                exception.printStackTrace(System.err);
                Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error saving " + string + " window file:  " + exception.getMessage(), false);
                boolean bl = false;
                Object var5_13 = null;
                application.restoreCursor();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            application.restoreCursor();
            throw throwable;
        }
    }

    public boolean saveProjectAs(Application application, boolean bl) {
        FileDialog fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Save Project...", 1);
        if (YoYo.language == 1) {
            fileDialog = new FileDialog((Frame)((Object)application.activeFrame), "Guarde Proyecto...", 1);
        }
        if (curDir != null) {
            fileDialog.setDirectory(curDir.getPath());
        }
        fileDialog.setFilenameFilter(application.projectFileFilter);
        fileDialog.show();
        curDir = new SLURL(3, fileDialog.getDirectory());
        if (fileDialog.getFile() != null) {
            this.filename = new SLURL(3, curDir.getPath(), fileDialog.getFile());
            this.saveFile(this.filename, application, bl);
            return true;
        }
        return false;
    }

    private final boolean saveFile(SLURL sLURL, Application application, boolean bl) {
        try {
            try {
                Object object;
                Object object2;
                Object object3;
                application.setCursor(Cursor.getPredefinedCursor(3));
                if (!(YoYo.macintoshp && !YoYo.macosxp || sLURL.getFileExtension().equalsIgnoreCase("slogo") || sLURL.getFileExtension().equalsIgnoreCase("slo"))) {
                    sLURL.setFileExtension("slogo");
                }
                String string = "";
                string = this.getContents(true);
                if (string.equalsIgnoreCase("error")) {
                    string = this.getContentsMinusWorld(true);
                    object3 = sLURL.getPath();
                    object2 = sLURL.getFile();
                    object = "There has been an error saving your file. A recovered version of your file will be saved with the name \"recovered_" + (String)object2 + "\"." + " The last previously saved version of this file will remain intact " + "under its original name.";
                    sLURL.setFile("recovered_" + sLURL.getFile());
                    Application.createMessageDialog(this.sl.myframe, "Error", (String)object, true);
                }
                object3 = new File(sLURL.getFullPath());
                object2 = new BufferedWriter(new FileWriter((File)object3));
                ((Writer)object2).write(string);
                ((BufferedWriter)object2).close();
                if (YoYo.macintoshp) {
                    application.macutils.setStarLogoFileType((File)object3);
                }
                this.clearChanged();
                application.iface.setTitle("StarLogo - " + this.filename.getFileNoExtension());
                if (!bl) {
                    application.procWin.setTitle("Control Center - " + this.filename.getFileNoExtension());
                }
                if (bl) {
                    object = new FileDialog((Frame)((Object)application.activeFrame), "Save HTML Template...", 1);
                    if (curDir != null) {
                        ((FileDialog)object).setDirectory(curDir.getPath());
                    }
                    ((FileDialog)object).setFilenameFilter(application.htmlFileFilter);
                    ((Dialog)object).show();
                    curDir = new SLURL(3, ((FileDialog)object).getDirectory());
                    if (((FileDialog)object).getFile() != null) {
                        SLURL sLURL2 = new SLURL(3, curDir.getPath(), ((FileDialog)object).getFile());
                        this.saveHTMLTemplate(sLURL2, sLURL.getFile(), application.iface.getTitle(), application);
                    }
                }
                if (this.backupPendingDeletion != null) {
                    object = new File(this.backupPendingDeletion.getFullPath());
                    ((File)object).delete();
                    this.backupPendingDeletion = null;
                }
                if (timer != null) {
                    timer.abort();
                }
                timer = new Timer(this, BACKUP_DELAY);
                boolean bl2 = true;
                Object var5_12 = null;
                application.restoreCursor();
                return bl2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error saving project file:  " + exception.getMessage(), false);
                boolean bl3 = false;
                Object var5_13 = null;
                application.restoreCursor();
                return bl3;
            }
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            application.restoreCursor();
            throw throwable;
        }
    }

    private final boolean saveHTMLTemplate(SLURL sLURL, String string, String string2, Application application) {
        try {
            if (!(YoYo.macintoshp && !YoYo.macosxp || sLURL.getFileExtension().equalsIgnoreCase("html") || sLURL.getFileExtension().equalsIgnoreCase("htm"))) {
                sLURL.setFileExtension("html");
            }
            int n = application.iface.getSize().width;
            int n2 = application.iface.getSize().height;
            String string3 = this.readTemplate(string, string2, YoYo.getLanguageAsString(), n, n2);
            File file = new File(sLURL.getFullPath());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string3);
            bufferedWriter.close();
            if (YoYo.macintoshp) {
                application.macutils.setHTMLFileType(file);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error saving project file:  " + exception.getMessage(), false);
            return false;
        }
    }

    private final String readTemplate(String string, String string2, String string3, int n, int n2) throws IOException, REException, MalformedURLException {
        RE rE = new RE("\\@width\\@");
        RE rE2 = new RE("\\@height\\@");
        RE rE3 = new RE("\\@project\\@");
        RE rE4 = new RE("\\@projecttitle\\@");
        RE rE5 = new RE("\\@language\\@");
        URL uRL = (class$Lstarlogo$Project != null ? class$Lstarlogo$Project : (class$Lstarlogo$Project = Project.class$("starlogo.Project"))).getResource("project-template.html");
        InputStream inputStream = uRL.openStream();
        REFilterInputStream rEFilterInputStream = new REFilterInputStream(inputStream, rE, String.valueOf(n));
        REFilterInputStream rEFilterInputStream2 = new REFilterInputStream(rEFilterInputStream, rE2, String.valueOf(n2));
        REFilterInputStream rEFilterInputStream3 = new REFilterInputStream(rEFilterInputStream2, rE3, string);
        REFilterInputStream rEFilterInputStream4 = new REFilterInputStream(rEFilterInputStream3, rE4, string2);
        REFilterInputStream rEFilterInputStream5 = new REFilterInputStream(rEFilterInputStream4, rE5, string3);
        InputStreamReader inputStreamReader = new InputStreamReader(rEFilterInputStream5);
        return PrimFile.readStream(inputStreamReader, -1, null);
    }

    public String getNewVersionFilenamePC(String string) {
        int n = string.lastIndexOf(".");
        if (!Character.isDigit(string.charAt(n - 1))) {
            string = string.substring(0, n) + "01" + ".slogo";
        } else if (!Character.isDigit(string.charAt(n - 2)) && Character.isDigit(string.charAt(n - 1))) {
            int n2 = Character.digit(string.charAt(n - 1), 10);
            string = ++n2 < 10 ? string.substring(0, n - 1) + "0" + Integer.toString(n2) + ".slogo" : string.substring(0, n - 1) + Integer.toString(n2) + ".slogo";
        } else {
            int n3 = Character.digit(string.charAt(n - 2), 10);
            n3 *= 10;
            n3 += Character.digit(string.charAt(n - 1), 10);
            string = ++n3 < 10 ? string.substring(0, n - 1) + Integer.toString(n3) + ".slogo" : string.substring(0, n - 2) + Integer.toString(n3) + ".slogo";
        }
        return string;
    }

    private static final String getBackupTag() {
        return "(backup) ";
    }

    private static final boolean isBackupTagPrefix() {
        return true;
    }

    private static final SLURL getBackupFromFile(SLURL sLURL) {
        SLURL sLURL2 = new SLURL(sLURL);
        if (Project.isBackupTagPrefix()) {
            sLURL2.setFile(Project.getBackupTag() + sLURL.getFileNoExtension());
        } else {
            sLURL2.setFile(sLURL.getFileNoExtension() + Project.getBackupTag());
        }
        sLURL2.setFileExtension(sLURL.getFileExtension());
        return sLURL2;
    }

    private static final SLURL getFileFromBackup(SLURL sLURL) {
        SLURL sLURL2 = new SLURL(sLURL);
        if (Project.isBackupTagPrefix()) {
            sLURL2.setFile(sLURL2.getFileNoExtension().substring(Project.getBackupTag().length()));
        } else {
            String string = sLURL2.getFileNoExtension();
            sLURL2.setFile(string.substring(0, string.length() - Project.getBackupTag().length()));
        }
        sLURL2.setFileExtension(sLURL.getFileExtension());
        return sLURL2;
    }

    public void ding() {
        if (this.filename == null || YoYo.applet != null || !this.contentsChanged) {
            timer = new Timer(this, BACKUP_DELAY);
        } else {
            this.backupPendingDeletion = null;
            SLURL sLURL = Project.getBackupFromFile(this.filename);
            if (!new File(new File(sLURL.getFullPath()).getParent()).canWrite()) {
                return;
            }
            this.saveFile(sLURL, this.sl.app, false);
            this.markChanged();
            this.backupPendingDeletion = sLURL;
        }
    }

    public String getNewVersionFilenameMac(String string) {
        if (string.toLowerCase().endsWith(".slogo")) {
            return this.getNewVersionFilenamePC(string);
        }
        int n = string.length() - 1;
        if (!Character.isDigit(string.charAt(n))) {
            string = string + "01";
        } else if (!Character.isDigit(string.charAt(n - 1)) && Character.isDigit(string.charAt(n))) {
            int n2 = Character.digit(string.charAt(n), 10);
            string = ++n2 < 10 ? string.substring(0, n) + "0" + Integer.toString(n2) : string.substring(0, n - 1) + Integer.toString(n2);
        } else {
            int n3 = Character.digit(string.charAt(n - 1), 10);
            n3 *= 10;
            n3 += Character.digit(string.charAt(n), 10);
            string = ++n3 < 10 ? string.substring(0, n) + Integer.toString(n3) : string.substring(0, n - 1) + Integer.toString(n3);
        }
        return string;
    }

    private final boolean saveProjectVersion(SLURL sLURL, Application application, boolean bl) {
        application.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                Object object;
                Object object2;
                Object object3;
                if (!YoYo.macintoshp || YoYo.macosxp) {
                    if (!sLURL.getFileExtension().toLowerCase().equals("slogo") && !sLURL.getFileExtension().toLowerCase().equals("slo")) {
                        sLURL.setFileExtension("slogo");
                    }
                    sLURL.setFile(this.getNewVersionFilenamePC(sLURL.getFile()));
                } else {
                    sLURL.setFile(this.getNewVersionFilenameMac(sLURL.getFile()));
                }
                String string = "";
                string = this.getContents(true);
                if (string.equalsIgnoreCase("error")) {
                    string = this.getContentsMinusWorld(true);
                    object3 = sLURL.getPath();
                    object2 = sLURL.getFile();
                    object = "There has been an error saving your file. A recovered version of your file will be saved with the name \"recovered_" + (String)object2 + "\". The last previously saved version of this file will remain intact under its original name.";
                    sLURL.setFile("recovered_" + sLURL.getFile());
                    Application.createMessageDialog(this.sl.myframe, "Error", (String)object, true);
                }
                object3 = new File(sLURL.getFullPath());
                object2 = new BufferedWriter(new FileWriter((File)object3));
                ((Writer)object2).write(string);
                ((BufferedWriter)object2).close();
                if (YoYo.macintoshp) {
                    application.macutils.setStarLogoFileType((File)object3);
                }
                this.clearChanged();
                this.filename = sLURL;
                application.iface.setTitle("StarLogo - " + this.filename.getFileNoExtension());
                if (!bl) {
                    application.procWin.setTitle("Control Center - " + this.filename.getFileNoExtension());
                }
                if (this.backupPendingDeletion != null) {
                    object = new File(this.backupPendingDeletion.getFullPath());
                    ((File)object).delete();
                    this.backupPendingDeletion = null;
                }
                if (timer != null) {
                    timer.abort();
                }
                timer = new Timer(this, BACKUP_DELAY);
                boolean bl2 = true;
                Object var5_11 = null;
                application.restoreCursor();
                return bl2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Application.createMessageDialog((Frame)((Object)application.activeFrame), "StarLogo Message", "Error saving project file:  " + exception.getMessage() + "\n", false);
                boolean bl3 = false;
                Object var5_12 = null;
                application.restoreCursor();
                return bl3;
            }
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            application.restoreCursor();
            throw throwable;
        }
    }

    private final String getContents(boolean bl) throws IOException {
        Object object = this.sl.runningp;
        synchronized (object) {
            String string = this.sl.saveWorld(bl);
            if (string.equals("error")) {
                return string;
            }
            return HEADER + "\r\n" + CURRENT_VERSION + "\r\n" + YoYo.getLanguageAsString() + "\r\n" + this.procWin.getSaveString() + "\r\n" + this.infoWin.getSaveString() + "\r\n" + this.iface.getSaveString(bl) + "\r\n" + TurtleShapes.saveShapes() + "\r\n" + (YoYo.swingavailablep && !YoYo.macintoshp ? this.theTemplate.save() : "") + "\r\n" + this.sl.saveSettings() + "\r\n" + string + "\r\n";
        }
    }

    private final String getContentsMinusWorld(boolean bl) throws IOException {
        return HEADER + "\r\n" + CURRENT_VERSION + "\r\n" + this.procWin.getSaveString() + "\r\n" + this.infoWin.getSaveString() + "\r\n" + this.iface.getSaveString(bl) + "\r\n" + TurtleShapes.saveShapes() + "\r\n" + (YoYo.swingavailablep && !YoYo.macintoshp ? this.theTemplate.save() : "") + "\r\n" + this.sl.saveSettings() + "\r\n";
    }

    public void compile(Application application) {
        if (!this.compilingp) {
            if (YoYo.applet == null) {
                this.compilingp = true;
                this.markChanged();
                application.setCursor(Cursor.getPredefinedCursor(3));
                this.procWin.compileText("");
                this.iface.compileWidgets();
                this.enqueueCompileDone(application);
            } else {
                application.compiled = true;
                application.rancompilerp = true;
            }
        }
    }

    public void enqueueCompileDone(Application application) {
        Object[] objectArray = new Object[]{Symbol.lookup("project-compile-done")};
        application.cc.enqueue(objectArray, application.message, application.err, null);
    }

    public void compileDone(Application application) {
        this.compilingp = false;
        application.compiled = true;
        application.rancompilerp = true;
        application.restoreCursor();
        Application.updateEntityMonitors();
        application.runMonitorsOnce();
    }

    public void compileFailed(Application application) {
        this.compilingp = false;
        application.compiled = false;
        application.rancompilerp = true;
        application.restoreCursor();
    }

    private static final String convertFormat(String string) {
        int n = string.indexOf("@#$#@#$#@");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        int n2 = string.indexOf("@#$#@#$#@", n + 9);
        String string3 = string.substring(n + 9, n2);
        int n3 = string.indexOf("@#$#@#$#@", n2 + 9);
        String string4 = n3 == -1 ? string.substring(n2 + 9) : string.substring(n2 + 9, n3);
        String string5 = HEADER + "\r\n" + MAC_VERSION + "\r\n" + "`observer`\r\n`turtle`\r\n" + string2 + "\r\n" + "`information`\r\n" + string4 + "\r\n" + "`interface`\r\n";
        Tokenizer tokenizer = new Tokenizer(string3);
        Vector vector = tokenizer.tokenize();
        int n4 = 0;
        String string6 = "";
        boolean bl = false;
        int n5 = 0;
        while (n5 < vector.size() - 1) {
            boolean bl2;
            String string7 = vector.elementAt(n5).toString();
            string6 = vector.elementAt(n5 + 1).toString();
            n4 = string3.indexOf(string7, n4) + string7.length();
            int n6 = string3.indexOf("\n", n4);
            int n7 = string3.indexOf("\r\n", n4);
            int n8 = string3.indexOf("\r", n4);
            int n9 = string3.indexOf("\t", n4);
            int n10 = string3.indexOf(string6, n4);
            boolean bl3 = bl2 = n6 > -1 && n6 < n10 || n7 > -1 && n7 < n10 || n8 > -1 && n8 < n10 || n9 > -1 && n9 < n10;
            if (string7.equals("BUTTON") || string7.equals("SLIDER") || string7.equals("MONITOR")) {
                string5 = string5.concat("\r\n");
            }
            if (bl) {
                if (bl2) {
                    bl = false;
                    string5 = string5.concat(string7 + "\"\r\n");
                } else {
                    string5 = string5.concat(string7 + " ");
                }
            } else if (bl2) {
                string5 = string5.concat(string7 + "\r\n");
            } else {
                bl = true;
                string5 = string5.concat("\"" + string7 + " ");
            }
            ++n5;
        }
        string5 = string5.concat(string6);
        return string5;
    }

    private final void setVersion(String string) {
        Tokenizer tokenizer = new Tokenizer(string.substring(HEADER.length()));
        this.version = tokenizer.getNextToken();
    }

    public void done(Context context) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Project(Application application) {
        this.app = application;
        this.sl = application.sl;
        if (YoYo.applet == null) {
            this.procWin = application.procWin;
            this.infoWin = application.infoWin;
            this.outWin = application.outWin;
            this.theTemplate = application.theTemplate;
        }
        this.iface = application.iface;
        if (YoYo.applet == null && curDir == null) {
            curDir = new SLURL(application.cc.base);
            if (YoYo.pcp) {
                curDir.setPath(curDir.getFullPath() + "\\My Documents\\");
            }
        }
        this.filename = null;
        this.clearChanged();
    }

    static {
        BACKUP_DELAY = 300;
    }
}

