/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import starlogo.Application;
import starlogo.DisplayMessage;
import starlogo.Interface;
import starlogo.SColortool;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import yoyo.Context;
import yoyo.Reader;
import yoyo.YoYo;

public class SColorChooser
extends Component
implements StarLogoCaller,
DisplayMessage {
    private boolean selected = false;
    public Interface iface;
    public StarLogo sl;
    private SColortool colort;
    public int drawColor;
    String cnum;
    String cname;
    Rectangle position;
    public Rectangle clipRect = new Rectangle();
    boolean runningp;
    StringBuffer tempStringBuffer = new StringBuffer();
    Component keyboardFocus;
    Font WIDGET_FONT = new Font("Dialog", 0, 10);
    public FontMetrics fm = this.getFontMetrics(this.WIDGET_FONT);
    String[] colorArray = new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "violet", "magenta", "pink", "gris", "rojo", "naranja", "marron", "amarillo", "verde", "verde claro", "turquesa", "cian", "celeste", "azul", "violeta", "magenta", "rosado"};
    private Vector spps = new Vector();
    private int sppcount = 0;

    public void setColor(int n) {
        this.drawColor = this.colort.curcolor;
        this.drawColor = n;
        this.addToClipRect(this.position);
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        int n;
        this.drawColor = this.colort.curcolor;
        graphics.translate(this.position.x, this.position.y);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setColor(SystemColor.control);
        graphics.fillRect(0, 0, 70, 20);
        graphics.draw3DRect(0, 1, 69, 14, false);
        graphics.draw3DRect(0, 17, 69, 14, false);
        graphics.setFont(this.WIDGET_FONT);
        this.cnum = String.valueOf(this.drawColor);
        if (this.keyboardFocus == this) {
            this.highlight(graphics);
        } else {
            graphics.setColor(Color.black);
            n = this.fm.stringWidth(this.cnum);
            graphics.drawString(this.cnum, 66 - n, 11);
        }
        graphics.setColor(SystemColor.control);
        graphics.fill3DRect(0, 17, 69, 14, false);
        graphics.setFont(this.WIDGET_FONT);
        graphics.setColor(Color.white);
        this.cname = this.getColorString();
        n = this.fm.stringWidth(this.cname);
        graphics.drawString(this.cname, 66 - n, 27);
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.translate(-this.position.x, -this.position.y);
    }

    private final String getColorString() {
        this.drawColor = this.colort.curcolor;
        if (this.drawColor == 0) {
            return "black";
        }
        if (this.drawColor == 9) {
            return "white";
        }
        String string = this.colorArray[this.drawColor / 10];
        if (YoYo.language == 1) {
            string = this.colorArray[this.drawColor / 10 + 14];
        }
        String string2 = "";
        int n = this.drawColor % 10;
        if (n < 5) {
            string2 = " - " + (5 - n);
        }
        if (n == 5) {
            string2 = "";
        }
        if (n > 5) {
            string2 = " + " + (n - 5);
        }
        return string + string2;
    }

    public String showColor() {
        return this.getColorString();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.drawColor = this.colort.curcolor;
        if (this.keyboardFocus == this) {
            this.enter();
        } else {
            this.select();
        }
        this.addToClipRect(this.position);
    }

    private final void highlight(Graphics graphics) {
        String string = this.tempStringBuffer.toString();
        int n = this.fm.stringWidth(string);
        graphics.setColor(Color.white);
        graphics.fillRect(1, 2, 68, 13);
        graphics.setColor(Color.blue);
        graphics.fillRect(65 - n, 2, n + 3, 13);
        graphics.setColor(Color.white);
        graphics.setFont(this.WIDGET_FONT);
        graphics.drawString(string, 66 - n, 11);
    }

    private final void highlight() {
        Graphics graphics = this.iface.getGraphics();
        graphics.translate(this.position.x, this.position.y);
        this.highlight(graphics);
    }

    public void chop() {
        if (this.tempStringBuffer.length() == 0) {
            return;
        }
        this.tempStringBuffer.setLength(this.tempStringBuffer.length() - 1);
        this.highlight();
    }

    public void add(char c) {
        if (this.tempStringBuffer.length() > 10) {
            return;
        }
        this.tempStringBuffer.append(c);
        this.highlight();
    }

    public void restoreOld() {
        if (this.selected) {
            this.addToClipRect(this.position);
        }
        this.deselect();
    }

    public void keyTyped(char c) {
        if (c == '\u001b') {
            this.restoreOld();
        } else if (c == '\u007f' || c == '\b') {
            this.chop();
        } else if (c == '\n') {
            this.enter();
        } else if (c > '\u001f' && c < '\u0080') {
            this.add(c);
        } else {
            return;
        }
        this.addToClipRect(this.position);
    }

    public void select() {
        this.selected = true;
        this.keyboardFocus = this;
        this.tempStringBuffer = new StringBuffer("");
    }

    public void deselect() {
        this.selected = false;
        this.keyboardFocus = null;
        this.tempStringBuffer = new StringBuffer();
    }

    public void enter() {
        String string = this.tempStringBuffer.toString();
        if (string.trim().equals("")) {
            this.restoreOld();
            return;
        }
        this.handlecr(this.tempStringBuffer.toString());
        this.deselect();
    }

    private final void handlecr(String string) {
        this.runline("compile-colorchooser [%setcc " + string + "]");
    }

    private final void runline(String string) {
        if (!this.sl.app.maybeCompile()) {
            return;
        }
        this.runningp = true;
        if (string != null && string != "") {
            Object[] objectArray = Reader.read(string);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = this;
            this.sl.app.cc.enqueue(objectArray2, this.sl.app.message, this.sl.app.err, null);
        }
    }

    public void done(Context context) {
    }

    public void runCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        if (this.sl.locked) {
            this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
        } else {
            Object object = this.sl.runningp;
            synchronized (object) {
                int n2 = this.sl.internalSetInstructions(this.toString(), nArray, objectArray2);
                StackProcessParent.runObserver(this.sl, n2, false, this);
            }
        }
    }

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0 && this.runningp) {
            this.runningp = false;
        }
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
    }

    public void callerPrintln(String string) {
        this.iface.statusbar().setStatusMessage(string);
    }

    public void callerClearText() {
        this.iface.statusbar().setStatusMessage("");
    }

    public void displayOneString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error", string, true);
    }

    public void displayAString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error", string, true);
    }

    public void addToClipRect(Rectangle rectangle) {
        if (this.clipRect.isEmpty()) {
            this.clipRect.setBounds(rectangle);
        } else {
            this.clipRect = this.clipRect.union(rectangle);
        }
    }

    public SColorChooser(SColortool sColortool) {
        this.colort = sColortool;
        this.drawColor = this.colort.curcolor;
        this.cnum = String.valueOf(this.drawColor);
        this.position = new Rectangle(0, 0, 70, 50);
    }
}

