/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import starlogo.Application;
import starlogo.Interface;
import starlogo.PatchCanvas;
import starlogo.SliderDialog;
import starlogo.StarLogo;
import starlogo.ToolTipWidget;
import starlogo.Widget;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.YoYo;

public class SliderWidget
extends WidgetDrag {
    public static int SLIDER_HEIGHT = 25;
    public static int idCount = 0;
    static final int sliderTrackEdgeHeight = 11;
    static final int sliderTrackEdgeWidth = 6;
    static final int sliderBottomEdgeHeight = 13;
    static final int sliderBottomEdgeWidth = 5;
    static Image sliderEdges;
    static Image sliderMiddleTrack;
    static Image sliderMiddleBottom;
    static Image sliThumb;
    static Image sliTick;
    static Font SLIDER_FONT;
    private String oldname = null;
    public String var;
    public String name;
    public int min;
    public int max = 1;
    Font font;
    public int id;
    public int cur;
    public Integer curInt;
    public boolean showName;
    Rectangle thumbPos;
    int handle;
    boolean sliding = false;
    public int maxPixelVal = 77;
    public int minPixelVal = 4;
    FontMetrics fm = null;
    int textDescent;
    int textHeight;
    int textWidth;
    int maxTextWidth;
    int minTextWidth;
    int maxValueWidth;
    int minValueWidth;
    int minmaxValueWidth;
    public Rectangle topRect;
    public Rectangle botRect;
    StarLogo sl;
    Application app;
    public boolean activep;
    private static /* synthetic */ Class class$Lstarlogo$Pool;

    public static void createNew(Interface interface_) {
        SliderDialog sliderDialog = Application.createSliderDialog(interface_.frame(), "New Slider");
        if (YoYo.language == 1) {
            sliderDialog = Application.createSliderDialog(interface_.frame(), "Barra de Enrollar Nueva");
        }
        sliderDialog.show();
        if (sliderDialog.pressedOK()) {
            SliderWidget sliderWidget = new SliderWidget(interface_, interface_.sl());
            sliderDialog.getValues(sliderWidget);
            sliderWidget.updateMinSize();
            interface_.addWidget(sliderWidget);
            interface_.app().rancompilerp = false;
        }
        sliderDialog.dispose();
    }

    public void edit() {
        SliderDialog sliderDialog = Application.createSliderDialog(this.parent.frame(), "Edit Slider", this);
        sliderDialog.show();
        if (sliderDialog.pressedOK()) {
            boolean bl = this.showName;
            String string = this.name;
            String string2 = this.var;
            this.parent.addHandlesToClipRect(this);
            sliderDialog.getValues(this);
            this.updateThumbPos();
            if (bl != this.showName || this.showName && !string.equals(this.name) || !this.showName && !string2.equals(this.var)) {
                this.updateMinSize();
            }
            this.parent.addToClipRect(this.position);
            this.app.rancompilerp = false;
            this.app.project.markChanged();
        }
        sliderDialog.dispose();
        super.edit();
    }

    public static SliderWidget load(Vector vector, Interface interface_, StarLogo starLogo) {
        Object object;
        Object object2;
        int n = 0;
        int n2 = 0;
        int n3 = 50;
        int n4 = 20;
        int n5 = 1;
        int n6 = 0;
        int n7 = 99;
        int n8 = 50;
        boolean bl = false;
        String string = "slider1";
        String string2 = "nothing";
        Object object3 = new String();
        int n9 = 0;
        while (n9 < vector.size()) {
            String string3;
            object2 = vector.elementAt(n9).toString();
            if (((String)object2).equals("top-left")) {
                object = vector.elementAt(n9 + 1).toString();
                string3 = vector.elementAt(n9 + 2).toString();
                n = Integer.parseInt((String)object);
                n2 = Integer.parseInt(string3);
                n9 += 3;
                continue;
            }
            if (((String)object2).equals("width-height")) {
                object = vector.elementAt(n9 + 1).toString();
                string3 = vector.elementAt(n9 + 2).toString();
                n3 = Integer.parseInt((String)object);
                n4 = Integer.parseInt(string3);
                n9 += 3;
                continue;
            }
            if (((String)object2).equals("name")) {
                string = vector.elementAt(n9 + 1).toString();
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("variable")) {
                string2 = vector.elementAt(n9 + 1).toString();
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("show-name?")) {
                object = vector.elementAt(n9 + 1).toString();
                bl = ((String)object).equals("true");
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("slider-number")) {
                object = vector.elementAt(n9 + 1).toString();
                n5 = Integer.parseInt((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("min-value")) {
                object = vector.elementAt(n9 + 1).toString();
                n6 = Integer.parseInt((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("max-value")) {
                object = vector.elementAt(n9 + 1).toString();
                n7 = Integer.parseInt((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("current-value")) {
                object = vector.elementAt(n9 + 1).toString();
                n8 = Integer.parseInt((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("toolTip-text")) {
                object3 = object = vector.elementAt(n9 + 1).toString();
                n9 += 2;
                continue;
            }
            n9 += 2;
        }
        object2 = interface_.getBoundaries();
        object = new Rectangle(n2 + ((Rectangle)object2).x, n + ((Rectangle)object2).y, n3, n4);
        if (n5 >= idCount) {
            idCount = n5 + 1;
        }
        return new SliderWidget(string, string2, (Rectangle)object, n6, n7, n8, bl, n5, interface_, starLogo, (String)object3);
    }

    public String getSaveString(boolean bl) {
        Rectangle rectangle = this.parent.getBoundaries();
        return "SLSlider\r\ntop-left " + (this.position.y - rectangle.y) + " " + (this.position.x - rectangle.x) + "\r\n" + "width-height " + this.position.width + " " + this.position.height + "\r\n" + "name \"" + this.name + "\"\r\n" + "variable \"" + this.var + "\"\r\n" + "min-value " + this.min + "\r\n" + "max-value " + this.max + "\r\n" + "current-value " + this.cur + "\r\n" + "slider-number " + this.id + "\r\n" + "show-name? " + (this.showName ? "true\r\n" : "false\r\n") + this.getToolTipSaveString() + "\r\n";
    }

    public String toString() {
        return "Slider: " + this.var;
    }

    public void updateMinSize() {
        int n = this.showName ? this.fm.stringWidth(this.name) : this.fm.stringWidth(this.var);
        this.maxValueWidth = this.fm.stringWidth(String.valueOf(this.max));
        this.minValueWidth = this.fm.stringWidth(String.valueOf(this.min));
        this.maxValueWidth = this.minValueWidth > this.maxValueWidth ? this.minValueWidth : this.maxValueWidth;
        this.minmaxValueWidth = this.fm.stringWidth(String.valueOf(-999));
        this.maxTextWidth = n + 2 * this.maxValueWidth;
        this.minTextWidth = n + this.minValueWidth;
        this.maxTextWidth = this.minTextWidth > this.maxTextWidth ? this.minTextWidth : this.maxTextWidth;
        int n2 = this.maxTextWidth + 6 + 10;
        if (this.position.width < n2) {
            this.position.width = n2;
            this.resizeMe();
        }
        if (this.parent.outline() != null) {
            this.parent.outline().width = this.position.width;
        }
    }

    public boolean draggable(MouseEvent mouseEvent) {
        if (YoYo.applet != null) {
            return false;
        }
        boolean bl = this.thumbPos.contains(mouseEvent.getX() - this.position.x, mouseEvent.getY() - this.position.y);
        return !bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (YoYo.applet != null) {
            if (this.thumbPos.contains(mouseEvent.getX() - this.position.x, mouseEvent.getY() - this.position.y)) {
                this.handle = mouseEvent.getX() - this.position.x - this.thumbPos.x;
                this.sliding = true;
                this.activep = true;
            } else {
                this.activep = false;
            }
            return;
        }
        if (this.thumbPos.contains(mouseEvent.getX() - this.position.x, mouseEvent.getY() - this.position.y)) {
            this.handle = mouseEvent.getX() - this.position.x - this.thumbPos.x;
            this.sliding = true;
        } else {
            this.sliding = false;
        }
        this.activep = true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.activep) {
            return;
        }
        this.updateValue();
        if (this.sliding) {
            this.thumbPos.x = mouseEvent.getX() - this.handle - this.position.x;
            this.updateValue();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.sliding) {
            this.sliding = false;
            this.updateValueAtEnd();
        } else if (this.parent.getToolbar().buttonDown == 1 && this.topRect.contains(mouseEvent.getX() - this.position.x, mouseEvent.getY() - this.position.y) && !this.thumbPos.contains(mouseEvent.getX() - this.position.x, mouseEvent.getY() - this.position.y)) {
            this.jumpThumb(mouseEvent.getX() - this.position.x > this.thumbPos.x);
        }
    }

    void updateThumbPos() {
        this.thumbPos.x = this.minPixelVal + (this.maxPixelVal - this.minPixelVal) * (this.cur - this.min) / (this.max - this.min);
    }

    public void updateValue() {
        if (this.thumbPos.x < this.minPixelVal) {
            this.thumbPos.x = this.minPixelVal;
        }
        if (this.thumbPos.x > this.maxPixelVal) {
            this.thumbPos.x = this.maxPixelVal;
        }
        this.cur = (int)Math.round((double)this.min + (double)((this.max - this.min) * (this.thumbPos.x - this.minPixelVal)) / ((double)this.maxPixelVal - (double)this.minPixelVal));
        this.curInt = new Integer(this.cur);
        this.parent.addToClipRect(this.position);
    }

    public void updateValueAtEnd() {
        if (this.thumbPos.x < this.minPixelVal) {
            this.thumbPos.x = this.minPixelVal;
        }
        if (this.thumbPos.x > this.maxPixelVal) {
            this.thumbPos.x = this.maxPixelVal;
        }
        this.cur = (int)Math.round((double)this.min + (double)((this.max - this.min) * (this.thumbPos.x - this.minPixelVal)) / ((double)this.maxPixelVal - (double)this.minPixelVal));
        this.curInt = new Integer(this.cur);
        this.updateThumbPos();
        this.parent.addToClipRect(this.position);
    }

    public Integer getValue() {
        return this.curInt;
    }

    public void setValue(int n) {
        if (n >= this.min && n <= this.max) {
            this.cur = n;
            this.curInt = new Integer(this.cur);
            this.thumbPos = new Rectangle(this.minPixelVal + (this.maxPixelVal - this.minPixelVal) * (this.cur - this.min) / (this.max - this.min), 1, 9, 9);
            this.updateThumbPos();
            this.parent.addToClipRect(this.position);
        }
    }

    public boolean nameChanged() {
        boolean bl = !this.name.equals(this.oldname);
        this.oldname = this.name;
        return bl;
    }

    public void jumpThumb(boolean bl) {
        this.cur = bl ? (this.max < 10 ? ++this.cur : (int)Math.min((double)this.max, (double)this.cur + Math.floor((this.max - this.min) / 10))) : (this.max < 10 ? --this.cur : (int)Math.max((double)this.min, (double)this.cur - Math.floor((this.max - this.min) / 10)));
        this.curInt = new Integer(this.cur);
        this.updateThumbPos();
        this.parent.addToClipRect(this.position);
    }

    public void delete() {
        this.packID();
        --idCount;
        this.parent.sliders().removeElement(this);
        super.delete();
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.font);
        if (this.maxTextWidth < 0) {
            // empty if block
        }
        graphics.translate(this.position.x, this.position.y);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, 6, 11);
        graphics.drawImage(sliderEdges, 0, 0, null);
        graphics.setClip(shape);
        graphics.clipRect(this.position.width - 6, 0, 6, 11);
        graphics.drawImage(sliderEdges, this.position.width - 12, 0, null);
        graphics.setClip(shape);
        graphics.clipRect(3, 12, 5, 13);
        graphics.drawImage(sliderEdges, 3, 1, null);
        graphics.setClip(shape);
        graphics.clipRect(this.position.width - 3 - 5, 12, 5, 13);
        graphics.drawImage(sliderEdges, this.position.width - 3 - 10, 1, null);
        graphics.setClip(shape);
        graphics.drawImage(sliderMiddleTrack, 6, 0, this.position.width - 12, 11, null);
        graphics.drawImage(sliderMiddleBottom, 8, 12, this.position.width - 6 - 10, 13, null);
        graphics.drawImage(sliThumb, this.thumbPos.x, this.thumbPos.y, null);
        graphics.setColor(Color.black);
        graphics.setClip(shape);
        graphics.clipRect(6, 13, this.position.width - 12 - this.maxValueWidth - 6, 10);
        graphics.drawString(this.showName ? this.name : this.var, 6, 18 + (YoYo.macintoshp || YoYo.linuxp ? 1 : 0) + this.textHeight / 2 - this.textDescent);
        graphics.setClip(shape);
        this.paintValue(graphics);
        graphics.setClip(shape);
        graphics.translate(-this.position.x, -this.position.y);
    }

    public void paintValue(Graphics graphics) {
        String string = String.valueOf(this.cur);
        this.paintValue(graphics, string);
    }

    public void paintValue(Graphics graphics, String string) {
        this.textWidth = this.fm.stringWidth(string);
        graphics.clipRect(this.position.width - 6 - this.textWidth, 13, this.textWidth, 10);
        graphics.drawString(string, this.position.width - 6 - this.textWidth, 18 + (YoYo.macintoshp || YoYo.linuxp ? 1 : 0) + this.textHeight / 2 - this.textDescent);
    }

    private final void packID() {
        Enumeration enumeration = this.parent.wh().listDragWidgets();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SliderWidget)) continue;
            SliderWidget sliderWidget = (SliderWidget)e;
            if (sliderWidget.id <= this.id) continue;
            --sliderWidget.id;
            sliderWidget.name = "slider" + sliderWidget.id;
        }
    }

    public boolean contains(int n, int n2) {
        return this.topRect.contains(n - this.position.x, n2 - this.position.y) || this.botRect.contains(n - this.position.x, n2 - this.position.y);
    }

    public boolean intersects(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (this.isSelected()) {
            PatchCanvas cfr_ignored_0 = this.sl.patchcanvas;
            PatchCanvas cfr_ignored_1 = this.sl.patchcanvas;
            rectangle2.grow(WidgetDrag.CORNER_WIDTH, WidgetDrag.CORNER_WIDTH);
        }
        rectangle2.translate(-this.position.x, -this.position.y);
        return this.topRect.intersects(rectangle2) || this.botRect.intersects(rectangle2);
    }

    public int getToolbarButton() {
        return 3;
    }

    public int resizeWhichCorner(Point point) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.position.x - 8, this.position.y - 8, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 7;
        }
        rectangle.setBounds(this.position.x + this.position.width, this.position.y - 8, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 8;
        }
        rectangle.setBounds(this.position.x - 8, this.position.y + this.position.height, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 7;
        }
        rectangle.setBounds(this.position.x + this.position.width, this.position.y + this.position.height, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 8;
        }
        return 0;
    }

    public void resize(Point point, int n) {
        super.resize(point, n);
        this.resizeMe();
    }

    public void resizeMe() {
        this.topRect = new Rectangle(0, 0, this.position.width, 11);
        this.botRect = new Rectangle(3, 12, this.position.width - 8, 13);
        this.maxPixelVal = this.position.width - 13;
        this.updateThumbPos();
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        sliderEdges = toolkit.getImage((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = SliderWidget.class$("starlogo.Pool"))).getResource(string + "slider-edges.gif"));
        sliderMiddleTrack = toolkit.getImage((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = SliderWidget.class$("starlogo.Pool"))).getResource(string + "slider-middle.gif"));
        sliderMiddleBottom = toolkit.getImage((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = SliderWidget.class$("starlogo.Pool"))).getResource(string + "slider-bottom-middle.gif"));
        sliTick = toolkit.getImage((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = SliderWidget.class$("starlogo.Pool"))).getResource(string + "slider-bottom-tick.gif"));
        sliThumb = toolkit.getImage((class$Lstarlogo$Pool != null ? class$Lstarlogo$Pool : (class$Lstarlogo$Pool = SliderWidget.class$("starlogo.Pool"))).getResource(string + "slider-thumb.gif"));
        mediaTracker.addImage(sliderEdges, Widget.trackerID++);
        mediaTracker.addImage(sliderMiddleTrack, Widget.trackerID++);
        mediaTracker.addImage(sliderMiddleBottom, Widget.trackerID++);
        mediaTracker.addImage(sliTick, Widget.trackerID++);
        mediaTracker.addImage(sliThumb, Widget.trackerID++);
    }

    public WidgetDrag copy(int n, Rectangle rectangle) {
        String string = this.name + " copy" + WidgetDrag.editionString(n);
        String string2 = this.var;
        if (n > 1) {
            string2 = string2 + n;
        }
        return new SliderWidget(string, string2, rectangle, this.min, this.max, this.cur, this.showName, ++idCount, this.parent, this.sl, this.getToolText());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SliderWidget(String string, String string2, Rectangle rectangle, int n, int n2, int n3, boolean bl, int n4, Interface interface_, StarLogo starLogo, String string3) {
        this.name = string;
        this.var = string2;
        this.showName = bl;
        this.position = new Rectangle(rectangle);
        this.position.height = SLIDER_HEIGHT;
        this.min = n;
        this.max = n2;
        this.cur = n3;
        this.curInt = new Integer(n3);
        this.id = n4;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = SLIDER_FONT;
        this.topRect = new Rectangle(0, 0, rectangle.width, 11);
        this.botRect = new Rectangle(3, 12, rectangle.width - 8, 13);
        this.maxPixelVal = rectangle.width - 13;
        this.thumbPos = new Rectangle(this.minPixelVal + (this.maxPixelVal - this.minPixelVal) * (n3 - n) / (n2 - n), 1, 9, 9);
        this.fm = this.parent.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        if (!ToolTipWidget.empty(string3)) {
            this.setToolTip(new ToolTipWidget(this.parent, string3));
        }
    }

    public SliderWidget(Interface interface_, StarLogo starLogo) {
        if (interface_.outline().x + this.MIN_WIDTH > interface_.getSize().width) {
            interface_.outline().width = interface_.outline().width + interface_.outline().x - interface_.getSize().width + this.MIN_WIDTH;
            interface_.outline().x = interface_.getSize().width - this.MIN_WIDTH;
        }
        if (interface_.outline().width < this.MIN_WIDTH) {
            interface_.outline().width = this.MIN_WIDTH;
        }
        if (interface_.outline().y + SLIDER_HEIGHT > interface_.getSize().height) {
            interface_.outline().height = interface_.outline().height + interface_.outline().y - interface_.getSize().height + SLIDER_HEIGHT;
            interface_.outline().y = interface_.getSize().height - SLIDER_HEIGHT;
        }
        if (interface_.outline().height < SLIDER_HEIGHT) {
            interface_.outline().height = SLIDER_HEIGHT;
        }
        this.position = new Rectangle(interface_.outline());
        this.position.height = SLIDER_HEIGHT;
        this.id = idCount++;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = WidgetLite.WIDGET_FONT;
        this.showName = false;
        this.topRect = new Rectangle(0, 0, this.position.width, 11);
        this.botRect = new Rectangle(3, 12, this.position.width - 8, 13);
        this.maxPixelVal = this.position.width - 13;
        this.thumbPos = new Rectangle(this.minPixelVal + (this.maxPixelVal - this.minPixelVal) * (this.cur - this.min) / (this.max - this.min), 1, 9, 9);
        this.fm = this.parent.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
    }

    public SliderWidget(Vector vector, int n, Interface interface_) {
        this.parent = interface_;
        this.position = new Rectangle();
        this.position.x = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().x;
        this.position.y = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().y;
        this.position.width = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().x - this.position.x;
        this.position.height = SLIDER_HEIGHT;
        int n2 = ++n;
        this.name = vector.elementAt(n2).toString();
        int n3 = ++n;
        this.var = vector.elementAt(n3).toString();
        int n4 = ++n;
        this.min = new Integer(vector.elementAt(n4).toString());
        int n5 = ++n;
        this.max = new Integer(vector.elementAt(n5).toString());
        int n6 = ++n;
        this.cur = new Integer(vector.elementAt(n6).toString());
        this.curInt = new Integer(this.cur);
        int n7 = ++n;
        ++n;
        this.id = new Integer(vector.elementAt(n7).toString());
        if (this.id >= idCount) {
            idCount = this.id + 1;
        }
        this.showName = false;
        this.font = WidgetLite.WIDGET_FONT;
        this.topRect = new Rectangle(0, 0, this.position.width, 11);
        this.botRect = new Rectangle(3, 12, this.position.width - 8, 13);
        this.maxPixelVal = this.position.width - 13;
        this.thumbPos = new Rectangle(this.minPixelVal + (this.maxPixelVal - this.minPixelVal) * (this.cur - this.min) / (this.max - this.min), 1, 9, 9);
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.updateMinSize();
    }

    static {
        try {
            SLIDER_FONT = WidgetLite.WIDGET_FONT;
            if (YoYo.macintoshp) {
                SLIDER_FONT = Font.getFont("starlogo.slider.font", SLIDER_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

