/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import starlogo.Patch;
import starlogo.StarLogo;
import starlogo.TurtleMonitor;
import starlogo.Utilities;
import starlogo.VM;
import yoyo.Context;
import yoyo.LogoError;
import yoyo.YoYo;

class Turtle
extends VM
implements Serializable {
    public static Hashtable stateOffsetTable = Turtle.initStateOffsets();
    static int numVars = 0;
    static String[] varnames;
    static boolean[] varenums;
    static int[] varposes;
    static int numBreeds;
    static String[] breednames;
    static int[] breednums;
    transient Turtle next;
    transient Turtle prev;
    transient Turtle overme;
    transient Turtle underme;
    transient int patch;
    int who;
    int shape;
    Integer whoInt;
    double xcor;
    double ycor;
    double heading;
    double breed;
    double color;
    double xdelta;
    double ydelta;
    boolean pendownp = false;
    boolean shownp = true;
    boolean alive = true;
    transient VM grabber = null;
    transient boolean hasTMp = false;
    transient TurtleMonitor tm;

    public int hashCode() {
        return this.who;
    }

    public boolean equals(Object object) {
        if (object instanceof Turtle) {
            return ((Turtle)object).who == this.who;
        }
        return false;
    }

    public static Turtle restore(StarLogo starLogo, byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 1;
        double d = starLogo.turhalfwidth;
        double d2 = starLogo.turhalfheight;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 5.0;
        boolean bl = false;
        boolean bl2 = true;
        int n6 = Turtle.getOffset("who");
        if (n6 >= 0) {
            n2 = Utilities.readIntFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("xcor")) >= 0) {
            d = Utilities.readDoubleFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("ycor")) >= 0) {
            d2 = Utilities.readDoubleFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("heading")) >= 0) {
            d3 = Utilities.readDoubleFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("color")) >= 0) {
            d5 = Utilities.readDoubleFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("breed")) >= 0) {
            d4 = Utilities.readDoubleFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("shape")) >= 0) {
            n3 = Utilities.readIntFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("plotpen")) >= 0) {
            n4 = Utilities.readIntFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("plotwidget")) >= 0) {
            n5 = Utilities.readIntFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("pendownp")) >= 0) {
            bl = Utilities.readBooleanFromByteArray(byArray, n + n6);
        }
        if ((n6 = Turtle.getOffset("shownp")) >= 0) {
            bl2 = Utilities.readBooleanFromByteArray(byArray, n + n6);
        }
        Object[] objectArray = Turtle.restoreVariables(byArray, n + Turtle.getStateLength());
        return new Turtle(starLogo, d, d2, d3, d5, n2, d4, n3, n4, n5, bl, bl2, objectArray);
    }

    public void save(byte[] byArray, int n) {
        int n2 = Turtle.getOffset("who");
        if (n2 >= 0) {
            Utilities.writeIntoByteArray(this.who, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("xcor")) >= 0) {
            Utilities.writeIntoByteArray(this.xcor - VM.sl.turhalfwidth, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("ycor")) >= 0) {
            Utilities.writeIntoByteArray(VM.sl.turhalfheight - this.ycor, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("heading")) >= 0) {
            Utilities.writeIntoByteArray(this.heading, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("color")) >= 0) {
            Utilities.writeIntoByteArray(this.color, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("breed")) >= 0) {
            Utilities.writeIntoByteArray(this.breed, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("shape")) >= 0) {
            Utilities.writeIntoByteArray(this.shape, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("plotpen")) >= 0) {
            Utilities.writeIntoByteArray(this.plotpen, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("plotwidget")) >= 0) {
            Utilities.writeIntoByteArray(this.plotwidget, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("pendownp")) >= 0) {
            Utilities.writeIntoByteArray(this.pendownp, byArray, n + n2);
        }
        if ((n2 = Turtle.getOffset("shownp")) >= 0) {
            Utilities.writeIntoByteArray(this.shownp, byArray, n + n2);
        }
        this.saveVariables(byArray, n + Turtle.getStateLength());
    }

    public void saveVariables(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < numVars) {
            int n4 = Turtle.getVarPos(n3);
            Object object = this.turtlesown[n4];
            int n5 = Utilities.addIntoTable(object, VM.sl);
            Utilities.writeIntoByteArray(n5, byArray, n + n2);
            n2 += 4;
            ++n3;
        }
    }

    public static Object[] restoreVariables(byte[] byArray, int n) {
        Object[] objectArray = new Object[numVars];
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Object object;
            int n4 = Utilities.readIntFromByteArray(byArray, n + n2);
            n2 += 4;
            objectArray[Turtle.getVarPos((int)n3)] = object = Utilities.lookupInTable(n4);
            ++n3;
        }
        return objectArray;
    }

    public static Hashtable initStateOffsets() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("who", new Integer(0));
        hashtable.put("xcor", new Integer(4));
        hashtable.put("ycor", new Integer(12));
        hashtable.put("heading", new Integer(20));
        hashtable.put("color", new Integer(28));
        hashtable.put("breed", new Integer(36));
        hashtable.put("shape", new Integer(42));
        hashtable.put("plotpen", new Integer(46));
        hashtable.put("pendownp", new Integer(50));
        hashtable.put("shownp", new Integer(51));
        hashtable.put("plotwidget", new Integer(52));
        hashtable.put("statelength", new Integer(56));
        hashtable.put("length", new Integer(56));
        return hashtable;
    }

    public static int getLength() {
        return Turtle.getOffset("length");
    }

    public static void setLength(Integer n) {
        stateOffsetTable.put("length", n);
    }

    public static int getStateLength() {
        return Turtle.getOffset("statelength");
    }

    public static int getOffset(String string) {
        if (stateOffsetTable.containsKey(string)) {
            return (Integer)stateOffsetTable.get(string);
        }
        return -1000;
    }

    public static byte[] getStateDesc() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Enumeration enumeration = stateOffsetTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = (Integer)stateOffsetTable.get(string);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(n);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void setStateDesc(byte[] byArray) throws IOException {
        stateOffsetTable.clear();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        while (dataInputStream.available() > 0) {
            String string = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            stateOffsetTable.put(string, new Integer(n));
        }
        dataInputStream.close();
    }

    public final boolean grab(Object object) {
        if (this.grabber != null) {
            return false;
        }
        if (object instanceof Number) {
            Turtle turtle = VM.sl.getWho(((Number)object).intValue());
            if (turtle != null && turtle != this && turtle.grabber == null && turtle.partner == null) {
                this.ostack[this.sp++] = turtle;
                this.ostack[this.sp++] = VM.grabbedMarker;
                this.partner = turtle;
                turtle.grabber = this;
                int n = this.istack[--this.isp];
                this.istack[this.isp++] = 1;
                this.istack[this.isp++] = this.ip;
                this.ip = n;
                this.istack[this.isp++] = 204799;
                return true;
            }
            return false;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            int n2 = objectArray.length - 1;
            while (n2 >= 0) {
                Turtle turtle = VM.sl.getWho(this.aInteger(objectArray[n2]));
                if (turtle != null && turtle != this && turtle.grabber == null && turtle.partner == null) {
                    this.ostack[this.sp++] = turtle;
                    this.ostack[this.sp++] = VM.grabbedMarker;
                    this.partner = turtle;
                    turtle.grabber = this;
                    ++n;
                }
                --n2;
            }
            if (n > 0) {
                int n3 = this.istack[--this.isp];
                this.istack[this.isp++] = n;
                this.istack[this.isp++] = this.ip;
                this.ip = n3;
                this.istack[this.isp++] = 204799;
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean grabPatch(Patch patch) {
        if (this.grabber != null) {
            return false;
        }
        if (!patch.grabbedp && patch.patchpartner == null) {
            this.ostack[this.sp++] = patch;
            this.ostack[this.sp++] = VM.grabbedPatchMarker;
            this.patchpartner = patch;
            patch.grabbedp = true;
            int n = this.istack[--this.isp];
            this.istack[this.isp++] = 1;
            this.istack[this.isp++] = this.ip;
            this.ip = n;
            this.istack[this.isp++] = 204798;
            return true;
        }
        return false;
    }

    public final void setheading(double d) {
        double d2 = d - (double)((int)d);
        this.heading = (double)((int)d) % 360.0;
        if (this.heading < 0.0) {
            this.heading += 360.0;
        }
        this.heading += d2;
        double d3 = this.heading * Math.PI / 180.0;
        this.xdelta = Math.sin(d3);
        this.ydelta = -1.0 * Math.cos(d3);
    }

    public final void setState(int n, Object object) {
        switch (n & 0xFF) {
            case 0: {
                VM.sl.unlink(this);
                this.xcor = VM.sl.turhalfwidth + this.aDouble(object);
                VM.sl.wrapandlink(this);
                break;
            }
            case 2: {
                VM.sl.unlink(this);
                this.ycor = VM.sl.turhalfheight - this.aDouble(object);
                VM.sl.wrapandlink(this);
                break;
            }
            case 14: {
                this.color = this.aDouble(object) % 140.0;
                double d = this.color = this.color < 0.0 ? this.color + 140.0 : this.color;
                if (this != VM.sl.patches[this.patch].topturtle) break;
                VM.sl.patchcanvas.drawTurtle(this);
                break;
            }
            case 27: {
                this.setheading(this.aDouble(object));
                break;
            }
            case 32: {
                this.breed = this.aDouble(object);
                break;
            }
            case 36: {
                this.shape = this.aInteger(object) % VM.sl.numshapes;
                int n2 = this.shape = this.shape < 0 ? this.shape + VM.sl.numshapes : this.shape;
                if (this != VM.sl.patches[this.patch].topturtle) break;
                VM.sl.patchcanvas.drawTurtle(this);
                break;
            }
            case 23: {
                if (object != YoYo.symfalse) {
                    this.pendownp = true;
                    break;
                }
                this.pendownp = false;
                break;
            }
            case 31: {
                if (object != YoYo.symfalse) {
                    if (this.shownp) break;
                    this.shownp = true;
                    VM.sl.showTurtle(this);
                    break;
                }
                if (!this.shownp) break;
                this.shownp = false;
                VM.sl.hideTurtle(this);
                break;
            }
            default: {
                throw new LogoError("Oops, compiler error in Turtle. setState of " + n + " in instruction: " + this.iinst[this.ip - 1]);
            }
        }
    }

    public final Object getState(int n) {
        switch (n & 0xFF) {
            case 0: {
                return new Double(this.xcor - VM.sl.turhalfwidth);
            }
            case 2: {
                return new Double(VM.sl.turhalfheight - this.ycor);
            }
            case 14: {
                return new Double(this.color);
            }
            case 27: {
                return new Double(this.heading);
            }
            case 32: {
                return new Double(this.breed);
            }
            case 36: {
                return new Integer(this.shape);
            }
            case 23: {
                return this.pendownp ? YoYo.symtrue : YoYo.symfalse;
            }
            case 31: {
                return this.shownp ? YoYo.symtrue : YoYo.symfalse;
            }
        }
        throw new LogoError("Oops, compiler error in Turtle. getState of " + n + " in instruction: " + this.iinst[this.ip - 1]);
    }

    public void die() {
        if (this.hasTMp) {
            this.tm.die();
        }
        VM.sl.app.iface.erasePointsOnAllWidgets(this.who);
    }

    public static void setVars(Object[] objectArray, StarLogo starLogo, Context context) {
        Object[] objectArray2;
        numVars = objectArray.length;
        Turtle.setLength(new Integer(Turtle.getStateLength() + 4 * numVars));
        varnames = new String[numVars];
        varposes = new int[numVars];
        varenums = new boolean[numVars];
        Turtle turtle = starLogo.firstturtle;
        while (turtle != null) {
            if (turtle.turtlesown.length < numVars) {
                objectArray2 = new Object[numVars];
                System.arraycopy(turtle.turtlesown, 0, objectArray2, 0, turtle.turtlesown.length);
                int n = turtle.turtlesown.length;
                while (n < numVars) {
                    objectArray2[n] = VM.zeroInt;
                    ++n;
                }
                turtle.turtlesown = objectArray2;
            } else if (turtle.turtlesown.length > numVars / 2) {
                objectArray2 = new Object[numVars];
                System.arraycopy(turtle.turtlesown, 0, objectArray2, 0, numVars);
                turtle.turtlesown = objectArray2;
            }
            turtle = turtle.next;
        }
        int n = 0;
        while (n < numVars) {
            objectArray2 = YoYo.aList(context, objectArray[n]);
            Turtle.varnames[n] = YoYo.aString(context, objectArray2[0]);
            Turtle.varposes[n] = YoYo.aInteger(context, objectArray2[1]);
            Turtle.varenums[n] = YoYo.aBoolean(context, objectArray2[2]);
            ++n;
        }
    }

    public static int getNumVars() {
        return numVars;
    }

    public static String getVarName(int n) {
        return varnames[n];
    }

    public static int getVarPos(int n) {
        return varposes[n];
    }

    public static boolean getVarEnump(int n) {
        return varenums[n];
    }

    public static void setBreeds(Object[] objectArray, Context context) {
        numBreeds = objectArray.length;
        breednames = new String[numBreeds];
        breednums = new int[numBreeds];
        int n = 0;
        while (n < numBreeds) {
            Object[] objectArray2 = YoYo.aList(context, objectArray[n]);
            Turtle.breednames[n] = YoYo.aString(context, objectArray2[0]);
            Turtle.breednums[n] = YoYo.aInteger(context, objectArray2[1]);
            ++n;
        }
    }

    public static int getNumBreeds() {
        return numBreeds;
    }

    public static String getBreedName(int n) {
        return breednames[n];
    }

    public static int getBreedNum(int n) {
        return breednums[n];
    }

    public String toString() {
        return Integer.toString(this.who);
    }

    public String niceToString() {
        return "Turtle #" + this.toString();
    }

    Turtle(StarLogo starLogo, double d, double d2, double d3, double d4, int n, double d5, int n2) {
        this(starLogo, d, d2, d3, d4, n, d5, n2, 1, 1, false, true, new Object[numVars]);
        int n3 = 0;
        while (n3 < numVars) {
            this.turtlesown[n3] = VM.zeroInt;
            ++n3;
        }
    }

    Turtle(StarLogo starLogo, double d, double d2, double d3, double d4, int n, double d5, int n2, boolean bl, boolean bl2, int n3, int n4) {
        this(starLogo, d, d2, d3, d4, n, d5, n2, n3, n4, bl, bl2, new Object[numVars]);
        int n5 = 0;
        while (n5 < numVars) {
            this.turtlesown[n5] = VM.zeroInt;
            ++n5;
        }
    }

    Turtle(StarLogo starLogo, double d, double d2, double d3, double d4, int n, double d5, int n2, int n3, int n4, boolean bl, boolean bl2, Object[] objectArray) {
        VM.sl = starLogo;
        this.xcor = d - starLogo.turhalfwidth;
        this.ycor = starLogo.turhalfheight - d2;
        this.color = d4;
        this.who = n;
        this.whoInt = new Integer(n);
        this.breed = d5;
        this.shape = n2;
        this.plotpen = n3;
        this.plotwidget = n4;
        this.shownp = bl2;
        this.pendownp = bl;
        this.patch = -1;
        this.turtlesown = objectArray;
        this.setheading(d3);
    }

    static {
        numBreeds = 0;
        breednames = new String[0];
        breednums = new int[0];
    }
}

